function captureUserMedia(mediaConstraintsExpressionRecorder, successCallbackExpressionRecorder, errorCallbackExpressionRecorder) {
    navigator.mediaDevices.getUserMedia(mediaConstraintsExpressionRecorder).then(successCallbackExpressionRecorder).catch(errorCallbackExpressionRecorder);
}

var mediaConstraintsExpressionRecorder = {
    audio: true
};

//var formDataExpressionRecording = new FormData(document.getElementById('form-expression-recording'));

document.querySelector('#btn-stop-expression-record').onclick = function() {
    this.disabled = true;
    mediaRecorderExpressionRecorder.stop();
    mediaRecorderExpressionRecorder.stream.stop();
    document.querySelector('.wave-1').classList.remove('d-block');
    document.querySelector('.wave-2').classList.remove('d-block');
    document.querySelector('#btn-start-expression-record').removeAttribute('disabled');
    document.querySelector('#btn-save-expression-record').disabled = false;
    stopStopwatchElearning();
};



document.querySelector('#btn-save-expression-record').onclick = function() {
    //$('.spinner-border').fadeIn('slow');
    //$('#form-expression-recording').fadeOut('slow');
    //$('.recording-container').fadeOut('slow');
    //$('#bs-recording').attr('style','text-align:center;');
    this.disabled = true;
    var btn = $(this);
    btn.hide();
    $('.spinner-loader-transcription').removeClass('d-none');
    //mediaRecorderExpressionRecorder.save();
    // alert('Drop WebM file on Chrome or Firefox. Both can play entire file. VLC player or other players may not work.');
    $('.langChoice').each(function(){
    	var langageTranscript = $(this);
    	if (langageTranscript.is(':checked')) {
    		formDataExpressionRecording.append('transcriptionLanguage', langageTranscript.attr('id'));
    		$('#transcriptionLanguageForm').val(langageTranscript.attr('id'));
    	}
    });
    formDataExpressionRecording.append('sumbitform', 'transcription');
    $.ajax({
      url:  $('.baseURL').val()+'transcript-expression-audio',
      type: 'POST',
      data: formDataExpressionRecording,
      processData: false,
      contentType: false,
      dataType: 'json',
      success: function(result){
      	var translateJson = translate(result.target, result.message);
      	if (typeof translateJson.transcriptionResult !== 'undefined') {
      		$('#text_langage_cible_exp').val(translateJson.transcriptionResult);
      	}
      	$('#transcription-expression-recording').val(result.message);
      	$('#fileExpressionRecording').val(result.fileName);
      	$('#repFileExpressionRecording').val(result.repFileName);
      	$('.label-expression').html(result.fileName.replace(".wav", ""));
      	$('#expression-recording-source').attr('data-source',result.audioLink);
		$('.ep-wrap-action-record').addClass('d-none');
		$('.ep-detail-audio-record').removeClass('d-none');
		$('.el-btn-action-expression-record').removeClass('d-none');
    	$('.spinner-loader-transcription').addClass('d-none');
      },
      error: function(error, msg){
      	$('.ep-wrap-action-record').addClass('d-none');
		$('.ep-detail-audio-record').removeClass('d-none');
		$('.el-btn-action-expression-record').removeClass('d-none');
    	$('.spinner-loader-transcription').addClass('d-none');
        toastr.error(error);
        toastr.error(msg);
      }
    });
};

function translate(translate_language, text_to_translate){
	var dataResult;
	$.ajax({
		url: $('.baseURL').val()+'translate',
		type: 'post',
		data: {translate_language: translate_language, text_to_translate: text_to_translate},
		dataType: 'json',
		async: false,
      	success: function(result){
      		dataResult = result;
      	},
      	error: function(error, msg){
      	}
    });
    return dataResult;
}

var mediaRecorderExpressionRecorder;

function onMediaSuccessExpressionRecorder(stream) {
    var audioExpressionRecorder = document.createElement('audio');
    document.getElementById('audios-container').innerHTML = '';

    audioExpressionRecorder = mergeProps(audioExpressionRecorder, {
        controls: true,
        muted: true
    });
    audioExpressionRecorder.srcObject = stream;
    audioExpressionRecorder.play();
    audiosContainer.appendChild(audioExpressionRecorder);
    mediaRecorderExpressionRecorder = new MediaStreamRecorder(stream);
    mediaRecorderExpressionRecorder.stream = stream;
    mediaRecorderExpressionRecorder.audioChannels = 1;

    var recorderType = 'WebAudio API (WAV)';

    if (recorderType === 'MediaRecorder API') {
        mediaRecorderExpressionRecorder.recorderType = MediaRecorderWrapper;
    }

    if (recorderType === 'WebAudio API (WAV)') {
        mediaRecorderExpressionRecorder.recorderType = StereoAudioRecorder;
        mediaRecorderExpressionRecorder.mimeType = 'audio/wav';
    }

    if (recorderType === 'WebAudio API (PCM)') {
        mediaRecorderExpressionRecorder.recorderType = StereoAudioRecorder;
        mediaRecorderExpressionRecorder.mimeType = 'audio/pcm';
    }
		
	mediaRecorderExpressionRecorder.ondataavailable = function(blob) {
    	var urlblob =  URL.createObjectURL(blob);
    	formDataExpressionRecording = new FormData(document.getElementById('form-expression-recording'));
    	formDataExpressionRecording.append('fileUpload', blob);
    };

    /*var timeIntervalExpressionRecording = document.querySelector('#time-interval-expression-recording').value;
    if (timeIntervalExpressionRecording) timeIntervalExpressionRecording = parseInt(timeIntervalExpressionRecording);
    else timeIntervalExpressionRecording = 5000 * 1000;*/
    var timeIntervalExpressionRecording = 5000 * 1000;


    //console.log(timeIntervalExpressionRecording);
    // get blob after specific time interval
    mediaRecorderExpressionRecorder.start(timeIntervalExpressionRecording);

    document.querySelector('#btn-stop-expression-record').disabled = false;
    document.querySelector('#btn-save-expression-record').disabled = true;
}

function onMediaErrorExpressionRecorder(e) {
    console.error('media error', e);
}

var audiosContainer = document.getElementById('audios-container');
var index = 1;

// below function via: http://goo.gl/B3ae8c
function bytesToSize(bytes) {
    var k = 1000;
    var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
    if (bytes === 0) return '0 Bytes';
    var i = parseInt(Math.floor(Math.log(bytes) / Math.log(k)), 10);
    return (bytes / Math.pow(k, i)).toPrecision(3) + ' ' + sizes[i];
}

// below function via: http://goo.gl/6QNDcI
function getTimeLength(milliseconds) {
    var data = new Date(milliseconds);
    return data.getUTCHours() + " hours, " + data.getUTCMinutes() + " minutes and " + data.getUTCSeconds() + " second(s)";
}

var startTimeElearning; // to keep track of the start time
var stopwatchIntervalElearning; // to keep track of the interval
var elapsedPausedTimeElearning = 0; // to keep track of the elapsed time while stopped

function startStopwatchElearning() {
	if (!stopwatchIntervalElearning) {
	  	startTimeElearning = new Date().getTime() - elapsedPausedTimeElearning; // get the starting time by subtracting the elapsed paused time from the current time
	  	stopwatchIntervalElearning = setInterval(updateStopwatchElearning, 1000); // update every second
	}
}

function stopStopwatchElearning() {
	clearInterval(stopwatchIntervalElearning); // stop the interval
	elapsedPausedTimeElearning = new Date().getTime() - startTimeElearning; // calculate elapsed paused time
	stopwatchIntervalElearning = null; // reset the interval variable
}

function resetStopwatchElearning() {
	stopStopwatchElearning(); // stop the interval
	elapsedPausedTimeElearning = 0; // reset the elapsed paused time variable
	//document.querySelector(".time-interval-expression-recording").innerHTML = "00:00:00"; // reset the display
	document.querySelector(".time-interval-expression-recording").innerHTML = "00:00"; // reset the display
	document.getElementById("time-interval-expression-recording").value = "00:00";
}

function updateStopwatchElearning() {
	var currentTime = new Date().getTime(); // get current time in milliseconds
	var elapsedTime = currentTime - startTimeElearning; // calculate elapsed time in milliseconds
	var seconds = Math.floor(elapsedTime / 1000) % 60; // calculate seconds
	var minutes = Math.floor(elapsedTime / 1000 / 60) % 60; // calculate minutes
	var hours = Math.floor(elapsedTime / 1000 / 60 / 60); // calculate hours
	//var displayTime = padElearning(hours) + ":" + padElearning(minutes) + ":" + padElearning(seconds); // format display time
	var displayTime = padElearning(minutes) + ":" + padElearning(seconds); // format display time
	document.querySelector(".time-interval-expression-recording").innerHTML = displayTime; // update the display
	document.getElementById("time-interval-expression-recording").value = displayTime;
}

function padElearning(number) {
	// add a leading zero if the number is less than 10
	return (number < 10 ? "0" : "") + number;
}

function speakTextExpressionRecording(link,identification){
	var btn = $(link);
	//setTimeout('$(".loader-text-to-speach").removeClass("d-none");','1000');
	var language = '';
	var sentence    = btn.parents('.ep-input').find('textarea').val();
	
	if (identification == 'transcription') {
		if ($('#transcriptionLanguageForm').val() == 'en-US') {
			language = 'UK English Male';			
		}
		else{
			language = 'French Male';
		}
	}
	else{
		if ($('#transcriptionLanguageForm').val() == 'en-US') {
			language = 'French Male';		
		}
		else{
			language = 'UK English Male';	
		}
	}
	responsiveVoice.speak(sentence,language);
}

function textToSpeachExpressionRecording(expressionRecordingId, language, identification){
	var sentence = "";
	if (identification == 'transcription') {
		$('.content-transcription').each(function(){
			var textarea = $(this);
			if (textarea.attr('data-audio-id') == expressionRecordingId) {
				sentence += textarea.val();
			}
		});
	}
	else{
		$('.content-translation').each(function(){
			var textarea = $(this);
			if (textarea.attr('data-audio-id') == expressionRecordingId) {
				sentence += textarea.val();
			}
		});
	}
	console.log('sentence : ' + sentence);

	responsiveVoice.speak(sentence,language);
}

function registerContentExpressionRecording(link){
	var btn = $(link);
	$('.spinner').fadeIn('slow');
	var expressionRecordingId = btn.attr('data-audio-id');
	var sentence = '';
	var cible = btn.attr('data-cible');
	if (cible == 'transcription') {
		$('.content-transcription').each(function(){
			var textarea = $(this);
			if (textarea.attr('data-audio-id') == expressionRecordingId) {
				sentence += textarea.val();
			}
		});
	}
	else{
		$('.content-translation').each(function(){
			var textarea = $(this);
			if (textarea.attr('data-audio-id') == expressionRecordingId) {
				sentence += textarea.val();
			}
		});
	}

	$.ajax({
		url: $('.baseURL').val()+'update-content-expression-recording',
		type: 'post',
		data: {sentence : sentence, expressionRecordingId : expressionRecordingId, cible : cible},
		dataType: 'json',
      	success: function(result){
	        toastr.success(data_save_ok);
	        $('.spinner').fadeOut('slow');
      	},
      	error: function(error, msg){
	        $('.spinner').fadeOut('slow');
	        toastr.error(error);
	        toastr.error(msg);
      	}
    });


}

function readExpressionRecording(link){
	var btn = $(link);
	var file_source = btn.attr('data-source');
	if (file_source == '') {
		toastr.error(booster_file_doesnt_exist);
	}
	else{
		const sound = new Audio(btn.attr('data-source'));
		sound.play();
	}
}

function listenExpressionRecording(link){
	var btn = $(link);
	var file_source = btn.attr('data-source');
	var timer = btn.attr('data-time').replace(":", "m")+"s";
	if (file_source == '') {
		toastr.error(booster_file_doesnt_exist);
	}
	else{		
		const sound = new Audio(btn.attr('data-source'));
		sound.play();
		btn.html('<i class="bx bx-pause"></i>');
		btn.attr('disabled',true);
		deplayTimer(btn,btn.parents('.form-action').find('.time-interval-expression-recording-db'),timer);
	}
}


function deplayTimer(containerParents,container,timer){
	container.fadeIn('slow');
	container.timer({
		duration: timer,
		countdown: true,
		format: '%M:%S',
		callback: function() {
			container.fadeOut('slow');
			containerParents.html('<i class="bx bx-play"></i>');
			containerParents.removeClass('disabled');
			container.timer('reset');
			container.timer('remove');
		},
		repeat: false //repeatedly calls the callback you specify
	});
}

function deleteExpressionRecording(expressionRecordingId){
	$('#expression-recording-id').val(expressionRecordingId);
	$('#modal-confirmation-delete-expression-recording').addClass('open');
}

function newsCategoryExpression(link){
	var btn = $(link);
	btn.hide();	
	$('#ep-new-category-expression').removeClass('d-none');
}

window.onbeforeunload = function() {
    document.querySelector('#btn-start-expression-record').disabled = false;
};

$(document).ready(function(){

	$('#btn-start-expression-record').click(function() {
		var loadRecord = false;
		$('.langChoice').each(function(){
	    	if ($(this).is(':checked')) {
	    		loadRecord = true;
	    	}
	    });
	    if (loadRecord === true) {
		    resetStopwatchElearning();
		    $(this).attr('disabled','disabled');
		    $('.wave').addClass('d-block');
		    $('.other-content-rework-audio').fadeOut('slow');
		    $('#btn-stop-expression-record').removeAttr('disabled');
		    $('#btn-save-expression-record').removeAttr('disabled');
		    captureUserMedia(mediaConstraintsExpressionRecorder, onMediaSuccessExpressionRecorder, onMediaErrorExpressionRecorder);
		    startStopwatchElearning();
		}
		else{
			toastr.error(booster_choose_langage_transcription);
		}
	});

	$('.ep-btn-go-back').click(function(e){
		e.preventDefault();
		$.ajax({
	      url:  $('.baseURL').val()+'unlik-file-audio',
	      type: 'POST',
	      data: {rep : $('#repFileExpressionRecording').val()},
	      dataType: 'json',
	      success: function(result){
	      	$('.ep-wrap-action-record').removeClass('d-none');
			$('.ep-detail-audio-record').addClass('d-none');
			$('#btn-save-expression-record').fadeIn('slow');
			$('.el-btn-action-expression-record').addClass('d-none');
	      },
	      error: function(error, msg){
	      	console.log(error);
	      	console.log(msg);
	      	$('.ep-wrap-action-record').removeClass('d-none');
			$('.ep-detail-audio-record').addClass('d-none');
			$('#btn-save-expression-record').fadeIn('slow');
			$('.el-btn-action-expression-record').addClass('d-none');
	      }
	    });		
	});

	$('#save-expression-recording-btn').click(function(e){
		e.preventDefault();
		var categoryExpression = $('input[name="category_new_expression"]:checked').val();
		var formData = new FormData(document.getElementById('form-expression-recording'));
		formData.append('category_expression_recorder', categoryExpression);
	    $.ajax({
			url: $('#form-expression-recording').attr('action'),
			type: $('#form-expression-recording').attr('method'),
			data: formData,
			processData: false,
			contentType: false,
			dataType: 'json',
	      	success: function(result){
		        toastr.success(data_save_ok);
		        $('.ep-btn-go-back').click();
		        $('.other-content-rework-audio').fadeOut('slow');
		        $('.recording-container').fadeIn('slow');
		        $('.expression-databank-shorctuf-from').fadeOut('slow');
		        $('.control-generate-transcription').find('.spinner-border').fadeOut('slow');
		        $('.label-expression').html();

		        $('.time-interval-expression-recording').html('00:00');
		    	$('.ep-btn-go-back').click();
		    	$('#form-expression-recording').trigger("reset");


		        $('#modal-save-expression-recording').removeClass('open');
		        $('.btn-confirm-access-databank-list').attr('href',$('.baseURL').val()+'databank-expression?categ='+result.category);
		        $('#modal-confirm-access-dtbk').addClass('open');
		        disablestp();
		        activerec();
		        disablesave();
	      	},
	      	error: function(error, msg){
		        toastr.error(error);
		        toastr.error(msg);
		        $('.other-content-rework-audio').fadeOut('slow');
		        $('.recording-container').fadeIn('slow');
		        $('.expression-databank-shorctuf-from').fadeOut('slow');
		        $('.control-generate-transcription').find('.spinner-border').fadeOut('slow');
		        $('.label-expression').html();

		        $('.time-interval-expression-recording').html('00:00');
		    	$('.ep-btn-go-back').click();
		    	$('#form-expression-recording').trigger("reset");

    	
		        $('#modal-save-expression-recording').removeClass('open');
		        disablestp();
		        activerec();
		        disablesave();
	      	}
	    });
	});


	$('#form-expression-recording').on('submit', function(e){
		var form = $(this);
	    e.preventDefault();	  
	     
		formDataExpressionRecording.append('timeExpressionRecording', $('#time-interval-expression-recording').val());
		formDataExpressionRecording.append('category', $('#category_expression_recorder').val());
	    $('.langChoice').each(function(){
	    	if ($(this).is(':checked')) {
	    		formDataExpressionRecording.append('transcriptionLanguage', $(this).attr('id'));
	    	}
	    });
	    $('#modal-save-expression-recording').addClass('open'); 

  	});


	$('.ep-save-new-category-expression').click(function(e){
		e.preventDefault();
		$('.spinner').fadeIn('slow');
		var cetgoryName = $('#new-category-expression').val();
		if (cetgoryName == '') {
			toastr.error(category_required);
		}
		else{
			$.ajax({
	      		url : $('.baseURL').val()+"ajax-add-category-expression",
	      		type: 'POST',
	      		data: {cetgoryName : cetgoryName}, 
	      		dataType: 'json',  
	      		success:function(response){
	      			console.log(response);
	      			$('.ep-category-content').prepend('<input type="radio" value="'+response.id+'" id="cat-'+response.id+'" name="category_new_expression" checked><label for="cat-'+response.id+'">'+response.data.intitule+'</label>');
	      			$('#ep-new-category-expression').addClass('d-none');
	      			$('.ep-new-category').fadeIn('slow');
	            	$('.spinner').fadeOut('slow');
	            	toastr.success(data_save_ok);
	          	}
	    	});	
		}
	});

	$('.ep-close-form-category-expression').click(function(e){
		e.preventDefault();
		$('#ep-new-category-expression').addClass('d-none');
	});

  	$('.close-form-expression-recording').click(function(e) {
  		e.preventDefault();
		var btn = $(this);
	    $.ajax({
	      url:  $('.baseURL').val()+'unlik-file-audio',
	      type: 'POST',
	      data: {rep : $('#repFileExpressionRecording').val()},
	      dataType: 'json',
	      success: function(result){
	      	$('.recording-container').fadeIn('slow');
	      	$('.other-content-rework-audio').fadeOut('slow');
	      	$('.expression-databank-shorctuf-from').fadeOut('slow');

	      	$('.control-generate-transcription').find('#btn-save-expression-record').fadeIn('slow');
	    	$('.control-generate-transcription').find('button#btn-save-expression-record').fadeOut('slow');
	    	$('.label-expression').html();
	    	
	    	$('.time-interval-expression-recording').html('00:00');
	    	$('.ep-btn-go-back').click();
	    	$('#form-expression-recording').trigger("reset");
	      },
	      error: function(error, msg){
	      	$('.recording-container').fadeIn('slow');
	      	$('.other-content-rework-audio').fadeOut('slow');
	      	$('.expression-databank-shorctuf-from').fadeOut('slow');

	      	$('.control-generate-transcription').find('#btn-save-expression-record').fadeIn('slow');
	    	$('.control-generate-transcription').find('button#btn-save-expression-record').fadeOut('slow');
	    	$('.label-expression').html();
	    	
	    	$('.time-interval-expression-recording').html('00:00');
	    	$('.ep-btn-go-back').click();
	    	$('#form-expression-recording').trigger("reset");
	      }
	    });
  	});

  	$('.btn-see-more-expression-recording').click(function(e){
  		e.preventDefault();  		
  		var btn = $(this);
  		var expressionRecordingId = btn.attr('data-audio-id');
  		$('.container-specific').each(function(){
  			var container = $(this);
  			if (container.attr('data-audio-id') == expressionRecordingId) {
  				if(container.hasClass('active')){
		  			btn.html('<i class="bx bx-chevron-down"></i> ' + booster_label_more);
		  			container.removeClass('active');
		  		}
		  		else{
		  			$('.container-specific').removeClass('active');
		  			$('.btn-see-more-expression-recording').html('<i class="bx bx-chevron-down"></i> ' + booster_label_more);
		  			btn.html('<i class="bx bx-chevron-up"></i> ' + booster_label_less);
		  			container.addClass('active');
		  		}
  			}
  		});  		
  	});

  	$('#form-delete-expression-recording').on('submit', function(e){
	    e.preventDefault();	  
		var form = $(this);
		$('.spinner').fadeIn('slow');
	    $.ajax({
	      	url: form.attr('action'),
			type: form.attr('method'),
			data: {expression_recording_id : $('#expression-recording-id').val()},
			dataType: 'json',
	      	success: function(result){
	      		toastr.success(data_delete_ok);
		        $('.container-expression-recording').each(function(){
		        	var container = $(this);
		        	if (container.attr('data-audio-id') == $('#expression-recording-id').val()) {
		        		container.remove();
		        	}
		        });
		        $('.spinner').fadeOut('slow');
		        $('#modal-confirmation-delete-expression-recording').removeClass('open');
	      	},
	      	error: function(error, msg){
	      		$('.spinner').fadeOut('slow');
		        $('#modal-confirmation-delete-expression-recording').removeClass('open');
		        toastr.error(error);
		        toastr.error(msg);
	      	}
	    });
  	});

  	$('input[name="langChoice"]').on("click", function() {
		var language = $('input[name="langChoice"]:checked').val();
		if (language == 'fr-FR') {
			$('.ep-flag-transcription').html('<div class="flag flag-fr"></div><span class="lang-fr"></span>');
			$('.ep-flag-translation').html('<div class="flag flag-en"></div><span class="lang-en"></span>');
			$('#translateLanguage').val('en-US');
		}
		else{
			$('.ep-flag-translation').html('<div class="flag flag-fr"></div><span class="lang-fr"></span>');
			$('.ep-flag-transcription').html('<div class="flag flag-en"></div><span class="lang-en"></span>');
			$('#translateLanguage').val('fr-FR');
		}
	});

	$('#target_langue_cible').on('change', function(){
		var select = $(this);
		var translate_language = '';
		var translate_voice_cible = '';
		var translate_html_cible = '';

		console.log('value : ' + select.val());
		switch(select.val()) {
		  	case '1':
		    	translate_language += 'en';
		    	translate_html_cible += '<div class="flag flag-en"></div><span class="lang-en"></span></div>';
		    	translate_voice_cible += 'UK English Male';
		    	break;
		    case '2':
			    translate_language += 'ar';
			    translate_html_cible += '<div class="flag flag-ar"></div><span class="lang-ar"></span></div>';
			    translate_voice_cible += 'Arabic Male';
			    break;
			case '3':
			    translate_language += 'zh';
			    translate_html_cible += '<div class="flag flag-zh"></div><span class="lang-zh"></span></div>';
			    translate_voice_cible += 'Chinese Male';
			    break;
			case '4':
			    translate_language += 'es';
			    translate_html_cible += '<div class="flag flag-es"></div><span class="lang-es"></span></div>';
			    translate_voice_cible += 'Spanish Latin American Male';
			    break;
			case '5':
			    translate_language += 'fr';
			    translate_html_cible += '<div class="flag flag-fr"></div><span class="lang-fr"></span></div>';
			    translate_voice_cible += 'French Male';
			    break;
			case '6':
			    translate_language += 'ru';
			    translate_html_cible += '<div class="flag flag-ru"></div><span class="lang-ru"></span></div>';
			    translate_voice_cible += 'Russian Female';
			    break;
		  	default:
		    // code block
		}

		//console.log('translate_html_cible : ' + translate_html_cible);
		//console.log('translate_language : ' + translate_language);
		//console.log('translate_voice_cible : ' + translate_voice_cible);
		var text_to_translate = $('#text_langage_origin').val();
		//if (translate_language != '' && text_to_translate != '') {
		$('#text_langage_cible').addClass('d-none');
		$('.translate-loading').removeClass('d-none');
		$('.ep-flag-contanier-translation').html(translate_html_cible);
		$('.ep-flag-contanier-translation').removeClass('d-none');
		$.ajax({
			url: $('.baseURL').val()+'translate',
			type: 'post',
			data: {translate_language: translate_language, text_to_translate: text_to_translate},
			dataType: 'json',
	      	success: function(response){
	      		$('#text_langage_cible').val(response.transcriptionResult);
	      		$('#text_langage_cible').removeClass('d-none');
				$('.translate-loading').addClass('d-none');

				$('.speach-text-translate').attr('data-language-cible',translate_voice_cible);
				$('.speach-text-translate').removeClass('d-none');
	      	},
	      	error: function(error, msg){
		        toastr.error(error);
		        toastr.error(msg);			        
	      		$('#text_langage_cible').removeClass('d-none');
				$('.translate-loading').addClass('d-none');
	      	}
	    });
		//}
	});

	$('#langage_traduction_edit').on('change', function(){
		var select = $(this);
		var translate_language = '';
		var translate_voice_cible = '';
		var translate_html_cible = '';
		switch(select.val()) {
		  	case '1':
		    	translate_language += 'en';
		    	translate_html_cible += '<div class="flag flag-en"></div><span class="lang-en"></span></div>';
		    	translate_voice_cible += 'UK English Male';
		    	break;
		    case '2':
			    translate_language += 'ar';
			    translate_html_cible += '<div class="flag flag-ar"></div><span class="lang-ar"></span></div>';
			    translate_voice_cible += 'Arabic Male';
			    break;
			case '3':
			    translate_language += 'zh';
			    translate_html_cible += '<div class="flag flag-zh"></div><span class="lang-zh"></span></div>';
			    translate_voice_cible += 'Chinese Male';
			    break;
			case '4':
			    translate_language += 'es';
			    translate_html_cible += '<div class="flag flag-es"></div><span class="lang-es"></span></div>';
			    translate_voice_cible += 'Spanish Latin American Male';
			    break;
			case '5':
			    translate_language += 'fr';
			    translate_html_cible += '<div class="flag flag-fr"></div><span class="lang-fr"></span></div>';
			    translate_voice_cible += 'French Male';
			    break;
			case '6':
			    translate_language += 'ru';
			    translate_html_cible += '<div class="flag flag-ru"></div><span class="lang-ru"></span></div>';
			    translate_voice_cible += 'Russian Female';
			    break;
		  	default:
		    // code block
		}
		var text_to_translate = $('#original_text_langage_edit').val();
		if (translate_language != '' && text_to_translate != '') {
			$('#target_text_langage_edit').addClass('d-none');
			$('.translate-loading').removeClass('d-none');
			$.ajax({
				url: $('.baseURL').val()+'translate',
				type: 'post',
				data: {translate_language: translate_language, text_to_translate: text_to_translate},
				dataType: 'json',
		      	success: function(response){
		      		$('#target_text_langage_edit').val(response.transcriptionResult);
		      		$('#target_text_langage_edit').removeClass('d-none');
					$('.translate-loading').addClass('d-none');

					$('.ep-flag-contanier-translation').html(translate_html_cible);
					$('.ep-flag-contanier-translation').removeClass('d-none');

					$('.speach-text-translate').attr('data-language-cible',translate_voice_cible);
					$('.speach-text-translate').removeClass('d-none');
		      	},
		      	error: function(error, msg){
			        toastr.error(error);
			        toastr.error(msg);			        
		      		$('#target_text_langage_edit').removeClass('d-none');
					$('.translate-loading').addClass('d-none');
		      	}
		    });
		}
	});


	$('#origin_langage_').on('change', function(){
		var select = $(this);
		var translate_language = '';
		var translate_voice_cible = '';
		var translate_html_cible = '';
		switch(select.val()) {
		  	case '1':
		    	translate_language += 'en';
		    	translate_html_cible += '<div class="flag flag-en"></div><span class="lang-en"></span></div>';
		    	translate_voice_cible += 'UK English Male';
		    	break;
		    case '2':
			    translate_language += 'ar';
			    translate_html_cible += '<div class="flag flag-ar"></div><span class="lang-ar"></span></div>';
			    translate_voice_cible += 'Arabic Male';
			    break;
			case '3':
			    translate_language += 'zh';
			    translate_html_cible += '<div class="flag flag-zh"></div><span class="lang-zh"></span></div>';
			    translate_voice_cible += 'Chinese Male';
			    break;
			case '4':
			    translate_language += 'es';
			    translate_html_cible += '<div class="flag flag-es"></div><span class="lang-es"></span></div>';
			    translate_voice_cible += 'Spanish Latin American Male';
			    break;
			case '5':
			    translate_language += 'fr';
			    translate_html_cible += '<div class="flag flag-fr"></div><span class="lang-fr"></span></div>';
			    translate_voice_cible += 'French Male';
			    break;
			case '6':
			    translate_language += 'ru';
			    translate_html_cible += '<div class="flag flag-ru"></div><span class="lang-ru"></span></div>';
			    translate_voice_cible += 'Russian Female';
			    break;
		  	default:
		    // code block
		}
		$('.ep-flag-contanair-original').html(translate_html_cible);
		$('.speach-text-origin').attr('data-language-cible',translate_voice_cible);
	});

	$('#origin_langage_edit').on('change', function(){
		var select = $(this);
		var translate_language = '';
		var translate_voice_cible = '';
		var translate_html_cible = '';
		switch(select.val()) {
		  	case '1':
		    	translate_language += 'en';
		    	translate_html_cible += '<div class="flag flag-en"></div><span class="lang-en"></span></div>';
		    	translate_voice_cible += 'UK English Male';
		    	break;
		    case '2':
			    translate_language += 'ar';
			    translate_html_cible += '<div class="flag flag-ar"></div><span class="lang-ar"></span></div>';
			    translate_voice_cible += 'Arabic Male';
			    break;
			case '3':
			    translate_language += 'zh';
			    translate_html_cible += '<div class="flag flag-zh"></div><span class="lang-zh"></span></div>';
			    translate_voice_cible += 'Chinese Male';
			    break;
			case '4':
			    translate_language += 'es';
			    translate_html_cible += '<div class="flag flag-es"></div><span class="lang-es"></span></div>';
			    translate_voice_cible += 'Spanish Latin American Male';
			    break;
			case '5':
			    translate_language += 'fr';
			    translate_html_cible += '<div class="flag flag-fr"></div><span class="lang-fr"></span></div>';
			    translate_voice_cible += 'French Male';
			    break;
			case '6':
			    translate_language += 'ru';
			    translate_html_cible += '<div class="flag flag-ru"></div><span class="lang-ru"></span></div>';
			    translate_voice_cible += 'Russian Female';
			    break;
		  	default:
		    // code block
		}
		$('.ep-flag-contanair-original-edit').html(translate_html_cible);
		$('#modal-edition-expression .speach-text-origin').attr('data-language-cible',translate_voice_cible);
	});


	$("#text_langage_origin").on("keyup", function( event ) {
		var key = $(this).val().toLowerCase();
		var translate_language = '';
		switch($('#target_langue_cible').val()) {
		  	case '1':
		    	translate_language += 'en';
		    	break;
		    case '2':
			    translate_language += 'ar';
			    break;
			case '3':
			    translate_language += 'zh';
			    break;
			case '4':
			    translate_language += 'es';
			    break;
			case '5':
			    translate_language += 'fr';
			    break;
			case '6':
			    translate_language += 'ru';
			    break;
		  	default:
		    // code block
		}

		if (translate_language == '' && $('.speach-text-translate').attr('data-language-cible') != '') {
			if ($('.speach-text-translate').attr('data-language-cible') == 'French Male') {
				translate_language += 'fr';
			}
			else{
				translate_language += 'en';
			}
		}

      	if(key.length >= 3 && translate_language != '') {
      		//$('#text_langage_cible').addClass('d-none');
			//$('.translate-loading').addClass('d-none');
        	$.ajax({  
				url      : 'translate',  
				type     : "POST", 
				data     : { text_to_translate: $(this).val(), translate_language: translate_language }, 
				dataType : 'json',
				success: function(data) {   
					$('#text_langage_cible').val(data.transcriptionResult);  
					//$('#text_langage_cible').removeClass('d-none');
					//$('.translate-loading').removeClass('d-none');
				}
        	});
      	}
    });


    $("#original_text_langage_edit").on("keyup", function( event ) {
		var key = $(this).val().toLowerCase();
		var translate_language = '';
		switch($('#langage_traduction_edit').val()) {
		  	case '1':
		    	translate_language += 'en';
		    	break;
		    case '2':
			    translate_language += 'ar';
			    break;
			case '3':
			    translate_language += 'zh';
			    break;
			case '4':
			    translate_language += 'es';
			    break;
			case '5':
			    translate_language += 'fr';
			    break;
			case '6':
			    translate_language += 'ru';
			    break;
		  	default:
		    // code block
		}
      	if(key.length >= 3 && translate_language != '') {
      		//$('#target_text_langage_edit').addClass('d-none');
			//$('.translate-loading').addClass('d-none');
        	$.ajax({  
				url      : 'translate',  
				type     : "POST", 
				data     : { text_to_translate: $(this).val(), translate_language: translate_language }, 
				dataType : 'json',
				success: function(data) {   
					$('#target_text_langage_edit').val(data.transcriptionResult); 
					//$('#target_text_langage_edit').removeClass('d-none'); 
					//$('.translate-loading').removeClass('d-none');
				}
        	});
      	}
    });  
});

function speechContentTranslate(link,cible){
	var btn = $(link);
	var voice = btn.attr('data-language-cible');
	var sentence = $('#'+cible+'').val();
	var results = responsiveVoice.speak(sentence,voice);
	console.log(results);
}

function speechContentTranslateEdit(link){
	var btn = $(link);
	var voice = btn.attr('data-language-cible');
	var sentence = $('#target_text_langage_edit').val();
	var results = responsiveVoice.speak(sentence,voice);
	console.log(results);
}