<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forma2Plus - EL<?php echo date('Y') ?> - Login</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css" integrity="sha512-MV7K8+y+gLIBoVD59lQIYicR65iaqukzvf/nwasF0nqhPay5w/9lJmVM2hMDcnK1OnMGCdVK+iQrJ7lzPJQd1w==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/themes/other/css/bootstrap-grid.min.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/themes/other/css/components.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/themes/other/css/cookieconsent.css" media="print" onload="this.media='all'">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/themes/other/css/cookieconsent-personnalise.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/themes/other/css/cdn.jsdelivr.net_gh_orestbida_iframemanager@v1.0_dist_iframemanager.css">
    <script src="<?php echo base_url(); ?>assets/bootstrap4/js/jquery.min.js"></script>
    <script type="text/javascript" src="assets/themes/other/js/cdn.jsdelivr.net_gh_orestbida_iframemanager@v1.0_dist_iframemanager.js"></script>
    <script type="text/javascript" src="assets/themes/other/js/cookieconsent.js"></script>
    <script type="text/javascript" src="assets/themes/other/js/cookieconsent-init.js" defer></script>
    <script type="text/javascript">
        $(document).bind("contextmenu",function(){
          return false;
        }); 
        $(window).on('load', function(){
           $(".spinner").fadeOut("slow");
        });
        $(document).ready(function(){
            $('.btn-forgot-password').click(function(e){
                e.preventDefault();
                $('#login-form-container').fadeOut('slow');
                $('#forgot-password-user-name').fadeIn('slow');
            });

            $('.go-back-login').click(function(e){
                e.preventDefault();
                $('#login-form-container').fadeIn('slow');
                $('#forgot-password-user-name').fadeOut('slow');
            });

            $('.close').click(function(e){
                e.preventDefault();
                $('.alert').fadeOut('slow');
            });
        });
    </script>
</head>
<body class="bg-body body-el">
    <div class="spinner"></div>
    <div class="limiter">
        <div class="page-content">
            <div class="login-container">
                <div class="container">
                    <div class="row justify-content-center align-items-center">

                        <!-- logo -->
                        <div class="col-10 col-sm-8 col-md-5 col-lg-6 col-xl-6 mb-5 mb-md-0">
                            <div class="brand-container">
                                <div class="brand-wrap">
                                    <a href=""><img src="assets/themes/other/images/forma2plus.svg" alt=""></a>                                
                                </div>
                            </div>
                            <div class="divider divider-lg"></div>

                            <div class="basline <?php echo time() > 1727827200 ? '' : 'd-none' ?>">
                                <h5>our training dashboard</h5>
                                <br>
                            </div>

                            <div class="basline <?php echo time() < 1727827200 ? '' : 'd-none' ?>">
                                <h5><?php echo $this->lang->line('welcome_elearning_v3') ?></h5>
                            </div>
                            <br>

                            <div class="basline">
                                <!--div class="brand-wrap incident-technic-wrag"-->
                                <div class="incident-technic-login">
                                    <a href="<?php echo $this->config->item('api_url_incident_technik') ?>?nom=&origin=<?php echo base_url() ?>&mail=" target="_blank" class="inc-btn"  data-page="incident-technic">
                                        <span><?php echo $this->lang->line('incident_technic') ?></span>
                                        <img src="<?php echo base_url() ?>assets/themes/other/images/inc-icon.svg" alt="">
                                    </a>
                                </div>
                            </div>

                        </div>

                        <!-- login -->
                        <div class="col-sm-10 col-md-7 col-lg-5 col-xl-4">
                            <div class="login-wrap">
                                <div class="login-inner">
                                    <div class="login" id="login-form-container" style="<?php echo (isset($_GET['capt']) && $_GET['capt'] == 'fg') ? 'display:none' : '' ?>">
                                        <div class="login-head">
                                            <i class="fa-solid fa-circle-user"></i>
                                            <span>Use the username and password provided in your invitation email to log in and start your training</span>
                                        </div>

                                        <?php $this->load->helper('form'); $error = $this->session->flashdata('error'); if($error) { ?>
                                                <div class="alert alert-danger alert-dismissable">
                                                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                  <?php echo $error; ?>                    
                                                </div>
                                        <?php } $success = $this->session->flashdata('success');
                                            if($success) {  ?>
                                                <div class="alert alert-success alert-dismissable">
                                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                    <?php echo $success; ?>                    
                                                </div>
                                        <?php } ?>

                                        <form  class="login-form" action="<?php echo base_url(); ?>loginMe" method="post">

                                            <div class="login-field">
                                                <label for="login-user" class="login-label">Login (E-mail)</label>
                                                <input type="text" id="login-user" name="email" class="login-input">
                                            </div>
                                            <div class="login-field">
                                                <label for="login-password" class="login-label">Password</label>
                                                <input type="password" id="login-password" name="password" class="login-input">
                                            </div>
                                            <div class="login-field">
                                                <label class="label-remember el-checkbox">
                                                    <input type="checkbox" name="remember" id="remember" class="el-form-check">Remember me     
                                                    <span class="checkmark"></span>
                                                </label>
                                            </div>
                                            <div class="login-field">
                                                <label class="label-send-mail el-checkbox">
                                                    <a href="#" class="btn-forgot-password el-btn">Forgot username or password ?</a>
                                                </label>
                                            </div>
                                            <button type="submit" class="login-submit">
                                                <span>Login</span>
                                            </button>
                                        </form>
                                    </div>
                                    <div class="login" id="forgot-password-user-name" style="<?php echo (isset($_GET['capt']) && $_GET['capt'] == 'fg') ? '' : 'display:none' ?>">
                                        <div class="login-head">
                                            <i class="fa-solid fa-circle-user"></i>
                                            <span>Forgot username or password ?</span>
                                        </div>

                                        <?php $this->load->helper('form'); $error = $this->session->flashdata('error'); if($error) { ?>
                                                <div class="alert alert-danger alert-dismissable">
                                                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                  <?php echo $error; ?>                    
                                                </div>
                                        <?php } $success = $this->session->flashdata('success');
                                            if($success) {  ?>
                                                <div class="alert alert-success alert-dismissable">
                                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                    <?php echo $success; ?>                    
                                                </div>
                                        <?php } ?>

                                        <form  class="login-form" action="<?php echo base_url(); ?>forgot-username-password" method="post">

                                            <div class="login-field">
                                                <label for="login-user" class="login-label">Email address</label>
                                                <input type="text" id="email" name="email" class="login-input" required placeholder="exemple@gmail.com">
                                            </div>    
                                            <div class="btn-group">
                                                <button type="submit" class="login-submit">
                                                    <span>Send</span>
                                                </button>
                                                <a href="#" class="el-btn go-back-login">
                                                    <span>Back</span>
                                                </a>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <footer class="footer">
                <span>© <?php echo date('Y') ?> E-learning by forma2plus.com</span>
            </footer>


        </div>
    </div>
</body>
</html>