<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Corporate_library_soc_model extends CI_Model
{
    
    public function __construct(){
        
        parent::__construct();
        $this->table = 'corporate_library_soc';             
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }

    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function add($arrayData){
        $this->db->trans_start();
        $this->db->insert($this->table, $arrayData);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function getAll() {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getBySoc($id_soc,$Order) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_soc', $id_soc);
        if (isset($Order) && $Order == 'an') {
            $this->db->order_by('name', 'asc');
        }
        elseif (isset($Order) && $Order == 'dn') {
            $this->db->order_by('name', 'desc');
        }        
        elseif (isset($Order) && $Order == 'aid') {
            $this->db->order_by('id', 'asc');
        }        
        elseif (isset($Order) && $Order == 'did') {
            $this->db->order_by('id', 'desc');
        }
        else{
            $this->db->order_by('name', 'asc');
        }
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function Request($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
    
}

?>
