<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/speech/v2/cloud_speech.proto

namespace Google\Cloud\Speech\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * `StreamingRecognizeResponse` is the only message returned to the client by
 * `StreamingRecognize`. A series of zero or more `StreamingRecognizeResponse`
 * messages are streamed back to the client. If there is no recognizable
 * audio then no messages are streamed back to the client.
 * Here are some examples of `StreamingRecognizeResponse`s that might
 * be returned while processing audio:
 * 1. results { alternatives { transcript: "tube" } stability: 0.01 }
 * 2. results { alternatives { transcript: "to be a" } stability: 0.01 }
 * 3. results { alternatives { transcript: "to be" } stability: 0.9 }
 *    results { alternatives { transcript: " or not to be" } stability: 0.01 }
 * 4. results { alternatives { transcript: "to be or not to be"
 *                             confidence: 0.92 }
 *              alternatives { transcript: "to bee or not to bee" }
 *              is_final: true }
 * 5. results { alternatives { transcript: " that's" } stability: 0.01 }
 * 6. results { alternatives { transcript: " that is" } stability: 0.9 }
 *    results { alternatives { transcript: " the question" } stability: 0.01 }
 * 7. results { alternatives { transcript: " that is the question"
 *                             confidence: 0.98 }
 *              alternatives { transcript: " that was the question" }
 *              is_final: true }
 * Notes:
 * - Only two of the above responses #4 and #7 contain final results; they are
 *   indicated by `is_final: true`. Concatenating these together generates the
 *   full transcript: "to be or not to be that is the question".
 * - The others contain interim `results`. #3 and #6 contain two interim
 *   `results`: the first portion has a high stability and is less likely to
 *   change; the second portion has a low stability and is very likely to
 *   change. A UI designer might choose to show only high stability `results`.
 * - The specific `stability` and `confidence` values shown above are only for
 *   illustrative purposes. Actual values may vary.
 * - In each response, only one of these fields will be set:
 *     `error`,
 *     `speech_event_type`, or
 *     one or more (repeated) `results`.
 *
 * Generated from protobuf message <code>google.cloud.speech.v2.StreamingRecognizeResponse</code>
 */
class StreamingRecognizeResponse extends \Google\Protobuf\Internal\Message
{
    /**
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one
     * [is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final]=`true`
     * result (the newly settled portion), followed by zero or more
     * [is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final]=`false`
     * results (the interim results).
     *
     * Generated from protobuf field <code>repeated .google.cloud.speech.v2.StreamingRecognitionResult results = 6;</code>
     */
    private $results;
    /**
     * Indicates the type of speech event.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.StreamingRecognizeResponse.SpeechEventType speech_event_type = 3;</code>
     */
    private $speech_event_type = 0;
    /**
     * Time offset between the beginning of the audio and event emission.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration speech_event_offset = 7;</code>
     */
    private $speech_event_offset = null;
    /**
     * Metadata about the recognition.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 5;</code>
     */
    private $metadata = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<\Google\Cloud\Speech\V2\StreamingRecognitionResult>|\Google\Protobuf\Internal\RepeatedField $results
     *           This repeated list contains zero or more results that
     *           correspond to consecutive portions of the audio currently being processed.
     *           It contains zero or one
     *           [is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final]=`true`
     *           result (the newly settled portion), followed by zero or more
     *           [is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final]=`false`
     *           results (the interim results).
     *     @type int $speech_event_type
     *           Indicates the type of speech event.
     *     @type \Google\Protobuf\Duration $speech_event_offset
     *           Time offset between the beginning of the audio and event emission.
     *     @type \Google\Cloud\Speech\V2\RecognitionResponseMetadata $metadata
     *           Metadata about the recognition.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Speech\V2\CloudSpeech::initOnce();
        parent::__construct($data);
    }

    /**
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one
     * [is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final]=`true`
     * result (the newly settled portion), followed by zero or more
     * [is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final]=`false`
     * results (the interim results).
     *
     * Generated from protobuf field <code>repeated .google.cloud.speech.v2.StreamingRecognitionResult results = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResults()
    {
        return $this->results;
    }

    /**
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one
     * [is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final]=`true`
     * result (the newly settled portion), followed by zero or more
     * [is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final]=`false`
     * results (the interim results).
     *
     * Generated from protobuf field <code>repeated .google.cloud.speech.v2.StreamingRecognitionResult results = 6;</code>
     * @param array<\Google\Cloud\Speech\V2\StreamingRecognitionResult>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResults($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Speech\V2\StreamingRecognitionResult::class);
        $this->results = $arr;

        return $this;
    }

    /**
     * Indicates the type of speech event.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.StreamingRecognizeResponse.SpeechEventType speech_event_type = 3;</code>
     * @return int
     */
    public function getSpeechEventType()
    {
        return $this->speech_event_type;
    }

    /**
     * Indicates the type of speech event.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.StreamingRecognizeResponse.SpeechEventType speech_event_type = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setSpeechEventType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Speech\V2\StreamingRecognizeResponse\SpeechEventType::class);
        $this->speech_event_type = $var;

        return $this;
    }

    /**
     * Time offset between the beginning of the audio and event emission.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration speech_event_offset = 7;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getSpeechEventOffset()
    {
        return $this->speech_event_offset;
    }

    public function hasSpeechEventOffset()
    {
        return isset($this->speech_event_offset);
    }

    public function clearSpeechEventOffset()
    {
        unset($this->speech_event_offset);
    }

    /**
     * Time offset between the beginning of the audio and event emission.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration speech_event_offset = 7;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setSpeechEventOffset($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->speech_event_offset = $var;

        return $this;
    }

    /**
     * Metadata about the recognition.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 5;</code>
     * @return \Google\Cloud\Speech\V2\RecognitionResponseMetadata|null
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    public function hasMetadata()
    {
        return isset($this->metadata);
    }

    public function clearMetadata()
    {
        unset($this->metadata);
    }

    /**
     * Metadata about the recognition.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 5;</code>
     * @param \Google\Cloud\Speech\V2\RecognitionResponseMetadata $var
     * @return $this
     */
    public function setMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\RecognitionResponseMetadata::class);
        $this->metadata = $var;

        return $this;
    }

}

