<?php 
	use PHPMailer\PHPMailer\PHPMailer;
	use PHPMailer\PHPMailer\SMTP;
	use PHPMailer\PHPMailer\Exception;

	defined ( 'BASEPATH' ) or exit ( 'No direct script access allowed' ); 
	include (APPPATH.'controllers/commun/html_table.php');
	include (APPPATH.'libraries/html_script.php');
	include (APPPATH.'libraries/html_form.php');
	include (APPPATH.'includes/Navigation.php');
	//require_once (APPPATH.'libraries/ElearningImages.php');
	require_once(APPPATH.'libraries/global_language.php')				;
	require APPPATH . '/libraries/vendor/autoload.php';
	//include (APPPATH.'language/elearrning_lang.php');
	/**
	 * Class : ElearningForma2PlusController
	 * Base Class to control over all the classes
	 * @author : Alexandre Bors
	 * @version : 1.1
	 * @since : 22 November 2018
	 */
	class ElearningForma2PlusController extends CI_Controller {
		protected $role = '';
		protected $vendorId = '';
		protected $name = '';
		protected $roleText = '';
		protected $GUSERID = '';
		protected $GEXTRANETID = '';
		protected $GUSER = '';
		protected $GUSERTYPE = '';
		protected $BAR = '';
		protected $MODE_ACCES = '';
		protected $GROUPE = '';
		protected $ACCES_FONCTIONS_ADMIN = '';
		protected $TUTEUR_ENTREPRISE = '';
		protected $TYPE = '';
		protected $ROLE = '';
		protected $CNX = '';
		protected $TRACKINGID = '';
		protected $TRACKINGBNTLATERAL = '';
		protected $STAGIAIREGRP = '';
		protected $SOCIETE = '';
		protected $IDSOCIETE = '';
		protected $PDP = '';
		protected $STAGIAIREEXTRANETID = '';
		protected $STAGIAIREID = '';
		protected $GUSERLOGIN;
		protected $STAGIAIRENAME;
		protected $GLOSSAIREONLINE;
		protected $WORKBOOK;
		protected $IDSTAGE;
		protected $NBCONNEXION;
		protected $global = array ();

		public function __construct(){        
	        parent::__construct();
	        //date_default_timezone_set($this->config->item("time_reference"));
	        //$this->config->item("time_reference")
	        $this->load->model('documentsign_model');
	        $this->load->model('bno_model');
	        $this->load->model('video_model');
	        $this->load->model('categoryExpression_model');
	        $this->load->model('Notification_model');
	        $this->load->model('stat_model');
	        $this->load->model('Audio_model');
	        $this->load->model('utilities_model');
	        $this->load->model('stag_individu_model');
	        $this->load->model('historik_course_nl_model');      
	        $this->load->model('connexion_model');  
	        $this->load->model('membres_model');  
	        $this->load->model('sequence_model');
	        $this->load->model('parcours_model');
	        $this->load->model('chapitres_model');
	        $this->load->model('newsletter_model');
	        $this->load->model('databankExpression_model');
	        $this->load->model('stat_prg_model');	        
	        $this->load->model('codeColor_model');
	        $this->load->model('coursHistorik_model');
	        $this->load->model('todolist_model');
	        $this->load->model('document_repository_model');
	        $this->load->model('Document_repository_model');
	        $this->load->model('document_model');
	        $this->load->model('Teacher_link_and_document_model');
	        $this->load->model('modules_model');
	        $this->load->model('groupes_model');
	        $this->load->model('classificationFavoris_Model');
	        $this->load->model('tracking_model');
	        $this->load->model('Content_community_library_forma2plus_model');
	        $this->load->model('Community_library_forma2plus_model');
	        $this->load->file(APPPATH.'libraries/ElearningImages.php', true);
	        $this->script = new HTML_Script(); 
	        $this->connexion_model->refresh($this->session->userdata ( 'CNX' ));
	        $this->tracking_type = 8; 

	    }
		/**
		 * Takes mixed data and optionally a status code, then creates the response
		 *
		 * @access public
		 * @param array|NULL $data
		 *        	Data to output to the user
		 *        	running the script; otherwise, exit
		 */
		public function response($data = NULL) {
			$this->output->set_status_header ( 200 )->set_content_type ( 'application/json', 'utf-8' )->set_output ( json_encode ( $data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES ) )->_display ();
			exit ();
		}
		
		/**
		 * This function used to check the user is logged in or not
		 */
		public function isLoggedIn() {
			$isLoggedIn = $this->session->userdata ( 'isLoggedIn' );
			$ncxExist   = $this->connexion_model->RequestByIdCnx ('id_connexion',$this->session->userdata ('CNX'));			
			if (! isset ( $isLoggedIn ) || $isLoggedIn != TRUE || $ncxExist == '') {
				$this->session->sess_destroy ();    
        		redirect ( 'login' );
			} else {
				$this->IDSTAGE                               = $this->session->userdata ( 'IDSTAGE' );
				$this->GUSERID                               = $this->session->userdata ( 'GUSERID' );
				$this->GUSERLOGIN                            = $this->session->userdata ( 'GUSERLOGIN' );			
				$this->ROLE                                  = $this->session->userdata ( 'ROLE' );			
				$this->GUSER                                 = $this->convert_utf8($this->session->userdata ( 'GUSER' ));
				$this->GEXTRANETID                           = $this->session->userdata ( 'GEXTRANETID' );
				$this->GUSERTYPE                             = $this->session->userdata ( 'GUSERTYPE' );
				$this->BAR                                   = $this->session->userdata ( 'BAR' );
				$this->MODE_ACCES                            = $this->session->userdata ( 'MODE_ACCES' );
				$this->GROUPE                                = $this->session->userdata ( 'GROUPE' );
				$this->ACCES_FONCTIONS_ADMIN                 = $this->session->userdata ( 'ACCES_FONCTIONS_ADMIN' );
				$this->TUTEUR_ENTREPRISE                     = $this->session->userdata ( 'TUTEUR_ENTREPRISE' );
				$this->TYPE                                  = $this->session->userdata ( 'TYPE' );
				$this->CNX                                   = $this->session->userdata ( 'CNX' );
				$this->IDSOCIETE                             = $this->session->userdata ( 'IDSOCIETE' );
				$this->SOCIETE                               = $this->session->userdata ( 'SOCIETE' );
				$this->PDP                                   = $this->session->userdata ( 'PDP' );
				$this->STAGIAIRENAME                         = $this->session->userdata ( 'STAGIAIRENAME' );
				$this->STAGIAIREID                           = $this->session->userdata ( 'STAGIAIREID' );
				$this->STAGIAIREGRP                          = $this->session->userdata ( 'STAGIAIREGRP' );
				$this->GLOSSAIREONLINE                       = $this->session->userdata ( 'GLOSSAIREONLINE' );
				$this->NBCONNEXION                           = $this->session->userdata ( 'NBCONNEXION' );
				$this->WORKBOOK                              = $this->session->userdata ( 'WORKBOOK' );
				
				$this->global ['IDSTAGE']                    = $this->convert_utf8($this->IDSTAGE);
				$this->global ['GUSER']                      = $this->convert_utf8($this->GUSER);
				$this->global ['ROLE']                       = $this->ROLE;
				$this->global ['WORKBOOK']                   = $this->WORKBOOK;
				$this->global ['GEXTRANETID']                = $this->GEXTRANETID;
				$this->global ['GUSERID']                    = $this->GUSERID;
				$this->global ['GUSERTYPE']                  = $this->GUSERTYPE;
				$this->global ['BAR']                        = $this->BAR;
				$this->global ['MODE_ACCES']                 = $this->MODE_ACCES;
				$this->global ['GROUPE']                     = $this->GROUPE;
				$this->global ['ACCES_FONCTIONS_ADMIN']      = $this->ACCES_FONCTIONS_ADMIN;
				$this->global ['TUTEUR_ENTREPRISE']          = $this->TUTEUR_ENTREPRISE;
				$this->global ['TYPE']                       = $this->TYPE;
				$this->global ['CNX']                        = $this->CNX;
				$this->global ['STAGIAIREGRP']               = $this->STAGIAIREGRP;
				$this->global ['STAGIAIREEXTRANETID']        = $this->STAGIAIREEXTRANETID;
				$this->global ['STAGIAIRENAME']              = $this->STAGIAIRENAME;
				$this->global ['IDSOCIETE']                  = $this->IDSOCIETE;
				$this->global ['SOCIETE']                    = $this->SOCIETE;
				$this->global ['PDP']                        = $this->PDP;
				$this->global ['STAGIAIREID']                = $this->STAGIAIREID;
				$this->global ['TRACKINGID']                 = $this->TRACKINGID;
				$this->global ['TRACKINGBNTLATERAL']         = $this->TRACKINGBNTLATERAL;
				$this->global ['GUSERLOGIN']                 = $this->GUSERLOGIN;
				$this->global ['GLOSSAIREONLINE']            = $this->GLOSSAIREONLINE;
				$this->global ['NBCONNEXION']                = $this->NBCONNEXION;

				if ($this->isTuteurConnet()) {
					$this->global ['LISTAUTO']               = $this->groupes_model->readGroupStagiaire($this->session->userdata ('GUSERID'));
					$urlCurrent = str_replace(base_url(), '', $this->getFullUrlCurrent());
					$this->load->model('Log_model');
					if ((strpos($_SERVER['REQUEST_URI'], "trainee-dashbord") && !isset($_GET['action'])) || !strpos($_SERVER['REQUEST_URI'], "trainee-dashbord")) {
						if ($this->trackingRoutesToLoad($urlCurrent) == true) {	
							$data_stat_connexion = array(
								'last_active_link' => $urlCurrent 
							);
							$this->Log_model->update($this->session->userdata ('CNX'),$data_stat_connexion);
						}
						/*elseif (strpos($_SERVER['REQUEST_URI'], "readprog-trainee") || strpos($_SERVER['REQUEST_URI'], "personnal-interest?pave=7")) {
							$data_stat_connexion = array(
								'last_active_link' => $urlCurrent 
							);
							$this->Log_model->update($this->session->userdata ('CNX'),$data_stat_connexion);
						}*/
					}
					elseif (isset($_GET['extranet_id']) && !empty($_GET['extranet_id'])) {
		                $langageFormation = $this->groupes_model->RequestByGrp('langue',$_GET['groupe']);
		                $langagePlateform = '';
		                if (preg_match('/Anglais/i', $langageFormation, $matches)) {  
		                    $langagePlateform = 'english';
		                } 
		                elseif (preg_match('/Français/i', $langageFormation, $matches)){
		                    $langagePlateform = 'french';
		                }             
		                elseif ($langageFormation == NULL || $langageFormation == ''){
		                    $langagePlateform = 'english';
		                }
		                else{
		                    $langagePlateform = 'french';
		                }
		                $sessionArray = array(
		                    'site_lang'      =>$langagePlateform,
		                    'GLOSSAIREONLINE'=>$this->groupes_model->Request('glossaireenligne',$_GET['groupe']),
		                    'IDSTAGE'=> $this->Stag_individu_model->getMaxNumStageByIdMembers($_GET['id']),
		                    'STAGIAIREID'=>$_GET['id'],
		                    'STAGIAIREGRP'=>$_GET['groupe'],
		                    'STAGIAIRENAME'=>$this->membres_model->GetPrenom($_GET['id']).' '.$this->membres_model->GetNom($_GET['id']),
		                    'STAGIAIREEXTRANETID' =>$_GET['extranet_id'],
		                    'IDSOCIETE'           =>$this->membres_model->Request('id_societe',$_GET['id']),
		                    'IDSOCIETESTAGIAIRE'  =>$this->membres_model->Request('id_societe',$_GET['id']),
		                    'NAMESOCIETESTAGIAIRE'=>$this->societe_model->Request('description',$this->membres_model->Request('id_societe',$_GET['id']))
		                ); 
		                $this->global['GLOSSAIREONLINE']          = $this->groupes_model->Request('glossaireenligne',$_GET['groupe']);
		                $this->global['GEXTRANETID']          = isset($_GET['extranet_id']) ? $_GET['extranet_id'] : $GEXTRANETID;
		                $this->global['IDSTAGE']              = isset($_GET['id']) ? $this->Stag_individu_model->getMaxNumStageByIdMembers($_GET['id']) : $IDSTAGE;
		                $this->global['groupe']                = $_GET['groupe'];
                
		                $this->global['STAGIAIREID']           = $_GET['id'];
		                $this->global['STAGIAIREGRP']          = $_GET['groupe'];

		                $dataConnexion = array(
		                	'id_groupe'  => $this->global['STAGIAIREGRP'],
		                    'id_stage' => $this->Stag_individu_model->getMaxNumStageByIdMembers($_GET['id'])
		                );

		                $this->connexion_model->update($this->session->userdata ('CNX'),$dataConnexion);

		                $this->session->set_userdata($sessionArray);			
		                $last_activity_link = $this->Log_model->Request('last_active_link',$this->session->userdata ('CNX'));
		                /*var_dump(strstr($last_activity_link, "readprog-trainee"));
		                die($last_activity_link);
		                if (strstr($last_activity_link, "readprog-trainee") >= 1) {
		                	die('readprog-trainee?action=listerPageStagiaire&paves_sequence='.$_GET['paves_sequence'].'&id='.$this->session->userdata ('STAGIAIREID').'&groupe='.$this->session->userdata ('STAGIAIREGRP').'');
							redirect('readprog-trainee?action=listerPageStagiaire&paves_sequence='.$_GET['paves_sequence'].'&id='.$this->session->userdata ('STAGIAIREID').'&groupe='.$this->session->userdata ('STAGIAIREGRP').'');
						}
						else{*/
							redirect($last_activity_link);
						//}
		            }
		            elseif (strpos($_SERVER['REQUEST_URI'], "add-tracking-to-access-content") || strpos($_SERVER['REQUEST_URI'], "add-tracking-lib") || strpos($_SERVER['REQUEST_URI'], "saveTrackingLib") || strpos($_SERVER['REQUEST_URI'], "updateTracking")) {	
						return true;
					}
		            else{
		            	die('Error 403 !! <br>Access defined');
		            }
				}

				if ($this->global['GUSERTYPE']==STAGIAIRE) {
					$this->global ['DATABANKEXPRESSIONS']               = $this->databankExpression_model->read($this->session->userdata ('GUSERID'));
				}
			}
		}

		public function trackingRoutes($routes){
			$arrayRoutes = array('refresh-tracking', 'logout-by-params', 'add-tracking-navigation', 'add-tracking-shortcut-navigation', 'add-tracking-and-get-status-by-link', 'add-tracking', 'add-tracking-exercice-in-fav', 'add-tracking-to-access-content', 'add-tracking-com', 'refresh-tracking-btn-lateral', 'refresh-data', 'saveTracking', 'switch-to-v1', 'authorization-baerer', 'authorization', 'get-token', 'add-tracking-document', 'scan-url', 'add-tracking-to-access-content', 'add-tracking-lib', 'saveTrackingLib', 'updateTracking', 'get-status-by-todo-in-tutor', 'get-status-by-link', 'get-status-by-todo');
			return in_array($routes, $arrayRoutes);
		}

		public function trackingRoutesToLoad($routes){
			$arrayRoutes = array('tutordashbord', 'trainee-dashbord', 'statistic', 'trainee-todo-in-tutor', 'get-trainee-favorite', 'fbTuteur', 'speed-connexion', 'readprog-trainee', 'personnal-interest', 'trainer-newsletter', 'coporate-lib-soc', 'dcTuteur', 'listLinkDocs', 'community-library-f2plus', 'user-profil', 'media-list', 'audio-list', 'databank-expression', 'picture-list');
			return in_array($routes, $arrayRoutes);
		}
		
		/**
		 * This function is used to check the access
		 */
		public function isAdmin() {
			if ($this->TYPE == ADMIN) {
				return true;
			} 
			else {
				return false;
			}
		}

		public function isSupervisor() {
			if ($this->TYPE == SUPERVISEUR) {
				return true;
			} 
			else {
				return false;
			}
		}

		public function isTuteur() {
			if ($this->TYPE != TUTEUR) {
				$return = "";
			} 
			else {
				$return = $this->groupes_model->readGrpTutor($this->session->userdata ('GUSERID'));		
			}
			return $return;
		}
		
		/**
		 * This function is used to check the access
		 */
		public function isTicketter() {
			if ($this->TYPE != ADMIN || $this->TYPE != SUPERVISEUR) {
				return true;
			} else {
				return false;
			}
		}

		public function isTrainee() {
			if ($this->TYPE == STAGIAIRE && $this->MODE_ACCES != "3") {
				return true;
			} else {
				return false;
			}
		}

		public function isAdministratif() {
			if ($this->TYPE == STAGIAIRE && $this->MODE_ACCES == "3") {
				return true;
			} else {
				return false;
			}
		}

	    public function isTuteurConnet() {
			if ($this->TYPE == TUTEUR) {
				return true;
			} else {
				return false;
			}
		}
		
		
		/**
		 * This function is used to load the set of views
		 */
		public function loadThis() {
			$this->global ['pageTitle'] = 'Plateforme E-learning : Access Denied';	
			$this->load->view ( 'includes/header', $this->global );
			$this->load->view ( 'access' );
			$this->load->view ( 'includes/footer' );
		}
		
		/**
		 * This function is used to logged out user from system
		 */
		public function logout() {
			$this->session->sess_destroy ();	
			redirect ( 'login' );
		}

		public function adminMenu(){
			return array(
				0 => array(
					'menu'     => 'Outils',
					'roots'    => array('managefb'),
					'icon'     => "<i class='bx bx-chevron-down'></i>",
					'submenus' => array(
						0 => array(
							'title' => 'Feuille blanche', 
							'root'  => 'managefb', 
							'icon'  => "<i class='bx bxs-note'></i>", 
						),
					),
				) , 
				1 => array(
					'menu' => 'Librairies',
					'roots'    => array('managesequences', 'managenewsletter', 'managemodules', 'manageparcours'),
					'icon'  => "<i class='bx bx-chevron-down'></i>",
					'submenus' => array(
						0 => array(
							'title' => 'Modules', 
							'root' => 'managemodules', 
							'icon'  => "<i class='bx bx-folder-open'></i>", 
						),
						1 => array(
							'title' => 'Newsletter', 
							'root' => 'managenewsletter', 
							'icon'  => "<i class='bx bx-news'></i>", 
						),
						2 => array(
							'title' => 'Parcours', 
							'root' => 'manageparcours',
							'icon'  => "<i class='bx bxl-discourse'></i>",  
						),
						3 => array(
							'title' => 'Séquence', 
							'root' => 'managesequences',
							'icon'  => "<i class='bx bx-list-plus'></i>",  
						),
					),
				) ,  
				2 => array(
					'menu' => 'Boosters',
					'roots'    => array(),
					'icon'  => "<i class='bx bx-chevron-down'></i>",
					'submenus' => array(
						0 => array(
							'title' => 'Liste des vidéos', 
							'root' => '', 
							'icon'  => "<i class='bx bxs-videos'></i>", 
						),
						1 => array(
							'title' => 'Liste des expression', 
							'root' => '', 
							'icon'  => "<i class='bx bxs-file'></i>", 
						),
						2 => array(
							'title' => 'Liste des images', 
							'root' => '', 
							'icon'  => "<i class='bx bxs-image'></i>", 
						),
						3 => array(
							'title' => 'Liste des audios', 
							'root' => '',
							'icon'  => "<i class='bx bxs-playlist'></i>",  
						),
					),
				) ,  
				3 => array(
					'menu' => 'Profil',
					'roots'    => array('members'),
					'icon'  => "<i class='bx bx-chevron-down'></i>",
					'submenus' => array(
						0 => array(
							'title' => 'Utilisateurs', 
							'root' => 'members', 
							'icon'  => "<i class='bx bxs-user' ></i>", 
						),
					),
				) ,  
				4 => array(
					'menu' => 'Autres',
					'roots'    => array('folder-group', 'mail-box', 'communic', 'connexion-failure'),
					'icon'  => "<i class='bx bx-chevron-down'></i>",
					'submenus' => array(
						0 => array(
							'title' => 'Dossier groupe', 
							'root'  => 'folder-group',
							'icon'  => "<i class='bx bx-folder'></i>",  
						),
						1 => array(
							'title' => 'Email & SMS', 
							'root'  => 'communic',
							'icon'  => "<i class='bx bxs-envelope' ></i>",  
						),
						2 => array(
							'title' => 'Noficiation CH', 
							'root'  => 'mail-box', 
							'icon'  => "<i class='bx bxs-envelope' ></i>", 
						),
						3 => array(
							'title' => 'Tentative de connexion', 
							'root'  => 'connexion-failure',
							'icon'  => "<i class='bx bx-log-in-circle'></i>",  
						),
					),
				) , 
			);
		}

	    public function loadViews($viewName = "", $headerInfo = NULL, $pageInfo = NULL, $footerInfo = NULL){
	    	$this->load->library('Encodage_Library');
	    	if ($this->isTuteurConnet()) {

	    		$this->load->view('includes/templates/professor/header', $headerInfo);
	    		$this->load->view($viewName, $pageInfo);
	    		$this->load->view('includes/templates/professor/footer', $footerInfo);        	
	    	}
	    	elseif ($this->isAdmin()) {
	    		$headerInfo['adminMenus'] = $this->adminMenu();
				$this->load->view('includes/templates/admin/header', $headerInfo);
				$this->load->view($viewName, $pageInfo);

	    		$this->load->view('includes/templates/admin/footer', $footerInfo); 
	    	}
	    	elseif ($this->isSupervisor()) {
	    		$this->load->view('includes/templates/supervisor/header', $headerInfo);
	    		$this->load->view($viewName, $pageInfo);
	    		$this->load->view('includes/templates/supervisor/footer', $footerInfo); 
	    	}
	    	elseif ($this->isTrainee() || $this->isAdministratif()) {
	    		$this->load->view('includes/templates/trainee/trainee_header', $headerInfo);
	    		$this->load->view($viewName, $pageInfo);
	    		$this->load->view('includes/templates/trainee/trainee_footer', $footerInfo); 
	    		/*$this->load->view('includes/templates/trainee/header', $headerInfo);
	    		$this->load->view($viewName, $pageInfo);
	    		$this->load->view('includes/templates/trainee/footer', $footerInfo); */
	    	}
	    	else{
	    		$this->load->view('includes/header', $headerInfo);
	    		$this->load->view($viewName, $pageInfo);
	    		$this->load->view('includes/footer', $footerInfo);        	
	    	}
	    	
	        
	    }

		public function paginationCompress($link, $count, $perPage = 10) {
			$this->load->library ( 'pagination' );
		
			$config ['base_url'] = base_url () . $link;
			$config ['total_rows'] = $count;
			$config ['uri_segment'] = SEGMENT;
			$config ['per_page'] = $perPage;
			$config ['num_links'] = 5;
			$config ['full_tag_open'] = '<nav><ul class="pagination">';
			$config ['full_tag_close'] = '</ul></nav>';
			$config ['first_tag_open'] = '<li class="arrow">';
			$config ['first_link'] = 'First';
			$config ['first_tag_close'] = '</li>';
			$config ['prev_link'] = 'Previous';
			$config ['prev_tag_open'] = '<li class="arrow">';
			$config ['prev_tag_close'] = '</li>';
			$config ['next_link'] = 'Next';
			$config ['next_tag_open'] = '<li class="arrow">';
			$config ['next_tag_close'] = '</li>';
			$config ['cur_tag_open'] = '<li class="active"><a href="#">';
			$config ['cur_tag_close'] = '</a></li>';
			$config ['num_tag_open'] = '<li>';
			$config ['num_tag_close'] = '</li>';
			$config ['last_tag_open'] = '<li class="arrow">';
			$config ['last_link'] = 'Last';
			$config ['last_tag_close'] = '</li>';
		
			$this->pagination->initialize ( $config );
			$page = $config ['per_page'];
			$segment = $this->uri->segment ( SEGMENT );
		
			return array (
					"page" => $page,
					"segment" => $segment
			);
		}

		public function DisplayGroupe($idg,$stagiaireid=NULL) {
		 	$ret = '';
			//On ajoute ou pas l'ecran extranet
			if (empty($stagiaireid)) {
				$ret.= $this->tableProgramme($idg);
			} else {
				$ret.= $this->StagiaireAvecExtranet($idg,$stagiaireid);
			}		
			//On ajoute ou pas l'activités en cours d'une session groupe
			$userId = $this->groupes_model->getUserIdByGroupId($idg);
			
			/*if ($this->connexion_model->Activity($userId) != "") { desactiveko pour le moment			
				$ret.= $this->activityStagiaire($userId);		
			}*/
		
			//Last activity for tutor
			if ($this->isTuteurConnet()) {				
				/*$listOfActivities = $this->groupes_model->getListActivityByTuteur($this->session->userdata ('GUSERID'));
				if (count($listOfActivities) > 0) {
					$ret.= $this->ActiviteEffectueByTuteur($listOfActivities);
				} */
			}				
			return $ret;
		}

		public function activityStagiaire($idg) {
			
			$ret = "";
			$ret .= "<br>";
			$ret .= "<table class='table'><tr><td>Activit&eacute; en cours</td>";
			$ret .= "<td><span style='color:green;font-weight:bold'><blink>".$this->connexion_model->Activity($idg)."</blink></span></td></tr></table>";
			
			return $ret;
		}

		public function ActiviteEffectue($listOfActivities) {
			$ret  = "";
			$ret .= "<br>";
			$tableActiviteEffectuees = new HTML_Table_Titres(array(29, 25, 25, 25),
			 		   	 	 				   80,
			                                   array("Heure commenc&eacute;e",
													 "Temps Complet&eacute;",	
													 "S&eacute;quence",
													 "Exercice"));
			for ( $i=0; $i<$listOfActivities['cnt']; $i++) {
				$ligne = array();
				$ligne[] = str_replace(".000000", '', $listOfActivities[$i]['date']);

				if ($listOfActivities[$i]['time']=="838:59:59") {
					$time="";
				}
				else{
					$time=$listOfActivities[$i]['time'];
				}
				$ligne[] = $time;
				$ligne[] = $listOfActivities[$i]['sequence'];
				$ligne[] = $listOfActivities[$i]['exercice'];
				$tableActiviteEffectuees->addRow($ligne);
			}	
			$ret.= $tableActiviteEffectuees->toHTML();		
			return $ret;
		}
		public function ActiviteEffectueByTuteur($listOfActivities) {
			$start_time     = '';
			$full_time      = '';
			$Sequence       = '';
			$Exercice       = '';
			$ret  = "";
			$ret .= "<br>";
			$ret .= "<table class='table tableLastActivity' id='tableLastActivity'>";
				$ret .= "<thread>";										 
					$ret .= "<tr>";										 
						$ret .= "<th>Started time</th>";										 
						$ret .= "<th>Full Time</th>";										 
						$ret .= "<th>Sequence</th>";										 
						$ret .= "<th>Exercise</th>";										 
					$ret .= "</tr>";										 
				$ret .= "</thread>";										 
				$ret .= "<tbody>";		
				/*foreach ($listOfActivities as $res) {
					$start_time = date('Y-m-d H:i:s', $res->date);
	                $full_time  = gmdate('H:i:s', $res->time);

					switch ($res->tracking_type) {
	                  case 2:
	                    if (!is_null($res->sequence_id)) {
	                      $Sequence       = $this->coursHistorik_model->Request('intitule',$res->sequence_id);
	                    }
	                    if (!is_null($res->chapitre_id)) {
	                      $Exercice       = $this->todolist_model->Request('sequence',$res->chapitre_id);
	                    }
	                    break;
	                  case 4:
	                  	$Sequence       = 'My database documents';
	                    if (!is_null($res->sequence_id)) {
	                      $Exercice       = $this->document_model->Request('titre',$res->sequence_id);
	                    }
	                    break;
	                  case 6:
	                    if (!is_null($res->chapitre_id)) {     
	                      $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$res->chapitre_id));
	                      $Exercice       = $this->newsletter_model->Request('article',$res->chapitre_id);
	                    }
	                    break;
	                  case 7:
	                    if (!is_null($res->sequence_id) && $res->sequence_id != 0) {
	                      $Sequence       = $this->sequence_model->Request('sequence_titre',$res->sequence_id);
	                    }   

	                    if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {    
	                      $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$res->sequence_id,$res->chapitre_id);
	                    }
	                    break; 
	                  case 8:
	                    if (!is_null($res->sequence_id) && $res->sequence_id != 0) {
	                      $Sequence       = $this->sequence_model->Request('sequence_titre',$res->sequence_id);
	                    }   

	                    if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {     
	                      $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$res->sequence_id,$res->chapitre_id);
	                    }
	                    break; 
	                  case 9:
	                    if (!is_null($res->sequence_id) && $res->sequence_id != 0) {
	                      $Sequence       = $this->sequence_model->Request('sequence_titre',$res->sequence_id);
	                    }   

	                    if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {     
	                      $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$res->sequence_id,$res->chapitre_id);
	                    }
	                    break; 
	                  case 10:                   
	                    $Sequence       = 'Statistic connexion'; 
	                    break;
	                  case 14:
	                    $Sequence      = 'Training objectif'; 
	                    break; 
	                  case 16:
	                    $Sequence       = 'My document to sign'; 
	                    break;  
	                  case 18:
	                    //$Parcours       = 'Dashbord';  
	                    $Parcours       = '';  
	                    break;       
	                  case 20:
	                    $Sequence           = 'My own expression databank'; 
	                    break;     
	                  case 22:
	                    $Sequence           = 'My glossary';
	                    break;       
	                  case 23:
	                    $Sequence           = 'My audio';
	                    break;         
	                  case 24:
	                    $Parcours       = 'Accès plateforme e-learning et tutorat';
	                    $Menu           = 'My training period';
	                    $SousMenu       = 'My favoris';  
	                    if ($this->stat_prg_model->Request('type',$res->sequence_id) == 'document') {
	                      $Sequence       = $this->classificationFavoris_Model->Request('intitule',$res->module_id);
	                      $Exercice       = $this->document_model->Request('titre',$res->chapitre_id);
	                    }  
	                    elseif ($this->stat_prg_model->Request('type',$res->sequence_id) == 'activity_sequence') {
	                      $Sequence       = $this->sequence_model->Request('sequence_titre',$this->stat_prg_model->Request('id_prg',$res->sequence_id));
	                      $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$this->stat_prg_model->Request('id_prg',$res->sequence_id),$res->chapitre_id);
	                    } 
	                    elseif ($this->stat_prg_model->Request('type',$res->sequence_id) == 'nl_article') {
	                      $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$res->chapitre_id));
	                      $Exercice       = $this->newsletter_model->Request('article',$res->chapitre_id);
	                    } 
	                    elseif ($this->stat_prg_model->Request('type',$res->sequence_id) == 'nl_categories') {
	                      if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {
	                        $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$res->chapitre_id));
	                        $Exercice       = $this->newsletter_model->Request('article',$res->chapitre_id);
	                      }
	                    }
	                    elseif ($this->stat_prg_model->Request('type',$res->sequence_id) == 'sequence_activite') {
	                      $Sequence       = $this->sequence_model->Request('sequence_titre',$this->stat_prg_model->Request('id_prg',$res->sequence_id));
	                      if (!is_null($res->chapitre_id) && $res->chapitre_id != 0) {
	                        $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$this->stat_prg_model->Request('id_prg',$res->sequence_id),$res->chapitre_id);
	                      }
	                    }  
	                    else {
	                      $Sequence       = $this->classificationFavoris_Model->Request('intitule',$res->module_id);
	                      $Exercice       = $this->document_model->Request('titre',$res->chapitre_id);
	                    } 
	                    break;      
	                  case 25:
	                    $Sequence       = 'My connexion speed';  
	                    break;           
	                  case 26:
	                    $Sequence       = 'White paper';              
	                  case 30:
	                    $Sequence       = 'Conference call';   
	                    break;                
	                  default:
	                    # code...
	                    break;
	                }
					$ret .= "<tr>";							 
						$ret .= "<td>".htmlentities($start_time)."</td>";							 
						$ret .= "<td>".htmlentities($full_time)."</td>";							 
						$ret .= "<td>".htmlentities($Sequence)."</td>";							 
						$ret .= "<td>".htmlentities($Exercice)."</td>";							 
					$ret .= "</tr>";
				}*/							 
				$ret .= "</tbody>";										 
			$ret .= "</table>";
			return $ret;
		}

		public function tableProgramme($idg) {
		
			$table = "";
			$table .= "<table class='table'>";
				$table .= "<thead>";
					$table .= "<tr>";
						$table .= "<th>Trainee</th>";
						$table .= "<th>Last Session</th>";
						$table .= "<th>Total sessions</th>";
					$table .= "</tr>";
				$table .= "</thead>";
				$table .= "<tbody>";

			$tGroupe = $this->groupes_model->Members($idg);
			for ( $i=0; $i<$tGroupe['cnt']; $i++) {
				$table .= "<tr>";
					$table .= "<td>".utf8_decode($tGroupe[$i]['name'])."</td>";
					$table .= "<td>".str_replace(".000000", '', $tGroupe[$i]['date_cnx'])."</td>";
					$table .= "<td><a href='".base_url().'tuteur/detail/index?action=listerConnexions&groupe='.$tGroupe[$i]['id_groupe'].'&id='.$tGroupe[$i]['id']."'>".$tGroupe[$i]['nbconnexion']."</a></td>";
				$table .= "</tr>";
			}
			$table .= "</tbody>";
			$table .= "</table>";
			return $table;
		}

		public function StagiaireAvecExtranet($idg,$stagiaireid) {
			$ret = '';
			$ret .= $this->tableProgramme($idg);				
			return $ret;
		}
		
		public function ReplaceDateTime($date)	{
			if ($date == '') {
				return('');
			}
			return(date(FORMATDATETIME, $date));
		}

		public function ReplaceDate($date)	{
			if ($date == '' ||
				$date < 0 || $date > 2147382000) {
				return('');
			}
			return(date(FORMATDATE, $date));
		}

		public function getFileName($url){
			$path = parse_url($url, PHP_URL_PATH);
			return basename($path);
		}
		/*Generate thumbnail*/
		public function generateThumbnail($url,$width,$height,$dest){
	        $this->thumb = new Screen\Capture($url);

			if (!isset($url)) {
	            exit;
	        }

	        if (isset($width)) { // Width
	            $this->thumb->setWidth(intval($width));
	        }

	        if (isset($height)) { // Height
	            $this->thumb->setHeight(intval($height));
	        }

	        if (isset($width)) { // Clip Width
	            $this->thumb->setClipWidth(intval($width));
	        }

	        if (isset($height)) { // Clip Height
	            $this->thumb->setClipHeight(intval($height));
	        }

	        if (isset($_GET['user-agent'])) { // User Agent String
	            $this->thumb->setUserAgentString($_GET['user-agent']);
	        }

	        if (isset($_GET['bg-color'])) { // Background Color
	            $this->thumb->setBackgroundColor($_GET['bg-color']);
	        }

	        if (isset($_GET['format'])) { // Format
	            $this->thumb->setImageType($_GET['format']);
	        }
	        if($this->thumb->save($dest)){
	            return true;
	        }
	        else{
	            return false;
	        }
	        exit;
		}

		public function image_handler($source_image,$destination,$tn_w = 100,$tn_h = 100,$quality = 80,$wmsource = false) {
	        // The getimagesize functions provides an "imagetype" string contstant, which can be passed to the image_type_to_mime_type function for the corresponding mime type
	        $info = getimagesize($source_image);
	        $imgtype = image_type_to_mime_type($info[2]);
	        // Then the mime type can be used to call the correct function to generate an image resource from the provided image
	        switch ($imgtype) {
	            case 'image/jpeg':
	                $source = imagecreatefromjpeg($source_image);
	            break;
	            case 'image/gif':
	                $source = imagecreatefromgif($source_image);
	            break;
	            case 'image/png':
	                $source = imagecreatefrompng($source_image);
	            break;
	            default:
	                die('Invalid image type.');
	        }
	        // Now, we can determine the dimensions of the provided image, and calculate the width/height ratio
	        $src_w = imagesx($source);
	        $src_h = imagesy($source);
	        $src_ratio = $src_w/$src_h;
	        // Now we can use the power of math to determine whether the image needs to be cropped to fit the new dimensions, and if so then whether it should be cropped vertically or horizontally. We're just going to crop from the center to keep this simple.
	        if ($tn_w/$tn_h > $src_ratio) {
	        $new_h = $tn_w/$src_ratio;
	        $new_w = $tn_w;
	        } else {
	        $new_w = $tn_h*$src_ratio;
	        $new_h = $tn_h;
	        }
	        $x_mid = $new_w/2;
	        $y_mid = $new_h/2;
	        // Now actually apply the crop and resize!
	        $newpic = imagecreatetruecolor(round($new_w), round($new_h));
	        imagecopyresampled($newpic, $source, 0, 0, 0, 0, $new_w, $new_h, $src_w, $src_h);
	        $final = imagecreatetruecolor($tn_w, $tn_h);
	        imagecopyresampled($final, $newpic, 0, 0, ($x_mid-($tn_w/2)), ($y_mid-($tn_h/2)), $tn_w, $tn_h, $tn_w, $tn_h);
	        // If a watermark source file is specified, get the information about the watermark as well. This is the same thing we did above for the source image.
	        if($wmsource) {
	            $info = getimagesize($wmsource);
	            $imgtype = image_type_to_mime_type($info[2]);
	            switch ($imgtype) {
	                case 'image/jpeg':
	                    $watermark = imagecreatefromjpeg($wmsource);
	                break;
	                case 'image/gif':
	                    $watermark = imagecreatefromgif($wmsource);
	                break;
	                case 'image/png':
	                    $watermark = imagecreatefrompng($wmsource);
	                break;
	                default:
	                    die('Invalid watermark type.');
	            }
	            // Determine the size of the watermark, because we're going to specify the placement from the top left corner of the watermark image, so the width and height of the watermark matter.
	            $wm_w = imagesx($watermark);
	            $wm_h = imagesy($watermark);
	            // Now, figure out the values to place the watermark in the bottom right hand corner. You could set one or both of the variables to "0" to watermark the opposite corners, or do your own math to put it somewhere else.
	            $wm_x = $tn_w - $wm_w;
	            $wm_y = $tn_h - $wm_h;
	            // Copy the watermark onto the original image
	            // The last 4 arguments just mean to copy the entire watermark
	            imagecopy($final, $watermark, $wm_x, $wm_y, 0, 0, $tn_w, $tn_h);
	        }
	        // Ok, save the output as a jpeg, to the specified destination path at the desired quality.
	        // You could use imagepng or imagegif here if you wanted to output those file types instead.
	        if(Imagejpeg($final,$destination,$quality)) {
	            return true;
	        }
	        // If something went wrong
	        return false;
	    }

	    public function displayFicheStagiaireTracking($idu, $idg) {
			
			$info = $this->membres_model->GetFiche($idu);		
			return($info);
		}
		public function displayhpotos($idu) {
			$photo = $this->membres_model->photo($idu);
			return($photo);
		}
		
		public function displaySessionTracking($idu, $idg,$PAVE='') {
			$retour = "";
		    $nbrBtn= 1;
		    $nbrMod= 1;
		    $nbrSeq= 1;
		    $lienCol= 1;
		    $sequence_id;
		    $paves_sequence_nom = '';
		    $tabContentHtml = '';
		    //Declaration variable numero pour chaque liste
		    $numeroSeq = 0;
		    $url_sequence = ""; 

		    define('PAGELOCALFORMATION',  base_url().'formation'); 
		   
		    if($PAVE!=''){
		        $ret_complementary_activities=$this->sequence_model->getPavetComplementary($this->session->userdata ('STAGIAIREGRP'));  
		        $ret_newsletter2 = $this->sequence_model->getPavetSequenceHaut($this->session->userdata ('STAGIAIREGRP'),$this->session->userdata ('GUSERID'),$PAVE);  
		        $nbrBtn= 1;
		        $active = '';
		        foreach($ret_newsletter2['module'] as $key2=>$value2){
		            if(is_array($value2)){ 
		                $active = $nbrBtn == 1 ? 'active' : '';
		                $tabContentHtml.= '<div id="content-'.$nbrBtn.'" class="tab-content '.$active.' container-sequence">';
		                    $tabContentHtml.= '<div class="tab-title title-active-menu-pg"><h2 class="content_title">Your sequences (content of '.$key2.')</h2></div>';
		                    $tabContentHtml .= '<div class="card-container">';
		                        foreach($value2 as $key3=>$value3){
		                            $ret_newsletter3=$this->sequence_model->getPavetSequenceHauts($value3['MODULENAME'],$value3['idg'],$value3['module_id'],$PAVE);
		                            foreach($ret_newsletter3['module'] as $key4=>$value4){
		                                if(is_array($value4)){
		                                    $sequenceName = '';
		                                    foreach($value4 as $key5=>$value5){
		                                        if($value5['sequence_name'] != "") {
		                                            $sequenceName = ($this->session->userdata ('site_lang') == 'english' && $value5['sequence_name'] == "Articles REBONDIR") ? "Anastasia Autret's Tips" : $value5['sequence_name'];
		                                            $sequenceUrl   = $value5['sequence_url'];  
		                                            $idsequence    = $value5['sequence_id'];   
		                                            $locsequence    = $value5['locs'];   
		                                            //Thumb
		                                            $thumbnailSeq = $this->sequence_model->getThumbFromLastSequence($idsequence);
		                                            if ($thumbnailSeq != '' && file_exists($thumbnailSeq)) {
		                                                $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnailSeq;
		                                            }
		                                            else{

		                                                $fileimg = base_url()."groupes/bg-laptop.png";
		                                            }
		                                            $tabContentHtml .= '<div class="card-style-1">
		                                                <div class="card">
		                                                    <div class="card-left">
		                                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
		                                                    </div>
		                                                    <div class="card-right sequenceTotal">
		                                                        <div class="card-title">
		                                                            <h4>'.$this->convert_utf8($sequenceName).'</h4>
		                                                        </div>
		                                                        <div class="card-footer">
		                                                            <a href="#" class="btn-see" onclick="getAllActivityBySequence(this);" data-pave="'.$PAVE.'" value="'.$nbrSeq.'" data-name="'.$sequenceName.'" data-ids="'.$idsequence.'">
		                                                                <i class="fa-solid fa-eye"></i>
		                                                            </a>
		                                                            <a href="#" data-title="'.$this->convert_utf8($sequenceName).'" class="add-comment" onclick="addCommentSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" title="'.$this->lang->line('course_history_placeholder_comment').'">
		                                                                <i class="fa-solid fa-comment"></i>
		                                                            </a>
		                                                            <a data-title="'.$this->convert_utf8($sequenceName).'" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" class="add-favorite" onclick="addSequenceInFavorite(this);" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
		                                                                <i class="fa-solid fa-heart"></i>
		                                                            </a>
		                                                        </div>
		                                                    </div>
		                                                </div>
		                                            </div>';
		                                        }
		                                    }
		                                }
		                            }
		                        }
		                    $tabContentHtml.='</div>';
		                $tabContentHtml.='</div>';
		                $nbrBtn= $nbrBtn + 1;
		            }
		        }   

		        $array_newsletter = $this->sequence_model->getPavetHaut($this->session->userdata ('STAGIAIREGRP'),4);
		        $array_ped_training = $this->sequence_model->getPavetHaut($this->session->userdata ('STAGIAIREGRP'),6);
		        $array_pers_ling = $this->sequence_model->getPavetHaut($this->session->userdata ('STAGIAIREGRP'),7);
		        $array_ling_tools = $this->sequence_model->getPavetHaut($this->session->userdata ('STAGIAIREGRP'),8);

		        $arrayListeModule = array();
		        $array_id_module_newsletter = array();
		        $array_id_module_ped_training = array();
		        $array_id_module_pers_ling = array();
		        $array_id_module_ling_tools = array();   

		        if(!empty($array_newsletter)){
		            if (is_array($array_newsletter['module'])) {
		                foreach($array_newsletter['module'] as $key=>$value){
		                    foreach($value as $key2=>$value2){
		                        $arrayListeModule[] = $value2['module_id'];
		                        $array_id_module_newsletter[] = $value2['module_id'];
		                    }
		                }
		            }
		        }
		        if(!empty($array_ped_training)){
		            if (is_array($array_ped_training['module'])) {
		                foreach($array_ped_training['module'] as $key=>$value){
		                    foreach($value as $key2=>$value2){
		                        $arrayListeModule[] = $value2['module_id'];
		                        $array_id_module_ped_training[] = $value2['module_id'];
		                    }
		                }
		            }
		        }
		        if(!empty($array_pers_ling)){
		            if (is_array($array_pers_ling['module'])) {
		                foreach($array_pers_ling['module'] as $key=>$value){
		                    foreach($value as $key2=>$value2){
		                        $arrayListeModule[] = $value2['module_id'];
		                        $array_id_module_pers_ling[] = $value2['module_id'];
		                    }
		                }
		            }
		        }
		        if(!empty($array_ling_tools)){
		            if (is_array($array_ling_tools['module'])) {
		                foreach($array_ling_tools['module'] as $key=>$value){
		                    foreach($value as $key2=>$value2){
		                        $arrayListeModule[] = $value2['module_id'];
		                        $array_id_module_ling_tools[] = $value2['module_id'];
		                    }
		                }
		            }
		        }
		        if(!empty($ret_complementary_activities)){
		            if (is_array($ret_complementary_activities['module'])) {
		                foreach($ret_complementary_activities['module'] as $key=>$value){
		                    $arrayListeModule[] = $value['module_id'];
		                }
		            }
		        }

		        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_newsletter) ;
		        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
		        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;
		        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ling_tools) ;          
		        if(!empty($ret_complementary_activities)){
		            if(is_array($ret_complementary_activities['module']) && $PAVE=='6'){
		                $tabContentHtml.= '<div id="content-000000" class="tab-content container-sequence">';
		                    $tabContentHtml.= '<div class="tab-title title-active-menu-pg"><h2 class="content_title">Your sequences (content of Complementary Activities)</h2></div>';
		                    $tabContentHtml .= '<div class="card-container">';
		                        foreach($ret_complementary_activities['module'] as $key=>$value){
		                            if (in_array($value['module_id'], $arrayListeModule)) {
		                                $thumbnailSeq = $this->sequence_model->getThumbFromLastSequence($value['sequence_id']);
		                                if ($thumbnailSeq != '' && file_exists($thumbnailSeq)) {
		                                    $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnailSeq;
		                                }
		                                else{

		                                    $fileimg = base_url()."groupes/bg-laptop.png";
		                                }
		                                $tabContentHtml .= '
		                                <div class="card-style-1">
		                                    <div class="card">
		                                        <div class="card-left">
		                                            <a href="#"><img src="'.$fileimg.'" alt=""></a>
		                                        </div>
		                                        <div class="card-right sequenceTotal">
		                                            <div class="card-title">
		                                                <h4>'.$value['sequence_name'].'</h4>
		                                            </div>
		                                            <div class="card-footer">
		                                                <a href="#" class="btn-see" onclick="getAllActivityBySequence(this);" tablinks" data-pave="'.$PAVE.'" value="'.$nbrSeq.'" data-name="'.$value['sequence_name'].'" data-ids="'.$value['sequence_id'].'">
		                                                    <i class="fa-solid fa-eye"></i>
		                                                </a>
		                                                <a href="#" data-title="'.$this->convert_utf8($value['sequence_name']).'" class="add-comment" onclick="addCommentSequence(this);" data-id="'.$value['sequence_id'].'" data-code="'.$value5['code'].'" title="'.$this->lang->line('course_history_placeholder_comment').'">
		                                                    <i class="fa-solid fa-comment"></i>
		                                                </a>
		                                                <a data-title="'.$this->convert_utf8($value['sequence_name']).'" data-id="'.$value['sequence_id'].'" data-code="'.$value5['code'].'" class="add-favorite" onclick="addSequenceInFavorite(this);" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
		                                                    <i class="fa-solid fa-heart"></i>
		                                                </a>
		                                            </div>
		                                        </div>
		                                    </div>
		                                </div>';
		                            } 
		                        } 
		                    $tabContentHtml.='</div>';
		                $tabContentHtml.='</div>';
		            } 
		        }

		        if($tabContentHtml == ''){
		            $tabContentHtml.='
		            <div class="row empty-data-row">
		                <div class="col-md-12 text-center">
		                    <h4 class="nothing-data text-center">'.$this->lang->line('my_link_and_document_datatable_empty_data').'</h4>
		                </div>
		            </div>';
		        }      
		      
		    }
		    return ($tabContentHtml);
		}

		public function displaySessionTrackingPersonnalise($idu,$idg,$paves) {
			$paves_sequence_nom = '';
		    switch ($paves) {
		        case 4:
		           $paves_sequence_nom.=$this->lang->line('other_trainee_library');
		           	$this->tracking_type = 6;
		            break;
		        case 6:
		            $paves_sequence_nom.=$this->lang->line('educational_library_pedagogical_training');
		            $this->tracking_type = 7; 
		            break;
		        case 7:
		            $paves_sequence_nom.=$this->lang->line('educational_library_personnal_interest');
		            $this->tracking_type = 8; 
		            break;
		        case 8:
		            $paves_sequence_nom.=$this->lang->line('educational_library_lingustic_tools');
		            $this->tracking_type = 9; 
		            break;           
		    }
			$codeHTML = '';
			$parametre_pour_tracking ="&id=".$idu."&idg=".$idg."&groupe=".$idg;
			$url_personnalize_program = base_url().'personnalize-program?action=listerPageStagiaire&paves_sequence='.$paves;

			$codeHTML = '';
			if ($paves == 4) {
				$codeHTML .= '<h3 class="text-center title-menu">'.$paves_sequence_nom.'</h3><hr>';
			}
			else{
				if ($this->session->userdata ('GUSERID') == 9322 || $this->session->userdata ('GUSERID') == 9324) {
					$codeHTML .= '<h3 class="text-center title-menu">'.$paves_sequence_nom.'&nbsp;<a href="'.$url_personnalize_program.$parametre_pour_tracking.'" class="btn btn-primary btn-action-customise"><i class="glyphicon glyphicon-edit"></i>&nbsp;Edit custom content</a></h3><hr>';
				}
				else{

					$codeHTML .= '<h3 class="text-center title-menu">'.$paves_sequence_nom.'</h3><hr>';
				}
			}
			
			if ($this->isTuteurConnet()) {
				$codeHTML.= $this->ListSessionUserUsignThreeView($idg, $idu,$paves);
			}
			else{
				$codeHTML.= $this->ListSessionUser($idg, $idu,$paves);
			}
			
			return($codeHTML);
		}

		public function ListSessionUserUsignThreeView($idg, $guser,$PAVE)
	    {
	        $codeHTML = "";
	        $parametre_pour_tracking ="&id=".$guser."&idg=".$guser."&groupe=".$idg;
			$url_newsletter          = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=4';
			$url_pedogogical         = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=6';
			$url_personal            = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=7';
			$url_linguistic          = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=8';

			$url_personnalize_pedogogical         = base_url().'personnalize-program?action=listerPageStagiaire&paves_sequence=6';
			$url_personnalize_personal            = base_url().'personnalize-program?action=listerPageStagiaire&paves_sequence=7';
			$url_personnalize_linguistic          = base_url().'personnalize-program?action=listerPageStagiaire&paves_sequence=8';      
			$url_training            = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=9'; 
			//$codeHTML .="<section class='content'>";
			$codeHTML .="<div class=''>";
			if(!isset($PAVE) || $PAVE==''){
		    }
		    else{
	             
		        switch ($PAVE) {
		            case 4:
		               $paves_sequence_nom='Newsletter';
		                break;
		            case 6:
		                $paves_sequence_nom='Pedagogical Training';
		                break;
		            case 7:
		                $paves_sequence_nom='Personal Interest';
		                break;
		            case 8:
		                $paves_sequence_nom='Linguistic Tools';
		                break;           
		        }
		        
		        $this->global['pageTitle'] = 'E-learning : '.$paves_sequence_nom;
		        $this->global['sequenceTitle'] = $paves_sequence_nom;
		        $this->global['groupe'] = $this->session->userdata ('GROUPE');

		        $url_sequence = "";    
		        if ($PAVE != 4) {                                     
		        	$codeHTML     .= '<div class="col-md-8">
		        	<form action="'.base_url().'del-session-group" name="session-form" method="post" class="session-form" enctype="multipart/form-data">
			        	<div class="card">
			        		<div class="card-title">
			        			<h3 class="text-center"><i class="glyphicon glyphicon-edit"></i> Modify the custom program</h3>
			        			</div>
			        		<div class="card-body">'; 
			        			$codeHTML     .= '<div class="row">
			        				<div class="col-md-4">
			        					<h4 style="color:brown;font-weight:bold;">Sequence order<i class="glyphicon glyphicon-sort-by-order"></i></h4>
			        					</div>
						        	<div class="col-md-8">
						        		<h4>
						        			<a href="#" data-domaine="'.$PAVE.'" class="btn btn-success btn-action-add-program btn-action-add-sequence"><i class="glyphicon glyphicon-plus-sign"></i>&nbsp;Sequence</a>
						        			<a href="#" data-domaine="'.$PAVE.'" class="btn btn-success btn-action-add-program btn-action-add-module"><i class="glyphicon glyphicon-plus-sign"></i>&nbsp;Module</a>
						        			<a href="#" data-domaine="'.$PAVE.'" class="btn btn-success btn-action-add-program btn-action-add-parcours"><i class="glyphicon glyphicon-plus-sign"></i>&nbsp;Parcours</a>
						        		</h4>
						        	</div>
						        </div>'; 
					        	$codeHTML     .= '<ul id="domains" class="tree">'; 
					        	$codeHTML     .= '<li class="link-threed-program"><span>'.$paves_sequence_nom.'</span><ul class="tree">'; 
					        	
		        }
		        define('PAGELOCALFORMATION',  base_url().'formation'); 

		        if($PAVE!=''){
		        	if ($PAVE == 4) {
		        		$codeHTML .= $this->readNewsletter();
		        	}
		        	else{
		        		$parcours = $this->parcours_model->getParcoursByGroupDomaine($idg,$PAVE);
		        		foreach ($parcours as $p) {
		        			$codeHTML.= '<li><span>'.$p->parcours_titre.'</span><a data-id="'.$p->parcours_id.'" data-domaine="'.$p->domaine_id.'" data-matiere="'.$p->matiere_id.'" data-groupe="'.$idg.'" class="btn btn-delete-parcours" title="Remove cours"><i class="glyphicon glyphicon-remove-sign remove-program"></i>&nbsp;</a>';
		        			$codeHTML.= '<ul class="tree">';
				            
				              
				            $ret_newsletter2 = $this->sequence_model->getPavetSequenceHautByParcours($idg,$this->session->userdata ('GUSERID'),$PAVE,$p->parcours_id);
				            if(!empty($ret_newsletter2)){
				                if(is_array($ret_newsletter2['module'])){
				                    foreach($ret_newsletter2['module'] as $key2=>$value2){
				                        if(is_array($value2)){
				                            $ident = str_replace(" ", "_", $key2);
				                            $identity = str_replace("-", "_", $ident);
				                            
				                            foreach($value2 as $key3=>$value3){
				                                $ret_newsletter3=$this->sequence_model->getPavetSequenceHauts($value3['MODULENAME'],$value3['idg'],$value3['module_id'],$PAVE);
				                                
				                                $codeHTML.= '<li><span class="domaineName"><img align="absmiddle" src="'.base_url().'assets/images/autres/ic_module_local.gif" border="0" alt="Sequence">&nbsp;&nbsp;'.$key2.'&nbsp;<a href="#" class="btn-remove-module" data-id="'.$value3['module_id'].'" data-parcours-id="'.$p->parcours_id.'" data-groupes-id="'.$idg.'"><i class="glyphicon glyphicon-remove-sign remove-program"></i></a>&nbsp;<a href="#" class="btn-add-sequence-in-module" data-id="'.$value3['module_id'].'" data-parcours-id="'.$p->parcours_id.'" data-groupes-id="'.$idg.'"><i class="glyphicon glyphicon-plus-sign"></i></a></span>';
			                           					$codeHTML.= '<ul class="materialmenu">';
				                                foreach($ret_newsletter3['module'] as $key4=>$value4){
				                                    if(is_array($value4)){
				                                        foreach($value4 as $key5=>$value5){
				                                            if($value5['sequence_name'] != "") { 
				                                                $codeHTML .='<li class="material"><input type="checkbox" name="sequence_prog[]" class="sequence_prog" value="'.$value5['sequence_id'].'_'.$value5['locs'].'_'.$value5['locm'].'_'.$value5['locp']."_".$value5['module_id']."_".$value5['parcours_id'].'"><span class="materialName">&nbsp;&nbsp;<img align="absmiddle" src="'.base_url().'assets/images/autres/ic_sequence_local.gif" border="0" alt="Sequence">&nbsp;&nbsp;'.$value5['sequence_name'].'&nbsp;<a href="#" class="btn btn-delete-sequence"><i class="glyphicon glyphicon-remove-sign remove-program"></i></a></span>';	                    
				                                                $codeHTML .='</li>';
				                                                
				                                            }                           
				                                        }
				                                    }
				                                }

					                            $codeHTML .= '</ul>';
				                            	$codeHTML .= '</li>';
				                            }
				                        }
				                    }
				                }
				            }
				            else{
				                /*$codeHTML.= '<li class="bloc_customisedprog">
				                                <span><h2>Your customised program</h2></span>
				                                <span><strong>To start, Select your program from the four buttons above</strong>
				                                </span></li>';*/
				            }
				            $codeHTML     .= '</ul>'; 
				        }

				        $ret_module_complementary_activities=$this->sequence_model->getPavetComplementaryThreeView($idg);         
			            if(!empty($ret_module_complementary_activities) && $PAVE == 6){
	                	 	foreach($ret_module_complementary_activities as $res){ 
                	 		$codeHTML .= '<li><span class="domaineName">'.$res->module_titre.'</span>';
	                    		$codeHTML .= '<ul class="materialmenu">'; 
	                    			$sequence = $this->sequence_model->getPavetSequenceComplementaryThreeView($res->module_id,$this->session->userdata ('STAGIAIREGRP'));    
	                    		  	foreach($sequence['module'] as $key=>$value){
	                    		  		$codeHTML .='<li class="material"><input type="checkbox" name="sequence_prog[]" class="sequence_prog" value="'.$value['sequence_id'].'_'.$value['locs'].'_'.$value['locm'].'_'.$value['locp']."_".$value['module_id']."_".$value['parcours_id'].'"><span class="materialName">&nbsp;&nbsp;<img align="absmiddle" src="'.base_url().'assets/images/autres/ic_sequence_local.gif" border="0" alt="Sequence">&nbsp;&nbsp;'.$value['sequence_name'].'&nbsp;<a href="#" class="btn btn-delete-sequence"><i class="glyphicon glyphicon-remove-sign remove-program"></i></a></span>';
		                           		$codeHTML .='</li>';

			                    	}

	                           	$codeHTML.= '</ul></li>';

		                    }
			            }
           				$sequence_complementary = $this->sequence_model->getPavetSequenceComplementaryThreeView(0,$this->session->userdata ('STAGIAIREGRP'));  
           				if(!empty($sequence_complementary['module'])){  
	            		  	foreach($sequence_complementary['module'] as $key=>$value){
	            		  		$codeHTML .='<li class="material"><input type="checkbox" name="sequence_prog[]" class="sequence_prog" value="'.$value['sequence_id'].'_'.$value['locs'].'_'.$value['locm'].'_'.$value['locp']."_".$value['module_id']."_".$value['parcours_id'].'"><span class="materialName">&nbsp;&nbsp;<img align="absmiddle" src="'.base_url().'assets/images/autres/ic_sequence_local.gif" border="0" alt="Sequence">&nbsp;&nbsp;'.$value['sequence_name'].'&nbsp;<a href="#" class="btn btn-delete-sequence"><i class="glyphicon glyphicon-remove-sign remove-program"></i></a></span>';
	                       		$codeHTML .='</li>';
	                    	}
                    	}
			        }
			          
		        }


		        if ($PAVE != 4) {                                     
		        	 
			        $codeHTML     .= '</li>'; 
		        	$codeHTML     .= '</ul>'; 
		        	$codeHTML     .= '</li>'; 
		        	$codeHTML     .= '</ul>'; 

		        	$codeHTML     .= '</div><br><div class="card-footer text-center">
		        		<div class="btn-toolbar" role="toolbar" aria-label="Toolbar with button groups">
						  <div class="btn-group mr-2" role="group" aria-label="First group">
						    <button type="button" class="btn btn-info btn-check-sequence">Check all</button>
						    <button type="button" class="btn btn-secondary btn-uncheck-sequence">All Uncheck</button>
						  </div>
						  <div class="btn-group mr-2" role="group" aria-label="Second group">
						    <button type="button" class="btn btn-danger btn-remove-sequence-program">Delete selected</button>
						  </div>
						  <div class="btn-group" role="group" aria-label="Third group">
						    <button type="button" class="btn btn-success btn-save-modif-programe" onClick="window.history.back();">Go to content</button>
						  </div>
						</div>
		        	</div><br></div></form></div><div class="col-md-4">
	        		<div class="card">
	        			<div class="card-title">
	        				<h3 class="text-center text-info"><i class="glyphicon glyphicon-question-sign"></i> How does it work  
	        				</h3>
	        			</div>
	        			<div class="card-body">
	        				<p class="text-justify">You can change the training programs for trainees. Click on Add a sequence, Add a module or Add a course to add content at the end of the tree structure. Click Add, Add or Add to insert content at the different levels of the tree structure. Click Session Sequence Order to change the order in which the items are displayed. You may need to allow pop-up windows.</p>
	        			</div>
	        			<div class="card-title">
	        				<h3 class="text-center text-info"><i class="glyphicon glyphicon-question-sign"></i> How to use it 
	        				</h3>
	        			</div>
	        			<div class="card-body">
	        				<p class="text-justify">Familiarize yourself with the content offered. During the tutoring, add the courses and exercises corresponding to the needs of the trainee.Do not delete the original content!</p>
	        			</div>
		        	</div>'; 
		        }
		    }  

		   // $codeHTML .="</section>";              

	        return $codeHTML;
	    }

	    public function displayContentProgramInternEelearning($idg, $userId, $PAVE)
	    {
	        $codeHTML = "";	        
	        $paves_sequence_nom = "";
	        switch ($PAVE) {
		        case 4:
		           $paves_sequence_nom.=$this->lang->line('educational_library_newsletter');
		           	$this->tracking_type = 6;
		            break;
		        case 6:
		            $paves_sequence_nom.=$this->lang->line('educational_library_pedagogical_training');
		            $this->tracking_type = 7; 
		            break;
		        case 7:
		            $paves_sequence_nom.=$this->lang->line('educational_library_personnal_interest');
		            $this->tracking_type = 8; 
		            break;
		        case 8:
		            $paves_sequence_nom.=$this->lang->line('educational_library_lingustic_tools');
		            $this->tracking_type = 9; 
		            break;           
		    }	        
	        define('PAGELOCALFORMATION',  base_url().'formation');     

	        $url_sequence = "";                                    
	        $codeHTML     .= '
	        	<div class="card">
	        		<div class="card-body">
		        		<form action="'.base_url().'del-session-group" name="session-form" method="post" class="session-form" enctype="multipart/form-data">';
		        			$codeHTML .='
		        			<ul id="domains" class="tree">
				        		<li class="link-threed-program"><span>'.$paves_sequence_nom.'</span>
				        			<ul class="tree">';
				        				$parcours = $this->parcours_model->getParcoursByGroupDomaine($idg,$PAVE);
						        		foreach ($parcours as $p) {				        			
						        		$ret_newsletter2 = $this->sequence_model->getPavetSequenceHautByParcours($idg,$userId,$PAVE,$p->parcours_id);
						        		$codeHTML.= '
						        			<li>
						        				<span>'.$p->parcours_titre.'</span><a data-id="'.$p->parcours_id.'" data-domaine="'.$p->domaine_id.'" data-matiere="'.$p->matiere_id.'" data-groupe="'.$idg.'" class="btn btn-delete-parcours" title="Remove cours"><i class="bx bx-trash-alt remove-program"></i>&nbsp;</a>';
						        			$codeHTML.= '<ul class="tree">';
								            if(!empty($ret_newsletter2)){
								                if(is_array($ret_newsletter2['module'])){
								                    foreach($ret_newsletter2['module'] as $key2=>$value2){
								                        if(is_array($value2)){
								                            $ident = str_replace(" ", "_", $key2);
								                            $identity = str_replace("-", "_", $ident);	
								                            foreach($value2 as $key3=>$value3){
								                                $ret_newsletter3=$this->sequence_model->getPavetSequenceHauts($value3['MODULENAME'],$value3['idg'],$value3['module_id'],$PAVE);
								                                
								                                $codeHTML.= '
								                                <li>
								                                	<span class="domaineName">'.$key2.'&nbsp;<a href="#" class="btn-remove-module" data-id="'.$value3['module_id'].'" data-parcours-id="'.$p->parcours_id.'" data-groupes-id="'.$idg.'"><i class="bx bx-trash-alt remove-program"></i></a>&nbsp;<a href="#" class="btn-add-sequence-in-module" data-id="'.$value3['module_id'].'" data-parcours-id="'.$p->parcours_id.'" data-groupes-id="'.$idg.'"><i class="bx bx-plus"></i></a></span>';
							                           					$codeHTML.= '
						                           					<ul class="materialmenu">';
										                                foreach($ret_newsletter3['module'] as $key4=>$value4){
										                                    if(is_array($value4)){
										                                        foreach($value4 as $key5=>$value5){
										                                            if($value5['sequence_name'] != "") { 
										                                                $codeHTML .='<li class="material">
										                                                <label class="switch switch-data-le">
												                                        <input type="checkbox"  class="custom_activity_sequence" name="sequence_prog[]" value="'.$value5['sequence_id'].'_'.$value5['locs'].'_'.$value5['locm'].'_'.$value5['locp']."_".$value5['module_id']."_".$value5['parcours_id'].'">
												                                        <span></span>
												                                        <span class="checkbox-label">'.$value5['sequence_name'].'</span>
												                                    	</label> 
										                                                <span class="materialName">&nbsp;&nbsp;&nbsp;<a href="#" class="btn btn-delete-sequence"><i class="bx bx-trash-alt remove-program"></i></a></span>';	                    
										                                                $codeHTML .='</li>';
										                                                
										                                            }                           
										                                        }
										                                    }
										                                }

								                            		$codeHTML .= '
								                            		</ul>
								                        		</li>';
								                            }
								                        }
								                    }
								                }
								            }
								            $codeHTML     .= '</ul>'; 
								        }

								        $ret_module_complementary_activities=$this->sequence_model->getPavetComplementaryThreeView($idg);         
							            if(!empty($ret_module_complementary_activities) && $PAVE == 6){
					                	 	foreach($ret_module_complementary_activities as $res){ 
				                	 		$codeHTML .= '<li><span class="domaineName">'.$res->module_titre.'</span>';
					                    		$codeHTML .= '<ul class="materialmenu">'; 
					                    			$sequence = $this->sequence_model->getPavetSequenceComplementaryThreeView($res->module_id,$this->session->userdata ('STAGIAIREGRP'));    
					                    		  	foreach($sequence['module'] as $key=>$value){
					                    		  		$codeHTML .='<li class="material">
					                    		  		<label class="switch switch-data-le">
					                                        <input type="checkbox"  class="custom_activity_sequence" name="sequence_prog[]" value="'.$value['sequence_id'].'_'.$value['locs'].'_'.$value['locm'].'_'.$value['locp']."_".$value['module_id']."_".$value['parcours_id'].'">
					                                        <span></span>
					                                        <span class="checkbox-label">'.$value['sequence_name'].'</span>
					                                    </label> 
					                    		  		<span class="materialName">&nbsp;&nbsp;<img align="absmiddle" src="'.base_url().'assets/images/autres/ic_sequence_local.gif" border="0" alt="Sequence">&nbsp;&nbsp;&nbsp;<a href="#" class="btn btn-delete-sequence"><i class="bx bx-trash-alt remove-program"></i></a></span>';
						                           		$codeHTML .='</li>';

							                    	}

					                           	$codeHTML.= '</ul></li>';

						                    }
							            }
							        	$codeHTML     .= '
					        			</li>
						        	</ul>
						    	</li>
							</ul>
						</form>
					</div>
    			</div>
    		';        

	        return $codeHTML;
	    }
	    public function ListSessionUserUsignThreeThumbnail($idg, $guser,$PAVE)
		{
			$codeHTML = "";
	        $parametre_pour_tracking ="&id=".$guser."&idg=".$guser."&groupe=".$idg;
			$url_newsletter          = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=4';
			$url_pedogogical         = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=6';
			$url_personal            = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=7';
			$url_linguistic          = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=8';

			$url_personnalize_pedogogical         = base_url().'personnalize-program?action=listerPageStagiaire&paves_sequence=6';
			$url_personnalize_personal            = base_url().'personnalize-program?action=listerPageStagiaire&paves_sequence=7';
			$url_personnalize_linguistic          = base_url().'personnalize-program?action=listerPageStagiaire&paves_sequence=8';


			$url_training            = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=9';
			if(!isset($PAVE) || $PAVE==''){
		    }
		    else{
			    $retour = "";
			    $nbrBtn= 1;
			    $nbrMod= 1;
			    $nbrSeq= 1;
			    $lienCol= 1;
			    $sequence_id;
			    $paves_sequence_nom = '';
			    //Declaration variable numero pour chaque liste
			    $numeroSeq = 0;
			    switch ($PAVE) {
			        case 4:
			           $paves_sequence_nom.=$this->lang->line('educational_library_newsletter');
			           	$this->tracking_type = 6;
			            break;
			        case 6:
			            $paves_sequence_nom.=$this->lang->line('educational_library_pedagogical_training');
			            $this->tracking_type = 7; 
			            break;
			        case 7:
			            $paves_sequence_nom.=$this->lang->line('educational_library_personnal_interest');
			            $this->tracking_type = 8; 
			            break;
			        case 8:
			            $paves_sequence_nom.=$this->lang->line('educational_library_lingustic_tools');
			            $this->tracking_type = 9; 
			            break;           
			    }

			    if (isset($_GET['id-art'])) {
			    	$trackingid = $this->tracking_model->Add(0,$_GET['id-art'],6);
			    	$sessionArray = array('TRACKINGID'=>$trackingid);                                    
			        $this->session->set_userdata($sessionArray);
			        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
			    }
			    elseif (isset($PAVE)) {  			    	        
			        $trackingid = $this->tracking_model->Add(0,0,$this->tracking_type);
			        $sessionArray = array('TRACKINGID'=>$trackingid);                                    
			        $this->session->set_userdata($sessionArray);
			        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
			    }
			    else{
			        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
			    }
			    
			    $this->global['pageTitle'] = 'E-learning : '.$paves_sequence_nom;
			    $this->global['sequenceTitle'] = $paves_sequence_nom;
			    $this->global['groupe'] = $this->session->userdata ('GROUPE');

			    $url_sequence = "";      
			    $codeHTML  .='<input type="hidden" class="current_module" id="current_module">';
			    $codeHTML  .='<input type="hidden" class="current_tracking_type" id="current_tracking_type" value="'.$this->tracking_type.'">';
			    //$codeHTML     .= '<div class="item" id="item-smart">'; 
			    define('PAGELOCALFORMATION',  base_url().'formation'); 
			   	if ($PAVE == 4) {
		    		$codeHTML .= $this->readNewsletter();
		    	}
		    	else{
		    		if ($this->isTuteurConnet()) {
		    			$userId  = $this->session->userdata ('STAGIAIREID');
		    			$groupId = $this->session->userdata ('STAGIAIREGRP');
		    		}
		    		else{
		    			$userId  = $this->session->userdata ('GUSERID');
		    			$groupId = $this->session->userdata ('GROUPE');
		    		}
		    		$ret_complementary_activities=$this->sequence_model->getPavetComplementary($groupId);  
	            	$ret_newsletter2 = $this->sequence_model->getPavetSequenceHaut($idg,$userId,$PAVE);
			        if(!empty($ret_newsletter2)){
			            if(is_array($ret_newsletter2['module'])){
			                $active_menu = '';
			                $codeHTML.='<div class="row"><div class="box"><div class="col-md-12">';
			                foreach($ret_newsletter2['module'] as $key2=>$value2){
			                	$this->load->model('codeColor_model');
			                    if(is_array($value2)){ 
			                        $ident = str_replace(" ", "_", $key2);
			                        $identity = str_replace("-", "_", $ident);
			                        foreach($value2 as $key3=>$value3){
			                        	$back = $this->codeColor_model->Request('background',$nbrBtn); 
		                                $brdl = $this->codeColor_model->Request('border_left',$nbrBtn); 
		                                $text = $this->codeColor_model->Request('text',$nbrBtn); 

			                        	$codeHTML.= ' <button  style="background-color: '.$back.';border-color:'.$brdl.';color:'.$text.' !important;" data-id="'.$value3['module_id'].'" class="btn btn-module-'.$nbrBtn.' btn-mod" value="'.$nbrBtn.'">'.$key2.'</button>';
			                        }
			                        $nbrBtn= $nbrBtn + 1;
			                        
			                    }
			                }
			                if($PAVE=='6'){
		                        $codeHTML.= ' <button class="btn btn-module-'.$nbrBtn.' btn-mod" value="'.$nbrBtn.'">'.$this->lang->line('other_complementary_activity').'</button>';
		                    }
			                $codeHTML.='</div></div></div>';
			                $codeHTML.=' <div class="box" style="display:none;box-shadow:none !important;"><h5 class="titre-your-module titre-seq">Navigation : <a onclick="showSequence(this);" class="btn btn-module-1 btn-mod ChangeBtn btn-stan-incons" value="'.$nbrBtn.'"></a></h5></div>';
			                /* sequences */
			                $nbrBtn= 1;
			               
			                $codeHTML.='<div class="row"><div class="col-md-12 padding-elearning"><div class="text-left title-active-menu-pg"><h5 class="content_title"><b>Your sequences (content of your module)</b></h5></div></div></div>';

			                $codeHTML.='<div class="row row-view-activity hidden-div"><div class="box" style="border-radius: 0px;border-top: 0px;"><div class="col-md-12 padding-elearning"><div class="embed-responsive embed-responsive-16by9"><iframe class="embed-responsive-item iframeActivitySequence" allowfullscreen style="visibility:visible"></iframe></div></div></div></div>';
			                $codeHTML.='<div class="row row-view-sequence-search hidden-div"><div class="box" style="border-radius: 0px;border-top: 0px;"><div class="col-md-12 padding-elearning"><div class="details-sequences-search"></div></div></div></div>';
			                foreach($ret_newsletter2['module'] as $key2=>$value2){
			                    if(is_array($value2)){ 
			                        $ident = str_replace(" ", "_", $key2);
			                        $identity = str_replace("-", "_", $ident);

			                        $codeHTML.= '<div class="row module'.$nbrMod.' modus" value="'.$nbrBtn.'"><div class="box"><div class="col-md-12"><br>
			                                        
			                        ';
			                        $nbrBtn= $nbrBtn + 1;
			                        $nbrMod= $nbrMod + 1;
			                        foreach($value2 as $key3=>$value3){
			                            $ret_newsletter3=$this->sequence_model->getPavetSequenceHauts($value3['MODULENAME'],$value3['idg'],$value3['module_id'],$PAVE);
			                            foreach($ret_newsletter3['module'] as $key4=>$value4){
			                                if(is_array($value4)){
			                                    foreach($value4 as $key5=>$value5){
			                                        if($value5['sequence_name'] != "") {
			                                            $sequenceUrl   = $value5['sequence_url'];  
			                                            $idsequence    = $value5['sequence_id'];   
			                                            $locsequence    = $value5['locs'];   
			                                            //$resutlthumb = $this->utilities_model->getinfothumbs($idsequence,$locsequence,1);
			                                            //Thumb
			                                            $thumbnailSeq = $this->sequence_model->getThumbFromLastSequence($idsequence);
			                                            if ($thumbnailSeq != '') {
			                                                $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnailSeq;
			                                            }
			                                            else{

			                                                $fileimg = base_url()."groupes/default.png";
			                                            }
			                                            $codeHTML .=' 
			                                                        <div class="col-md-2 sequenceTotal">
			                                                            <div class="sequ1 sequence sequence1 col-lien-pointer" value="'.$nbrSeq.'" data-name="'.$value5['sequence_name'].'" data-id="'.$idsequence.'">
			                                                            <img class="" id="image-thumb"  src="'.$fileimg.'" width="100%" height="100%" style="border-radius:10px;">
			                                                            <div class="sequence-hover" value="'.$nbrSeq.'">
			                                                                <div class = "btn-group-vertical btn-action-activity btn-action-sequence-pdg">
			                                                                    <a class="btn link-action-nl btn-add-comment-sequence-activity"
			                                                                     data-title="'.$value5['sequence_name'].'" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" title="'.$this->lang->line('course_history_placeholder_comment').'">
			                                                                        <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" class="image-action-nl img-comment-nl" style="z-index:100 !important;">
			                                                                    </a>
			                                                                    <a data-title="'.$value5['sequence_name'].'" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" class="btn link-action-nl btn-add-fav-sequence" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'" data-type="sequence_activite">
			                                                                        <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" class="image-action-nl img-favorite-nl" style="z-index:100 !important;">
			                                                                    </a>
			                                                                </div>
			                                                            </div>
			                                                            </div>
			                                                            <p>'.$value5['sequence_name'].'</p>
			                                                         ';
			                                            $nbrSeq= $nbrSeq + 1;
			                                            $imgthumbnail = '';
			                                            $class = '';
			                                            
			                                            $codeHTML .='</div>';
			                                            if (isset($chapitre['cnt'])) {
			                                                // colonne lien
			                                                $codeHTML.=' <div class="row col_lien " value="'.$lienCol.'">
			                                                <div class="col-md-12">
			                                                <h5 class="titre-your-module titre-activ"><b>Activities of '.$value5['sequence_name'].' </b></h5> 
			                                                </div>
			                                                <div class="row row-lien">
			                                                ';
			                                                $lienCol= $lienCol + 1;
			                                                $codeHTML .='</div></div>';
			                                                
			                                            }
			                                        }
			                                    }


			                                }
			                            }
			                        }
			                        
			                        $codeHTML.='</div></div></div>';
			                    }
			                }
			            }
			        }
			        else{
			            $codeHTML.= '<div class="bloc_customisedprog">
			                            <h2>Your customised program</h2>
			                            <div id="sidetree"><div class="treeheader">&nbsp;</div><strong>To start, Select your program from the four buttons above</strong>
			                            </div>
			                            </div>';
			        }
			        

			        $array_newsletter = $this->sequence_model->getPavetHaut($idg,4);
		            $array_ped_training = $this->sequence_model->getPavetHaut($idg,6);
		            $array_pers_ling = $this->sequence_model->getPavetHaut($idg,7);
		            $array_ling_tools = $this->sequence_model->getPavetHaut($idg,8);

			        $arrayListeModule = array();
			        $array_id_module_newsletter = array();
			        $array_id_module_ped_training = array();
			        $array_id_module_pers_ling = array();
			        $array_id_module_ling_tools = array();   

			        if(!empty($array_newsletter)){
			            if (is_array($array_newsletter['module'])) {
			                foreach($array_newsletter['module'] as $key=>$value){
			                    foreach($value as $key2=>$value2){
			                        $arrayListeModule[] = $value2['module_id'];
			                        $array_id_module_newsletter[] = $value2['module_id'];
			                    }
			                }
			            }
			        }
			        if(!empty($array_ped_training)){
			            if (is_array($array_ped_training['module'])) {
			                foreach($array_ped_training['module'] as $key=>$value){
			                    foreach($value as $key2=>$value2){
			                        $arrayListeModule[] = $value2['module_id'];
			                        $array_id_module_ped_training[] = $value2['module_id'];
			                    }
			                }
			            }
			        }
			        if(!empty($array_pers_ling)){
			            if (is_array($array_pers_ling['module'])) {
			                foreach($array_pers_ling['module'] as $key=>$value){
			                    foreach($value as $key2=>$value2){
			                        $arrayListeModule[] = $value2['module_id'];
			                        $array_id_module_pers_ling[] = $value2['module_id'];
			                    }
			                }
			            }
			        }
			        if(!empty($array_ling_tools)){
			            if (is_array($array_ling_tools['module'])) {
			                foreach($array_ling_tools['module'] as $key=>$value){
			                    foreach($value as $key2=>$value2){
			                        $arrayListeModule[] = $value2['module_id'];
			                        $array_id_module_ling_tools[] = $value2['module_id'];
			                    }
			                }
			            }
			        }
			        if(!empty($ret_complementary_activities)){
			            if (is_array($ret_complementary_activities['module'])) {
			                foreach($ret_complementary_activities['module'] as $key=>$value){
			                    $arrayListeModule[] = $value['module_id'];
			                }
			            }
			        }

			        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_newsletter) ;
			        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
			        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;
			        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ling_tools) ;
			        if(!empty($ret_complementary_activities)){
		                if(is_array($ret_complementary_activities['module']) && $PAVE=='6'){
		                    $codeHTML.= '<div class="row module'.$nbrMod.' modus" value="'.$nbrBtn.'"><div class="box"><div class="col-md-12">';
		                    foreach($ret_complementary_activities['module'] as $key=>$value){
		                        if (in_array($value['module_id'], $arrayListeModule)) {
		                            $thumbnailSeq = $this->sequence_model->getThumbFromLastSequence($value['sequence_id']);
		                            if ($thumbnailSeq != '') {
		                                $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnailSeq;
		                            }
		                            else{

		                                $fileimg = base_url()."groupes/img_default.jpg";
		                            }
		                            $codeHTML .=' 
		                                <div class="col-md-2 sequenceTotal">
		                                    <div class="sequ1 sequence sequence1 col-lien-pointer" value="'.$nbrSeq.'" data-name="'.$value['sequence_name'].'" data-id="'.$value['sequence_id'].'">
		                                    <img class="" id="image-thumb"  src="'.$fileimg.'" width="100%" height="100%" style="border-radius:10px;">
		                                    <div class="sequence-hover" value="'.$nbrSeq.'">
		                                        <div class = "btn-group-vertical btn-action-activity btn-action-sequence-pdg">
		                                            <a class="btn link-action-nl btn-add-comment-activity" title="'.$this->lang->line('course_history_placeholder_comment').'">
		                                                <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" class="image-action-nl img-comment-nl" style="z-index:100 !important;">
		                                            </a>
		                                            <a data-title="'.$value['sequence_name'].'" data-id="'.$value['sequence_id'].'" data-code="'.$value['code'].'" class="btn link-action-nl btn-add-fav-sequence" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'" data-type="sequence_activite">
		                                                <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" class="image-action-nl img-favorite-nl" style="z-index:100 !important;">
		                                            </a>
		                                        </div>
		                                    </div>
		                                    </div>
		                                    <p>'.htmlentities($value['sequence_name']).'</p>
		                                 ';
		                            $codeHTML .='</div>';
		                        } 
		                    } 
		                    $codeHTML.='</div></div></div>';
		                } 
		            }

		            $codeHTML.='<div class="row row-detail-activity hidden-div"><div class="box"><div class="col-md-12 activite-datail"></div></div></div>';
			      
			    }
			    /*$codeHTML.="</div>";   */                
			}
			return $codeHTML;
		}

	    public function ListSessionUser($idg, $guser,$PAVE)
	    {
	        $codeHTML = "";
	        $parametre_pour_tracking ="&id=".$guser."&idg=".$guser."&groupe=".$idg;
			$url_newsletter          = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=4';
			$url_pedogogical         = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=6';
			$url_personal            = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=7';
			$url_linguistic          = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=8';      
			$url_training            = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=9'; 
			$codeHTML .="<section class='content'>";
			$codeHTML .="<div class='row'>";
			if(!isset($PAVE) || $PAVE==''){

			    $codeHTML.='<nav class="navbar navbar-default" role="navigation">
						    <div class="navbar-header">
						        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
						            <span class="icon-bar"></span>
						            <span class="icon-bar"></span>
						            <span class="icon-bar"></span>
						        </button>
						    </div>
						    <div class="navbar-collapse collapse">';
						    	if ($this->session->userdata ('GUSERTYPE') == TUTEUR) {
						    		$codeHTML.='<ul class="nav navbar-nav navbar-left nav-bar-trainee-program">
							            <li class="newsletter"><a  href="'.$url_newsletter.$parametre_pour_tracking.'">Newsletter</a></li>
				             			<li class="pedagogic"><a href="'.$url_pedogogical.$parametre_pour_tracking.'">Pedagogical Training</a></li>
				             			<li class="personal"><a href="'.$url_personal.$parametre_pour_tracking.'">Personal Interest</a></li>
				             			<li class="linguistic"><a  href="'.$url_linguistic.$parametre_pour_tracking.'">Linguistic Tools</a></li></ul>';
				             		$codeHTML.='<ul class="nav navbar-nav navbar-right">
							            
				             			<li class="pedagogic"><a href="#">Modify pedagogical training</a></li>
				             			<li class="personal"><a href="#">Modify personal interest</a></li>
				             			<li class="linguistic"><a  href="#">Modify linguistic tools</a></li></ul>';
						    	}
						    	else {
						        	$codeHTML.='<ul class="nav navbar-nav navbar-center">
							            <li class="newsletter"><a  href="'.$url_newsletter.$parametre_pour_tracking.'">Newsletter</a></li>
				             			<li class="pedagogic"><a href="'.$url_pedogogical.$parametre_pour_tracking.'">Pedagogical Training</a></li>
				             			<li class="personal"><a href="'.$url_personal.$parametre_pour_tracking.'">Personal Interest</a></li>
				             			<li class="linguistic"><a  href="'.$url_linguistic.$parametre_pour_tracking.'">Linguistic Tools</a></li></ul>';
				             	}
						    $codeHTML.='</div>
						</nav>';
		    }
		    else{
	      		 $codeHTML.='<nav class="navbar navbar-default" role="navigation">
						    <div class="navbar-header">
						        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
						            <span class="icon-bar"></span>
						            <span class="icon-bar"></span>
						            <span class="icon-bar"></span>
						        </button>
						    </div>
						    <div class="navbar-collapse collapse">';
						    	if ($this->session->userdata ('GUSERTYPE') == TUTEUR) {
						    		$codeHTML.='<ul class="nav navbar-nav navbar-left nav-bar-trainee-program">
							            <li class="newsletter"><a  href="'.$url_newsletter.$parametre_pour_tracking.'">Newsletter</a></li>
				             			<li class="pedagogic"><a href="'.$url_pedogogical.$parametre_pour_tracking.'">Pedagogical Training</a></li>
				             			<li class="personal"><a href="'.$url_personal.$parametre_pour_tracking.'">Personal Interest</a></li>
				             			<li class="linguistic"><a  href="'.$url_linguistic.$parametre_pour_tracking.'">Linguistic Tools</a></li></ul>';
				             		$codeHTML.='<ul class="nav navbar-nav navbar-right">
							            
				             			<li class="pedagogic"><a href="#">Modify pedagogical training</a></li>
				             			<li class="personal"><a href="#">Modify personal interest</a></li>
				             			<li class="linguistic"><a  href="#">Modify linguistic tools</a></li></ul>';
						    	}
						    	else {
						        	$codeHTML.='<ul class="nav navbar-nav navbar-center">
							            <li class="newsletter"><a  href="'.$url_newsletter.$parametre_pour_tracking.'">Newsletter</a></li>
				             			<li class="pedagogic"><a href="'.$url_pedogogical.$parametre_pour_tracking.'">Pedagogical Training</a></li>
				             			<li class="personal"><a href="'.$url_personal.$parametre_pour_tracking.'">Personal Interest</a></li>
				             			<li class="linguistic"><a  href="'.$url_linguistic.$parametre_pour_tracking.'">Linguistic Tools</a></li></ul>';
				             	}
						    $codeHTML.='</div>
						</nav>';
	             
		        switch ($PAVE) {
		            case 4:
		               $paves_sequence_nom='Newsletter';
		                break;
		            case 6:
		                $paves_sequence_nom='Pedagogical Training';
		                break;
		            case 7:
		                $paves_sequence_nom='Personal Interest';
		                break;
		            case 8:
		                $paves_sequence_nom='Linguistic Tools';
		                break;           
		        }
		        
		        $this->global['pageTitle'] = 'E-learning : '.$paves_sequence_nom;
		        $this->global['sequenceTitle'] = $paves_sequence_nom;
		        $this->global['groupe'] = $this->session->userdata ('GROUPE');

		        $url_sequence = "";    
		        if ($PAVE != 4) {                                     
		        	$codeHTML     .= '<div class="item" id="item-smart">'; 
		        }
		        define('PAGELOCALFORMATION',  base_url().'formation'); 

		        if($PAVE!=''){
		        	if ($PAVE == 4) {
		        		$codeHTML .= $this->readNewsletter();
		        	}
		        	else{
			            $ret_complementary_activities=$this->sequence_model->getPavetComplementary($idg);  
			            $ret_newsletter2 = $this->sequence_model->getPavetSequenceHaut($idg,$this->session->userdata ('GUSERID'),$PAVE);
			            if(!empty($ret_newsletter2)){
			                if(is_array($ret_newsletter2['module'])){
			                    foreach($ret_newsletter2['module'] as $key2=>$value2){
			                        if(is_array($value2)){
			                            $ident = str_replace(" ", "_", $key2);
			                            $identity = str_replace("-", "_", $ident);
			                            $codeHTML.= '<div class="title">
			                                <h2><span id="smart-title">'.$key2.'</span></h2>
			                                <span class="more">
			                                    <a href="#" title="" id="btn-smart-dept-more">
			                                        <img src="'.base_url().'assets/dist/img/pictoMore.png" alt="more...">
			                                    </a>
			                                </span>
			                            </div>
			                            <div class="showRoom smartCourshevesShowRoom">
			                            
			                                <div class="container" id="smart-list">';
			                            foreach($value2 as $key3=>$value3){
			                                $ret_newsletter3=$this->sequence_model->getPavetSequenceHauts($value3['MODULENAME'],$value3['idg'],$value3['module_id'],$PAVE);

			                                foreach($ret_newsletter3['module'] as $key4=>$value4){
			                                    if(is_array($value4)){
			                                        foreach($value4 as $key5=>$value5){
			                                          
			                                            if($value5['sequence_name'] != "") {
			                                                $sequenceUrl   = $value5['sequence_url'];  
			                                                $idsequence    = $value5['sequence_id'];   
			                                                $locsequence    = $value5['locs'];   
			                                                $resutlthumb = $this->utilities_model->getinfothumbs($idsequence,$locsequence,1);
			                                                $chapitre = $this->chapitres_model->read($idsequence,$this->session->userdata ('GUSERID'),$idg);

			                                                $codeHTML .='<div class="smartCourseshelf" data-id="'.$identity.'">
			                                                    <span class="smartCourseshelfTitle"><h3>'.$value5['sequence_name'].'</h3></span>
			                                                    <div class="books" id="smart-books-3062"> ';
			                                                $imgthumbnail = '';

			                                                if (isset($chapitre['cnt'])) {
			                                                    for($i=0;$i<$chapitre['cnt'];$i++) {

			                                                        $type           = $chapitre[$i]['type']     ;
			                                                        $titre          = $chapitre[$i]['titre']    ;
			                                                        $numero         = $chapitre[$i]['numero']   ;
			                                                        $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
			                                                        $linkUrl        = $chapitre[$i]['lienUrl']  ;
			                                                        $id_sequence    = $chapitre[$i]['id_sequence']  ;
			                                                        $detect_link    = $chapitre[$i]['ifrmaccess']  ;

			                                                           
			                                                        $link_support = $linkUrl;
			                                                        $redir        = 'redir.php?url';
			                                                        $support      = '';
			                                                        $urlF         = "";
			                                                        if ($this->validate_url($link_support)){
			                                                            $urlF         .= $link_support;
			                                                        }
			                                                        else{
			                                                            if (strpos($link_support, $redir) == false) { 
			                                                                $filename      = $this->getFileName($link_support);
			                                                                $ext            = explode(".", $filename);
			                                                                if (isset($ext[1]) && $ext[1]=="pdf") {
			                                                                    $urlF         .= HTTP_FORMATIONS.$link_support;
			                                                                }
			                                                                elseif (isset($ext[1]) && ($ext[1]=="doc" || $ext[1]=="docx" || $ext[1]=="ppt")){
			                                                                    $urlF   .= base_url().'groupes/index.php?link='.HTTP_FORMATIONS.$link_support;;
			                                                                }
			                                                                else{
			                                                                    $urlF  .= HTTP_FORMATIONS.$link_support;
			                                                                }
			                                                            }                 
			                                                            else { 
			                                                                $urlF         .= str_replace("/redir.php?url=", "", $link_support);                 
			                                                            } 
			                                                        }
			                                                        
			                                                        if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
			                                                            $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
			                                                            $codeHTML .= "";                
			                                                        }
			                                                        else{
			                                                            $fileimg = base_url()."groupes/img_default.jpg";
			                                                            $codeHTML .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
			                                                        }

			                                                        if ($titre != "Support") {
			                                                            if ($i<=6) {
			                                                                switch ($i) {
			                                                                    case 6:
			                                                                        $class = "didi";
			                                                                        break;
			                                                                    case 5:
			                                                                        $class = "kiki";
			                                                                        break;
			                                                                    case 4:
			                                                                        $class = "roro";
			                                                                        break;
			                                                                    case 3:
			                                                                        $class = "riri";
			                                                                        break;
			                                                                    case 2:
			                                                                        $class = "fifi";
			                                                                        break;
			                                                                    case 1:
			                                                                        $class = "loulou";
			                                                                        break;                                                               
			                                                                }
			                                                                $codeHTML .=' 
			                                                                    <div class="activiteSequence" title="'.$titre.'">
			                                                                        <img class="'.$class.'" id="image-thumb"  src="'.$fileimg.'" >
			                                                                        <div class="overlay" style="display:none;">      
			                                                                            <h4 class="activity-title">'.$titre.'</h4>
			                                                                            <input class="numSequence" type="hidden" value="'.$numero.'">
			                                                                            <input class="idSequence" type="hidden" value="'.$id_sequence.'">
			                                                                            <input class="linkSequence" type="hidden" value="'.$urlF.'">
			                                                                            <input class="detectlinkifrm" type="hidden" value="'.$detect_link.'">
			                                                                            <!--div class = "btn-group-vertical btn-action-activity">
			                                                                                <a class="btn link-action-nl btn-add-comment-activity" title="'.$this->lang->line('course_history_placeholder_comment').'">
			                                                                                    <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" class="image-action-nl img-comment-nl">
			                                                                                </a>
			                                                                                <a class="btn link-action-nl btn-add-fav-activity" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
			                                                                                    <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" class="image-action-nl img-favorite-nl">
			                                                                                </a>
			                                                                                 
			                                                                            </div-->
			                                                                            <div class="btn-loop-activity">
			                                                                              <a href="#" class="btn link-loop-nl btn-access-activity" title="Access to the activity">
			                                                                                  <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" class="image-action-nl img-loop-nl">
			                                                                              </a>
			                                                                          </div>
			                                                                        </div>
			                                                                    </div>';
			                                                            }
			                                                        }
			                                                               
			                                                    }
			                                                }
			                                                        
			                                               $codeHTML .='</div>
			                                                    <a class="more" href="#" title="View detail">
			                                                        <img src="'.base_url().'assets/dist/img/pictoMore.png" alt="more...">
			                                                    </a>
			                                                </div>';
			                                                
			                                            }                           
			                                        }
			                                    }
			                                }
			                            }
			                            $codeHTML .='</div></div>';
			                        }
			                    }
			                }
			            }
			            else{
			                $codeHTML.= '<div class="bloc_customisedprog">
			                                <h2>Your customised program</h2>
			                                <div id="sidetree"><div class="treeheader">&nbsp;</div><strong>To start, Select your program from the four buttons above</strong>
			                                </div></div>';
			            }

			            $array_newsletter = $this->sequence_model->getPavetHaut($idg,4);
			            $array_ped_training = $this->sequence_model->getPavetHaut($idg,6);
			            $array_pers_ling = $this->sequence_model->getPavetHaut($idg,7);
			            $array_ling_tools = $this->sequence_model->getPavetHaut($idg,8);

			            $arrayListeModule = array();
			            $array_id_module_newsletter = array();
			            $array_id_module_ped_training = array();
			            $array_id_module_pers_ling = array();
			            $array_id_module_ling_tools = array();   

			            if(!empty($array_newsletter)){
			                if (is_array($array_newsletter['module'])) {
			                    foreach($array_newsletter['module'] as $key=>$value){
			                        foreach($value as $key2=>$value2){
			                            $arrayListeModule[] = $value2['module_id'];
			                            $array_id_module_newsletter[] = $value2['module_id'];
			                        }
			                    }
			                }
			            }
			            if(!empty($array_ped_training)){
			                if (is_array($array_ped_training['module'])) {
			                    foreach($array_ped_training['module'] as $key=>$value){
			                        foreach($value as $key2=>$value2){
			                            $arrayListeModule[] = $value2['module_id'];
			                            $array_id_module_ped_training[] = $value2['module_id'];
			                        }
			                    }
			                }
			            }
			            if(!empty($array_pers_ling)){
			                if (is_array($array_pers_ling['module'])) {
			                    foreach($array_pers_ling['module'] as $key=>$value){
			                        foreach($value as $key2=>$value2){
			                            $arrayListeModule[] = $value2['module_id'];
			                            $array_id_module_pers_ling[] = $value2['module_id'];
			                        }
			                    }
			                }
			            }
			            if(!empty($array_ling_tools)){
			                if (is_array($array_ling_tools['module'])) {
			                    foreach($array_ling_tools['module'] as $key=>$value){
			                        foreach($value as $key2=>$value2){
			                            $arrayListeModule[] = $value2['module_id'];
			                            $array_id_module_ling_tools[] = $value2['module_id'];
			                        }
			                    }
			                }
			            }
			            if(!empty($ret_complementary_activities)){
			                if (is_array($ret_complementary_activities['module'])) {
			                    foreach($ret_complementary_activities['module'] as $key=>$value){
			                        $arrayListeModule[] = $value['module_id'];
			                    }
			                }
			            }

			            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_newsletter) ;
			            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
			            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;
			            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ling_tools) ;          
			            if(!empty($ret_complementary_activities)){
			                if(is_array($ret_complementary_activities['module']) && $PAVE=='6'){

			                 
			                      $codeHTML.= '
			                        <div class="title">
			                            <h2><span id="smart-title">Complementary Activities</span></h2>
			                                <span class="more">
			                                    <a href="#" title="" id="btn-smart-dept-more">
			                                        <img src="'.base_url().'assets/dist/img/pictoMore.png" alt="more...">
			                                    </a>
			                                </span>
			                            </div>
			                            <div class="showRoom smartCourshevesShowRoom">
			                                <div class="container" id="smart-list">
			                              ';
			                 
			                     foreach($ret_complementary_activities['module'] as $key=>$value){                
			                            $chapitre = $this->chapitres_model->read($value['sequence_id'],$this->session->userdata ('GUSERID'),$idg);

			                            $codeHTML .='
			                                <div class="smartCourseshelf" data-id="'.$key.'">
			                                    <span class="smartCourseshelfTitle">
			                                        <h3>'.$value['sequence_name'].'</h3>
			                                    </span>
			                                    <div class="books" id="smart-books-3062">'; 
			                                        $imgthumbnail = '';
			                                        if (isset($chapitre['cnt'])) {
			                                        
			                                            for($i=0;$i<$chapitre['cnt'];$i++) {

			                                                $type           = $chapitre[$i]['type']     ;
			                                                $titre          = $chapitre[$i]['titre']    ;
			                                                $numero         = $chapitre[$i]['numero']   ;
			                                                $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
			                                                $linkUrl        = $chapitre[$i]['lienUrl']  ;
			                                                $id_sequence    = $chapitre[$i]['id_sequence']  ;
			                                                $detect_link    = $chapitre[$i]['ifrmaccess']  ;


			                                                $link_support = $linkUrl;
			                                                $redir        = 'redir.php?url';
			                                                $support      = '';
			                                                $urlF         = "";
			                                                if ($this->validate_url($link_support)){
			                                                    $urlF         .= $link_support;
			                                                }
			                                                else{
			                                                    if (strpos($link_support, $redir) == false) { 
			                                                        $filename      = $this->getFileName($link_support);
			                                                        $ext            = explode(".", $filename);
			                                                        if (isset($ext[1]) && $ext[1]=="pdf") {
			                                                            $urlF         .= HTTP_FORMATIONS.$link_support;
			                                                        }
			                                                        elseif (isset($ext[1]) && ($ext[1]=="doc" || $ext[1]=="docx" || $ext[1]=="ppt")){
			                                                            $urlF   .= base_url().'groupes/index.php?link='.HTTP_FORMATIONS.$link_support;;
			                                                        }
			                                                        else{
			                                                            $urlF  .= HTTP_FORMATIONS.$link_support;
			                                                        }
			                                                    }                 
			                                                    else { 
			                                                        $urlF         .= str_replace("/redir.php?url=", "", $link_support);                 
			                                                    } 
			                                                }


			                                                if ($thumbnail_file !="") {
			                                                    $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
			                                                    $codeHTML .= "";                
			                                                }
			                                                else{
			                                                    $fileimg = base_url()."groupes/img_default.jpg";
			                                                    $codeHTML .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
			                                                }

			                                                if ($titre != "Support") {
			                                                    if ($i<=6) {
			                                                        switch ($i) {
			                                                            case 6:
			                                                                $class = "didi";
			                                                                break;
			                                                            case 5:
			                                                                $class = "kiki";
			                                                                break;
			                                                            case 4:
			                                                                $class = "roro";
			                                                                break;
			                                                            case 3:
			                                                                $class = "riri";
			                                                                break;
			                                                            case 2:
			                                                                $class = "fifi";
			                                                                break;
			                                                            case 1:
			                                                                $class = "loulou";
			                                                                break;                                                               
			                                                        }
			                                                        $codeHTML .=' 
			                                                            <div class="activiteSequence" title="'.$titre.'">
			                                                                <img class="'.$class.'" id="image-thumb"  src="'.$fileimg.'" >
			                                                                <div class="overlay" style="display:none;">      
			                                                                    <h4 class="activity-title">'.$titre.'</h4>
			                                                                    <input class="numSequence" type="hidden" value="'.$numero.'">
			                                                                    <input class="idSequence" type="hidden" value="'.$id_sequence.'">
			                                                                    <input class="linkSequence" type="hidden" value="'.$urlF.'">
			                                                                    <input class="detectlinkifrm" type="hidden" value="'.$detect_link.'">
			                                                                    <!--div class = "btn-group-vertical btn-action-activity">
			                                                                        <a class="btn link-action-nl btn-add-comment-activity" title="'.$this->lang->line('course_history_placeholder_comment').'">
			                                                                            <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" class="image-action-nl img-comment-nl">
			                                                                        </a>
			                                                                        <a class="btn link-action-nl btn-add-fav-activity" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
			                                                                            <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" class="image-action-nl img-favorite-nl">
			                                                                        </a>
			                                                                         
			                                                                    </div-->
			                                                                    <div class="btn-loop-activity">
			                                                                        <a href="#" class="btn link-loop-nl" title="Access to the activity">
			                                                                          <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" class="image-action-nl img-loop-nl">
			                                                                        </a>
			                                                                    </div>
			                                                                </div>
			                                                            </div>';
			                                                    }
			                                                }
			                                                       
			                                            }
			                                        }
			                                    
			                           $codeHTML .='</div>
			                                <a class="more" href="#" title="View detail">
			                                    <img src="'.base_url().'assets/dist/img/pictoMore.png" alt="more...">
			                                </a>
			                            </div>';

			                    }
			                    $codeHTML.= '
			                                </div>
			                            </div>
			                        </div>';

			                } 
			            }
			        }
			          
		        }
		        else
		        {
		            
		        }
		        if ($PAVE != 4) {                                     
		        	$codeHTML     .= '</div>'; 
		        }
		        $codeHTML .="</section>";   
		    }             

	        return $codeHTML;
	    }

	    public function readNewsletter(){
	    	$codeHTML='';
	    	$this->global['pageTitle']  = 'E-learning : Newsletter management';
	        $data['category']  = array(
	                           '1' => 'Politics' , 
	                           '2' => 'Health' , 
	                           '3' => 'Art' , 
	                           '4' => 'Travel' , 
	                           '5' => 'Lifestyle' , 
	                           '6' => 'Livestock' , 
	                           '7' => 'Culture' , 
	                           '8' => 'Society' , 
	                           '9' => 'Sport' , 
	                           '10'=> 'Economy' 
	                          );

	        $data['statPrg'] =  $this->stat_prg_model->getSatCat($this->session->userdata ('GUSERID'))->result(); 
	        $active_m = '';
			$active_m_c = '';
			$active_t = '';
			$active_t_c = '';
			if (isset($_GET['type']) && $_GET['type'] == 'm') {
				$active_m = 'active';
				$active_m_c = 'in active';
			}

			if (!isset($_GET['type'])){
				$active_m = 'active';
				$active_m_c = 'in active';
			}

			if (isset($_GET['type']) && $_GET['type'] == 'l') {
				$active_t = 'active';
				$active_t_c = 'in active';
			}
			$actual_link = base_url().'readprog-trainee?action=listerPageStagiaire&paves_sequence=4&id='.$this->session->userdata('STAGIAIREID').'&groupe='.$this->session->userdata('STAGIAIREGRP');
			//$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
		    $codeHTML.='

			    <style type="text/css">
			    	.img-vignette {
					    border-radius: 20px 20px 20px 20px !important;
					    border: none;
					}
			    </style>
		    	<link href="'.base_url().'assets/dist/css/sequencestyle.min.css" rel="stylesheet" type="text/css" /> 
		    	<script type="text/javascript" src="'.base_url().'assets/js/responsivevoice.src.js"></script>
				<input type="hidden" name="url-look-article" class="url-look-article" value="'.base_url().'getAllArticleByOtherUser">
				<input type="hidden" name="url-stat-article" class="url-stat-article" value="'.base_url().'stat-article">
				<input type="hidden" name="url-theme-page-article" class="url-theme-page-article" value="'.base_url().'page-theme">';
				$codeHTML.='<input type="hidden" name="pagination_theme" id="pagination_theme">
				<section class="content-header">
					<div class="parcours-trainee-loader" style="display: none;"></div>
      				<!--div class="notification"></div-->
					<div class="row">
						<div class="col-xs-12">
							<div class="col-xs-8">
					            <h4 class="action-menu-nl">
					            	<a href="'.base_url().'">
					                	<img src="assets/icons-f2+/menu_transverse/ico-home.png" alt="User elearning" class="user-image img-home">&nbsp;<span class="home-title ">Home</span>&nbsp;<img src="assets/icons-f2+/historique_de_cours/ico-arrowright.png" alt="User elearning" class="user-image img-home icons-rigth">
					              	</a>
					              	<a href="'.$_SERVER['REQUEST_URI'].'" class="btn-action-nl-home home-page active" >Newsletter</a>
					              	<a href="#" onclick="reloadTheme(this);" class="btn-action-nl-cat" style="display: none;"></a>
					            </h4>
				        	</div>
				        	<div class="col-xs-4">
					        	<div class="bs-example btn-grp-view" data-example-id="single-button-dropdown">
								    <div class="btn-group btn-chrono">
								      <a  data-toggle="tab"  class="btn btn-primary btn-action-chrono" href="#chronological-view">Chronological view</a>
								    </div><!-- /btn-group -->
								    <div class="btn-group btn-categ">
								      <a  data-toggle="tab"  class="btn btn-default btn-category-view" href="#view-by-category">View by category</a>
								    </div>
								</div>
				        	</div>
						</div>
					</div>
				</section>
				<section class="content">
					<div class="row">  
						<div class="box">
							<div class="notification"></div>
							<h3 style="margin-left: 35px;" class="text-center title-menu">Student training library</h3>  
						    <div class="loader-nl"></div>
						   	<div class="col-nl-detail">
						   		<div class="col-xs-12 content-list-theme"></div>
						   	</div>
						   	<div class="col-xs-12 row-vignette">
		                		<div class="card-body tab-content">
		                			<div class="chronological-view tab-pane fade in active" id="chronological-view">
		                				<ul class="nav nav-tabs card-header-tabs nav-newsletter-chrono" style="margin-bottom: 20px;">
								    		
									        <li class="nav-item '.$active_m.'">
									          <a data-toggle="tab" href="#newsletter-of-the-month">Newsletter of the month</a>
									        </li>
									        <li class="nav-item '.$active_t.'">
									          <a data-toggle="tab" href="#past-newsletter">Past newsletter</a>
									        </li>
									    </ul>
									    <div class="card-body tab-content">
								    		<div class="newsletter-of-the-month tab-pane fade '.$active_m_c.'" id="newsletter-of-the-month">
								    			<div class="row">
								    				<div class="col-md-12">';
								    				foreach ($this->newsletter_model->getArticleOfTheMonth() as $res) {
												      	$img= "";
												      	$thumb = $this->utilities_model->getthumbNL($res->ID);
													    if ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
													       $img  = base_url()."groupes/ACTIVITES/".$thumb;
													    }
													    else{
													        $img  = base_url()."groupes/default.png";
													    } 

													    $codeHTML.='<div class="col-md-2 padding-col">
															<div class="container-image hovereffect">
																<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$img.'">
																<div class="overlay">
																	<div class="btn-group-vertical" style="float: right !important;">
																		<input type="hidden" class="idCat" value="'.$res->ID.'">
																		<a href="#"  data-article="'.$res->article.'" data-id="'.$res->ID.'" data-module="'.$res->theme.'" data-sequence="'.$res->nl_monthnewsletter_id.'" class="btn link-action-nl btn-add-comment"  onclick="addArtCommNlotheMonth(this);" title="'.$this->lang->line('course_history_placeholder_comment').'">
																			<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">
																		</a>
																		<a href="#" data-article="'.$res->article.'" data-id="'.$res->ID.'" data-module="'.$res->theme.'" data-sequence="'.$res->nl_monthnewsletter_id.'" class="btn link-action-nl" title="Add in favorite" onclick="addArtFavNlMonth(this);">
																			<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" width="40%" class="image-action-nl img-favorite-nl">
																		</a>  
																	</div>

																	<div style="float: left !important;">
																		<a href="'.base_url().'read-data?id='.$res->ID.'" class="" title="'.$this->lang->line('course_history_placeholder_article').'">
																			<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" style="max-width:30%;" class="image-action-nl img-loop-nl">
																		</a>
																	</div>
																</div>
															</div>
															<div class="legend title-vignette"><span class="titleTumbnail">'.$res->article.'</span></div>
														</div>';
													}
								    					
								    				$codeHTML.='</div>
								    			</div>
								    		</div>
								    		<div class="past-newsletter tab-pane fade '.$active_t_c.'" id="past-newsletter">';
								    			$codeHTML .='<div class="row row-past-nl">
									    			<div class="panel-group col-xs-12" id="accordion">';
										    			$i = 1; 
										    			foreach ($this->newsletter_model->getLastMonth($this->newsletter_model->getMaxIdInMonth()) as $nl) { 
															$back = $this->codeColor_model->Request('background',$i); 
															$brdl = $this->codeColor_model->Request('border_left',$i); 
															$text = $this->codeColor_model->Request('text',$i);
															$codeHTML .='<div class="col-md-3">
															  	<div class="panel panel-default panel-nl" style="border-left-width: 7px;border-left-style: solid;border-left-color:'.$brdl.' !important;border-color:'.$back.';">
																    <div class="panel-heading" style="background-color: '.$back.';border-color:'.$back.'; ?>;border-top-left-radius:0px !important;border-top-right-radius:0px !important;">
																      	<h4 class="panel-title">
																        	<a class="accordion-toggle month-article-nl" style="color:'.$text.'" data-toggle="collapse" data-parent="#accordion" href="#collapse'.$i.'" indice="'.$i.'">&nbsp;&nbsp;'.utf8_encode($nl->monthNewsletter).'
																        	</a>
																      	</h4>
																    </div>
																    <div id="collapse'.$i.'" class="panel-collapse collapse">
																      <div class="panel-body" style="background-color:'.$back.'; ?>;">
																        <ul class="nav menu-article-nl">';
																        	foreach ($this->newsletter_model->listArticle($nl->id) as $al) {
											                              		$codeHTML .='<li class="material" style="">
											                                    	<a class="lnk-article-nl"  style="color:'.$text.'" href="'.base_url().'read-data?id='.$al->ID.'&type=l">'.utf8_encode($al->article).'</a>
											                                  	</li>';
											                                }
											                                $codeHTML .='</ul>
											                            </div>
																    </div>
																</div>
															</div>';
															$i++; 
														}
										    		$codeHTML .='</div>
								    			</div>
								    		</div>
								    	</div>
		                			</div>
		                			<div  class="row-vignette cls-detail-thumb tab-pane fade" id="view-by-category">
		                				<br>
		                				<br>
										<div class="col-md-12 row-vignette cls-detail-thumb">';
									        foreach ($data['category'] as $key => $theme) {
									        	$codeHTML .='<div class="col-md-2 padding-col">
									          		<div class="container-image hovereffect">
									            		<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.base_url().'groupes/NEWSLETTER/CATEGORIES/'.$theme.'.jpg">
									            		<div class="legend"><span class="titleTumbnail">'.$theme.'</span></div>	
									            		<div class="overlay">
														<div class="btn-group-vertical" style="float: right !important;">
															<input type="hidden" name="idCat" class="idCat" value="'.$key.'">
															<a href="#" class="btn link-action-nl btn-add-comment-cat" title="'.$this->lang->line('course_history_placeholder_comment').'">
																<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" style="max-width:42%;" class="image-action-nl img-comment-nl">
															</a>
															<a href="#" class="btn link-action-nl btn-add-fav-cat" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" width="40%" class="image-action-nl img-favorite-nl">
															</a>
														</div>

														<div style="float: left !important;">
															<a href="#" class="btn link-loop-nl" data-module="'.$key.'" title="'.$this->lang->line('course_history_placeholder_article').'">
																<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" style="max-width:30%;" class="image-action-nl img-loop-nl">
															</a>
														</div>
													</div>
									           		</div>
									        	</div>';
									        }
											$codeHTML.='
										</div>  
									</div>  
								</div>        
							</div>
						</div>
					</div>
				</section>
			</div>';

			return $codeHTML;
	    }

	    public function validate_url($url){
			$curl = curl_init($url); 
			curl_setopt($curl, CURLOPT_NOBODY, true); 
			$result = curl_exec($curl); 
			  
			if ($result !== false) { 
			    $statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE); 
			    if ($statusCode != 200 && $statusCode != 302 && $statusCode != 304) { 
			        return false; 
			    } 
			    else { 
			        return true; 
			    } 
			} 
			else { 
			    return false; 
			}
	    }

	    public function getResponseUrl($link){
	    	if (isset($link)) {
				$headers = @get_headers($link);
				return $headers;
	    	}
	    }

		public function makeArray($tab) {
			$ret = array();
			for($i=0;$i<$tab['cnt'];$i++) {
				$ret[] = $tab[$i]['id'] ;
			}
			return($ret);
		}

		public function ListSessionGroupeAdminDel($list, $del, $session=0,$id='',$id_seq) {
			$ret = '' ;

			$cur_parcous_name = '' ;
			$cur_module_name = ''  ;
			$strUrl = "";
			$seq_name = "";
			
			if ($id_seq == "pedagocical") {
				$seq_name = "pedagocical" ;
			} elseif ($id_seq == "interest_link") {
				$seq_name = "Interesting Links" ;
			} elseif ($id_seq == "linguistic_t") {
				$seq_name = "Dictionaries and translators" ;
			} elseif ($id_seq == "training_pr") {
				$seq_name = "Training Program" ;
			}		
			for($j=0;$j<$list['cnt'];$j++) {			
	            if ( $list[$j]['sequence_id'] > 0 ) {
	                
					$sequence_id 	= $list[$j]['sequence_id'] 	;
					$locs 			= $list[$j]['locs'] 		;
					$module_id 		= $list[$j]['module_id'] 	;
					$locm 			= $list[$j]['locm'] 		;
					$parcours_id 	= $list[$j]['parcours_id'] 	;
					$locp 			= $list[$j]['locp'] 		;
					$sequence_name 	= $list[$j]['sequence_name'];
					$module_name 	= $list[$j]['module_name'] 	;
					$parcours_name 	= $list[$j]['parcours_name'];
					$space = '' ;
					
					// Newsletter of the month,Interesting Links,Dictionaries and translators
					//if($seq_name != "") {
					if($seq_name != "") {
						if($module_name == $seq_name) {
							if ( $parcours_name != '' && $parcours_name!=$cur_parcous_name ) {
						
							   $cur_parcous_name = $parcours_name ;
							   $cur_module_name = '' ;
							   $img = $list[$j]['locp']=='<i class="fa fa-folder"></i>' ;
							   $param = '&sequence_id=-1&module_id=-1&parcours_id='.$parcours_id ;
							   $param.= '&locs=-1&locm=-1&locp='.$list[$j]['locp'] ;
							   $url  = $del.$param ;
							   $ldel = $this->script->LienNormal(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="fa fa-trash"></i>'));
							   //sequence
							   $liste_sequence = $session==1?'liste_sequence_session':'liste_sequence';
							   $url.= '&action='.$liste_sequence.'&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
							   $action = "onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
							   $lseq = $this->script->LienNormal(array('url'=>'#', 'action'=>$action,'val'=>'<i class="fa fa-plus"></i>'));
							   // module
							   $liste_module = $session==1?'liste_module_session':'liste_module';
							   $url.= '&action='.$liste_module.'&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
							   $action = "onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
							   $lmod = $this->script->LienNormal(array('url'=>'#', 'action'=>$action,'val'=>'<i class="fa fa-edit"></i>'));
							   $ret .= "&nbsp;".$img."&nbsp;".$parcours_name."&nbsp;".$ldel."&nbsp;".$lseq."&nbsp;".$lmod." <br />\n";
							}
							$space.= $parcours_name != '' ? '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;':'';
							if ( $module_name != '' && $module_name!=$cur_module_name) {				
						
							   $cur_module_name = $module_name ;
							   $img = $list[$j]['locm']=='<i class="fa fa-folder"></i>';
							   $param = '&sequence_id=-1&module_id='.$module_id.'&parcours_id='.$parcours_id ;
							   $param.= '&locs=-1&locm='.$list[$j]['locm'].'&locp='.$list[$j]['locp'] ;
							   $url  = $del.$param ;
							   $ldel = $this->script->LienNormal(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="fa fa-trash"></i>'));
							   $liste_sequence = $session==1?'liste_sequence_session':'liste_sequence';
							   $url.= '&action='.$liste_sequence.'&cur_module_id='.$module_id.'&cur_locm='.$locm ;
							   $url.= '&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
							   $action = "onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
							   $lseq = $this->script->LienNormal(array('url'=>'#', 'action'=>$action,'val'=>'<i class="fa fa-plus"></i>'));
							   $ret .= "&nbsp;".$space.$img."&nbsp;".$module_name."&nbsp;".$ldel."&nbsp;".$lseq." <br />\n";
							}     	
							$space.= $module_name != '' ? '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;':'';
							$param = '&sequence_id='.$sequence_id.'&module_id='.$module_id.'&parcours_id='.$parcours_id ;
							$param.= '&locs='.$list[$j]['locs'].'&locm='.$list[$j]['locm'].'&locp='.$list[$j]['locp'] ;
							$img = $list[$j]['locs']=='<i class="fa fa-folder"></i>' ;
							$url  = $del.$param ;
							$link = $this->script->LienNormal(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="fa fa-trash"></i>'));
							$ret .= "<input type='checkbox'  name='checkboxseq[]'  value='$j/".$parcours_id.'_'.$sequence_id.'_'.$list[$j]['locs'].'_'.$list[$j]['locm'].'_'.$list[$j]['locp']."_".$module_id."'>";
							$ret .= "&nbsp;".$space.$img."&nbsp;".$sequence_name."&nbsp;".$link." <br />\n";
							$ret.="<input type='hidden' value='$url' id='url$j' >";
						} 
						elseif( $seq_name == "pedagocical") {
							if( $module_name !="Newsletter of the month" && $module_name !="Interesting Links" && $module_name !="Dictionaries and translators" ) {
								if ( $parcours_name != '' && $parcours_name!=$cur_parcous_name ) {
							
								   $cur_parcous_name = $parcours_name ;
								   $cur_module_name = '' ;
								   $img = $list[$j]['locp']=='<i class="fa fa-folder"></i>';
								   $param = '&sequence_id=-1&module_id=-1&parcours_id='.$parcours_id ;
								   $param.= '&locs=-1&locm=-1&locp='.$list[$j]['locp'] ;
								   $url  = $del.$param ;
								   $ldel = $this->script->LienNormal(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="fa fa-trash"></i>'));
								   //sequence
								   $liste_sequence = $session==1?'liste_sequence_session':'liste_sequence';
								   $url.= '&action='.$liste_sequence.'&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
								   $action = "onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
								   $lseq = $this->script->LienNormal(array('url'=>'#', 'action'=>$action,'val'=>'<i class="fa fa-plus"></i>'));
								   // module
								   $liste_module = $session==1?'liste_module_session':'liste_module';
								   $url.= '&action='.$liste_module.'&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
								   $action = "onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
								   $lmod = $this->script->LienNormal(array('url'=>'#', 'action'=>$action,'val'=>'<i class="fa fa-edit"></i>'));
								   $ret .= "&nbsp;".$img."&nbsp;".$parcours_name."&nbsp;".$ldel."&nbsp;".$lseq."&nbsp;".$lmod." <br />\n";
								}
								$space.= $parcours_name != '' ? '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;':'';
								if ( $module_name != '' && $module_name!=$cur_module_name) {				
							
								   $cur_module_name = $module_name ;
								   $img = $list[$j]['locm']=='<i class="fa fa-folder"></i>' ;
								   $param = '&sequence_id=-1&module_id='.$module_id.'&parcours_id='.$parcours_id ;
								   $param.= '&locs=-1&locm='.$list[$j]['locm'].'&locp='.$list[$j]['locp'] ;
								   $url  = $del.$param ;
								   $ldel = $this->script->LienNormal(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="fa fa-trash"></i>'));
								   $liste_sequence = $session==1?'liste_sequence_session':'liste_sequence';
								   $url.= '&action='.$liste_sequence.'&cur_module_id='.$module_id.'&cur_locm='.$locm ;
								   $url.= '&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
								   $action = "onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
								   $lseq = $this->script->LienNormal(array('url'=>'#', 'action'=>$action,'val'=>'<i class="fa fa-plus"></i>'));
								   $ret .= "&nbsp;".$space.$img."&nbsp;".$module_name."&nbsp;".$ldel."&nbsp;".$lseq." <br />\n";
								}     	
								$space.= $module_name != '' ? '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;':'';
								$param = '&sequence_id='.$sequence_id.'&module_id='.$module_id.'&parcours_id='.$parcours_id ;
								$param.= '&locs='.$list[$j]['locs'].'&locm='.$list[$j]['locm'].'&locp='.$list[$j]['locp'] ;
								$img = $list[$j]['locs']=='<i class="fa fa-add"></i>' ;
								$url  = $del.$param ;
								$link = $this->script->LienNormal(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="fa fa-trash"></i>'));
								$ret .= "<input type='checkbox'  name='checkboxseq[]'  value='$j/".$parcours_id.'_'.$sequence_id.'_'.$list[$j]['locs'].'_'.$list[$j]['locm'].'_'.$list[$j]['locp']."_".$module_id."'>";
								$ret .= "&nbsp;".$space.$img."&nbsp;".$sequence_name."&nbsp;".$link." <br />\n";
								$ret.="<input type='hidden' value='$url' id='url$j' >";
							}	
						}		
					} 
					else {
						if ( $parcours_name != '' && $parcours_name!=$cur_parcous_name ) {
					
							   $cur_parcous_name = $parcours_name ;
							   $cur_module_name = '' ;
							   $img = $list[$j]['locp']=='<i class="fa fa-plus"></i>' ;
							   $param = '&sequence_id=-1&module_id=-1&parcours_id='.$parcours_id ;
							   $param.= '&locs=-1&locm=-1&locp='.$list[$j]['locp'] ;
							   $url  = $del.$param ;
							   $ldel = $this->script->LienNormal(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="fa fa-trash"></i>'));
							   //sequence
							   $liste_sequence = $session==1?'liste_sequence_session':'liste_sequence';
							   $url.= '&action='.$liste_sequence.'&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
							   $action = "onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
							   $lseq = $this->script->LienNormal(array('url'=>'#', 'action'=>$action,'val'=>'<i class="fa fa-plus"></i>'));
							   // module
							   $liste_module = $session==1?'liste_module_session':'liste_module';
							   $url.= '&action='.$liste_module.'&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
							   $action = "onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
							   $lmod = $this->script->LienNormal(array('url'=>'#', 'action'=>$action,'val'=>'<i class="fa fa-edit"></i>'));
							   $ret .= "&nbsp;".$img."&nbsp;".$parcours_name."&nbsp;".$ldel."&nbsp;".$lseq."&nbsp;".$lmod." <br />\n";
							 //  $ret.="<input type='hidden' name='fullUrl[]' id='fullUrl[]' value='".$url."' />";
							}
							$space.= $parcours_name != '' ? '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;':'';
							if ( $module_name != '' && $module_name!=$cur_module_name) {
							
							   $cur_module_name = $module_name ;
							   //$img = $list[$j]['locm']==LOCAL?IMG_TYPE_MODULE_LOCAL:IMG_TYPE_MODULE ;
							   $img = $list[$j]['locm']=='<i class="fa fa-add"></i>' ;
							   $param = '&sequence_id=-1&module_id='.$module_id.'&parcours_id='.$parcours_id ;
							   $param.= '&locs=-1&locm='.$list[$j]['locm'].'&locp='.$list[$j]['locp'] ;
							   $url  = $del.$param ;
							   $ldel = $this->script->LienNormal(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="fa fa-trash"></i>'));
							   $liste_sequence = $session==1?'liste_sequence_session':'liste_sequence';
							   $url.= '&action='.$liste_sequence.'&cur_module_id='.$module_id.'&cur_locm='.$locm ;
							   $url.= '&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
							   $action = "onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
							   $lseq = $this->script->LienNormal(array('url'=>'#', 'action'=>$action,'val'=>'<i class="fa fa-plus"></i>'));
							   $ret .= "&nbsp;".$space.$img."&nbsp;".$module_name."&nbsp;".$ldel."&nbsp;".$lseq." <br />\n";
							}
							
							$space.= $module_name != '' ? '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;':'';
							$param = '&sequence_id='.$sequence_id.'&module_id='.$module_id.'&parcours_id='.$parcours_id ;
							$param.= '&locs='.$list[$j]['locs'].'&locm='.$list[$j]['locm'].'&locp='.$list[$j]['locp'] ;
							$img = $list[$j]['locs']=='<i class="fa fa-plus"></i>' ;
							//$img = $list[$j]['locs']==LOCAL?IMG_TYPE_SEQUENCE_LOCAL:IMG_TYPE_SEQUENCE ;
							$url  = $del.$param ;
							$link = $this->script->LienNormal(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="fa fa-trash"></i>'));
							$ret .= "<input type='checkbox'  name='checkboxseq[]'  value='".$parcours_id.'_'.$sequence_id.'_'.$list[$j]['locs'].'_'.$list[$j]['locm'].'_'.$list[$j]['locp']."_".$module_id."'>";
							$ret .= "&nbsp;".$space.$img."&nbsp;".$sequence_name."&nbsp;".$link." <br />\n";						
					}
	            }
	           
			}
			
			if(isset($sequence_id) && $sequence_id!=''){
				$ret.= "<br/><a href='Javascript:void(0);' class='btn btn-default' onclick=\"javascript:uncheckAll('checkboxseq'); \">Tous Decocher</a> ";   	
	         	$ret.= " <a href='Javascript:void(0);'  class='btn btn-danger' onclick=\"javascript:DeleteItem('".$strUrl."','checkboxseq'); return false;\">Supprimer la s&eacute;lection</a>";
	         
	    	}
	    	return($ret);
		}

		/*public function ListSessionGroupeAdminDelV3($list, $del, $session=0,$id_seq,$id='') {
			$ret              = '' ;
			$cur_parcous_name = '' ;
			$cur_module_name  = ''  ;
			$strUrl           = "";	

			for($j=0;$j<$list['cnt'];$j++) {			
	            if ( $list[$j]['sequence_id'] > 0 ) {
	                
					$sequence_id 	= $list[$j]['sequence_id'] 	;
					$locs 			= $list[$j]['locs'] 		;
					$module_id 		= $list[$j]['module_id'] 	;
					$locm 			= $list[$j]['locm'] 		;
					$parcours_id 	= $list[$j]['parcours_id'] 	;
					$locp 			= $list[$j]['locp'] 		;
					$sequence_name 	= $list[$j]['sequence_name'];
					$module_name 	= $list[$j]['module_name'] 	;
					$parcours_name 	= $list[$j]['parcours_name'];
					
					if ( $parcours_name != '' && $parcours_name!=$cur_parcous_name ) {					
					   $cur_parcous_name = $parcours_name ;
					   $cur_module_name = '' ;
					   $param = '&sequence_id=-1&module_id=-1&parcours_id='.$parcours_id.'&locs=-1&locm=-1&locp='.$list[$j]['locp'] ;
					   $url  = $del.$param ;
					   $ldel = $this->script->LienNormalV3(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="bx bx-trash-alt"></i>'));
					   //sequence
					   $url.= $session == 1? '&action=liste_sequence_session&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp : '&action=liste_sequence&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
					   $lseq = $this->script->LienNormalV3(array('url'=>'#', 'action'=>"onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\"",'val'=>'<i class="bx bx-window-open"></i>'));
					   // module
					   $url.= $session == 1 ? '&action=liste_module_session&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp : '&action=liste_module&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;

						//parcour block
					   $ret .= "<div class='el-p-1'>&nbsp;<i class='bx bx-folder-open bx-icon-el-lib'></i>".$parcours_name.$ldel.$lseq.$this->script->LienNormalV3(array('url'=>'#', 'action'=>"onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ",'val'=>'<i class="bx bxs-edit"></i>'))."</div>";
					}

					if ( $module_name != '' && $module_name!=$cur_module_name) {
					   $cur_module_name = $module_name ;
					   $param = '&sequence_id=-1&module_id='.$module_id.'&parcours_id='.$parcours_id.'&locs=-1&locm='.$list[$j]['locm'].'&locp='.$list[$j]['locp'] ;
					   $url  = $del.$param ;
					   $ldel = $this->script->LienNormalV3(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="bx bx-trash-alt"></i>'));
					   $url.= $session == 1 ? '&action=liste_sequence_session&cur_module_id='.$module_id.'&cur_locm='.$locm.'&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp : '&action=liste_sequence&cur_module_id='.$module_id.'&cur_locm='.$locm.'&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
					   $action = "onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
					   $lseq = $this->script->LienNormalV3(array('url'=>'#', 'action'=>$action,'val'=>'<i class="bx bx-window-open"></i>'));

						//module block
					   $ret .= "<div class='el-p-2'>&nbsp;<i class='bx bx-folder-plus bx-icon-el-lib'></i>".$module_name.$ldel.$lseq."</div>";
					}
						
					//sequence block
					$ret .= "<div class='el-checkbox el-p-3'><input type='checkbox'  name='checkboxseq[]' class='style-1' value='".$parcours_id.'_'.$sequence_id.'_'.$list[$j]['locs'].'_'.$list[$j]['locm'].'_'.$list[$j]['locp']."_".$module_id."'>".$sequence_name.$this->script->LienNormalV3(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$del.'&sequence_id='.$sequence_id.'&module_id='.$module_id.'&parcours_id='.$parcours_id.'&locs='.$list[$j]['locs'].'&locm='.$list[$j]['locm'].'&locp='.$list[$j]['locp']."','');\"",'val'=>'<i class="bx bx-trash-alt"></i>'))."</div>";	
	            }
	           
			}
			
			if(isset($sequence_id) && $sequence_id!=''){
				$ret.= "<br/><div class='btn-group'><button href='Javascript:void(0);' class='el-btn-light btn-table-plus' onclick=\"javascript:uncheckAll('checkboxseq'); \">Tous Decocher</button><button href='Javascript:void(0);'  class='el-btn-pink btn-table-plus' onclick=\"javascript:DeleteItem('".$strUrl."','checkboxseq'); return false;\">Supprimer la s&eacute;lection</button></div>";
	         
	    	}
	    	return($ret);
		}*/

		public function ListSessionGroupeAdminDelV3($list, $del, $session=0,$id_seq,$id='') {
			$ret              = '' ;
			$cur_parcous_name = '' ;
			$cur_module_name  = ''  ;
			$htmlParcours     = ''  ;
			$htmlModules      = ''  ;
			$htmlSequences    = ''  ;
			$strUrl           = "";	

			$ret              = '<ul id="formationPedagogique">' ;

			for($j=0;$j<$list['cnt'];$j++) {			
	            if ( $list[$j]['sequence_id'] > 0 ) {
	                
					$sequence_id 	= $list[$j]['sequence_id'] 	;
					$locs 			= $list[$j]['locs'] 		;
					$module_id 		= $list[$j]['module_id'] 	;
					$locm 			= $list[$j]['locm'] 		;
					$parcours_id 	= $list[$j]['parcours_id'] 	;
					$locp 			= $list[$j]['locp'] 		;
					$sequence_name 	= $list[$j]['sequence_name'];
					$module_name 	= $list[$j]['module_name'] 	;
					$parcours_name 	= $list[$j]['parcours_name'];
					
					if ( $parcours_name != '' && $parcours_name!=$cur_parcous_name ) {					
					   $cur_parcous_name = $parcours_name ;
					   $cur_module_name = '' ;
					   $param = '&sequence_id=-1&module_id=-1&parcours_id='.$parcours_id.'&locs=-1&locm=-1&locp='.$list[$j]['locp'] ;
					   $url  = $del.$param ;
					   $ldel = $this->script->LienNormalV3(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="bx bx-trash-alt"></i>'));
					   //sequence
					   $url.= $session == 1? '&action=liste_sequence_session&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp : '&action=liste_sequence&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
					   $lseq = $this->script->LienNormalV3(array('url'=>'#', 'action'=>"onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\"",'val'=>'<i class="bx bx-window-open"></i>'));
					   // module
					   $url.= $session == 1 ? '&action=liste_module_session&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp : '&action=liste_module&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;

						//parcour block
					   //$ret .= "<div class='el-p-1'>&nbsp;<i class='bx bx-folder-open bx-icon-el-lib'></i>".$parcours_name.$ldel.$lseq.$this->script->LienNormalV3(array('url'=>'#', 'action'=>"onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ",'val'=>'<i class="bx bxs-edit"></i>'))."</div>";
					   $htmlParcours .= "<div class='el-p-1'>&nbsp;<i class='bx bx-folder-open bx-icon-el-lib'></i>".$parcours_name.$ldel.$lseq.$this->script->LienNormalV3(array('url'=>'#', 'action'=>"onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ",'val'=>'<i class="bx bxs-edit"></i>'))."</div>";
					}

					if ( $module_name != '' && $module_name!=$cur_module_name) {
					   $cur_module_name = $module_name ;
					   $param = '&sequence_id=-1&module_id='.$module_id.'&parcours_id='.$parcours_id.'&locs=-1&locm='.$list[$j]['locm'].'&locp='.$list[$j]['locp'] ;
					   $url  = $del.$param ;
					   $ldel = $this->script->LienNormalV3(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$url."','');\"",'val'=>'<i class="bx bx-trash-alt"></i>'));
					   $url.= $session == 1 ? '&action=liste_sequence_session&cur_module_id='.$module_id.'&cur_locm='.$locm.'&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp : '&action=liste_sequence&cur_module_id='.$module_id.'&cur_locm='.$locm.'&cur_parcours_id='.$parcours_id.'&cur_locp='.$locp ;
					   $action = "onClick=\"openWindow('".$url."','list_seq','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
					   $lseq = $this->script->LienNormalV3(array('url'=>'#', 'action'=>$action,'val'=>'<i class="bx bx-window-open"></i>'));

						//module block
					   //$ret .= "<div class='el-p-2'>&nbsp;<i class='bx bx-folder-plus bx-icon-el-lib'></i>".$module_name.$ldel.$lseq."</div>";
					   $htmlModules .= "<div class='el-p-2'>&nbsp;<i class='bx bx-folder-plus bx-icon-el-lib'></i>".$module_name.$ldel.$lseq."</div>";
					}
						
					//sequence block
					//$ret .= "<div class='el-checkbox el-p-3'><input type='checkbox'  name='checkboxseq[]' class='style-1' value='".$parcours_id.'_'.$sequence_id.'_'.$list[$j]['locs'].'_'.$list[$j]['locm'].'_'.$list[$j]['locp']."_".$module_id."'>".$sequence_name.$this->script->LienNormalV3(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$del.'&sequence_id='.$sequence_id.'&module_id='.$module_id.'&parcours_id='.$parcours_id.'&locs='.$list[$j]['locs'].'&locm='.$list[$j]['locm'].'&locp='.$list[$j]['locp']."','');\"",'val'=>'<i class="bx bx-trash-alt"></i>'))."</div>";	
					$htmlModules .= "<div class='el-checkbox el-p-3'><input type='checkbox'  name='checkboxseq[]' class='style-1' value='".$parcours_id.'_'.$sequence_id.'_'.$list[$j]['locs'].'_'.$list[$j]['locm'].'_'.$list[$j]['locp']."_".$module_id."'>".$sequence_name.$this->script->LienNormalV3(array('url'=>'#', 'action'=>"onclick=\"javascript:DeleteItem('".$del.'&sequence_id='.$sequence_id.'&module_id='.$module_id.'&parcours_id='.$parcours_id.'&locs='.$list[$j]['locs'].'&locm='.$list[$j]['locm'].'&locp='.$list[$j]['locp']."','');\"",'val'=>'<i class="bx bx-trash-alt"></i>'))."</div>";	
	            }
	           
			}



			$ret              = '</ul>' ;
			
			if(isset($sequence_id) && $sequence_id!=''){
				$ret.= "<br/><div class='btn-group'><button href='Javascript:void(0);' class='el-btn-light btn-table-plus' onclick=\"javascript:uncheckAll('checkboxseq'); \">Tous Decocher</button><button href='Javascript:void(0);'  class='el-btn-pink btn-table-plus' onclick=\"javascript:DeleteItem('".$strUrl."','checkboxseq'); return false;\">Supprimer la s&eacute;lection</button></div>";
	         
	    	}
	    	return($ret);
		}

		public function ReplaceTime($val, $format=0) {
			$h = intval(intval($val) / 3600);
			if ($h < 10 && $format==0) {
				$h =  "0".$h;
			}

			$m = ((intval($val) / 60) % 60);
			if ($m < 10 && $format==0) {
				$m =  "0".$m;
			}

			$s = (intval($val) % 60);
			if ($s < 10 && $format==0) {
				$s = "0".$s;
			}

			switch($format) {
			case 0 :
				$res = $h.':'.$m.':'.$s;
				break;
			case 1 :
				$res = ($h>0?$h.' h ':'');
				$res.= ($m>0?$m.' mn ':'');
				$res.= ($s>0 || strlen($res)==0?$s.' s':'');
				break;
			}
			return($res);
		}
		public  function toTimeStamp($date='') {
			if($date=='' || $date=='01/01/70'){
				//Si la date est vide, retourne le timestamp du jour
				return mktime (0, 0, 0, Date('m'), Date('d'), Date('Y'));;
			} 
			else {
				$ret = explode('/', $date);
				$ret[0] = isset($ret[0])?$ret[0]:0 ;
				$ret[1] = isset($ret[1])?$ret[1]:0 ;
				$ret[2] = isset($ret[2])?$ret[2]:0 ;
				$res = @mktime(0,0,0,$ret[1], $ret[0], $ret[2]);
				return($res===-1?'01/01/70':$res);
			}
		}

		public function CopyPhotoMembre($file, $id) {
			if (isset($file['name'])) {
				$type_file_tab = explode('.', $file['name']);
				$ret = false ;
				//Vérifie l'extension de l'image et sauvegarde le fichier avec la même extension
				if(count($type_file_tab)>0) {
					$type_file = '.'.$type_file_tab[count($type_file_tab)-1];
					$nomPhoto = 'user_'.$id.$type_file;
					$ret = $this->copier_fichier($file, RP_UPLOAD_PHOTOS.$nomPhoto);
					$ancienNomPhoto = $this->membres_model->Request('nom_photo', $id);
					if($ancienNomPhoto != $nomPhoto) {
						$data = array('nom_photo' => $nomPhoto );
						$this->membres_model->update($id, $data);
						if($ancienNomPhoto!='') {
							$this->DeleteDocument(RP_UPLOAD_PHOTOS.$ancienNomPhoto);
						}
					}

				}
			}
			return($ret);
		}

		public function DeleteDocument($fichier) {
			if ( file_exists($fichier) ) {
				unlink($fichier);
			}
		}

		public function copier_fichier($fichier, $dest) {
			$name =  basename($dest);
			if ( is_uploaded_file($fichier['tmp_name']) ) {
				@move_uploaded_file($fichier['tmp_name'],$dest) ;
				return($name);
			} else {
				die('erreur tmp_file -> '.$fichier['error']);
				return(false) ;
			}
		}

	    public function findUltimateDestination($url, $maxRequests = 10){
	        $ch = curl_init();

	        curl_setopt($ch, CURLOPT_HEADER, true);
	        curl_setopt($ch, CURLOPT_NOBODY, true);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	        curl_setopt($ch, CURLOPT_MAXREDIRS, $maxRequests);
	        curl_setopt($ch, CURLOPT_TIMEOUT, 15);
	        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Link Checker)');
	        curl_setopt($ch, CURLOPT_URL, $url);
	        curl_exec($ch);
	        $url=curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
	        curl_close ($ch);
	        return $url;
	    }

	    public function getHeaderResponses($url){
	    	$response = array();
	    	$header = @get_headers($url, 1);
		    return $header;
	    }

	    public function getAllHeaderResponses($url){
	    	$response = array();
	    	$header = @get_headers($url);
		    return $header;
	    }

	    public function findStatusUrlFinal($urlF){
	    	$ret = array();
	    	$headerResponses = $this->getAllHeaderResponses($urlF);       
            if (strrpos($urlF, "https") !== false) {
                if ($headerResponses == false) {
                    $ret['status'] = 0;
                    $ret['urlF'] = $urlF;
                }
                else{
                    for ($i=0; $i < count($headerResponses); $i++) { 

                        if ((strrpos($headerResponses[$i], "403 Forbidden") !== false) || (strrpos($headerResponses[$i], "404 Not Found") !== false)) {
                            $ret['status'] = 3;
                    		$ret['urlF'] = $urlF;

                        }

                        if ((strrpos($headerResponses[$i], "X-Content-Security-Policy: frame-ancestors") !== false) || (strrpos($headerResponses[$i], "X-Frame-Options: SAMEORIGIN") !== false) || (strrpos($headerResponses[$i], "X-Frame-Options: DENY") !== false) || (strrpos($headerResponses[$i], "X-Frame-Options: deny") !== false)) {
                            $ret['status'] = 2;
                    		$ret['urlF'] = $urlF;

                        }

                        if ((strrpos($headerResponses[$i], "403 Forbidden") === false) && (strrpos($headerResponses[$i], "404 Not Found") === false) && (strrpos($headerResponses[$i], "X-Content-Security-Policy: frame-ancestors") === false) && (strrpos($headerResponses[$i], "X-Frame-Options: SAMEORIGIN") === false) && (strrpos($headerResponses[$i], "X-Frame-Options: DENY") === false) && (strrpos($headerResponses[$i], "X-Frame-Options: deny") === false)) {
                            $ret['status'] = 1;
                    		$ret['urlF'] = $urlF;
                        }
                    }
                }
            }
            else {
                if ($headerResponses == false) {
                    $ret['status'] = 7;
                    $ret['urlF'] = $urlF;
                }
                else{
                    $urlRedirect  = '';
                    for ($i=0; $i < count($headerResponses); $i++) { 
                        //Check lins a redirect
                        if (strrpos($headerResponses[$i], "Location:") !== false) {
                            $urlRedirect = str_replace("Location: ", "", $headerResponses[$i]);
                        }
                    }

                    if (isset($urlRedirect) && $urlRedirect !== '') {
                        //addLog('redirect url : '.$urlRedirect);
                        $headerResponses1 = $this->getAllHeaderResponses($urlRedirect);
                        if ($headerResponses1 == false) {
                            $ret['status'] = 6;
                    		$ret['urlF'] = $urlRedirect;
                        }
                        else{
                            for ($i=0; $i < count($headerResponses1); $i++) { 
                                
                                if ((strrpos($headerResponses1[$i], "403 Forbidden") !== false) || (strrpos($headerResponses1[$i], "404 Not Found") !== false)) {
                                    $ret['status'] = 3;
                    				$ret['urlF'] = $urlRedirect;
                                }

                                if ((strrpos($headerResponses1[$i], "X-Content-Security-Policy: frame-ancestors") !== false) || (strrpos($headerResponses1[$i], "X-Frame-Options: SAMEORIGIN") !== false) || (strrpos($headerResponses1[$i], "X-Frame-Options: DENY") !== false) || (strrpos($headerResponses1[$i], "X-Frame-Options: deny") !== false)) {
                                    $ret['status'] = 2;
                    				$ret['urlF'] = $urlRedirect;

                                }

                                if ((strrpos($headerResponses1[$i], "403 Forbidden") === false) && (strrpos($headerResponses1[$i], "404 Not Found") === false) && (strrpos($headerResponses1[$i], "X-Content-Security-Policy: frame-ancestors") === false) && (strrpos($headerResponses1[$i], "X-Frame-Options: SAMEORIGIN") === false) && (strrpos($headerResponses1[$i], "X-Frame-Options: DENY") === false) && (strrpos($headerResponses1[$i], "X-Frame-Options: deny") === false)) {
                                    $ret['status'] = 1;
                    				$ret['urlF'] = $urlRedirect;
                                }
                            }
                        }
                    }
                    else{   
                        $headerResponses2 = $this->getAllHeaderResponses($urlF);  
                        for ($i=0; $i < count($headerResponses2); $i++) { 
                        
                            if ((strrpos($headerResponses2[$i], "403 Forbidden") !== false) || (strrpos($headerResponses2[$i], "404 Not Found") !== false)) {
                                $ret['status'] = 3;
                    			$ret['urlF'] = $urlF;

                            }
                            else{                                                   
                                $ret['status'] = 4;
                    			$ret['urlF'] = $urlF;
                            }
                        }
                    }
                }
            }

            return $ret;
	    }

	    public function envoi_des_donnnes($taille){
            //$donnee="www.frameip.com ";
            $temps_avant_envoi=microtime();
            for ($i=0;$i<$taille/16;$i++)
                        //echo $donnee;
            $temps_apres_envoi=microtime();

            $tampon=explode(" ",$temps_avant_envoi);
            $temps_avant_envoi=((float)$tampon[0]+(float)$tampon[1]);
            $tampon=explode(" ",$temps_apres_envoi);
            $temps_apres_envoi=((float)$tampon[0]+(float)$tampon[1]);
            return($temps_apres_envoi-$temps_avant_envoi);
        }

        public function getThemesBddl(){
        	$curl = curl_init();
			curl_setopt_array($curl, array(
			  CURLOPT_URL => $this->config->item("bddl_api_").'api/prototypes/themes',
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'GET',
			));

			$response = curl_exec($curl);

			curl_close($curl);
			return json_decode($response);
		   
		}   

		public function getPrototypeBddl(){
			$curl = curl_init();
			curl_setopt_array($curl, array(
			  CURLOPT_URL => ''.$this->config->item("bddl_api_").'/api/prototypes/list',
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'GET',
			  CURLOPT_HTTPHEADER => array(
			    'Cookie: PHPSESSID=795ft17c0udj17sjpt4n48r10l'
			  ),
			));

			$response = curl_exec($curl);
			curl_close($curl);
			return json_decode($response);
		   
		} 

		public function getProfilExtranet($extranetId){
        	$curl = curl_init();
			curl_setopt_array($curl, array(
			  CURLOPT_URL => $this->config->item("api_base_url_extranet").'Profil-el/Home/Getprofil/'.$extranetId,
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'GET',
			));

			$response = curl_exec($curl);

			curl_close($curl);
			return json_decode($response);
		   
		} 
		public function getDateStartAndEndDate($start_date,$end_date){
			$date = array();
			$s =  explode('/', $start_date);
			$e =  explode('/', $end_date);
            $date['start_date'] = mktime ( 1 , 59 , 59 , $s[1] , $s[0] , $s[2] );
            $date['end_date']   = mktime ( 1 , 59 , 59 , $e[1] , $e[0]+1 , $e[2] );
            return $date;
		}

		public function getDateStartAndEndDate1($start_date,$end_date){
			$date = array();
			$s =  explode('/', $start_date);
			$e =  explode('/', $end_date);
            $date['start_date'] = mktime ( 1 , 59 , 59 , $s[1] , $s[0] , $s[2] );
            $date['end_date']   = mktime ( 1 , 59 , 59 , $e[1] , $e[0] , $e[2] );
            return $date;
		}

		public function getEmbedUrlFromTodo($idNewSequence){
			$linkIfram = '';
			$retour = '';
			$allResult = $this->todolist_model->getInfoNewSequence($idNewSequence);
            foreach ($allResult as $res) {
                $urlTodo1 = $res->link;
                if ($res->type == 0 && strpos($urlTodo1, 'youtube') === false && strpos($urlTodo1, 'youtu.be') === false && strpos($urlTodo1, 'vimeo.com') === false && strpos($urlTodo1, 'facebook.com') === false && strpos($urlTodo1, 'dailymotion.com') === false) {
                    $linkIfram = $res->link;
                }
                elseif ($res->type == 0 && (strpos($urlTodo1, 'vimeo.com') !== false || strpos($urlTodo1, 'facebook.com') !== false || strpos($urlTodo1, 'dailymotion.com') !== false || strpos($urlTodo1, 'youtube') !== false || strpos($urlTodo1, 'youtu.be') !== false)) {
                    $linkIfram = $this->getEmbedUrl($urlTodo1);
                }            
                elseif ((strpos(HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1, '.doc') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1, '.docx') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1, '.ppt') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1, '.pdf') !== false)){

                    $linkIfram = HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1;
                }
                else{
                    $linkIfram = HTTP_MAIN.'groupes/GRPT'.$res->user_create.'/documentTodo/'.$urlTodo1;
                }
            }

            if ($linkIfram != '') {
            	$retour = $this->findUltimateDestination($linkIfram,10);
            }
            else{
            	$retour = '';
            }
            return $retour;
            
		}

	    public function getEmbedUrl($url) {
	        // function for generating an embed link
	        $finalUrl = '';

	        if (strpos($url, 'facebook.com/') !== false) {
	            // Facebook Video
	            $finalUrl.='https://www.facebook.com/plugins/video.php?href='.rawurlencode($url).'&show_text=1&width=200';

	        } else if(strpos($url, 'vimeo.com/') !== false) {
	            // Vimeo video
	            $videoId = isset(explode("vimeo.com/",$url)[1]) ? explode("vimeo.com/",$url)[1] : null;
	            if (strpos($videoId, '&') !== false){
	                $videoId = explode("&",$videoId)[0];
	            }
	            $finalUrl.='https://player.vimeo.com/video/'.$videoId;

	        } else if (strpos($url, 'youtube.com/') !== false) {
	            // Youtube video
	            $videoId = isset(explode("v=",$url)[1]) ? explode("v=",$url)[1] : null;
	            if (strpos($videoId, '&') !== false){
	                $videoId = explode("&",$videoId)[0];
	            }
	            $finalUrl.='https://www.youtube.com/embed/'.$videoId;

	        } else if(strpos($url, 'youtu.be/') !== false) {
	            // Youtube  video
	            $videoId = isset(explode("youtu.be/",$url)[1]) ? explode("youtu.be/",$url)[1] : null;
	            if (strpos($videoId, '&') !== false) {
	                $videoId = explode("&",$videoId)[0];
	            }
	            $finalUrl.='https://www.youtube.com/embed/'.$videoId;

	        } else if (strpos($url, 'dailymotion.com/') !== false) {
	            // Dailymotion Video
	            $videoId = isset(explode("dailymotion.com/",$url)[1]) ? explode("dailymotion.com/",$url)[1] : null;
	            if (strpos($videoId, '&') !== false) {
	                $videoId = explode("&",$videoId)[0];
	            }
	            $finalUrl.='https://www.dailymotion.com/embed/'.$videoId;

	        } else{
	            $finalUrl.=$url;
	        }

	        return $finalUrl;
	    }
	    
	    public function isMobileDetect(){
	        if(!empty($_SERVER['HTTP_USER_AGENT'])){
	           $user_ag = $_SERVER['HTTP_USER_AGENT'];
	           if(preg_match('/(Mobile|Android|Tablet|GoBrowser|[0-9]x[0-9]*|uZardWeb\/|Mini|Doris\/|Skyfire\/|iPhone|Fennec\/|Maemo|Iris\/|CLDC\-|Mobi\/)/uis',$user_ag)){
	              return true;
	           };
	        };
	        return false;
	    }

	    public  function convert_utf8($str) {
		    $new2old = array(
		      'á' => 'Ã¡',
		      'À' => 'Ã€',
		      'ä' => 'Ã¤',
		      'Ä' => 'Ã„',
		      'ã' => 'Ã£',
		      'å' => 'Ã¥',
		      'Å' => 'Ã…',
		      'æ' => 'Ã¦',
		      'Æ' => 'Ã†',
		      'ç' => 'Ã§',
		      'Ç' => 'Ã‡',
		      'é' => 'Ã©',
		      'É' => 'Ã‰',
		      'è' => 'Ã¨',
		      'È' => 'Ãˆ',
		      'ê' => 'Ãª',
		      'Ê' => 'ÃŠ',
		      'ë' => 'Ã«',
		      'Ë' => 'Ã‹',
		      //'í' => 'Ã-',
		      //'Í' => 'Ã',
		      'ì' => 'Ã¬',
		      'Ì' => 'ÃŒ',
		      'î' => 'Ã®',
		      'Î' => 'ÃŽ',
		      'ï' => 'Ã¯',
		      //'à' => 'Ã ',
		      'ñ' => 'Ã±',
		      'Ñ' => 'Ã‘',
		      'ó' => 'Ã³',
		      'Ó' => 'Ã“',
		      'ò' => 'Ã²',
		      'Ò' => 'Ã’',
		      'ô' => 'Ã´',
		      'Ô' => 'Ã”',
		      'ö' => 'Ã¶',
		      'Ö' => 'Ã–',
		      'õ' => 'Ãµ',
		      'Õ' => 'Ã•',
		      'ø' => 'Ã¸',
		      'Ø' => 'Ã˜',
		      'œ' => 'Å“',
		      'Œ' => 'Å’',
		      'ß' => 'ÃŸ',
		      'ú' => 'Ãº',
		      'Ú' => 'Ãš',
		      'ù' => 'Ã¹',
		      'Ù' => 'Ã™',
		      'û' => 'Ã»',
		      'Û' => 'Ã›',
		      'ü' => 'Ã¼',
		      'Ü' => 'Ãœ',
		      '€' => 'â‚¬',
		      '’' => 'â€™',
		      '‚' => 'â€š',
		      'ƒ' => 'Æ’',
		      '„' => 'â€ž',
		      '…' => 'â€¦',
		      '‡' => 'â€¡',
		      'ˆ' => 'Ë†',
		      '‰' => 'â€°',
		      'Š' => 'Å ',
		      '‹' => 'â€¹',
		      'Ž' => 'Å½',
		      '‘' => 'â€˜',
		      '“' => 'â€œ',
		      '•' => 'â€¢',
		      '–' => 'â€“',
		      '—' => 'â€”',
		      '˜' => 'Ëœ',
		      '™' => 'â„¢',
		      'š' => 'Å¡',
		      '›' => 'â€º',
		      'ž' => 'Å¾',
		      'Ÿ' => 'Å¸',
		      '¡' => 'Â¡',
		      '¢' => 'Â¢',
		      '£' => 'Â£',
		      '¤' => 'Â¤',
		      '¥' => 'Â¥',
		      '¦' => 'Â¦',
		      '§' => 'Â§',
		      '¨' => 'Â¨',
		      '©' => 'Â©',
		      'ª' => 'Âª',
		      '«' => 'Â«',
		      '¬' => 'Â¬',
		      '®' => 'Â®',
		      '¯' => 'Â¯',
		      '°' => 'Â°',
		      '±' => 'Â±',
		      '²' => 'Â²',
		      '³' => 'Â³',
		      '´' => 'Â´',
		      'µ' => 'Âµ',
		      '¶' => 'Â¶',
		      '·' => 'Â·',
		      '¸' => 'Â¸',
		      '¹' => 'Â¹',
		      'º' => 'Âº',
		      '»' => 'Â»',
		      '¼' => 'Â¼',
		      '½' => 'Â½',
		      '¾' => 'Â¾',
		      '¿' => 'Â¿',
		      'à' => 'Ã',
		      '†' => 'â€ ',
		      '”' => 'â€',
		      //'Á' => 'Ã',
		      'â' => 'Ã¢',
		      'Â' => 'Ã‚',
		      'Ã' => 'Ãƒ',
		      'â' => 'Ã¢',
		      'ô' => 'Í´',
		      'î' => 'Í®',
		      'ù' => 'à¹',
		      'oe' => 'Å"',
		          '”' => 'â€',
          		"'" => '&#39;',
		    );
		    $new = array();
		    $old = array();
		    foreach( $new2old as $key => $value ) {
		      $new[] = $key;
		      $old[] = $value;
		    }
		    return str_replace( $old, $new, $str );
  		}


  		public function sendMailElearning($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto){
  			$return = false;
  			
			require APPPATH . '/libraries/PHPMailer/src/PHPMailer.php';
			require APPPATH . '/libraries/PHPMailer/src/SMTP.php';
			require APPPATH . '/libraries/PHPMailer/src/Exception.php';
			require APPPATH . '/libraries/PHPMailer/vendor/autoload.php';

			$mail = new PHPMailer(true);
			try {
			    //Server settings
			    $mail->CharSet = 'UTF-8';
			    $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
			    $mail->isSMTP();                                            //Send using SMTP
			    $mail->Host       = $this->config->item("smtp_host_f2plus");                     //Set the SMTP server to send through
			    $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
			    $mail->Username   = $this->config->item("smtp_username_f2plus");                     //SMTP username
			    $mail->Password   = $this->config->item("smtp_password_f2plus");                               //SMTP password
			    $mail->SMTPSecure = $this->config->item("smtp_secure_f2plus");            //Enable implicit TLS encryption
			    $mail->Port       = $this->config->item("smtp_port_f2plus"); //TCP port to connect to; use 587 if you have set 
			    $mail->isSendmail();   

			    //Recipients
			    $sender['email'] != '' ? $mail->setFrom($sender['email'], $sender['name'], true) : '';
			    $destination['email'] != '' ? $mail->addAddress($destination['email'], $destination['email']) : '';     //Add a recipient
			    $replyto['email'] != '' ? $mail->addReplyTo($replyto['email'], $replyto['email']) : '';
			    //$mail->addCC('alexjob.travail@gmail.com');
			   	//$mail->addBCC('bcc@example.com');

			    //Attachments
			    //$mail->addAttachment($filePath);         //Add attachments
			    //Content
			    $mail->isHTML(true);                                  //Set email format to HTML
			    $mail->Subject = $subject;
			    $mail->Body    = $mailbody;
			    $mail->AltBody = $mailAltBody;

			    $mail->send();
			    $return = true;
			} catch (Exception $e) {
			    //echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
			    $return = false;
			}

			return $return;
  		}

  		function getEmbedUrlFromVideo($url) {
		    // function for generating an embed link
		    $finalUrl = '';

		    if (strpos($url, 'facebook.com/') !== false) {
		        // Facebook Video
		        $finalUrl.='https://www.facebook.com/plugins/video.php?href='.rawurlencode($url).'&show_text=1&width=200';

		    } else if(strpos($url, 'vimeo.com/') !== false) {
		        // Vimeo video
		        $videoId = isset(explode("vimeo.com/",$url)[1]) ? explode("vimeo.com/",$url)[1] : null;
		        if (strpos($videoId, '&') !== false){

		        }
		        $finalUrl.='https://player.vimeo.com/video/'.$videoId;

		    } else if (strpos($url, 'youtube.com/') !== false) {
		        // Youtube video
		        $videoId = isset(explode("v=",$url)[1]) ? explode("v=",$url)[1] : null;
		        if (strpos($videoId, '&') !== false){
		            $videoId = explode("&",$videoId)[0];
		        }
		        $finalUrl.='https://www.youtube.com/embed/'.$videoId;

		    } else if(strpos($url, 'youtu.be/') !== false) {
		        // Youtube  video
		        $videoId = isset(explode("youtu.be/",$url)[1]) ? explode("youtu.be/",$url)[1] : null;
		        if (strpos($videoId, '&') !== false) {
		            $videoId = explode("&",$videoId)[0];
		        }
		        $finalUrl.='https://www.youtube.com/embed/'.$videoId;

		    } else if (strpos($url, 'dailymotion.com/') !== false) {
		        // Dailymotion Video
		        $videoId = isset(explode("dailymotion.com/",$url)[1]) ? explode("dailymotion.com/",$url)[1] : null;
		        if (strpos($videoId, '&') !== false) {
		            $videoId = explode("&",$videoId)[0];
		        }
		        $finalUrl.='https://www.dailymotion.com/embed/'.$videoId;

		    } else{
		        $finalUrl.=$url;
		    }

		    return $finalUrl;
		}    

	    public function getGlossaireDigitalByPrototype($idPrototype){
	    	$response = array();
	        $curl = curl_init();
	        curl_setopt_array($curl, array(
	          CURLOPT_URL => ''.$this->config->item('bddl_api_glossaire_digital').'get-lexiques?id='.$idPrototype.'',
	          CURLOPT_RETURNTRANSFER => true,
	          CURLOPT_ENCODING => '',
	          CURLOPT_MAXREDIRS => 10,
	          CURLOPT_TIMEOUT => 0,
			  CURLOPT_SSL_VERIFYPEER => false,
	          CURLOPT_FOLLOWLOCATION => true,
	          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	          CURLOPT_CUSTOMREQUEST => 'GET',
	        ));
	        $response['result']      = curl_exec($curl);
	        curl_close($curl);
	        return json_encode($response);
	    }


	    public function postDataPrototypeToBddl($arrayData){
	    	$response = array();
			$ch = curl_init(''.$this->config->item('bddl_api_glossaire_digital').'post-data-prototype'.''); 
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($arrayData));
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
			$response['result'] = curl_exec($ch);
			curl_close($ch);
			return json_encode($response);
	    }

	    public function convertMonthToList($monthKey){
	    	$list = '';
	    	switch ($monthKey) {
	    		case 1:
	    			$list .= $this->lang->line('january');
	    			break;
	    		case 2:
	    			$list .= $this->lang->line('febroary');
	    			break;
	    		case 3:
	    			$list .= $this->lang->line('mars');
	    			break;
	    		case 4:
	    			$list .= $this->lang->line('april');
	    			break;
	    		case 5:
	    			$list .= $this->lang->line('may');
	    			break;
	    		case 6:
	    			$list .= $this->lang->line('june');
	    			break;
	    		case 7:
	    			$list .= $this->lang->line('jully');
	    			break;
	    		case 8:
	    			$list .= $this->lang->line('august');
	    			break;
	    		case 9:
	    			$list .= $this->lang->line('september');
	    			break;
	    		case 10:
	    			$list .= $this->lang->line('october');
	    			break;
	    		case 11:
	    			$list .= $this->lang->line('november');
	    			break;
	    		case 12:
	    			$list .= $this->lang->line('december');
	    			break;
	    		
	    		default:
	    			// code...
	    			break;
	    	}

	    	return $list;
	    }

	   	public function getAllInfosByTracking($idModule,$idSequence,$idChapitre,$trackingType){
			$resultArray = array();
			$Parcours       = '';
			$Menu           = '';
			$SousMenu       = '';
			$Module         = '';
			$Sequence       = '';
			$Exercice       = '';
			$Lien           = '';
			switch ($trackingType) {
				case 2:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'My training period';
					$SousMenu       = 'Course history';
					if (!is_null($idSequence)) {
					  $Sequence       = $this->coursHistorik_model->Request('intitule',$idSequence);
					}
					if (!is_null($idChapitre)) {
					  $Exercice       = $this->todolist_model->Request('sequence',$idChapitre);
					  $Lien           = $this->todolist_model->Request('url',$idChapitre);
					}
					break;
				case 4:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'My educational library';
					$SousMenu       = 'My links & documents';
					if (!is_null($idSequence)) {
					  $Sequence       = $this->document_repository_model->Request('name',$this->document_model->Request('id_repertory',$idSequence));
					  $Exercice       = $this->document_model->Request('titre',$idSequence);
					  $Lien           = $this->document_model->Request('fichier',$idSequence);
					}
					break;
				case 6:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'My educational library';
					$SousMenu       = 'Newsletter';
					if (!is_null($idChapitre)) {    
					  $Module         = $this->newsletter_model->Request('theme',$idChapitre); 
					  $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$idChapitre));
					  $Exercice       = $this->newsletter_model->Request('article',$idChapitre);
					  $Lien           = $this->newsletter_model->Request('origine',$idChapitre);
					}
					if ($idChapitre == 0 && !is_null($idSequence) && $idSequence != 10086) { 
					switch ($idSequence) {
					    case 1:
					      $Module       = 'Politics';
					      break;
					    case 2:
					      $Module       = 'Health';
					      break;
					    case 3:
					      $Module       = 'Art';
					      break;
					    case 4:
					      $Module       = 'Travel';
					      break;
					    case 5:
					      $Module       = 'Lifestyle';
					      break;
					    case 6:
					      $Module       = 'Livestock';
					      break;
					    case 7:
					      $Module       = 'Culture';
					      break;
					    case 8:
					      $Module       = 'Society';
					      break;
					    case 9:
					      $Module       = 'Sport';
					      break;                        
					    case 9:
					      $Module       = 'Economy';
					      break;
					    default:
					      # code...
					      break;
					  }
					}
					break;
				case 7:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'My educational library';                    
					$SousMenu       = 'Pedagogical training';                    
					if (!is_null($idModule)) {
					  $Module         = $this->modules_model->Request('module_titre',$idModule); 
					} 

					if (is_null($idModule) && !is_null($idSequence)) {
					  $Module         = 'Complementary Activities';
					}

					if (!is_null($idSequence) && $idSequence != 0) {
					  $Sequence       = $this->sequence_model->Request('sequence_titre',$idSequence);
					}   

					if (!is_null($idChapitre) && $idChapitre != 0) {    
					  $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$idSequence,$idChapitre);
					  $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$idSequence,$idChapitre);
					}
					break; 
				case 8:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'My educational library';                    
					$SousMenu       = 'Personal Interest';                    
					if (!is_null($idModule)) {
					  $Module         = $this->modules_model->Request('module_titre',$idModule); 
					} 

					if (is_null($idModule) && !is_null($idSequence)) {
					  $Module         = 'Complementary Activities';
					}

					if (!is_null($idSequence) && $idSequence != 0) {
					  $Sequence       = $this->sequence_model->Request('sequence_titre',$idSequence);
					}   

					if (!is_null($idChapitre) && $idChapitre != 0) {     
					  $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$idSequence,$idChapitre);
					  $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$idSequence,$idChapitre);
					}
					break; 
				case 9:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'My educational library';                    
					$SousMenu       = 'Linguistic Tools';                    
					if (!is_null($idModule)) {
					  $Module         = $this->modules_model->Request('module_titre',$idModule); 
					} 

					if (is_null($idModule) && !is_null($idSequence)) {
					  $Module         = 'Complementary Activities';
					}

					if (!is_null($idSequence) && $idSequence != 0) {
					  $Sequence       = $this->sequence_model->Request('sequence_titre',$idSequence);
					}   

					if (!is_null($idChapitre) && $idChapitre != 0) {     
					  $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$idSequence,$idChapitre);
					  $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$idSequence,$idChapitre);
					}
					break; 
				case 10:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'Profil data';                    
					$SousMenu       = 'Statistic connexion'; 
					break;
				case 14:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'Training period'; 
					$SousMenu       = 'Training objectif'; 
					break; 
				case 16:
					$Parcours       = 'Outils et document de mon stage';
					$Menu           = 'My document to sign'; 
					break;  
				case 18:
					//$Parcours       = 'Dashbord';  
					$Parcours       = '';  
					break;       
				case 20:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'Premium menu'; 
					$SousMenu       = 'My own expression databank'; 
					break;     
				case 22:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'Premium menu'; 
					$SousMenu       = 'My glossary';
					break;       
				case 23:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'Premium menu'; 
					$SousMenu       = 'My audio';
					break;         
				case 24:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'My training period';
					$SousMenu       = 'Personnal training area';  
					if ($this->stat_prg_model->Request('type',$idSequence) == 'document') {
					  $Module         = $this->classificationFavoris_Model->Request('intitule',$idModule);
					  $Exercice       = $this->document_model->Request('titre',$idChapitre);
					  $Lien           = $this->document_model->Request('fichier',$idChapitre);
					}  
					elseif ($this->stat_prg_model->Request('type',$idSequence) == 'activity_sequence') {
					  $Module         = $this->modules_model->Request('module_titre',$idModule); 
					  $Sequence       = $this->sequence_model->Request('sequence_titre',$this->stat_prg_model->Request('id_prg',$idSequence));
					  $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$this->stat_prg_model->Request('id_prg',$idSequence),$idChapitre);
					  $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$this->stat_prg_model->Request('id_prg',$idSequence),$idChapitre);
					} 
					elseif ($this->stat_prg_model->Request('type',$idSequence) == 'nl_article') {
					  $Module         = $this->newsletter_model->Request('theme',$idChapitre); 
					  $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$idChapitre));
					  $Exercice       = $this->newsletter_model->Request('article',$idChapitre);
					  $Lien           = $this->newsletter_model->Request('origine',$idChapitre);
					} 
					elseif ($this->stat_prg_model->Request('type',$idSequence) == 'nl_categories') {
					  $Module       = $this->stat_prg_model->Request('intitule',$idSequence);
					  if (!is_null($idChapitre) && $idChapitre != 0) {
					    $Sequence       = $this->newsletter_model->RequestMonth('monthNewsletter',$this->newsletter_model->Request('nl_monthnewsletter_id',$idChapitre));
					    $Exercice       = $this->newsletter_model->Request('article',$idChapitre);
					    $Lien           = $this->newsletter_model->Request('origine',$idChapitre);
					  }
					}
					elseif ($this->stat_prg_model->Request('type',$idSequence) == 'sequence_activite') {
					  $Module         = $this->modules_model->Request('module_titre',$idModule); 
					  $Sequence       = $this->sequence_model->Request('sequence_titre',$this->stat_prg_model->Request('id_prg',$idSequence));
					  if (!is_null($idChapitre) && $idChapitre != 0) {
					    $Exercice       = $this->sequence_model->RequestSeqByIdAndNumero('titre',$this->stat_prg_model->Request('id_prg',$idSequence),$idChapitre);
					    $Lien           = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$this->stat_prg_model->Request('id_prg',$idSequence),$idChapitre);
					  }
					}  
					else {
					  $Module         = $this->classificationFavoris_Model->Request('intitule',$idModule);
					  $Exercice       = $this->document_model->Request('titre',$idChapitre);
					  $Lien           = $this->document_model->Request('fichier',$idChapitre);
					} 
					break;      
				case 25:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'My educational tools';
					$SousMenu       = 'My connexion speed';  
					break;           
				case 26:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'My educational tools';
					$SousMenu       = 'White paper';              
				case 30:
					$Parcours       = 'Accès plateforme e-learning et tutorat';
					$Menu           = 'My educational tools';
					$SousMenu       = 'Conference call';   
					break;                
				case 33:
					$Parcours       = 'Educationnal library';
					$Menu           = 'Teacher link & documents';  
					break;                
				default:
					# code...
					break;
			}

			$resultArray = array(
				'Parcours'       =>  $Parcours,
				'Menu'           =>  $Menu,
				'SousMenu'       =>  $SousMenu,
				'Module'         =>  $Module,
				'Sequence'       =>  $Sequence,
				'Exercice'       =>  $Exercice,
				'Lien'           =>  $Lien
			);
			return $resultArray;
		}


	   	/*public function getModuleContentLoadPage($idGroup,$module_id,$module_name,$page){
		    $retour = array();
		    $html = '';
		    $seq = 0;
		    $seqC = 0;
		    $container = 0;
		    $imgthumbnail = '';
		    $class = '';
		    $activeMenu = '';
		    $activeContent = '';
		    $lienCol= 1;
		    $nbrSeq= 1;
		    $footerclass = '';
		    if ($this->isTuteurConnet()) {
		        $footerclass = 'card-footer-trainner';
		    }

		    $moduleContent = isset($module_id) ? $this->sequence_model->getPavetSequenceHauts($module_name,$idGroup,$module_id,$page) : NULL;
		    
		    $html .= '<div class="tab-wrap">';
		        $html .= '<div class="tab-nav-container mb-2">';
		            $html .= '<div class="tab-nav" id="tab-sequence-library">';
		                foreach($moduleContent['module'] as $key4=>$value4){
		                    if(is_array($value4)){ $sequenceName = ''; foreach($value4 as $key5=>$value5){if($value5['sequence_name'] != "") { $sequenceName = ($this->session->userdata ('site_lang') == 'english' && $value5['sequence_name'] == "Articles REBONDIR") ? "Anastasia Autret's Tips" : $value5['sequence_name']; $sequenceUrl = $value5['sequence_url']; $idsequence = $value5['sequence_id']; $locsequence  = $value5['locs']; if($seq == 0) { $activeMenu .= 'active'; }
		                            $html .= '<div class="tab-nav-item navigation-course-history '.$activeMenu.'" data-id="content-sequence'.$idsequence.'" data-id-sequence="'.$this->convert_utf8($idsequence).'" data-id-module="'.$this->convert_utf8($module_id).'" data-id-pave="'.$page.'" 
		                                data-name="'.$this->convert_utf8($sequenceName).'">
		                                    <div class="tab-nav-item-head">
		                                        <span>'.$sequenceName.'</span>
		                                    </div>
		                                    <div class="course-color"></div>
		                                    <div class="tab-nav-item-footer">
		                                        <button data-title="'.$this->convert_utf8($sequenceName).'" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" class="add-favorite" onclick="addSequenceInFavorite(this);"><i class="fa-solid fa-heart"></i></button>
		                                        <button data-title="'.$this->convert_utf8($sequenceName).'" class="add-comment" onclick="addCommentSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="fa-solid fa-comment"></i></button>';
		                                        if ($this->isTuteurConnet() && $page == 7) {
			                                        if ($this->session->userdata ('GUSERID') == $value5['user_create']) {
			                                        	$html .= '<button data-title="'.$this->convert_utf8($sequenceName).'" class="btn-trash" onclick="deleteListSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="bx bxs-trash-alt"></i></button>';
			                                        	$html .= '<button data-title="'.$this->convert_utf8($sequenceName).'" class="btn-edit" onclick="editListSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="bx bxs-edit-alt"></i></button>';
			                                        }
			                                        $html .= '<button data-title="'.$this->convert_utf8($sequenceName).'" class="btn-add" onclick="addContentInListSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="bx bx-plus"></i></button>';
			                                    }
		                                    $html .= '</div>
		                                </div>';

		                            }
		                        }
		                    $seq++; }
		                }
		            $html .= '</div>';
		        $html .= '</div>';
		        $html .= '<div class="tab-content-container">';                    
		            foreach($moduleContent['module'] as $key4=>$value4){
		                if(is_array($value4)){ foreach($value4 as $key5=>$value5){ if($value5['sequence_name'] != "") {  if ( $container === 0 ) { $activeContent .= 'active'; 
		                    $chapitre = $this->chapitres_model->readTraineeSequences($value5['sequence_id'],$this->session->userdata ('GUSERID'),$idGroup);
		                    $html .= '<div id="content-sequence'.$value5['sequence_id'].'"  class="tab-content '.$activeContent.'">';
		                        
		                        $html.= '<div class="tab-title title-active-menu-pg"><h2 class="content_title">'.$this->lang->line('other_init_activity_empty').' '.$this->sequence_model->Request('sequence_titre',$value5['sequence_id']).')</h2></div>';
		                        $html .= '<div class="card-container">';
		                            if (isset($chapitre['cnt'])) {
		                                // colonne lien
		                                $lienCol= $lienCol + 1;
		                                for($i=0;$i<$chapitre['cnt'];$i++) {                                    
		                                    $user_create    = $chapitre[$i]['user_create']     ;
		                                    $type           = $chapitre[$i]['type']     ;
		                                    $titre          = $chapitre[$i]['titre']    ;
		                                    $numero         = $chapitre[$i]['numero']   ;
		                                    $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
		                                    $linkUrl        = $chapitre[$i]['lienUrl']  ;
		                                    $id_sequence    = $chapitre[$i]['id_sequence']  ;
		                                    $detect_link    = $chapitre[$i]['ifrmaccess']  ;
		                                    $status_url     = $chapitre[$i]['status_url']  ;

		                                    if ($type == 4 && $user_create != null) {
		                                    	$final_url      = HTTP_FORMATION.'activitySequence/'.$chapitre[$i]['lienUrl']  ;
		                                    }
		                                    else{
		                                    	$final_url      = $chapitre[$i]['final_url'] == NULL ? $chapitre[$i]['lienUrl'] : $chapitre[$i]['final_url']  ;
		                                    }
		                                    
		                                    $link_support = $linkUrl;
		                                    $redir        = 'redir.php?url';
		                                    $support      = '';
		                                    $urlF         = "";
		                                    if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
		                                        $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
		                                        $html .= "";                
		                                    }
		                                    else{
		                                        $fileimg = base_url()."groupes/bg-laptop.png";
		                                        //$html .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
		                                    }

		                                    if ($titre != 'Support') {
	                                            if ($this->validate_url($link_support)){
	                                                $suffixe = '';
	                                                if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
	                                                    $suffixe  = 'https://';
	                                                }
	                                                elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
	                                                    $suffixe  = 'http://';
	                                                }
	                                                else{
	                                                    $suffixe  = '';
	                                                }
	                                                $urlF  .= $suffixe.$link_support;
	                                                $html .='
	                                                    <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
	                                                        <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
	                                                            <div class="card-img">
	                                                                <a href="#"><img src="'.$fileimg.'" alt=""></a>
	                                                            </div>
	                                                            <div class="card-title">
	                                                                <h4>'.$titre.'</h4>
	                                                            </div>';
	                                                            
	                                                            if ($this->isTuteurConnet() && $page == 7) {
																	if ($user_create == $this->session->userdata ('GUSERID')) {
																		$html .='
																		<div class="card-footer '.$footerclass.'">
																			<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
																			<a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
																	            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
																	        </a>
																	    </div>
																	    <div class="card-footer '.$footerclass.'">
																	        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
																	            <i class="fa-solid fa-comment"></i>
																	        </a>
																	        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																	            <i class="fa-solid fa-heart"></i>
																	        </a>
																	        <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																	            	<i class="fa-solid fa-edit"></i>
																	    	</a>
																	    	<a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																	        	<i class="fa-solid fa-trash"></i>
																	    	</a>
																	    </div>';
																	}
																	else{
																		$html .='
																		<div class="card-footer '.$footerclass.' opacity"></div>
																		<div class="card-footer '.$footerclass.'">
																			<a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
																	            <i class="fa-solid fa-comment"></i>
																	        </a>
																	        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																	            <i class="fa-solid fa-heart"></i>
																	        </a>
																	        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
																			<a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
																	            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
																	        </a>
																	    </div>';
																	}		
																}
																else{
																	$html .='
																	<div class="card-footer '.$footerclass.'">
																        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
																            <i class="fa-solid fa-comment"></i>
																        </a>
																        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																            <i class="fa-solid fa-heart"></i>
																        </a>';	

																        if($this->isTuteurConnet()){
																        	$html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
																        }                                                                 
																        $html .= '
																        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
																            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
																        </a>
																    </div>';
																}
	                                                        $html .='</div>
	                                                    </div>';               
	                                            }
	                                            else{
	                                                if (strpos($link_support, $redir) === false) { 
	                                                    if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
	                                                        $urlFormation = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
	                                                        
	                                                        $html .='
	                                                        <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
	                                                        <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
	                                                            <div class="card-img">
	                                                                <a href="#"><img src="'.$fileimg.'" alt=""></a>
	                                                            </div>
	                                                            <div class="card-title">
	                                                                <h4>'.$titre.'</h4>
	                                                            </div>';
	                                                            
	                                                            if ($this->isTuteurConnet() && $page == 7) {
																	if ($user_create == $this->session->userdata ('GUSERID')) {
																		$html .='
																		<div class="card-footer '.$footerclass.'">
																			<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
																			<a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
																	            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
																	        </a>
																	    </div>
																	    <div class="card-footer '.$footerclass.'">
																	        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
																	            <i class="fa-solid fa-comment"></i>
																	        </a>
																	        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																	            <i class="fa-solid fa-heart"></i>
																	        </a>
																	        <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																	            	<i class="fa-solid fa-edit"></i>
																	    	</a>
																	    	<a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																	        	<i class="fa-solid fa-trash"></i>
																	    	</a>
																	    </div>';
																	}
																	else{
																		$html .='
																		<div class="card-footer '.$footerclass.' opacity"></div>
																		<div class="card-footer '.$footerclass.'">
																			<a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
																	            <i class="fa-solid fa-comment"></i>
																	        </a>
																	        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																	            <i class="fa-solid fa-heart"></i>
																	        </a>
																	        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
																			<a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
																	            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
																	        </a>
																	    </div>';
																	}		
																}
																else{
																	$html .='
																	<div class="card-footer '.$footerclass.'">
																        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
																            <i class="fa-solid fa-comment"></i>
																        </a>
																        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																            <i class="fa-solid fa-heart"></i>
																        </a>';	

																        if($this->isTuteurConnet()){
																        	$html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
																        }                                                                 
																        $html .= '
																        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
																            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
																        </a>
																    </div>';
																}
	                                                        $html .='</div>
	                                                    </div>';    


	                                                    }
	                                                    else{
	                                                        $suffixe = '';
	                                                        if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
	                                                            $suffixe  = 'https://';
	                                                        }
	                                                        elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
	                                                            $suffixe  = 'http://';
	                                                        }
	                                                        else{
	                                                            $suffixe  = '';
	                                                        }
	                                                        $urlF  .= $suffixe.$link_support;
	                                                        $html .='
	                                                        <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
	                                                            <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
	                                                                <div class="card-img">
	                                                                    <a href="#"><img src="'.$fileimg.'" alt=""></a>
	                                                                </div>
	                                                                <div class="card-title">
	                                                                    <h4>'.$titre.'</h4>
	                                                                </div>';
	                                                                if ($this->isTuteurConnet() && $page == 7) {
																		if ($user_create == $this->session->userdata ('GUSERID')) {
																			$html .='
																			<div class="card-footer '.$footerclass.'">
																				<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
																				<a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
																		            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
																		        </a>
																		    </div>
																		    <div class="card-footer '.$footerclass.'">
																		        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
																		            <i class="fa-solid fa-comment"></i>
																		        </a>
																		        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																		            <i class="fa-solid fa-heart"></i>
																		        </a>
																		        <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																		            	<i class="fa-solid fa-edit"></i>
																		    	</a>
																		    	<a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																		        	<i class="fa-solid fa-trash"></i>
																		    	</a>
																		    </div>';
																		}
																		else{
																			$html .='
																			<div class="card-footer '.$footerclass.' opacity"></div>
																			<div class="card-footer '.$footerclass.'">
																				<a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
																		            <i class="fa-solid fa-comment"></i>
																		        </a>
																		        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																		            <i class="fa-solid fa-heart"></i>
																		        </a>
																		        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
																				<a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
																		            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
																		        </a>
																		    </div>';
																		}		
																	}
																	else{
																		$html .='
																		<div class="card-footer '.$footerclass.'">
																	        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
																	            <i class="fa-solid fa-comment"></i>
																	        </a>
																	        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																	            <i class="fa-solid fa-heart"></i>
																	        </a>';	

																	        if($this->isTuteurConnet()){
																	        	$html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
																	        }                                                                 
																	        $html .= '
																	        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
																	            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
																	        </a>
																	    </div>';
																	}
	                                                            $html .='</div>
	                                                        </div>
	                                                        ';  
	                                                    }
	                                                }                 
	                                                else { 
	                                                    $urlF1         = str_replace("/redir.php?url=", "", $link_support); 
	                                                    $suffixe = '';
	                                                    if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
	                                                        $suffixe  = 'https://';
	                                                    }
	                                                    elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
	                                                        $suffixe  = 'http://';
	                                                    }
	                                                    else{
	                                                        $suffixe  = '';
	                                                    }

	                                                    $urlF  .= $suffixe.$urlF1; 
	                                                    $html .='
	                                                        <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
	                                                            <div class="card" value="'.$nbrSeq.'" >
	                                                                <div class="card-img">
	                                                                    <a href="#"><img src="'.$fileimg.'" alt=""></a>
	                                                                </div>
	                                                                <div class="card-title">
	                                                                    <h4>'.$titre.'</h4>
	                                                                </div>';
	                                                                if ($this->isTuteurConnet() && $page == 7) {
																		if ($user_create == $this->session->userdata ('GUSERID')) {
																			$html .='
																			<div class="card-footer '.$footerclass.'">
																				<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
																				<a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
																		            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
																		        </a>
																		    </div>
																		    <div class="card-footer '.$footerclass.'">
																		        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
																		            <i class="fa-solid fa-comment"></i>
																		        </a>
																		        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																		            <i class="fa-solid fa-heart"></i>
																		        </a>
																		        <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																		            	<i class="fa-solid fa-edit"></i>
																		    	</a>
																		    	<a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																		        	<i class="fa-solid fa-trash"></i>
																		    	</a>
																		    </div>';
																		}
																		else{
																			$html .='
																			<div class="card-footer '.$footerclass.' opacity"></div>
																			<div class="card-footer '.$footerclass.'">
																				<a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
																		            <i class="fa-solid fa-comment"></i>
																		        </a>
																		        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																		            <i class="fa-solid fa-heart"></i>
																		        </a>
																		        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
																				<a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
																		            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
																		        </a>
																		    </div>';
																		}		
																	}
																	else{
																		$html .='<div class="card-footer '.$footerclass.'">
																	        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
																	            <i class="fa-solid fa-comment"></i>
																	        </a>
																	        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
																	            <i class="fa-solid fa-heart"></i>
																	        </a>';	

																	        if($this->isTuteurConnet()){
																	        	$html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
																	        }                                                                 
																	        $html .= '
																	        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
																	            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
																	        </a>
																	    </div>';
																	}
	                                                            $html .='</div>
	                                                        </div>
	                                                    ';               
	                                                } 
	                                            }
		                                        
		                                    }
		                                    $nbrSeq= $nbrSeq + 1;
		                                        
		                                }                        
		                            }
		                            
		                            if (isset($chapitre['cnt']) && $chapitre['cnt'] < 1){
		                                $html .= '
		                                    <div class="row empty-data-row">
		                                        <div class="col-md-12 text-center">
		                                            <h4 class="nothing-data text-center">'.$this->lang->line('my_link_and_document_datatable_empty_data').'</h4>
		                                        </div>
		                                    </div>';
		                            }
		                        $html .= '</div>';
		                    $html .= '</div>';
		                } } $container++; }  }
		            }
		        $html .= '</div>';
		    $html .= '</div>';

		    return ($html);
		}*/
		public function getModuleContentLoadPage($idGroup,$module_id,$module_name,$page){
		    $retour = array();
		    $html = '';
		    $seq = 0;
		    $seqC = 0;
		    $container = 0;
		    $imgthumbnail = '';
		    $class = '';
		    $activeMenu = '';
		    $activeContent = '';
		    $lienCol= 1;
		    $nbrSeq= 1;
		    $footerclass = '';
		    if ($this->isTuteurConnet()) {
		        $footerclass = 'card-footer-trainner';
		    }

		    $moduleContent = isset($module_id) ? $this->sequence_model->getPavetSequenceHauts($module_name,$idGroup,$module_id,$page) : NULL;
		    
		    $html .= '<div class="tab-wrap">';
		        $html .= '<div class="tab-nav-container mb-2">';
		            $html .= '<div class="tab-nav" id="tab-sequence-library">';
		                foreach($moduleContent['module'] as $key4=>$value4){
		                    if(is_array($value4)){ $sequenceName = ''; foreach($value4 as $key5=>$value5){if($value5['sequence_name'] != "") { $sequenceName = ($this->session->userdata ('site_lang') == 'english' && $value5['sequence_name'] == "Articles REBONDIR") ? "Anastasia Autret's Tips" : $value5['sequence_name']; $sequenceUrl = $value5['sequence_url']; $idsequence = $value5['sequence_id']; $locsequence  = $value5['locs']; if($seq == 0) { $activeMenu .= 'active'; }
		                            $html .= '<div class="tab-nav-item navigation-course-history '.$activeMenu.'" data-id="content-sequence'.$idsequence.'" data-id-sequence="'.$this->convert_utf8($idsequence).'" data-id-module="'.$this->convert_utf8($module_id).'" data-id-pave="'.$page.'" 
		                                data-name="'.$this->convert_utf8($sequenceName).'">
		                                    <div class="tab-nav-item-head">
		                                        <span>'.$sequenceName.'</span>
		                                    </div>
		                                    <div class="course-color"></div>
		                                    <div class="tab-nav-item-footer">
		                                        <button data-title="'.$this->convert_utf8($sequenceName).'" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" class="add-favorite" onclick="addSequenceInFavorite(this);"><i class="fa-solid fa-heart"></i></button>
		                                        <button data-title="'.$this->convert_utf8($sequenceName).'" class="add-comment" onclick="addCommentSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="fa-solid fa-comment"></i></button>';
		                                        if ($this->isTuteurConnet() && $page == 7) {
			                                        if ($this->session->userdata ('GUSERID') == $value5['user_create']) {
			                                        	$html .= '<button data-title="'.$this->convert_utf8($sequenceName).'" class="btn-trash" onclick="deleteListSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="bx bxs-trash-alt"></i></button>';
			                                        	$html .= '<button data-title="'.$this->convert_utf8($sequenceName).'" data-sequence-objectif="'.$this->convert_utf8($value5['sequence_objectifs']).'" data-id-module="'.$this->convert_utf8($this->convert_utf8($module_id)).'" class="btn-edit" onclick="editListSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="bx bxs-edit-alt"></i></button>';
			                                        }
			                                        $html .= '<button data-title="'.$this->convert_utf8($sequenceName).'" class="btn-add" onclick="addContentInListSequence(this);" data-id="'.$idsequence.'" data-module="'.$this->convert_utf8($module_id).'" data-code="'.$value5['code'].'"><i class="bx bx-plus"></i></button>';
			                                    }
		                                    $html .= '</div>
		                                </div>';

		                            }
		                        }
		                    $seq++; }
		                }
		            $html .= '</div>';
		        $html .= '</div>';
		        $html .= '<div class="tab-content-container">';                    
		            foreach($moduleContent['module'] as $key4=>$value4){
		                if(is_array($value4)){ foreach($value4 as $key5=>$value5){ if($value5['sequence_name'] != "") {  if ( $container === 0 ) { $activeContent .= 'active'; 
		                    $chapitre = $this->chapitres_model->readTraineeSequences($value5['sequence_id'],$this->session->userdata ('GUSERID'),$idGroup);
		                    $html .= '<div id="content-sequence'.$value5['sequence_id'].'"  class="tab-content '.$activeContent.'">';
		                        
		                        $html.= '<div class="tab-title title-active-menu-pg"><h2 class="content_title">'.$this->lang->line('other_init_activity_empty').' '.$this->sequence_model->Request('sequence_titre',$value5['sequence_id']).')</h2></div>';
		                        $html .= '<div class="card-container">';
		                            if (isset($chapitre['cnt'])) {
		                                $lienCol= $lienCol + 1;
		                                for($i=0;$i<$chapitre['cnt'];$i++) {                                    
		                                    $user_create    = $chapitre[$i]['user_create']     ;
		                                    $type           = $chapitre[$i]['type']     ;
		                                    $titre          = $chapitre[$i]['titre']    ;
		                                    $numero         = $chapitre[$i]['numero']   ;
		                                    $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
		                                    $linkUrl        = $chapitre[$i]['lienUrl']  ;
		                                    $id_sequence    = $chapitre[$i]['id_sequence']  ;
		                                    $detect_link    = $chapitre[$i]['ifrmaccess']  ;
		                                    $status_url     = $chapitre[$i]['status_url']  ;

		                                    if ($type == 4 && $user_create != null) {
		                                    	$final_url      = HTTP_FORMATION.'activitySequence/'.$chapitre[$i]['lienUrl']  ;
		                                    }
		                                    else{
		                                    	$final_url      = $chapitre[$i]['final_url'] == NULL ? $chapitre[$i]['lienUrl'] : $chapitre[$i]['final_url']  ;
		                                    }
		                                    
		                                    $link_support = $linkUrl;
		                                    $redir        = 'redir.php?url';
		                                    $support      = '';
		                                    $urlF         = "";
		                                    if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
		                                        $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
		                                        $html .= "";                
		                                    }
		                                    else{
		                                        $fileimg = base_url()."groupes/bg-laptop.png";
		                                        //$html .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
		                                    }

		                                    if ($titre != 'Support') {
                                                if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                    $urlF  = 'https://'.$link_support; 
                                                }
                                                elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                    $urlF  = 'http://'.$link_support;
                                                }
                                                elseif (strpos($link_support, $redir) === false) {
                                                	if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                                		$urlF = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
	                                                }
	                                                else { 
	                                                    $urlF = $link_support;
	                                                }
	                                            }
	                                            else{
	                                            	$urlF1         = str_replace("/redir.php?url=", "", $link_support); 
                                                	if ((strpos($urlF1, '.doc') !== false) || (strpos($urlF1, '.docx') !== false) || (strpos($urlF1, '.ppt') !== false) || (strpos($urlF1, '.pdf') !== false)){
                                                		$urlF = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$urlF1."&amp;embedded=true";
	                                                }
	                                                else { 	                                                    
	                                                    if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
	                                                        $urlF = 'https://'.$urlF1;
	                                                    }
	                                                    elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
	                                                        $urlF = 'http://'.$urlF1;
	                                                    }
	                                                    else{
	                                                        $urlF = $urlF1;
	                                                    }
	                                                }
                                                }

                                                $html .='
                                                <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                    <div class="card" value="'.$nbrSeq.'" >
                                                        <div class="card-img">
                                                            <a href="#"  data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'"><img src="'.$fileimg.'" alt=""></a>
                                                        </div>
                                                        <div class="card-title">
                                                            <h4>'.$titre.'</h4>
                                                        </div>';
                                                        if ($this->isTuteurConnet() && $page == 7) {
															if ($user_create == $this->session->userdata ('GUSERID')) {
																$html .='
																<div class="card-footer '.$footerclass.'">
																	<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
																	<a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
															            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
															        </a>
															    </div>
															    <div class="card-footer '.$footerclass.'">
															        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
															            <i class="fa-solid fa-comment"></i>
															        </a>
															        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
															            <i class="fa-solid fa-heart"></i>
															        </a>
															        <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
															            	<i class="fa-solid fa-edit"></i>
															    	</a>
															    	<a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
															        	<i class="fa-solid fa-trash"></i>
															    	</a>
															    </div>';
															}
															else{
																$html .='
																<div class="card-footer '.$footerclass.' opacity"></div>
																<div class="card-footer '.$footerclass.'">
																	<a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
															            <i class="fa-solid fa-comment"></i>
															        </a>
															        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
															            <i class="fa-solid fa-heart"></i>
															        </a>
															        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
																	<a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
															            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
															        </a>
															    </div>';
															}		
														}
														else{
															$html .='<div class="card-footer '.$footerclass.'">
														        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
														            <i class="fa-solid fa-comment"></i>
														        </a>
														        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
														            <i class="fa-solid fa-heart"></i>
														        </a>';	

														        if($this->isTuteurConnet()){
														        	$html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
														        }                                                                 
														        $html .= '
														        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
														            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
														        </a>
														    </div>';
														}
                                                    $html .='</div>
                                                </div>';
		                                    }
		                                    $nbrSeq= $nbrSeq + 1;
		                                        
		                                }                        
		                            }
		                            
		                            if (isset($chapitre['cnt']) && $chapitre['cnt'] < 1){
		                                $html .= '
		                                    <div class="row empty-data-row">
		                                        <div class="col-md-12 text-center">
		                                            <h4 class="nothing-data text-center">'.$this->lang->line('my_link_and_document_datatable_empty_data').'</h4>
		                                        </div>
		                                    </div>';
		                            }
		                        $html .= '</div>';
		                    $html .= '</div>';
		                } } $container++; }  }
		            }
		        $html .= '</div>';
		    $html .= '</div>';

		    return ($html);
		}

		/*public function getFinalUrlFromGroupMain($urlTodo1,$type,$repGroupIn,$httpmainGroup){
	        $retour = array();
	        if ($type == 0 && !$this->existMediaUrl($urlTodo1)) {            
	            if (strpos($urlTodo1, base_url()) !== false) {
	                $retour['infoContent'] = 'local_file';
	            }
	            else{
	                $retour['infoContent'] = 'simple_link';
	            }

	            if ($this->getExtensionFileGoogleDoc($urlTodo1)) {
	                $retour['linkF'] = 'https://docs.google.com/gview?url='.$urlTodo1.'&embedded=true'; 
	            }
	            else{
	                $retour['linkF'] = $urlTodo1;
	            }
	        }
	        elseif ($type == 0 && $this->existMediaUrl($urlTodo1)) {
	            $retour['linkF'] = $this->getEmbedUrl($urlTodo1);
	            $retour['infoContent'] = 'embend_url';
	        }            
	        elseif ($type != 0 && file_exists($repGroupIn.$urlTodo1) && $this->getExtensionFile($httpmainGroup.$urlTodo1)){
	            if (strpos($httpmainGroup.$urlTodo1, base_url()) !== false) {
	                $retour['infoContent'] = 'local_file';
	            }
	            else{
	                $retour['infoContent'] = 'simple_link';
	            }

	            if ($this->getExtensionFileGoogleDoc($httpmainGroup.$urlTodo1)) {
	                $retour['linkF'] = 'https://docs.google.com/gview?url='.$httpmainGroup.$urlTodo1.'&embedded=true'; 
	            }
	            else{
	                $retour['linkF'] = $httpmainGroup.$urlTodo1;
	            }
	        }
	        elseif($type != 0 && !file_exists($repGroupIn.$urlTodo1)){
	          	$retour['linkF'] = 'No_file';
	          	$retour['infoContent'] = '';
	        }
	        else{
	            $retour['linkF'] = $httpmainGroup.$urlTodo1;
	            $retour['infoContent'] = 'inconito';
	        }
	        return $retour;
	    }*/

	    public function getFileExtension($path){
	        return pathinfo($path, PATHINFO_EXTENSION);
	    }

	    public function getFinalUrlFromGroupMain($urlTodo1,$type,$repGroupIn,$httpmainGroup){
	        $retour = array();
	        if ($type == 0) {    
	            if ($this->existMediaUrl($urlTodo1)) {
	                $retour['linkF'] = $this->getEmbedUrl($urlTodo1);
	                $retour['infoContent'] = 'embend_url';
	                $retour['fileExntesion'] = $this->getFileExtension($urlTodo1);
	            } 
	            else{       
	                if (strpos($urlTodo1, base_url()) !== false) {
	                    $retour['infoContent'] = 'local_file';
	                }
	                else{
	                    $retour['infoContent'] = 'simple_link';
	                }


	                if ($this->getExtensionFileGoogleDoc($urlTodo1)) {
	                    $retour['linkF'] = 'https://docs.google.com/gview?url='.$urlTodo1.'&embedded=true'; 
	                }
	                elseif($this->getExtensionFilePPT($urlTodo1)){
	                    $retour['linkF'] = 'https://view.officeapps.live.com/op/embed.aspx?src='.$urlTodo1; 
	                }
	                else{
	                    $retour['linkF'] = $urlTodo1;
	                }

	                $retour['fileExntesion'] = $this->getFileExtension($urlTodo1);
	            }
	        }      
	        else{
	            if (file_exists($repGroupIn.$urlTodo1)) {
	                if (strpos($httpmainGroup.$urlTodo1, base_url()) !== false) {
	                    $retour['infoContent'] = 'local_file';
	                }
	                else{
	                    $retour['infoContent'] = 'simple_link';
	                }

	                if ($this->getExtensionFileGoogleDoc($httpmainGroup.$urlTodo1)) {
	                    $retour['linkF'] = 'https://docs.google.com/gview?url='.$httpmainGroup.$urlTodo1.'&embedded=true'; 
	                }
	                elseif($this->getExtensionFilePPT($httpmainGroup.$urlTodo1)){
	                    $retour['linkF'] = 'https://view.officeapps.live.com/op/embed.aspx?src='.$httpmainGroup.$urlTodo1; 
	                }
	                else{
	                    $retour['linkF'] = $httpmainGroup.$urlTodo1;
	                }

	                $retour['fileExntesion'] = $this->getFileExtension($repGroupIn.$urlTodo1);
	            }
	            else{
	                $retour['linkF'] = 'No_file';
	                $retour['infoContent'] = '';
	                $retour['fileExntesion'] = '';
	            }
	        }   
	        $retour['type'] = $type;
	        $retour['httpmainGroup'] = $httpmainGroup.$urlTodo1;
	        return $retour;
	    }

	    public function getExtensionFileGoogleDoc($file){
	        $status = false;
	        $extensionarray = array('.doc','.docx','.gdoc','.gdocx','.odt','.rtf','.txt');
	        foreach ($extensionarray as $ext) { 
	          if (strpos($file, $ext) !== false) {
	            $status = true;
	            break;
	          }
	        }
	        return $status;
	    }

	    public function existMediaUrl($url){
	        $status = false;
	        $mediaLinks = array('vimeo.com','facebook.com','dailymotion.com','youtube','youtu.be');
	        foreach ($mediaLinks as $ext) { 
	          if (strpos($url, $ext) !== false) {
	            $status = true;
	            break;
	          }
	        }
	        return $status;
	    }
	    public function getExtensionFile($file){
	        $status = false;
	        $extensionarray = array('.doc','.doc','.pdf','.ppt','.png','.PNG','.jpg','.JPG','.jpeg','.JPEG','.wav','.WAV','.MP3','.mp3','.PDF','.xl','.xls','.xlsx');
	        foreach ($extensionarray as $ext) { 
	          if (strpos($file, $ext) !== false) {
	            $status = true;
	            break;
	          }
	        }
	        return $status;
	    }

	    public function getAudioResultByApi($idGroup,$idStagiaire){
			$curl = curl_init();
			curl_setopt_array($curl, array(
			  CURLOPT_URL => ''.$this->config->item("audio_url_api").'',
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'POST',
			  CURLOPT_POSTFIELDS => array('stagiaire_id' => "".$idStagiaire."",'groupe_id' => "".$idGroup.""),
			));

			$response = curl_exec($curl);

			curl_close($curl);

			return json_decode($response);

	    }

	    public function qcmResult($idMaxNumStage){
            $curl = curl_init();
            curl_setopt_array($curl, array(
              CURLOPT_URL => ''.$this->config->item("qcm_url_api").$idMaxNumStage.'/get-result',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'GET',
              CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Cookie: PHPSESSID=migb59mlb2ndsjmt2nnurpves0'
              ),
            ));

            $response = curl_exec($curl);
            curl_close($curl);            
            return json_decode($response);
            
        }

        public function detecturl($link){
        
	        $urlhere = $link;
	        $ch      = curl_init();

	        $options = array(
	                CURLOPT_URL            => $urlhere,
	                CURLOPT_RETURNTRANSFER => true,
	                CURLOPT_HEADER         => true,
	                CURLOPT_FOLLOWLOCATION => true,
	                CURLOPT_ENCODING       => "",
	                CURLOPT_AUTOREFERER    => true,
	                CURLOPT_CONNECTTIMEOUT => 120,
	                CURLOPT_TIMEOUT        => 120,
	                CURLOPT_MAXREDIRS      => 10,
	        );
	        curl_setopt_array($ch, $options);
	        $response = curl_exec($ch);
	        $httpCode = curl_getinfo($ch);
	        $headers=substr($response, 0, $httpCode['header_size']);
	        if(stripos($headers, 'X-Frame-Options: deny')>-1 || stripos($headers, 'X-Frame-Options: SAMEORIGIN')>-1) {
	            $error   = true;
	        }
	        else{
	            $error   = false;
	        }
	        $httpcode= curl_getinfo($ch, CURLINFO_HTTP_CODE);
	        curl_close($ch);

	        return $error;
	    } 

	    public function postDataIncidentTechnic($data){
			$curl = curl_init();
			curl_setopt_array($curl, array(
			  CURLOPT_URL => ''.$this->config->item("api_post_data_incident_technik").'',
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'POST',
			  CURLOPT_POSTFIELDS => $data,
			));

			$response = curl_exec($curl);

			curl_close($curl);

			return json_decode($response);

	    }

	    public function getExtensionFilePPT($file){
	        $status = false;
	        $extensionarray = array('.ppt','.pptx');
	        foreach ($extensionarray as $ext) { 
	          if (strpos($file, $ext) !== false) {
	            $status = true;
	            break;
	          }
	        }
	        return $status;
	    }

	    public function getInfosMailDeDemarage($url_api_webcal_remonte_data){
	        $curl = curl_init();
	        curl_setopt_array($curl, array(
	          CURLOPT_URL => "".$url_api_webcal_remonte_data."",
	          CURLOPT_RETURNTRANSFER => true,
	          CURLOPT_ENCODING => "",
	          CURLOPT_MAXREDIRS => 10,
	          CURLOPT_TIMEOUT => 0,
	          CURLOPT_FOLLOWLOCATION => true,
	          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	          CURLOPT_CUSTOMREQUEST => "GET",
	        ));
	        $response = curl_exec($curl);
	        curl_close($curl);
	        return $response;
	    }

	    public function getInfosTranscript($urlTranscript){
	    	$curl = curl_init();
			curl_setopt_array($curl, array(
			  CURLOPT_URL => ''.$this->config->item("api_base_url_transcript").''.$urlTranscript.'',
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'POST',
			));
			$response = curl_exec($curl);
			curl_close($curl);
			return $response;
	    }
    
	    

	    public function loadTrackingEl($sequence_id,$chapitre_id,$type,$module_id=''){
	    	$trackingid = $this->tracking_model->Add($sequence_id,$chapitre_id,$type,$module_id);
            $sessionArray = array('TRACKINGID'=>$trackingid);                                    
            $this->session->set_userdata($sessionArray);
            $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
            return $trackingid;
	    }

	    public function loadTrackingBtnLateralEl($sequence_id,$chapitre_id,$type,$statusShortcuts){
	    	$trackingid = ($statusShortcuts == 'true') ? $this->tracking_model->AddBtnLateral($sequence_id,$chapitre_id,$type,$statusShortcuts) : '';
            $sessionArray = array('TRACKINGBNTLATERAL'=>$trackingid);                                    
            $this->session->set_userdata($sessionArray);
            return $trackingid;
	    }


	    public function scanUrl($link){
	        $ret = array();
	        $ret['retour'] = "tracking and url final";
	        if (isset($link)) {
	            if (strpos($link, 'learnenglish.britishcouncil.org') !== false || strpos($link, 'learnenglishkids.britishcouncil.org') !== false || strpos($link, 'www.liveworksheets.com') !== false || strpos($link, 'stackoverflow.com') !== false){
	                $ret['finalUrl']  = $link;
	                $ret['responses'] = false;
	            }
	            else{
	                $ret['finalUrl']  = $this->findUltimateDestination($link,10);
	                $ret['responses'] = $this->getHeaderResponses($link);
	            }
	            
	            if (strpos($link, 'vimeo.com') !== false || strpos($link, 'facebook.com') !== false || strpos($link, 'dailymotion.com') !== false || strpos($link, 'youtube') !== false || strpos($link, 'youtu.be') !== false) {
	                $ret['mediaUrl'] = $this->getEmbedUrl($link);
	            }
	        }
	        echo json_encode($ret);
	    }

	    public function getFullUrlCurrent(){
	    	$CI =& get_instance();
		    $url = $CI->config->site_url($CI->uri->uri_string());
		    return $_SERVER['QUERY_STRING'] ? $url.'?'.$_SERVER['QUERY_STRING'] : $url;
	    }

	    public function getVoiceListResults(){
	    	return $voiceArray = array (
	    		0 => array(
	    			'value' => 'UK English Female',
	    			'label' => $this->lang->line('footer_js_modal_infos_uk_en_fm'),
	    			'cible' => 1
	    		),
	    		1 => array(
	    			'value' => 'UK English Male',
	    			'label' => $this->lang->line('footer_js_modal_infos_uk_en_ml'),
	    			'cible' => 1
	    		),
	    		2 => array(
	    			'value' => 'US English Female',
	    			'label' => $this->lang->line('footer_js_modal_infos_us_en_fm'),
	    			'cible' => 1
	    		),
	    		3 => array(
	    			'value' => 'US English Male',
	    			'label' => $this->lang->line('footer_js_modal_infos_us_en_ml'),
	    			'cible' => 1
	    		),
	    		4 => array(
	    			'value' => 'Arabic Male',
	    			'label' => $this->lang->line('footer_js_modal_infos_ar_ml'),
	    			'cible' => 2
	    		),
	    		5 => array(
	    			'value' => 'Arabic Female',
	    			'label' => $this->lang->line('footer_js_modal_infos_ar_fm'),
	    			'cible' => 2
	    		),
	    		6 => array(
	    			'value' => 'Chinese Female',
	    			'label' => $this->lang->line('footer_js_modal_infos_ch_fm'),
	    			'cible' => 3
	    		),
	    		7 => array(
	    			'value' => 'Chinese Male',
	    			'label' => $this->lang->line('footer_js_modal_infos_ch_ml'),
	    			'cible' => 3
	    		),
	    		8 => array(
	    			'value' => 'Chinese (Hong Kong) Female',
	    			'label' => $this->lang->line('footer_js_modal_infos_ch_hk_fm'),
	    			'cible' => 3
	    		),
	    		9 => array(
	    			'value' => 'Chinese (Hong Kong) Male',
	    			'label' => $this->lang->line('footer_js_modal_infos_ch_hk_ml'),
	    			'cible' => 3
	    		),
	    		10 => array(
	    			'value' => 'Chinese Taiwan Female',
	    			'label' => $this->lang->line('footer_js_modal_infos_ch_tw_fm'),
	    			'cible' => 3
	    		),
	    		11 => array(
	    			'value' => 'Chinese Taiwan Male',
	    			'label' => $this->lang->line('footer_js_modal_infos_ch_tw_ml'),
	    			'cible' => 3
	    		),
	    		12 => array(
	    			'value' => 'Spanish Female',
	    			'label' => $this->lang->line('footer_js_modal_infos_sp_fm'),
	    			'cible' => 4
	    		),
	    		13 => array(
	    			'value' => 'Spanish Latin American Female',
	    			'label' => $this->lang->line('footer_js_modal_infos_sp_lat_am_fm'),
	    			'cible' => 4
	    		),
	    		14 => array(
	    			'value' => 'Spanish Latin American Male',
	    			'label' => $this->lang->line('footer_js_modal_infos_sp_lat_am_ml'),
	    			'cible' => 4
	    		),
	    		15 => array(
	    			'value' => 'French Female',
	    			'label' => $this->lang->line('footer_js_modal_infos_fr_fr_fm'),
	    			'cible' => 5
	    		),
	    		16 => array(
	    			'value' => 'French Male',
	    			'label' => $this->lang->line('footer_js_modal_infos_fr_fr_ml'),
	    			'cible' => 5
	    		),
	    		17 => array(
	    			'value' => 'French Canadian Female',
	    			'label' => $this->lang->line('footer_js_modal_infos_fr_cn_fr'),
	    			'cible' => 5
	    		),
	    		18 => array(
	    			'value' => 'French Canadian Male',
	    			'label' => $this->lang->line('footer_js_modal_infos_fr_cn_ml'),
	    			'cible' => 5
	    		),
	    		19 => array(
	    			'value' => 'Russian Female',
	    			'label' => $this->lang->line('footer_js_modal_infos_rs'),
	    			'cible' => 6
	    		),
	    	);
	    }

	    public function updateLastActivity($data){
	    	$this->load->model('Log_model');
	    	return $this->Log_model->update($this->session->userdata ('CNX'),$data);
	    }



	    public function loadContentPlateforme($contentType, $key){
	        $return = array();
	        $i = 0;
	        if (isset($contentType)) {
	            $return[$i] = array(
	                'data'   => array(
	                    'domaine' => array(
	                        'id'    => 0,
	                        'name'  => 'Aucun',
	                    ),
	                    'matieres'  => $this->getContentNotInMatiereAndDomaine($contentType, $key),
	                ),
	            );
	        }


	        $ii = isset($i) ? $i + 1 : 0;
	        $this->load->model('Domaines_model');
	        $domainResults = $this->Domaines_model->getAllData();
	        foreach ($domainResults as $d) {
	            if (isset($contentType)) {              
	                $return[$ii] = array(
	                    'data'   => array(
	                        'domaine' => array(
	                            'id'    => $d->domaine_id,
	                            'name'  => $d->name,
	                        ),
	                        'matieres'  => $this->getMatiereByContentTypeAndDomaine($contentType, $d->domaine_id, $key),
	                    ),
	                );
	            }
	            $ii++;
	        }

	        return $return;
	    }

	    public function getMatiereByContentTypeAndDomaine($contentType, $domaine_id, $key){
	        $i = 0;
	        $ii = 1;
	        $aucun  = array();
	        $return  = array();
	        $contents = array();

	        switch ($contentType) {
	            case TYPE_SEQUENCE:
	                $return[$i] = array(
	                    'id'   => 0,
	                    'name' => 'Aucun',
	                    'contents' => $this->sequence_model->getByParams(array('domaine_id' => $domaine_id, 'matiere_id' => 0, 'key' => $key)),
	                );
	                break;
	            case TYPE_MODULE:
	                $return[$i] = array(
	                    'id'   => 0,
	                    'name' => 'Aucun',
	                    'contents' => $this->modules_model->getByParams(array('domaine_id' => $domaine_id, 'matiere_id' => 0, 'key' => $key)),
	                );
	                break;
	            case TYPE_PARCOURS:
	                $return[$i] = array(
	                    'id'   => 0,
	                    'name' => 'Aucun',
	                    'contents' => $this->parcours_model->getByParams(array('domaine_id' => $domaine_id, 'matiere_id' => 0)),
	                );
	                break;
	            
	            default:
	                // code...
	                break;
	        }
	        //$return[$i] = $aucun;

	        $this->load->model('matieres_model');
	        $matiereResults = $this->matieres_model->readAllByDomaine($domaine_id);
	        
	        foreach ($matiereResults as $matiere) {
	        	if (isset($matiere->matiere_id) && $matiere->matiere_id != 0) {
	                switch ($contentType) {
	                    case TYPE_SEQUENCE:
	                        //$contents = $this->sequence_model->getByParams(array('domaine_id' => $domaine_id, 'matiere_id' => $matiere->matiere_id, 'key' => $key));
			                $return[$ii] = array(
			                    'id'       => $matiere->matiere_id,
			                    'name'     => $matiere->name,
			                    'contents' => $this->sequence_model->getByParams(array('domaine_id' => $domaine_id, 'matiere_id' => $matiere->matiere_id, 'key' => $key)),
			                );
	                        break;
	                    case TYPE_MODULE:
	                        //$contents = $this->modules_model->getByParams(array('domaine_id' => $domaine_id, 'matiere_id' => $matiere->matiere_id, 'key' => $key));
			                $return[$ii] = array(
			                    'id'       => $matiere->matiere_id,
			                    'name'     => $matiere->name,
			                    'contents' => $this->modules_model->getByParams(array('domaine_id' => $domaine_id, 'matiere_id' => $matiere->matiere_id, 'key' => $key)),
			                );
	                        break;
	                    case TYPE_PARCOURS:
	                        //$contents = $this->parcours_model->getByParams(array('domaine_id' => $domaine_id, 'matiere_id' => $matiere->matiere_id, 'key' => $key));
			                $return[$ii] = array(
			                    'id'       => $matiere->matiere_id,
			                    'name'     => $matiere->name,
			                    'contents' => $this->parcours_model->getByParams(array('domaine_id' => $domaine_id, 'matiere_id' => $matiere->matiere_id, 'key' => $key)),
			                );
	                        break;                    
	                    default:
	                        // code...
	                        break;
	                }
	                $ii++;
	            }
	        }

	        /*if (isset($i)) {
	        	$return[$i] = array(
                    'id'   => 0,
                    'name' => 'Aucun',
                    'contents' => $this->parcours_model->getByParams(array('domaine_id' => $domaine_id, 'matiere_id' => 0)),
                );
	        }*/
	       
	        return $return;
	    }

	    public function getContentNotInMatiereAndDomaine($contentType, $key){
	        $return = array();
	        $content = array();
	        $i = 0;

	        switch ($contentType) {
	            case TYPE_SEQUENCE:
	                $content = $this->sequence_model->getByParams(array('domaine_id' => 0, 'matiere_id' => 0, 'key' => $key));
	                break;
	            case TYPE_MODULE:
	                $content = $this->modules_model->getByParams(array('domaine_id' => 0, 'matiere_id' => 0, 'key' => $key));
	                break;
	            case TYPE_PARCOURS:
	                $content = $this->parcours_model->getByParams(array('domaine_id' => 0, 'matiere_id' => 0, 'key' => $key));
	                break;
	            
	            default:
	                // code...
	                break;
	        }

	        $return[$i] = array(
	            'id'   => 0,
	            'name' => 'Aucun',
	            'contents' => $content,
	        );
	        return $return;
	    }
	    

	}
