<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Whitepaper extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();  
        $this->tracking_type = 26;  
        $this->load->model('databankExpression_Model');
    }
    
    /**
     * This function used to load the first screen of the user
     */
   
    public function index()
    {
        
        $this->global['pageTitle'] = 'E-learning : White paper';
        
        $this->loadViews("traineeTodoList", $this->global, NULL , NULL);
    }

    public function view()
    {
        
        $this->global['pageTitle']     = 'E-learning : White paper';
        $this->global['groupe']           = $this->session->userdata ('STAGIAIREGRP');
        $this->global['etherpadId']    = $this->membres_model->membre_id_etherpad($this->session->userdata ('STAGIAIREID'));
        $this->global['categoryList']  = $this->databankExpression_Model->getCategoryByIdGroup($this->session->userdata ('STAGIAIREGRP'));
        $this->global['langageList']    = $this->databankExpression_Model->getLangageList();
        $this->global['maxidtracking'] = $this->tracking_model->getMaxIdTracking();

        $this->loadTrackingEl(0,0,$this->tracking_type);
        $this->global['isMobileDetect']    = $this->isMobileDetect();
        $this->loadViews("tutor/whitepaper/index", $this->global, NULL , NULL);
    }

   



    public function pageNotFound()
    {
        $this->global['pageTitle'] = 'CodeInsect : 404 - Page Not Found';
        
        $this->loadViews("404", $this->global, NULL, NULL);
    }
}

?>