<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Newsletter extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();   
        $this->load->model('login_model'); 
        $this->load->helper('url');
        $this->load->library('pagination');
        $this->load->model('Newsletter_nl_themes');
        $this->load->model('Newsletter_nl_articles_nl_themes');  
        $this->tracking_type = 6; 
        $this->sequence_id_default=10086;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {

        if (isset($_GET['id'])) {
            $data['articleResult']          = $this->newsletter_model->getArticle($_GET['id']);
            $data['termeResult']            = $this->newsletter_model->getTerme($_GET['id']);
            $data['themesResutlts']         = $this->Newsletter_nl_themes->getAllByArticle($_GET['id']);
        }

        $allResultCategory = $this->Newsletter_nl_themes->getAll();
        $i = 1;
        $categoryResult = array();
        foreach ($allResultCategory as $c) {
            $tanslateName = '';
            switch ($this->convert_utf8($c->name)) {
                case 'Politics':
                    $tanslateName = $this->lang->line('cat_politics');
                    break;
                case 'Health':
                    $tanslateName = $this->lang->line('cat_health');
                    break;
                case 'Business & Economy':
                    $tanslateName = $this->lang->line('cat_economy');
                    break;
                case 'Society':
                    $tanslateName = $this->lang->line('cat_society');
                    break;
                case 'Sport':
                    $tanslateName = $this->lang->line('cat_sport');
                    break;
                case 'Travel':
                    $tanslateName = $this->lang->line('cat_travel');
                    break;
                case 'Art & Culture':
                    $tanslateName = $this->lang->line('cat_art_culture');
                    break;
                case 'Lifestyle':
                    $tanslateName = $this->lang->line('cat_lifestyle');
                    break;
                case 'Environment':
                    $tanslateName = $this->lang->line('cat_environment');
                    break;
                case 'Technology':
                    $tanslateName = $this->lang->line('cat_technology');
                    break;
                
                default:
                    // code...
                    break;
            }

            $themeImage = '';
            switch ($this->convert_utf8($c->name)) {
                case 'Politics':
                    $themeImage = 'Politics';
                    break;
                case 'Health':
                    $themeImage = 'Health';
                    break;
                case 'Business & Economy':
                    $themeImage = 'Economy';
                    break;
                case 'Society':
                    $themeImage = 'Society';
                    break;
                case 'Sport':
                    $themeImage = 'Sport';
                    break;
                case 'Travel':
                    $themeImage = 'Travel';
                    break;
                case 'Art & Culture':
                    $themeImage = 'Culture';
                    break;
                case 'Lifestyle':
                    $themeImage = 'Lifestyle';
                    break;
                case 'Environment':
                    $themeImage = 'Livestock';
                    break;
                case 'Technology':
                    $themeImage = 'Technology';
                    break;
                
                default:
                    // code...
                    break;
            }
            $categoryResult[$i]  = array(
                $tanslateName, 
                'assets/themes/other/images/'.$themeImage.'.jpg', 
                $this->convert_utf8($c->name),
                $c->id
            );
           $i++;
        }
        $data['categoryResult'] = isset($categoryResult) ? $categoryResult : null;

        if (isset($_GET['user_el']) && $_GET['user_el'] != '') {
            $result = $this->login_model->loginMe($this->membres_model->Request('login',$_GET['user_el']), $this->membres_model->Request('password',$_GET['user_el']));
              
            if(count($result) > 0) {
                foreach ($result as $res) {
                    if ($res->mode_acces == '2') {
                        if ($res->type==0) {
                            $role = STAGIAIRE;
                        }
                        elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                            $role = TUTEUR;                            
                        }
                        elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                            $role = TUTEUR;                            
                        }
                        elseif ($res->type==4) {
                           $role = MANAGER;                            
                        }
                        elseif ($res->type==2) {
                           $role = ADMIN;                            
                        } 
                        else{
                            $role = ROLEAUTRES;
                        }
                        $CNX = $this->connexion_model->newconnexion($res->id);

                        $sessionArray = array('GUSERID'=>$res->id,
                            'GEXTRANETID'              =>$res->extranet_id,
                            'GUSER'                    =>$res->prenom." ".$res->nom,
                            'GUSERLOGIN'               =>$res->login,
                            'GUSERTYPE'                =>$res->type,
                            'BAR'                      =>$res->acces_bar,
                            'MODE_ACCES'               =>$res->mode_acces,
                            'GROUPE'                   =>$res->id_groupe,
                            'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                            'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                            'TYPE'                     =>$res->type,
                            'ROLE'                     =>$role,
                            'CNX'                      =>$CNX,
                            'SOCIETE'                  =>$res->description,
                            'PDP'                      =>$res->nom_photo,
                            'isLoggedIn'               => TRUE
                        );
                                    
                        $this->session->set_userdata($sessionArray);
                        
                    }
                    elseif (!empty($res->date_fin_acces)) {
                        if($res->date_fin_acces+((24*3600)+(60*60)+60) <= time()) {
                            $this->session->set_flashdata('error', 'Votre date d\'accès à la plateforme est expiré');                
                            redirect('/login');

                        }
                        else{
                            if ($res->type==0) {
                                $role = STAGIAIRE;
                            }
                            elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                                $role = TUTEUR;                            
                            }
                            elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                                $role = TUTEUR;                            
                            }
                            elseif ($res->type==4) {
                               $role = MANAGER;                            
                            }
                            elseif ($res->type==2) {
                               $role = ADMIN;                            
                            } 
                            else{
                                $role = ROLEAUTRES;
                            }
                            $CNX = $this->connexion_model->newconnexion($res->id);

                            $sessionArray = array('GUSERID'=>$res->id,
                                'GEXTRANETID'              =>$res->extranet_id,
                                'GUSERLOGIN'               =>$res->login,
                                'GUSER'                    =>$res->prenom." ".$res->nom,
                                'GUSERTYPE'                =>$res->type,
                                'BAR'                      =>$res->acces_bar,
                                'MODE_ACCES'               =>$res->mode_acces,
                                'GROUPE'                   =>$res->id_groupe,
                                'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                                'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                                'TYPE'                     =>$res->type,
                                'ROLE'                     =>$role,
                                'CNX'                      =>$CNX,
                                'SOCIETE'                  =>$res->description,
                                'PDP'                      =>$res->nom_photo,
                                'isLoggedIn'               => TRUE
                            );
                        }

                    }
                    else{                      

                        if ($res->type==0) {
                            $role = STAGIAIRE;
                        }
                        elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                            $role = TUTEUR;                            
                        }
                        elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                            $role = TUTEUR;                            
                        }
                        elseif ($res->type==4) {
                           $role = MANAGER;                            
                        }
                        elseif ($res->type==2) {
                           $role = ADMIN;                            
                        } 
                        else{
                            $role = ROLEAUTRES;
                        }
                        $CNX = $this->connexion_model->newconnexion($res->id);

                        $sessionArray = array('GUSERID'=>$res->id,
                            'GEXTRANETID'              =>$res->extranet_id,
                            'GUSER'                    =>$res->prenom." ".$res->nom,
                            'GUSERLOGIN'               =>$res->login,
                            'GUSERTYPE'                =>$res->type,
                            'BAR'                      =>$res->acces_bar,
                            'MODE_ACCES'               =>$res->mode_acces,
                            'GROUPE'                   =>$res->id_groupe,
                            'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                            'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                            'TYPE'                     =>$res->type,
                            'ROLE'                     =>$role,
                            'CNX'                      =>$CNX,
                            'SOCIETE'                  =>$res->description,
                            'PDP'                      =>$res->nom_photo,
                            'isLoggedIn'               => TRUE
                        );
                    }
                    $this->isLoggedIn();  
                    if (isset($_GET['id-art'])) {
                      $this->loadTrackingEl($_GET['id-art'],0,$this->tracking_type);
                    }
                    else{
                      $this->loadTrackingEl($this->sequence_id_default,0,$this->tracking_type);
                    }
                    
                    if (isset($_GET['id'])) {
                        $this->global['pageTitle']  = 'E-learning : Newsletter - '.$this->newsletter_model->Request('article',$_GET['id']);
                    }
                    elseif (isset($_GET['id-art'])) {
                        $this->global['pageTitle']  = 'E-learning : Newsletter - '.$this->newsletter_model->Request('article',$_GET['id-art']);
                    }
                    else{
                        $this->global['pageTitle']  = 'E-learning : Newsletter';
                    }

                    $data['statPrg'] =  $this->stat_prg_model->getSatCat($this->session->userdata ('GUSERID'))->result();           
                    $data['classification_favoris']   = $this->classificationFavoris_Model->getClassTuteurByTrainee($this->session->userdata ('STAGIAIREGRP')); 
                    $this->loadViews("tutor/newsletter/home", $this->global,$data, NULL );
                }
            }
            else
            {
                $this->session->set_flashdata('error', 'Email or password mismatch');
                
                redirect('/login');
            }
        }
        else{
            $this->isLoggedIn();  
            if (isset($_GET['id-art'])) {
              $this->loadTrackingEl(0,$_GET['id-art'],$this->tracking_type);
            }
            else{
              $this->loadTrackingEl($this->sequence_id_default,0,$this->tracking_type);
            }
            
            if (isset($_GET['id'])) {
                $this->global['pageTitle']  = 'E-learning : Newsletter - '.$this->newsletter_model->Request('article',$_GET['id']);
            }
            elseif (isset($_GET['id-art'])) {
                $this->global['pageTitle']  = 'E-learning : Newsletter - '.$this->newsletter_model->Request('article',$_GET['id-art']);
            }
            else{
                $this->global['pageTitle']  = 'E-learning : Newsletter';
            }

            $data['statPrg'] =  $this->stat_prg_model->getSatCat($this->session->userdata ('GUSERID'))->result();    
            $data['historik_course'] = $this->coursHistorik_model->getByUserCreateIdGroupTraineeCreate($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREID'),$this->session->userdata ('STAGIAIREGRP'));        
            $data['classification_favoris']   = $this->classificationFavoris_Model->getClassTuteurByTrainee($this->session->userdata ('STAGIAIREGRP')); 
            
            $this->loadViews("tutor/newsletter/home", $this->global,$data, NULL );
        }
    }
}

?>


  
  
  