<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';
/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Bors
 * @version : 1.1
 * @since : 22 November 2018
 */
class Groupes extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('societe_model');
        $this->isLoggedIn();   
        $this->action_type = 0;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {

    }
    public function personnalize(){
        $this->global['pageTitle']        = 'E-learning : Trainee program';
 
        if (isset($_GET['extranet_id']) && !empty($_GET['extranet_id'])) {           
            $this->global['displaygrp']       = $this->DisplayGroupe($_GET['groupe'],$_GET['id']);

            $sessionArray = array('STAGIAIREID'=>$_GET['id'],
                                    'STAGIAIREGRP'=>$_GET['groupe'],
                                    'STAGIAIRENAME'=>$this->membres_model->GetPrenom($_GET['id']).' '.$this->membres_model->GetNom($_GET['id']),
                                    'STAGIAIREEXTRANETID' =>$_GET['extranet_id']
                                ); 
            $this->session->set_userdata($sessionArray);
            $this->global['groupe']           = $_GET['groupe'];
            
            $this->global['STAGIAIREID']           = $_GET['id'];
            $this->global['STAGIAIREGRP']          = $_GET['groupe'];
        }
        else{
            $this->global['groupe']           = $this->session->userdata ('STAGIAIREGRP');
        }

        if (isset($_GET['paves_sequence'])) {
            define('PAVES_SEQUENCE',    $_GET['paves_sequence']);

            $date_debut = time();        
            if (PAVES_SEQUENCE==4) {
                $this->action_type = 24;
            }
            elseif (PAVES_SEQUENCE==6) {
                $this->action_type = 26;
            }   
            elseif (PAVES_SEQUENCE==7) {
                $this->action_type = 27;
            }   
            else{
                $this->action_type = 28;
            }   
        }
        else{
            define('PAVES_SEQUENCE',    '');
        }
        $societe = "";
        if ($this->convert_utf8($this->societe_model->GetSociete($this->session->userdata ('STAGIAIREID'))) != "") {
           $societe = " from <strong>".$this->convert_utf8($this->societe_model->GetSociete($this->session->userdata ('STAGIAIREID'))).'</strong>';
        }
        $url = base_url()."&groupe=".$this->session->userdata ('STAGIAIREGRP') ;    
        $this->global['navigation'] = "<strong>".$this->convert_utf8($this->membres_model->GetPrenom($this->session->userdata ('STAGIAIREID')))." ".$this->convert_utf8($this->membres_model->GetNom($this->session->userdata ('STAGIAIREID')))."</strong>".$societe;
        $this->global['ficheMmebre'] = $this->displayFicheStagiaireTracking($this->session->userdata ('STAGIAIREID'), $this->session->userdata ('GROUPE'));
        $this->global['photos'] = $this->displayhpotos($this->session->userdata ('STAGIAIREID'));
        $this->global['program'] = $this->displaySessionTrackingPersonnalise($this->session->userdata ('STAGIAIREID'), $this->session->userdata ('STAGIAIREGRP'),PAVES_SEQUENCE);
        $this->global['classification_favoris']              = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));      
        $this->loadViews("tutor/trainee/program-personnalize", $this->global, NULL , NULL);

    }

    public function readActivity(){
        
    }

    public function viewTodo(){
        $this->global['pageTitle'] = 'E-learning : Forma2+';
        
        $this->loadViews("todoList/viewstodo", $this->global, NULL , NULL);
    }

    public function pageNotFound()
    {
        $this->global['pageTitle'] = 'CodeInsect : 404 - Page Not Found';
        
        $this->loadViews("404", $this->global, NULL, NULL);
    }
    
    public function customContentPersonnalInterest(){
        $this->global['pageTitle']        = 'E-learning : '.$this->lang->line('educational_library_personnal_interest').'-'.$this->lang->line('educational_library_personal_interest_manage'); 
        $data['allContentHtml'] = $this->displayContentProgramInternEelearning($this->session->userdata ('STAGIAIREGRP'),$this->session->userdata ('STAGIAIREID'), 7);  
        $this->loadViews("tutor/trainee/custom-content-personnal-interest", $this->global, $data, NULL );  

    }
   
}

?>