<?php 
    if(!defined('BASEPATH')) exit('No direct script access allowed');

    require APPPATH . '/libraries/ElearningForma2PlusController.php';
    require  APPPATH. '/libraries/ExportData.php';

    /**
     * Class : Todolist
     * Base Class to control over all the classes
     * @author : Alexandre Boris
     * @version : 1.1
     * @since : 136 Decémbre 2019
     */

    class Expression extends ElearningForma2PlusController
    {
        /**
         * This is default constructor of the class
         */
        public function __construct()
        {
            parent::__construct();
            $this->load->model('databankExpression_Model');
            $this->load->model('CategoryExpression_model');
            $this->isLoggedIn();   
        }
        
        /**
         * This function used to load the first screen of the user
         */
        public function index()
        {
            /*$this->global['pageTitle'] = 'E-learning - Expression'; 
            $this->global['groupe']    = $this->session->userdata ('STAGIAIREGRP');
            $data['langage'] = $this->databankExpression_Model->getListLangage();
            $data['expressions'] = $this->databankExpression_Model->readExpressionTuteur($this->membres_model->GetIdByGrp($this->session->userdata('STAGIAIREGRP')));
            
            $this->loadViews("tutor/e-databank/index", $this->global, $data , NULL);*/
        }


        public function add()
        {
            $return = array();
            $category = NULL;
            $idTraineer;
            if (isset($_POST)) {

                if (isset($_POST['dataExpression']['visibilityNewCat']) && $_POST['dataExpression']['visibilityNewCat'] == 1 ) {
                    $dataCat = array(
                        'id_groupe' => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREGRP') : $this->session->userdata ('GROUPE'),
                        'intitule'  => $this->convert_utf8($_POST['dataExpression']['new_category'])
                    );
                    $categoryId = $this->CategoryExpression_model->add($dataCat);
                    $return['newCategoryId'] = $categoryId;
                    $return['newCategoryName'] = $_POST['dataExpression']['new_category'];
                    $return['visibilityNewCat'] = $_POST['dataExpression']['visibilityNewCat'];
                }
                else{
                    $categoryId =  $_POST['dataExpression']['category_expression'];
                }

                $additional_data = array(
                    'content_langue_origine'          => $_POST['dataExpression']['text_langage_origin'],
                    'target_langue_cible'             => $_POST['dataExpression']['target_langue_cible'],
                    'id_stagiaire'                    => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'),
                    'id_tuteur'                       => NULL,
                    'id_category'                     => $categoryId ,
                    'content_langue_cible'            => $_POST['dataExpression']['text_langage_cible'],
                    'date_creation'                   => date("Y-m-d H:i:s"),
                    'user_create'                     => $this->session->userdata('GUSERID'),
                    'id_tuteur'                       => $this->isTuteurConnet() ? $this->session->userdata('GUSERID') : NULL,
                );
                $return['newExpressionId'] = $this->databankExpression_Model->addExpression($additional_data);
                $return['category'] = $categoryId;
                echo json_encode($return);
            }
        }
        public function addGlossaryToMyOdb()
        {
            $additional_data = array();
            $data = array();
            $category = NULL;
            if (isset($_POST)) {

                if (isset($_POST['themes'])) {
                    $idRequest = $this->categoryExpression_model->RequestByNameAndGrp('id',$_POST['themes'],$this->session->userdata ('GROUPE'));
                    if ($idRequest != '' || $idRequest != NULL) {
                        $category = $idRequest;
                    }
                    else{
                        $dataCat = array(
                            'id_groupe' => $this->session->userdata ('GROUPE'),
                            'user_create' => $this->session->userdata ('GUSERID'),
                            'description' => NULL,
                            'date_creation' => time(),
                            'intitule'  => $_POST['themes']
                        );
                        $category = $this->databankExpression_Model->addCategory($dataCat);
                    }
                    $data['category'] = $category;
                    
                }
                $idTraineer = NULL;
                if($this->isTuteurConnet()){
                    $idTraineer = $this->session->userdata('GUSERID');
                }

                $additional_data = array(
                    'content_langue_origine'          => $_POST['origin'],
                    'target_langue_cible'             => 1,
                    'id_stagiaire'                    => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'),
                    'id_tuteur'                       => NULL,
                    'id_category'                     => $category ,
                    'content_langue_cible'            => $_POST['traduction'],
                    'date_creation'                   => date("Y-m-d H:i:s"),
                    'user_create'                     => $this->session->userdata('GUSERID'),
                    'id_tuteur'                       => isset($idTraineer) ? $this->session->userdata('GUSERID') : NULL,
                );
                $data['expression'] = $this->databankExpression_Model->addExpression($additional_data);
                echo json_encode($data);
            }
        }

        /*public function edit(){
            if (isset($_POST)) {
                $additional_data = array(
                    'content_langue_origine'          => $_POST['dataExpression']['text_langage_origin'],
                    'target_langue_cible'             => $_POST['dataExpression']['target_langue_cible'],
                    'content_langue_cible'            => $_POST['dataExpression']['text_langage_cible']
                );
                $this->databankExpression_Model->editExpression($_POST['dataExpression']['idExpression'],$additional_data);
                echo "OK";
            }
        }

        public function delete(){
            if (isset($_POST['id'])) {
                $id   =  $_POST['id'];
                $this->databankExpression_Model->deleteExpression($id);
                echo $id;
            }
            
        }
        public function export(){
            if($_POST['json']){
                $data = json_decode($_POST['json']);             
                
                $exporter = new ExportDataExcel('browser', 'Export_expression.xls');
                $exporter->initialize();
                $exporter->addRow(array( "Origin", "Langage cible", "Cible", "Creation date")); 
               foreach($data as $keys => $value){
                    $rows[$keys] = $value;

                    foreach($rows as $key => $val){
                        $row[$key][0] = $val[0];
                        $row[$key][1] = $val[1];
                        $row[$key][2] = $val[2];
                        $row[$key][3] = $val[5];
                    }
                    $exporter->addRow($row[$keys]);
                }
                $exporter->finalize() ;
            } 
        }

        public function record(){
            $this->global['groupe']    = $this->session->userdata ('STAGIAIREGRP');
            $this->global['pageTitle'] = 'Record audio';
            if (isset($_GET) && $_GET['id'] != NULL) {
                $this->loadViews("tutor/e-databank/record", $this->global, NULL , NULL);
            }
        }
       
        public function uploadaudio(){
            if (isset($_GET) && $_GET['id'] != NULL) {
                $repgrp = RP_GROUPES."GRP".$this->session->userdata('STAGIAIREGRP')."/expression/";
                if ( ! is_dir($repgrp) ) {
                    mkdir($repgrp, 0777,true);
                }
                $size = $_FILES['audio_data']['size']; 
                $input = $_FILES['audio_data']['tmp_name'];

                $output = $this->session->userdata ('GUSERID')."_".time().".mp3";
                $destination = $repgrp.$output;
                if(@move_uploaded_file($input, $destination)){
                    $data = array('audio_langue_origine' => $output);
                    $this->databankExpression_model->addOriginAudio($_GET['id'],$data);
                    echo '###'.$destination;
                }
                else{
                    echo '###vvvvv'.$repgrp;
                }
            }
        }*/
    }

?>