<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : BaseController
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Query extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();     
        $this->load->model('queryStat_model');       
        $this->isLoggedIn(); 
        $this->tracking_type = 18;  
        $this->menu = array();
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
    }
    public function list()
    {
        ini_set('memory_limit', -1);
        /*$trackingid = $this->tracking_model->Add(0,0,$this->tracking_type);
        $sessionArray = array('TRACKINGID'=>$trackingid);                                    
        $this->session->set_userdata($sessionArray);
        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');

        $this->global['pageTitle'] = 'E-learning : Dashboard';
        $this->global['groupe'] = $this->session->userdata ('GROUPE');   */ 
        $list = $this->CheckList();
        $list = $this->SortList($list);
        //$this->GenQuestionsList($list);
        $this->global['pageTitle'] = 'E-learning : Query list'; 
        //$data['allCategory'] = array_values(array_unique($this->queryStat_model->GetByQueryType('c'))); 
        $data['allQuestionsTag'] = $this->GenQuestionsList($list); 
      
        $this->loadViews("supervisor/query/list", $this->global, $data , NULL);
    }



    public function CheckList() {
        $list = $this->queryStat_model->AllQueryOptions();

        for ($i=0; $i<count($list); $i++) {
            if (!isset($list[$i]['c'])) {
                $list[$i]['c']="(Non classées)";                  
            }
            if (!isset($list[$i]['s'])) {
                $list[$i]['s']="";             
            }
        }
    
        return $list;
    }

    public function SortList() {
        $list = $this->CheckList();
        foreach ($list as $key => $row) {
           $cat[$key] = $row["c"];
           $subcat[$key] = $row["s"];
           $q[$key] = $row['q'];
        }
        array_multisort($cat, SORT_ASC, $subcat, SORT_ASC, $q, SORT_ASC, $list);
        return $list;
    }
    public function NewCat($elt, $old_cat) {
        if ($elt["c"]==$old_cat) {
            return false;
        } 
        else {
            return true;
        }
    }

    public function NewSubCat($elt, $old_subcat) {
        if ($elt["s"]==$old_subcat) {
            return false; // ce n'est pas une nouvelle catégorie.
        } else {
            return true;  // c'est une nouvelle catégorie
        }
    }

    public function GenQuestionsList($list) {
        $old_cat    = "";
        $old_subcat = "";
        $out        = "";
        $i          = 0;
        $table      = '<ul id="query_stat">' ;
            foreach ($list as $elt) {
                $table.= '<li class="link-threed-program branch">';

                    if ($this->NewCat($elt, $old_cat)===true) {
                        if ($elt['c'] != '') {                            
                            $table.= "<span>".$elt['c']."</span>";
                            $old_cat=$elt['c']; 
                            $old_subcat=""; 
                        }  
                        $table.= "<ul>";
                            if ($this->NewSubCat($elt, $old_subcat)===true) {
                                $table.= '<li class="branch" style=""><span>'.$elt['s'].'</span>';
                                $old_subcat=$elt['s'];                            
                                    $table.= "<ul>";
                                        $table.= '<li class="branch" style=""><span>'.$elt['q'].'</span></li>';
                                    $table.= "</ul>";
                                $table.= "</li>";
                            }
                        $table.= "</ul>";
                    }
                $table.= "</li>";
                $i++;
            }
        $table.= "</ul>";     
        return $table;
    }
}

?>