<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Video extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('video_model');
        $this->isLoggedIn();  
        $this->tracking_type = 44;  
        $this->load->library('user_agent');  
        Header('Access-Control-Allow-Origin: *'); //for allow any domain, insecure
        Header('Access-Control-Allow-Headers: *'); //for allow any headers, insecure
        Header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE'); //method allowed
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index(){     
        $this->loadTrackingEl(0,0,$this->tracking_type);

        $this->load->library('pagination');
        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('video_label');
        
        $data['myodb_url_api'] = $this->config->item("myodb_url_api");
        $data['allResutlDistinctDateCreate'] = $this->isTuteurConnet() ? $this->video_model->getAllDIstinctDateCreate($this->session->userdata ('STAGIAIREID')) : $this->video_model->getAllDIstinctDateCreate($this->session->userdata ('GUSERID'));
        $data['allResult'] = $this->isTuteurConnet() ? $this->video_model->trainee_first_videolist($this->session->userdata ('STAGIAIREID')) : $this->video_model->trainee_first_videolist($this->session->userdata ('GUSERID'));
        $data['idGroupe'] = $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREGRP') : $this->session->userdata ('GROUPE');
        $data['idStagiaire'] = $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID');
        if ($this->isTuteurConnet()) {
            $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
            $this->loadViews("tutor/video/list", $this->global,$data, NULL ); 
        }
        else{
            $this->loadViews("trainee/video/list", $this->global,$data, NULL ); 
        }
    }

    public function getByExpressionId(){
        $return = array();
        $html   = '';
        
        $idGroupe  = $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREGRP') : $this->session->userdata ('GROUPE');
        if (isset($_POST['id'])) {
            $allResult = $this->video_model->getByExpressionId($_POST['id']);
            foreach($allResult as $res) {
                $return['idExpression'] = $res->id_expression;
                $return['originalTexto'] = $this->convert_utf8($res->content_langue_origine);
                $mediaContent   = file_exists(RP_GROUPES.'GRP'.$idGroupe.'/'.$res->f_name) ? HTTP_MAIN.'groupes/GRP'.$idGroupe.'/'.$res->f_name : '';
                $html   .= '
                    <div class="col-md-6 mb-3">                        
                        <div class="video-container">
                            <video class="main-video" controls>
                                <source data-course = "'.RP_GROUPES.'GRP'.$idGroupe.'/'.$res->f_name.'" src="'.$mediaContent.'" type="video/mp4"/>
                            </video>
                            <div class="main-video-meta">
                                <h4>'.$this->convert_utf8(str_replace("\n"," ",$res->legende_f)).'</h4>
                                <div class="video-date">
                                    <i class="bx bxs-calendar-alt"></i>
                                    '.$this->convert_utf8($res->date_creat).'
                                </div>
                            </div> 
                        </div> 
                          
                    </div>';
                    $allResultsRework = $this->video_model->getAllResultRework($this->session->userdata ('GUSERID'),$res->id_expression);
                    $jsonDecodeAllResultsRework = json_decode($allResultsRework,true);
                    $html .='<div class="col-md-6 d-flex mb-3">                
                        <div class="audio-container">
                            <div class="audio-header">                        
                                <div class="select-audio">
                                    <select name="" id="" class="choose-audio el-form-select" onchange="loadAudioRework(this)">';
                                        $html .='<option  value="'.$mediaContent.'" data-id-expression="'.$res->id_expression.'" data-file-ref="'.$res->file_ref.'" data-id-file="'.$this->convert_utf8($res->id_files).'" data-content-lang-origin="'.$this->convert_utf8($res->content_langue_origine).'" data-content-lang-cible="'.$this->convert_utf8($res->content_langue_cible).'" data-intitule="'.$this->convert_utf8($res->intitule).'">'.$this->lang->line('audio_original').'</option>';
                                        for ($i=0; $i < count($jsonDecodeAllResultsRework) ; $i++) {

                                            $mediaName   = (isset($jsonDecodeAllResultsRework[$i]['f_name']) && file_exists(RP_GROUPES.'GRP'.$idGroupe.'/'.$jsonDecodeAllResultsRework[$i]['f_name'])) ? HTTP_MAIN.'groupes/GRP'.$idGroupe.'/'.$jsonDecodeAllResultsRework[$i]['f_name'] : '';
                                            $mediaIdExp = isset($jsonDecodeAllResultsRework[$i]['id_exp']) ? $jsonDecodeAllResultsRework[$i]['id_exp'] : '';
                                            $mediaFileReference = isset($jsonDecodeAllResultsRework[$i]['file_ref']) ? $jsonDecodeAllResultsRework[$i]['file_ref'] : '';
                                            $mediaFileId = isset($jsonDecodeAllResultsRework[$i]['id_files']) ? $jsonDecodeAllResultsRework[$i]['id_files'] : '';
                                            $mediaContentOrigin = isset($jsonDecodeAllResultsRework[$i]['content_langue_origine']) ? $jsonDecodeAllResultsRework[$i]['content_langue_origine'] : '';
                                            $mediaContentCible = isset($jsonDecodeAllResultsRework[$i]['content_langue_cible']) ? $jsonDecodeAllResultsRework[$i]['content_langue_cible'] : '';
                                            $mediaLabel = isset($jsonDecodeAllResultsRework[$i]['intitule']) ? $jsonDecodeAllResultsRework[$i]['intitule'] : '';
                                            $mediaAudioOrigin = isset($jsonDecodeAllResultsRework[$i]['audio_langue_origine']) ? $jsonDecodeAllResultsRework[$i]['audio_langue_origine'] : '';

                                            $html .= ($mediaName != '' && $mediaName != $mediaContent) ? '<option value="'.$mediaName.'" data-id-expression="'.$mediaIdExp.'" data-file-ref="'.$mediaFileReference.'" data-id-file="'.$mediaFileId.'" data-content-lang-origin="'.$mediaContentOrigin.'" data-content-lang-cible="'.$mediaContentCible.'" data-intitule="'.$mediaLabel.'">'.$mediaAudioOrigin.'</option>' : '';
                                        }
                                    $html .='</select>
                                </div>';
                                $html .= $this->isTuteurConnet() ? '' :  '<button class="el-btn-icon el-btn-blue rework-audio" onclick="reworkAudio(this)" data-expression-id="'.$res->idExpression.'" data-media="'.$mediaContent.'" data-media-name="'.$res->f_name.'">
                                    <i class="bx bxs-microphone"></i>
                                    '.$this->lang->line('reword_audio').'
                                </button>';
                            $html .='</div>';                            
                            $html .='<audio class="main-audio" controls>
                                <source  class="audio-link-read" data-course= "'.RP_GROUPES.'GRP'.$idGroupe.'/'.$res->f_name.'" src="'.$mediaContent.'" type="audio/mpeg"/>
                            </audio>
                            <div class="audio-statistics" data-expression-id="'.$this->convert_utf8($res->id_expression).'" data-expression-origin="'.$this->convert_utf8($res->content_langue_origine).'">
                                <div class="bs-stat-container">
                                    <div class="bs-stat">
                                        <span class="stat_words" data-id-expression="'.$this->convert_utf8($res->id_expression).'"></span>
                                        <span>'.$this->lang->line('media_words').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <div class="bs-stat">
                                        <span class="stat_happaxes" data-id-expression="'.$this->convert_utf8($res->id_expression).'"></span>
                                        <span>'.$this->lang->line('media_hapaxes').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <div class="bs-stat">
                                        <span class="stat_duration" data-id-expression="'.$this->convert_utf8($res->id_expression).'"></span>
                                        <span>'.$this->lang->line('media_duration').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <div class="bs-stat">
                                        <span class="stat_debit" data-id-expression="'.$this->convert_utf8($res->id_expression).'"></span>
                                        <span>'.$this->lang->line('media_debit').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="bs-stat-container">
                                    <div class="bs-stat bs-bg-green">
                                        <span class="stat_verbs" data-id-expression="'.$this->convert_utf8($res->id_expression).'"></span>
                                        <span>'.$this->lang->line('media_verbs').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <div class="bs-stat bs-bg-blue">
                                        <span class="stat_adjectif" data-id-expression="'.$this->convert_utf8($res->id_expression).'"></span>
                                        <span>'.$this->lang->line('media_adjectifs').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <div class="bs-stat bs-bg-pink">
                                        <span class="stat_active_voice" data-id-expression="'.$this->convert_utf8($res->id_expression).'"></span>
                                        <span>'.$this->lang->line('media_active_voice').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <div class="bs-stat bs-bg-orange">
                                        <span class="stat_passive_voice" data-id-expression="'.$this->convert_utf8($res->id_expression).'"></span>
                                        <span>'.$this->lang->line('media_passive_voice').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                </div>                        
                                <button class="el-btn el-btn-blue btn-open-stat-modal" onclick="openStatModal(this);" data-toggle="modal" data-target="stat-analyse-lexicales" data-expression-id="'.$this->convert_utf8($res->id_expression).'" data-expression-origin="'.$this->convert_utf8($res->content_langue_origine).'">'.$this->lang->line('track_your_progress').'</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3 mb-md-0">
                        <div class="transcription">
                            <div class="transcription-header">
                                <h4>'.$this->lang->line('my_speech').'</h4>
                                <div class="transcription-btn">
                                    <button onclick="copyTextContent(this);" class="btn-copy btn-copy-content-origin" data-btn-id="'.$this->convert_utf8($res->id_expression).'"><i class="bx bx-copy-alt"></i></button>
                                    <button class="btn-edit btn-edit-content-origin btn-save-data" onclick="registerContentOrigin(this);" data-btn-id="'.$this->convert_utf8($res->id_expression).'"><i class="bx bx-save"></i></button>
                                </div>
                            </div>
                            <div class="transcription-txt">
                                <textarea name="" data-content-id="'.$this->convert_utf8($res->id_expression).'" id="content-origin" class="el-textarea content-origin">'.$this->convert_utf8($res->content_langue_origine).'</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="translate">
                            <div class="translate-header">
                                <h4>'.$this->lang->line('my_translation').'</h4>
                                <div class="translate-btn">
                                    <button onclick="copyTextContent(this);" class="btn-copy btn-copy-content-cible" data-btn-id="'.$this->convert_utf8($res->id_expression).'"><i class="bx bx-copy-alt"></i></button>
                                    <button class="btn-edit btn-edit-content-cible" data-btn-id="'.$this->convert_utf8($res->id_expression).'"><i class="bx bx-edit"></i></button>
                                </div>
                            </div>
                            <div class="translate-txt">
                                <textarea name="" data-content-id="'.$this->convert_utf8($res->id_expression).'" id="content-cible" class="el-textarea content-cible">'.$this->convert_utf8($res->content_langue_cible).'</textarea>
                            </div>
                        </div>
                    </div>';
            }
        }
        $return['status'] = true;
        $return['htmlContent'] = $html;
        echo json_encode($return);
    }

    public function trainee_comment_file($id_exp){ 
        try {
            $this->video_model->trainee_comment($id_exp); 
            echo json_encode("obs added succesfuly");
        } catch (\Exception $e) {
            echo json_encode($e);
            die($e->getMessage());

        }
    }


}

?>