<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';
//require APPPATH . '/libraries/html_form.php';
require APPPATH . '/libraries/zip.class.php';
//define('HTTP_IMAGES',base_url().'assets/images/filemanager/')  ;
//define('HTTP_IMG',base_url().'assets/images/filemanager/')  ;
//require APPPATH .'/config/defineimg.php';
//include ('html_table.php');
/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Filemanager extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
        define('IMAGE_DIR', base_url()."/assets/images/filemanager/");
        define('IMG_VOIR',      '<img align="absmiddle" src="'.IMAGE_DIR.'actions/voir.gif" border="0" alt="Voir">') ;
        define('IMG_MODIF',     '<img align="absmiddle" src="'.IMAGE_DIR.'actions/modifier.gif" border="0" alt="Modifier">');
        define('IMG_DEL',       '<img align="absmiddle" src="'.IMAGE_DIR.'actions/supp.gif" border="0" alt="Supprimer">') ;
        define('IMG_DNL',       '<img align="absmiddle" src="'.IMAGE_DIR.'actions/download.gif" border="0" alt="telecharger">')       ;
        define('IMG_ARCHIVE',   '<img align="absmiddle" src="'.IMAGE_DIR.'actions/archiver.gif" border="0" alt="Archiver">');
        define('CHMOD',     0775)   ;
        global $max_caracteres;
        global $rep;
        

    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : File manager';
        
        $this->loadViews("commun/filemanager/index", $this->global, NULL , NULL);
    }

    //public function views($loc=NULL,$cmd=NULL,$cmd1=NULL,$id=NULL,$typeprgr=NULL,$action=NULL,$repertoire=""){
    public function views(){

        $loc = "";
        $cmd = "";
        $cmd1 = "";
        $action = "";
        $rep = "";
        $typeprgr = "";
        $id = "";
        $form = "";


        if (isset($_GET['id'])) {
           $id .= $_GET['id'];
        }
        if (isset($_GET['loc'])) {
           $loc .= $_GET['loc'];
        }

        if (isset($_GET['cmd'])) {
           $cmd .= $_GET['cmd'];
        }

        if (isset($_GET['cmd1'])) {
           $cmd1 .= $_GET['cmd1'];
        }

        if (isset($_GET['action'])) {
           $action .= $_GET['action'];
        }

        if (isset($_GET['rep'])) {
           $rep .= $_GET['rep'];
        }

        if (isset($_GET['form'])) {
           $form .= $_GET['form'];
        }
     

        $this->global['pageTitle'] = 'E-learning : File manager';
        
        define('FORM',      (isset($_GET['form'])?$_GET['form']:'')) ;
        
        define('FICHIER',   (isset($_GET['fichier'])?$_GET['fichier']:''));
        define('SENS',      (isset($_GET['sens'])?$_GET['sens']:0));
        define('PAGE',      base_url().'filemanager?loc='.$loc.'&cmd='.$cmd.'&cmd1='.$cmd1.'&id='.$id."&form=".FORM."&sens=".SENS."");

        $rep  = (isset($rep)?$rep:'') ;
        $select_file = false ;
        $gtitre = 'pas de titre !!!!';
        $content = '' ;
        switch($cmd) {
            case CMD_ALL :
                $gtitre = "Gestion des fichiers sur le serveur" ;
                $racine     = RP_MAIN   ;
                $url_racine = HTTP_MAIN;
                break;
            case CMD_FILE_FORMATION :
                $gtitre = "Liste des répertoires de formation";
                $select_file= true ;
                $racine     = RP_FORMATION  ;
                $url_racine = HTTP_FORMATION    ;
                break;
            case CMD_LIST_FORMATION :
                $gtitre = "Sélectionner un fichier" ;
                $racine     = RP_FORMATION  ;
                $url_racine = HTTP_FORMATION    ;
                break;
            default :
                $this->PageErreur();
                exit()      ;
        }
        switch($cmd1) {
            case CMD_ALL :
                $gtitre = "Gestion des fichiers sur le serveur";
                $racine     = RP_MAIN   ;
                $url_racine = HTTP_MAIN;
                break;
            case CMD_FILE_FORMATION :
                $gtitre = "Gestion des séquences de formation"        ;
                $select_file= true ;
                $racine     = RP_FORMATION  ;
                $url_racine = HTTP_FORMATION    ;
                break;
            case CMD_LIST_FORMATION :
                $gtitre = "Gestion des séquences de formation";
                $racine     = RP_FORMATION  ;
                $url_racine = HTTP_FORMATION    ;
                break;
            default :
                $this->PageErreur();
                exit()      ;
        }
    
       
        $nom_rep = '' ;
        switch($action) {
            case "telechargerzip":
                global $ClsZip;
                $filenamezip = basename(FICHIER);
                $fichier = FICHIER ;
                $racinezip = $racine.($fichier[0]=="/"?'':"/").$fichier ;
                $this->scann($racinezip);
                $archive = $ClsZip->file();
                header('Content-Type: application/x-zip');
                header('Content-Disposition: inline; filename='.$filenamezip.'.zip');
                echo $archive;
                exit();
                break;

            case "telecharger":
                $NomFichier = basename(FICHIER);
                $fichier = FICHIER ;
                $file = $racine.($fichier[0]=="/"?'':"/").$fichier ;

                $taille=filesize($file);

                switch(strrchr(basename(FICHIER), ".")) {
                    case ".gz": 
                        $type = "application/x-gzip"; 
                        break;
                    case ".tgz": 
                        $type = "application/x-gzip"; 
                        break;
                    case ".zip": 
                        $type = "application/zip"; 
                        break;
                    case ".pdf": 
                        $type = "application/pdf";
                        break;
                    case ".png": 
                        $type = "image/png"; 
                        break;
                    case ".gif": 
                        $type = "image/gif"; 
                        break;
                    case ".jpg": 
                        $type = "image/jpeg"; 
                        break;
                    case ".txt": 
                        $type = "text/plain"; 
                        break;
                    case ".htm": 
                        $type = "text/html"; 
                        break;
                    case ".html": 
                        $type = "text/html"; 
                        break;
                    case ".doc" : 
                        $type = "application/msword"; 
                        break;
                    case ".xls" : 
                        $type = "application/vnd.ms-excel"; 
                        break;
                    case ".ppt" : 
                        $type = "application/vnd.ms-powerpoint"; 
                        break;
                    default: 
                        $type = "application/octet-stream"; 
                        break;
                }

                header("Content-disposition: attachment; filename=\"$NomFichier\"");
                header("Content-Type: application/force-download");
                header("Content-Transfer-Encoding: $type\n");
                header("Content-Length: ".$taille);
                header("Pragma: no-cache");
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0, public");
                header("Expires: 0");
                readfile($file) or die("Le fichier spécifié est introuvable.");
                exit();
                break;
            case "voir" :
                $nomdufichier = basename(FICHIER);
                $img = '<img src="'.IMAGE_DIR.mimetype($racine.'/'.FICHIER,"image").'" align="ABSMIDDLE">' ;
                $table = new HTML_Table_Admin(array(100), 95, array("Fichier".' : '.$img.' '.strong($nomdufichier)));
                if(!$this->is_image(FICHIER)) {
                    $fp=@fopen($racine.'/'.FICHIER,"r");
                    if($fp) {
                        while(!feof($fp)){
                            $buffer=fgets($fp,4096);
                            $buffer=txt_vers_html($buffer);
                            $buffer=str_replace("\t","&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;",$buffer);
                            $table->addRow(array($buffer.BR()));
                        }
                        fclose($fp);
                    }else{
                        $table->addRow(array("Impossible d'ouvrir le fichier".' : '.$racine.'/'.FICHIER));
                    }
                }else{
                    $table->addRow(array('<center><img src="'.$url_racine.'/'.FICHIER.'" border="1"></center>'.BR()));
                }

                $content.= $table->toHTML();

                $page = new HTML_PageWindow("(c) Web-Jeff FileManager", "Fichier".' : '.$nomdufichier, $content );
                $page->display() ;

                exit;
                break;
            case "supprimer":

                $fic = $_GET['fic'];
                $mime = (is_dir($racine.'/'.$fic)?"r&eacute;pertoire":"fichier");
                $content.= $this->haut() ;
                
                $content.= "Voulez-vous supprimer d&eacute;finitivement le".' '.$mime.' <b>'.$fic.'</b> ?<br /><br />';
                $content.= '<a class="error" href="'.PAGE.'&action=supprimer_suite&rep='.$rep.'&fic='.$fic.'">'."OUI".'</a>&nbsp;&nbsp;&nbsp;';
                $content.='<a class="lien" href="'.PAGE.'&rep='.$rep.'">'."NON".'</a><br />';
                $content.= "<br><br><br><br>";
                break;

            case "supprimer_suite":
                $a_effacer  = $racine.'/'.$_GET['fic'];
                if(file_exists($a_effacer)) {
                    if(is_dir($a_effacer)){
                        $this->wj_deldir($a_effacer);
                    }else {
                        unlink($a_effacer);
                    }
                }
                header("Location:".PAGE."&rep=".$rep);
                exit;
                break;
            case "mkdir" :
                $err    = 0 ;
                $wj_messtmp = "";
              
                $nomdir = $this->traite_nom_fichier($this->input->post('text1'));
                
                if(empty($nomdir)) {
                    $wj_messtmp .= "Vous devez saisir un nom de fichier valide";
                    $err=1;
                } 
                elseif(file_exists($racine.'/'.str_replace("___", "/", $rep).'/'.$nomdir)) {
                    $wj_messtmp .= "Ce dossier existe d&eacute;jà";
                    $err=1;
                } 
                else {
                    mkdir($racine.'/'.str_replace("___", "/", $rep).'/'.$nomdir,CHMOD);
                    $wj_messtmp ="Le dossier".' <b>'.$nomdir.'</b>'. "a &eacute;t&eacute; cr&eacute;&eacute; dans le r&eacute;pertoire".' <b>';
                    $wj_messtmp.= (str_replace("___", "/", str_replace("___", "/", $rep))==''?'/':str_replace("___", "/", $rep));
                    $wj_messtmp.='</b>';
                   
                }

                if($err==0) {
                    header("Location:".base_url()."filemanager?loc=".$loc."&cmd=".$cmd.'&cmd1='.$cmd1.'&id='.$id."&form=".FORM."&sens=".SENS."&rep=".$rep);
                    exit;
                }
                else{
                    $content.= $this->haut();
                    $content.= $this->erreur($wj_messtmp);
                    $content.="<br>".$this->LienNormal(array('url'=>base_url()."filemanager?loc=".$loc."&cmd=".$cmd.'&cmd1='.$cmd1.'&id='.$id."&form=".FORM."&sens=".SENS."&rep=".$rep, 'val'=>"Retour"))."<br>";
                }
                
                break;

            case "upload":
                $rep_source=($rep!=''?'/'.$rep:'');
                $userfile = $_FILES['text1'];
                $name     = $userfile['name'];
                $name     = $this->traite_nom_fichier($name);
                $size     = ($userfile['size']!=0?$userfile['size']/1280:0);
                $file     = $userfile['tmp_name'];
                $error    = $userfile['error']  ;

                
                $destination=$racine.$rep_source.'/'.$name;
                $ext_zip = mb_eregi("\.zip$",$name) ;


                if ( $error == 0 ) {
                    if ($name!='') {
                        $dest = strpos($destination, "//");
                        if ($dest === false) {
                            $d = $destination;
                        } 
                        else{
                            $d = str_replace("//","/",$destination);
                        }

                      
                        if (copy($file, $d)){
                       
                          
                            if($this->is_editable($name))  {
                                $this->enlever_controlM($d);
                            }
                        }
                     
                        if ( $ext_zip && isset($_POST['force_zip'])) {
                            if ( function_exists('zip_open') ) {
                               unzip($file,$racine.$rep_source.'/');
                            } else {
                              
                               require_once("./pclzip.lib.php");
                               $archive = new PclZip($file);
                               if ($archive->extract($racine.$rep_source.'/') == 0) {
                                   die("Error : ".$archive->errorInfo(true));
                               }
                            }
                            DeleteDocument($d);
                        }

                        header("Location:".PAGE."&rep=".$rep);
                        exit;

                    }
                } 
                else {
                    $erreur = array( 1=>"The uploaded file exceeds the upload_max_filesize directive in php.ini.",
                                     2=>"The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form. ",
                                     3=>"The uploaded file was only partially uploaded.",
                                     4=>"No file was uploaded.",
                                     6=>"Missing a temporary folder. Introduced in PHP 4.3.10 and PHP 5.0.3.");
                    haut() ;
                    $messtmp="<font size=\"2\">".$erreur[$error]."</font>";
                    $messtmp.='<br /><br /><a href="javascript:history.back();">'."Retour".'</a>';
                    put('<center><br />'.$messtmp.'</center><br />');
                }

                break;
            case "rename":
                $fic     = $_GET['fic'];
                $nom_fic = basename($fic);

                $content.= $this->haut();
                $content.="<br>";

                $titre = "Renommer" .'&nbsp;<b>'.$nom_fic.'&nbsp;</b>' ;
                $url = PAGE.'&action=rename_suite&rep='.$rep.'&fic='.$fic.'&id='.$id ;
                $form = new HTML_Form($url, '', 90, $titre);
                $form->addText("Renommer",$nom_fic, true,60);
                $form->addSubmit("Renommer","Renommer","","Renommer");

                $content.=$form->toHTML();
                $content.= "<br>";
                $content.=$this->LienNormal(array('url'=>PAGE.'&rep='.$rep, 'val'=>"Retour"));
                break;

            case "rename_suite":
                $err="" ;
                $fic = $_GET['fic'];
                $fic_new = $_POST['text1'];
                $nom_fic=basename($fic);
                $fic_new=$this->traite_nom_fichier($fic_new);
                $old=$racine.$fic;
                $new=dirname($old)."/".$fic_new;

                $messtmp = '' ;
                if($fic_new == "") {
                    $messtmp.="Vous devez saisir un nom de fichier valide"; $err=1;
                }else if(file_exists($new)) {
                    $messtmp.="<b>$fic_new</b> existe d&eacute;jà"; $err=1;
                } else {
                    if(file_exists($old)) {
                        rename($old,$new);
                    }
                    $messtmp.="<b>$fic</b> &eacute;t&eacute; renomm&eacute; en <b>$fic_new</b>";
                }

                if($err=="") {
                    header("Location:".PAGE."&rep=".$rep);
                    exit;
                }
                $content.= haut();
                $content.= $this->erreur($messtmp);
                $content.=BR(2).$this->LienNormal(array('url'=>'javascript:history.back();', 'val'=>"Retour"))."<br><br><br>";
                break;

            default:  

                $content.= $this->haut();
                $content.= $this->lister_rep($rep,$nom_rep,$url_racine,$racine,$gtitre,$select_file);
                $content.= "<br>";
                $titre = '<img src="'.IMAGE_DIR.'upload.gif" align="ABSMIDDLE">Transf&eacute;rer un fichier dans : '.($rep==""?"/":$rep) ;
                $url = PAGE.'&action=upload&rep='.$rep ;
                $form = new HTML_Form($url, '', 90, $titre);
                $form->addTextFile("Select file", '', '', false);
                $form->addCheck('Dezipper automatiquement!#!', '', 'force_zip', 1, 1);
                $form->addSubmit("","Enregister","","Enregister");
                $content.= $form->toHTML();

                $content.= "<br>";
                $titre = '<img src="'.IMAGE_DIR.'dossier.gif" align="ABSMIDDLE">'.("Cr&eacute;er un nouveau r&eacute;pertoire dans : ".($rep==""?"/":$rep)) ;
                $url = base_url().'filemanager?loc='.LOC.'&cmd='.$cmd.'&cmd1='.$cmd1.'&id='.$id.'&form='.FORM.'&action=mkdir&sens='.SENS.'&rep='.$rep;
                $form = new HTML_Form($url, '', 90, $titre);
                $form->addText("Cr&eacute;er un nouveau r&eacute;pertoire dans : ",'', true,60);
                $form->addSubmit("","Enregister","","Enregister");
                $content.= $form->toHTML();
              
                break;
        }

        $this->global['gtitre']  = $gtitre;
        $this->global['content'] = $content;
        $this->loadViews("commun/filemanager/views", $this->global, NULL , NULL);
    }

    public function haut() {
    }

    
    

    public function date_modif($file)   {
        $tmp = filemtime($file);
        return date("d/m/Y H:i",$tmp);
    }

    public function mimetype($file,$quoi) {
        global $wj_mess,$HTTP_USER_AGENT;
        if(!mb_eregi("MSIE",$HTTP_USER_AGENT)) {
            $client="firefox.gif";
        } else {
            $client="html.gif";
        }
        if(is_dir($file)){$image="dossier.gif";$nom_type=$wj_mess[8];}
        elseif(mb_eregi("\.mid$",$file)){$image="mid.gif";$nom_type=$wj_mess[9];}
        elseif(mb_eregi("\.txt$",$file)){$image="txt.gif";$nom_type=$wj_mess[10];}
        elseif(mb_eregi("\.sql$",$file)){$image="txt.gif";$nom_type=$wj_mess[10];}
        elseif(mb_eregi("\.js$",$file)){$image="js.gif";$nom_type=$wj_mess[11];}
        elseif(mb_eregi("\.gif$",$file)){$image="gif.gif";$nom_type=$wj_mess[12];}
        elseif(mb_eregi("\.jpg$",$file)){$image="jpg.gif";$nom_type=$wj_mess[13];}
        elseif(mb_eregi("\.html$",$file)){$image=$client;$nom_type=$wj_mess[14];}
        elseif(mb_eregi("\.htm$",$file)){$image=$client;$nom_type=$wj_mess[15];}
        elseif(mb_eregi("\.rar$",$file)){$image="rar.gif";$nom_type=$wj_mess[60];}
        elseif(mb_eregi("\.gz$",$file)){$image="zip.gif";$nom_type=$wj_mess[61];}
        elseif(mb_eregi("\.tgz$",$file)){$image="zip.gif";$nom_type=$wj_mess[61];}
        elseif(mb_eregi("\.z$",$file)){$image="zip.gif";$nom_type=$wj_mess[61];}
        elseif(mb_eregi("\.ra$",$file)){$image="ram.gif";$nom_type=$wj_mess[16];}
        elseif(mb_eregi("\.ram$",$file)){$image="ram.gif";$nom_type=$wj_mess[17];}
        elseif(mb_eregi("\.rm$",$file)){$image="ram.gif";$nom_type=$wj_mess[17];}
        elseif(mb_eregi("\.pl$",$file)){$image="pl.gif";$nom_type=$wj_mess[18];}
        elseif(mb_eregi("\.zip$",$file)){$image="zip.gif";$nom_type=$wj_mess[19];}
        elseif(mb_eregi("\.wav$",$file)){$image="wav.gif";$nom_type=$wj_mess[20];}
        elseif(mb_eregi("\.php$",$file)){$image="php.gif";$nom_type=$wj_mess[21];}
        elseif(mb_eregi("\.php3$",$file)){$image="php.gif";$nom_type=$wj_mess[22];}
        elseif(mb_eregi("\.phtml$",$file)){$image="php.gif";$nom_type=$wj_mess[22];}
        elseif(mb_eregi("\.exe$",$file)){$image="exe.gif";$nom_type=$wj_mess[50];}
        elseif(mb_eregi("\.bmp$",$file)){$image="bmp.gif";$nom_type=$wj_mess[56];}
        elseif(mb_eregi("\.png$",$file)){$image="gif.gif";$nom_type=$wj_mess[57];}
        elseif(mb_eregi("\.css$",$file)){$image="css.gif";$nom_type=$wj_mess[58];}
        elseif(mb_eregi("\.mp3$",$file)){$image="mp3.gif";$nom_type=$wj_mess[59];}
        elseif(mb_eregi("\.xls$",$file)){$image="xls.gif";$nom_type=$wj_mess[64];}
        elseif(mb_eregi("\.doc$",$file)){$image="doc.gif";$nom_type=$wj_mess[65];}
        elseif(mb_eregi("\.pdf$",$file)){$image="pdf.gif";$nom_type=$wj_mess[79];}
        elseif(mb_eregi("\.mov$",$file)){$image="mov.gif";$nom_type=$wj_mess[80];}
        elseif(mb_eregi("\.avi$",$file)){$image="avi.gif";$nom_type=$wj_mess[81];}
        elseif(mb_eregi("\.mpg$",$file)){$image="mpg.gif";$nom_type=$wj_mess[82];}
        elseif(mb_eregi("\.mpeg$",$file)){$image="mpeg.gif";$nom_type=$wj_mess[83];}
        elseif(mb_eregi("\.swf$",$file)){$image="flash.gif";$nom_type=$wj_mess[91];}
        elseif(mb_eregi("\.xml$",$file)){$image="xml.gif";$nom_type=$wj_mess[91];}
        else {$image="defaut.gif";$nom_type=$wj_mess[23];}
        return($quoi=="image"?$image:$nom_type);
    }

    public function init_rep($rep,$racine){
        $content ="";
        $nom_rep = ($rep==''?$racine:$racine.'/'.$rep);
        
        if(!file_exists($racine)) {
           
            //$content.= "<a href='#'>"."Retour"."</a>";
            $content.= $this->LienNormal(array('url'=>PAGE, 'val'=>"Retour"));
            //exit;
        }
        if(!is_dir($nom_rep)) {
            $content.= 'Ce fichier a &eacute;t&eacute; supprim&eacute;<br /><br />'.$this->LienNormal(array('url'=>'javascript:window.history.back();','val'=>"Retour"));
        }
        return($nom_rep);
    }

    public function assemble_tableaux($t1,$t2) {
        $liste = '' ;
        if(SENS==0) {$tab1=$t1; $tab2=$t2;} else {$tab1=$t2; $tab2=$t1;}
        if(is_array($tab1)) {while (list($cle,$val) = each($tab1)) {$liste[$cle]=$val;}}
        if(is_array($tab2)) {while (list($cle,$val) = each($tab2)) {$liste[$cle]=$val;}}
        return($liste);
    }

    public function txt_vers_html($chaine)  {
        $chaine=str_replace("&#8216;","'",$chaine)  ;
        $chaine=str_replace("&#339;","oe",$chaine)  ;
        $chaine=str_replace("&#8217;","'",$chaine)  ;
        $chaine=str_replace("&#8230;","...",$chaine);
        $chaine=str_replace("&","&amp;",$chaine)    ;
        $chaine=str_replace("<","&lt;",$chaine)     ;
        $chaine=str_replace(">","&gt;",$chaine)     ;
        $chaine=str_replace("\"","&quot;",$chaine)  ;
        $chaine=str_replace("à","&agrave;",$chaine) ;
        $chaine=str_replace("é","&eacute;",$chaine) ;
        $chaine=str_replace("è","&egrave;",$chaine) ;
        $chaine=str_replace("ù","&ugrave;",$chaine) ;
        $chaine=str_replace("â","&acirc;",$chaine)  ;
        $chaine=str_replace("ê","&ecirc;",$chaine)  ;
        $chaine=str_replace("î","&icirc;",$chaine)  ;
        $chaine=str_replace("ô","&ocirc;",$chaine)  ;
        $chaine=str_replace("û","&ucirc;",$chaine)  ;
        $chaine=str_replace("ä","&auml;",$chaine)   ;
        $chaine=str_replace("ë","&euml;",$chaine)   ;
        $chaine=str_replace("ï","&iuml;",$chaine)   ;
        $chaine=str_replace("ö","&ouml;",$chaine)   ;
        $chaine=str_replace("ü","&uuml;",$chaine)   ;
        return $chaine;
    }

    public function listing($nom_rep)   {

        $poidstotal=0;
        $handle=opendir(str_replace("___", "/", $nom_rep));
        $liste_rep = array();
        $liste_fic = array();
        while ($file = readdir($handle)){

            if($file=='.' || $file=='..' ) continue;
            $fileorrep = str_replace("/", "___", $nom_rep.'/'.$file);
            $poidsfic=filesize(str_replace("___", "/", $fileorrep));
            $poidstotal+=$poidsfic;
            if(is_dir($nom_rep.'/'.$file)) {
                $liste_rep[$file]=$file;
            }
            else{
                $liste_fic[$file]=$this->mimetype(str_replace("___", "/", $fileorrep),'image');
            }
        }
        closedir($handle);
     

        if(is_array($liste_fic)) {
            if(SENS==0){
                ksort($liste_fic);
            } else {
                krsort($liste_fic);
            }
        }
        if(is_array($liste_rep)) {
            if(SENS==0){
                ksort($liste_rep);
            }else{
                krsort($liste_rep);
            }
        }
        $liste=$this->assemble_tableaux($liste_rep,$liste_fic);

        return array($liste,$poidstotal);
    }

    public function barre_outil($revenir)   {
        global $user,$wj_mess,$rep ;

        $ret = '' ;
        if($revenir==0) {
            $img = '<img border="0" src="'.IMAGE_DIR.'dossier.gif" width="20" height="20" align="ABSMIDDLE">';
            $ret.= "<a href='".PAGE."'>".$img."</a>";
            //$ret.= $this->LienNormal(array('url'=>PAGE, 'val'=>$img));
        }


        if($revenir==1) {
            $url = PAGE."&rep=$rep";
        } 
        else {
            $url = PAGE;
        }

        if($revenir==1) {
            $val = "Retour";
        } 
        else {
            $val = $user ;
        }
        
        $ret.= "<a href='".$url."'>".$val."</a>";
        if($revenir==1) {
            $ret.= "Retour</a>";
        }
    
        else {
            $ret.= "$user</a>";
            if(strpos($rep,"/")){
                $array_chemin=explode("/",$rep);
                $addchemin = '' ;

                while (list($cle,$val) = each($array_chemin)) {
                    if($val!="") {
                        if($addchemin!="") {
                            $addchemin=$addchemin."/".$val;
                        } else {
                            $addchemin=$val;
                        }
                        $ret.= '/'.($this->LienNormal(array('url'=>PAGE.'&rep='.$addchemin,'val'=>$val)));
                    }
                }
            }
        }

        return($ret);
    }

    public function contenu_dir($rep,$nom_rep,&$table,$racine,$select_file) {
        global $poidstotal,$wj_mess;

        list($liste,$poidstotal)=$this->listing($nom_rep);
        if(is_array($liste)) {
            $i = 0 ;
            while (list($file,$mime) = each($liste))    {
                $affiche_copier=false;
                if(is_dir("$nom_rep/$file"))    {

                    $repertoiref = ($rep!=""?"$rep/":"").$file;
                    $lien = PAGE."&rep=".$repertoiref ;
                } 
                else{
                    $lien = ($rep!=""?"$rep/":"").$file ;
                    $lien = "javascript:popup('$lien')";
                    $affiche_copier=true;
                }

                $codeHTML1 = '' ;
                $img = '<img src="'.IMAGE_DIR.$this->mimetype("$nom_rep/$file","image").'" width="20" height="20" align="ABSMIDDLE" border="0">';
                if ( is_dir("$nom_rep/$file")) {
                    $codeHTML1.= $this->LienNormal(array('url'=>$lien, 'val'=>"$img.$file"));
                }
                elseif( $this->is_editable($file) || $this->is_image($file) ) {
                    if ( $select_file ) {
                        $selection = str_replace($racine,'',$nom_rep.'/'.$file);
                        $click = "onclick=\"javascript:opener.document.forms['".FORM."'].support.value = '".$selection."';window.close();\"";
                        $codeHTML1.= $this->LienNormal(array('url'=>'#', 'action'=>$click, 'val'=>$img.$file));
                    } 
                    else {
                        $codeHTML1.= $img.$file;
                    }
                    $codeHTML1.= " ".$this->LienNormal(array('url'=>$lien, 'val'=>IMG_VOIR));
                } 
                else {
                    if ( $select_file  ) {
                        $selection = str_replace($racine,'',$nom_rep.'/'.$file);
                        $click = "onclick=\"javascript:opener.document.forms['".FORM."'].support.value = '".$selection."';window.close();\"";
                        $codeHTML1.= $this->LienNormal(array('url'=>'#', 'action'=>$click, 'val'=>$img.$file));
                    } 
                    else {
                        $codeHTML1.= $img.$file;
                    }
                }

                // AFFICHAGE DE LA LIGNE/COLONNE 2
                $codeHTML2 = $this->taille($nom_rep.'/'.$file) ;

                // AFFICHAGE DE LA LIGNE/COLONNE 3
                $codeHTML3 = '' ;

                //$loc,$cmd,$cmd1,$id,$typeprgr,$action,$repertoire=""

                $urlrename = PAGE.'&action=rename&rep=';
                $urlrename.= ($rep!=''?$rep.'&fic='.$rep."/":'&fic=').$file ;
                $codeHTML3.= $this->LienNormal(array('url'=>$urlrename,'val'=>IMG_MODIF));
                $codeHTML3.= " " ;

                // IMAGE SUPPRIMER
                $urldel = PAGE.'&action=supprimer&rep=' ;
                $urldel.= ($rep!=''?$rep.'&fic='.$rep."/":'&fic=').$file ;
                $codeHTML3.= $this->LienNormal(array('url'=>$urldel, 'val'=>IMG_DEL));
                $codeHTML3.= " " ;

                // IMAGE TELECHARGER
                if($affiche_copier) {
                    $urldownload = PAGE.'&action=telecharger&fichier='.($rep!=''?$rep.'/':'').$file ;
                    $codeHTML3.= $this->LienNormal(array('url'=>$urldownload, 'val'=>IMG_DNL));
                } 
                elseif (function_exists('zip_open')) {
                    $urldownloadzip = PAGE.'&action=telechargerzip&fichier='.($rep!=''?$rep.'/':'').$file ;
                    $codeHTML3.= $this->LienNormal(array('url'=>$urldownloadzip, 'val'=>IMG_ARCHIVE));
                }
                //die("codeHTML1 : ".$codeHTML1." codeHTML2 : ".$codeHTML2);
                $table->addRow(array($codeHTML1,$codeHTML2,$codeHTML3));
            }
        }
    }
    public function is_editable($file) {
        return(mb_eregi("\.txt$|\.sql$|\.php$|\.php3$|\.phtml$|\.htm$|\.html$|\.cgi$|\.pl$|\.js$|\.css$|\.inc$|\.bat$",$file));
    }
    public function is_image($file) {
        return(mb_eregi("\.png$|\.bmp$|\.jpg$|\.jpeg$|\.gif$",$file));
    }

    public function lister_rep($rep,$nom_rep,$url_racine,$racine,$gtitre,$select_file) {

        if(mb_eregi("\.\.",$rep)) {$rep="";}
              
      
        $nom_rep=$this->init_rep($rep,$racine);
        $outils = $this->barre_outil(0);
        $sens = (SENS==1?0:1);

        $js = '<script language="javascript">';
        $js.= 'function popup(lien) {';
        $js.= "var fen = window.open('".PAGE."&action=voir&fichier='+lien,'vfilemanager','status=yes,scrollbars=yes,resizable=yes,width=600,height=400');";
        $js.= '}';
        $js.='</script>';

        if($rep!=""){$lien="&rep=".$rep;}

        $arrayPropCol = array(60, 20, 20);
        $refresh = $this->LienNormal(array('url'=>'javascript:location.reload();','val'=>'<img align="ABSMIDDLE" src="'.IMAGE_DIR.'refresh.gif" alt="Actualiser" border="0">'));
        $refresh.= $this->LienNormal(array('url'=>PAGE.'&sens='.$sens,'val'=>"Nom du fichier"));

        $refresh.= '&nbsp;&nbsp;<img src="'.IMAGE_DIR.'fleche'.$sens.'.gif" width="10" height="10">';
        $arrayTitres  = array($refresh,"Taille","Actions");
        $table = "";
        $table = new HTML_Table_Admin($arrayPropCol, 95, $arrayTitres);

        if($rep!=""){

            $nom=dirname($rep);
            $url = PAGE.(($rep!=$nom && $nom!=".")?"&rep=".$nom:"") ;
            $lien = $this->LienNormal(array('url'=>$url,'val'=>'<img src="'.IMAGE_DIR.'/parent.gif" width="20" height="20" align="ABSMIDDLE" border="0">Dossier parent'));
            $table->addRow(array($lien,"",""));
            $table->addRow(array("","",""));
        }
        $this->contenu_dir($rep,$nom_rep,$table,$racine,$select_file);

        return($outils.$js.$table->toHTML()."<br>");
      
    }

    public function wj_deldir($location) {
        if(is_dir($location)){
            $all=opendir($location);
            while ($file=readdir($all)) {
                if (is_dir("$location/$file") && $file !=".." && $file!=".") {
                    $this->wj_deldir("$location/$file");
                    if(file_exists("$location/$file")){
                        rmdir("$location/$file");
                    }
                    unset($file);
                }elseif (!is_dir("$location/$file")) {
                    if(file_exists("$location/$file")){
                        unlink("$location/$file");
                    }
                    unset($file);
                }
            }
            closedir($all);
            rmdir($location);
        } else {
            if(file_exists("$location")) {
                unlink("$location");
            }
        }
    }

    public function enlever_controlM($file) {
        $fic=file($file);
        $fp=fopen($file,"w");
        while (list ($cle, $val) = each ($fic)) {
            $val=str_replace(CHR(10),"",$val);
            $val=str_replace(CHR(13),"",$val);
            fputs($fp,"$val\n");
        }
        fclose($fp);
    }

    public function traite_nom_fichier($nom) {
        $max_caracteres = 80;
        $nom=stripslashes($nom);
        $nom=str_replace("'","",$nom);
        $nom=str_replace("\"","",$nom);
        $nom=str_replace("\"","",$nom);
        $nom=str_replace("&","",$nom);
        $nom=str_replace(",","",$nom);
        $nom=str_replace(";","",$nom);
        $nom=str_replace("/","",$nom);
        $nom=str_replace("\\","",$nom);
        $nom=str_replace("`","",$nom);
        $nom=str_replace("<","",$nom);
        $nom=str_replace(">","",$nom);
        $nom=str_replace(" ","_",$nom);
        $nom=str_replace(":","",$nom);
        $nom=str_replace("*","",$nom);
        $nom=str_replace("|","",$nom);
        $nom=str_replace("?","",$nom);
        $nom=str_replace("é","e",$nom);
        $nom=str_replace("è","e",$nom);
        $nom=str_replace("ç","c",$nom);
        $nom=str_replace("@","",$nom);
        $nom=str_replace("â","a",$nom);
        $nom=str_replace("ê","e",$nom);
        $nom=str_replace("î","i",$nom);
        $nom=str_replace("ô","o",$nom);
        $nom=str_replace("û","u",$nom);
        $nom=str_replace("ù","u",$nom);
        $nom=str_replace("à","a",$nom);
        $nom=str_replace("!","",$nom);
        $nom=str_replace("§","",$nom);
        $nom=str_replace("+","",$nom);
        $nom=str_replace("^","",$nom);
        $nom=str_replace("(","",$nom);
        $nom=str_replace(")","",$nom);
        $nom=str_replace("#","",$nom);
        $nom=str_replace("=","",$nom);
        $nom=str_replace("$","",$nom);
        $nom=str_replace("%","",$nom);
        $nom = substr ($nom,0,$max_caracteres);
        return $nom;
    }


    public function LienNormal($link) {
        $over  = 'onMouseOver="window.status=\'\';return true;" ' ;
        $out   = 'onMouseOut="window.status=\'\';return true;" ' ;
        $target = isset($link['target'])?'target="'.$link['target'].'"':'';
        $action = isset($link['action'])?$link['action']:$over.$out;
        $ret = '<a href="'.$link['url'].'" '.$action.' '.$target.' class="lien" >'.$link['val'].'</a>' ;
        return($ret);
    }
    
    public function taille($fichier) {
        global $st_texte ;
        if ( ! is_file($fichier)) {
          return('');
        }
        $taille=filesize($fichier);
        if ( $taille >= 1073741824 ) {
            $taille = round($taille / 1073741824 * 100) / 100 . " ".$st_texte['go'] ;
        } elseif ( $taille >= 1048576 ) {
            $taille = round($taille / 1048576 * 100) / 100 . " ".$st_texte['mo']    ;
        } elseif ( $taille >= 1024 ) {
            $taille = round($taille / 1024 * 100) / 100 . " ".$st_texte['ko']       ;
        } else {
            $taille = $taille . "  ".$st_texte['octets'];
        }
        if( $taille == 0 ) {
            $taille="-";
        }
        return($taille);
    }
   
   public function erreur($txt,$center=false) {
      if ( trim($txt) == '' ) return('');
      $center = $center?'align="center"':'';
        return('<div '.$center.' class="error">'.$txt.'</div>') ;
    }

    public function PageErreur() {
        Header("Location: ".HTTP_ERROR );
        exit();
    }

    function scann($diir) {
        global $ClsZip,$racinezip;
        $fold=@opendir($diir);
        while ($fichier=readdir($fold)) {
            if ($fichier!="." && $fichier!="..") {
                if (is_dir("$diir/$fichier")) {
                    $this->scann("$diir/$fichier");
                } else {
                    $fp = @fopen ("$diir/$fichier", 'r');
                    if ($fp) {
                        $content = fread($fp, filesize("$diir/$fichier"));
                        fclose ($fp);
                        $name="$diir/$fichier";
                        $name=substr($name,strlen($racinezip)+1);
                        $ClsZip->addfile($content, $name);
                    }
                }
            }
        }
    }

}

?>