<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';
require APPPATH . '/libraries/google/vendor/autoload.php';
use Google\Cloud\Translate\V2\TranslateClient;

class ExpressionRecording extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('ExpressionRecording_model');
        $this->load->model('CategoryExpression_model');
        $this->tracking_type = 968;
        $this->isLoggedIn();  
        $this->loadTrackingEl(0,0,$this->tracking_type); 
        $this->translate = new TranslateClient([
            'key' => $this->config->item('google_api_key')
        ]);
    }

    public function index(){
        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('booster_expression_recording');
        $data['idGroupe']          = $this->isTuteurConnet() ? $this->session->userdata('STAGIAIREGRP') : $this->session->userdata('GROUPE');
        $data['resultsNotInCat']   = $this->ExpressionRecording_model->getAllByGroupNotInCategory($data['idGroupe']);
        $data['allCategoryResult'] = $this->CategoryExpression_model->getCategoryByIdGroup($data['idGroupe']);
        $data['allResults']        = $this->ExpressionRecording_model->getAllByGroup($data['idGroupe']);
        $data['langageList']         = $this->databankExpression_model->getLangageList();
        $views                     = $this->isTuteurConnet() ? "tutor/e-databank/list-recording" : "trainee/e-databank/list-recording";
        $this->loadViews($views, $this->global,$data, NULL );
    }

    public function add(){
        $return = array();
        if (isset($_POST)) {
            $return['_POST'] = $_POST;
            try{

                $data = array(
                    'name_audio'                => $_POST['fileExpressionRecording'],
                    'timer'                     => $_POST['timeExpressionRecording'],
                    'transcription_langage'     => (isset($_POST['transcriptionLanguageForm']) && $_POST['transcriptionLanguageForm'] == 'fr-FR') ? 5 : 1,
                    'transcription'             => isset($_POST['transcription-expression-recording']) ? $_POST['transcription-expression-recording'] : '',
                    'translate_langage'         => (isset($_POST['translateLanguage']) && $_POST['translateLanguage'] == 'fr-FR') ? 5 : 1,
                    'translation'               => isset($_POST['text_langage_cible_exp']) ? $_POST['text_langage_cible_exp'] : '',
                    'user_create'               => $this->session->userdata('GUSERID'),
                    'id_groupe'                 => $this->isTuteurConnet() ? $this->session->userdata('STAGIAIREGRP') : $this->session->userdata('GROUPE'),
                    'id_category'                => $_POST['category_expression_recorder'],
                    'date'                      => time()
                );

                $return = array(
                    'status'   => true,
                    'message'  => $this->ExpressionRecording_model->add($data),
                    'category' => $_POST['category_expression_recorder'],
                );
            }
            catch (Exception $e) {

                $return = array(
                    'status' => false,
                    'message' => $e->getMessage(),
                    'category' => $_POST['category_expression_recorder'],
                );
            }
        }
        echo json_encode($return);
    }

    public function transcript(){
        $return = array();
        $target = '';
        if (isset($_POST)) {
            $return['_POST'] = $_POST;
            $audioFile = $_FILES['fileUpload']; 

            try{

                $idGroupe = '';

                if ($this->isTuteurConnet()) {
                    $idGroupe = $this->session->userdata('STAGIAIREGRP');
                }
                else{
                    $idGroupe = $this->session->userdata('GROUPE');
                }

                $numero_audio = $this->ExpressionRecording_model->getMaxId() + 1;

                $fileName = $idGroupe."_".$numero_audio.".wav";

                $fullpath = RP_GROUPES."GRP".$idGroupe;
                if ( ! is_dir($fullpath) ) {
                    mkdir($fullpath, 0777,true);
                } 

                $upload = move_uploaded_file($audioFile['tmp_name'], $fullpath.'/'.$fileName);

                if (isset($_POST['transcriptionLanguage']) && $_POST['transcriptionLanguage'] == "en-US") {
                    $transcriptionLinkF = 'transcription';
                    $target        = 'fr';
                }
                else{
                    $transcriptionLinkF = 'transcription_fr2';
                    $target        = 'en';
                }

                $audioLink = base_url().'groupes/GRP'.$idGroupe.'/'.$fileName;

                $transcription = (isset($audioLink) && isset($transcriptionLinkF)) ? $this->getInfosTranscript($transcriptionLinkF.'?audio_link='.$audioLink) : '';
                $transcriptionFinal = isset($transcription) ? str_replace('\n','<br>',$transcription) : '';
                $transcriptionFinal1 = isset($transcriptionFinal) ? str_replace('"','',$transcriptionFinal) : '';
                $return = array(
                    'status'      => true,
                    'message'     => $transcriptionFinal1,
                    'target'      => $target,
                    'fileName'    => $fileName,
                    'repFileName' => $fullpath.'/'.$fileName,
                    'audioLink'   => $audioLink,
                    'audioFile'   => $audioFile,
                );
            }
            catch (Exception $e) {

                $return = array(
                    'status' => false,
                    'message' => $e->getMessage(),
                );
            }


            if (isset($return['status']) && $return['status'] == true && isset($translate_language) && $translate_language != '') {
                //$return['translation'] = $this->translateSentence('fr', 'test value of string');
            }
        }
        echo json_encode($return);
    }

    public function delete(){
        $return = array();
        if (isset($_POST['expression_recording_id'])) {
            $idGroupe = $this->isTuteurConnet() ? $this->session->userdata('STAGIAIREGRP') : $this->session->userdata('GROUPE');
            $fileDirectory = RP_GROUPES."GRP".$idGroupe."/".$this->ExpressionRecording_model->Request('name_audio',$_POST['expression_recording_id']);
            if (is_file($fileDirectory)) {
                unlink($fileDirectory);
            }
            $return['status'] = $this->ExpressionRecording_model->delete($_POST['expression_recording_id']);
        }
        echo json_encode($return);
    }

    public function update(){
        $return = array();
        if (isset($_POST['expressionRecordingId'])) {
            $data = array(
                $_POST['cible'] => $_POST['sentence']
            );
            $return['status'] = $this->ExpressionRecording_model->update($_POST['expressionRecordingId'], $data);
        }
        echo json_encode($return);
    }

    public function unlinkFile(){
        $return = array();
        if (isset($_POST['rep'])) {
            $return['status'] = unlink($_POST['rep']);
        }
        echo json_encode($return);
    }

    public function translate(){
        $return = array();
        if (isset($_POST['translate_language']) && isset($_POST['text_to_translate']) && $_POST['text_to_translate'] != '' && $_POST['translate_language'] != '') {
            $json = $this->translateSentence($_POST['text_to_translate'], $_POST['translate_language']);
            $return['status'] = true;
            $return['result'] = $json;
            $return['transcriptionResult'] = $this->convert_utf8($json['text']);
        }
        else{
            $return = array(
                'status'              => false,
                'result'              => '',
                'transcriptionResult' => '',
            );
        }
        echo json_encode($return);
    }

    public function translateSentence($translate_language, $text_to_translate){

        return $this->translate->translate(
            "".$translate_language."", [
                'target' => "".$this->convert_utf8($text_to_translate).""
            ]
        );

    }

}

?>
