<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

class ExpressionDatabank extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
        $this->tracking_type = 39;  
        $this->load->model('Rework_audio_model');
    }
    
    public function getListLangage(){
        $retour = "";
        $result = $this->databankExpression_model->getListLangage();
        foreach ($result as $l) {
            if (isset($_GET['optionSelect']) && $_GET['optionSelect'] != "" &&  $_GET['optionSelect'] == $l->id){
                $retour .="<option value='".$l->id."' selected=selected>".$l->intitule."</option>";
            }else{
                $retour .="<option value='".$l->id."'>".$l->intitule."</option>";
            }
        }
        echo $retour;
    }

    public function add(){
        $this->loadTrackingEl(0,0,$this->tracking_type);
        $this->form_validation->set_rules('original_text_langage', $this->lang->line('training_expression_new_expression_language_Origin'), 'required');
        $this->form_validation->set_rules('target_text_langage', $this->lang->line('training_expression_new_expression_language_cible'), 'required');
        $this->form_validation->set_rules('langage_traduction', $this->lang->line('training_expression_new_expression_language_tr'), 'required');
        $this->form_validation->set_rules('category', $this->lang->line('training_expression_new_expression_cat'), 'required');

        if($this->form_validation->run() == FALSE)
        {
            $this->data['target_text_langage'] = array(
                'type'  => 'text',
                'name'  => 'target_text_langage',
                'id'    => 'target_text_langage',
                'value' => $this->form_validation->set_value('target_text_langage'),
                'class' => 'form-control'
            ); 
            $this->data['original_text_langage'] = array(
                'type'  => 'text',
                'name'  => 'original_text_langage',
                'id'    => 'original_text_langage',
                'value' => $this->form_validation->set_value('original_text_langage'),
                'class' => 'form-control'
            ); 
            $errors = validation_errors();
            $this->session->set_flashdata('message', $errors);
            $this->data['target_language'] = $this->databankExpression_model->getListLangage();


            $this->global['pageTitle']     ="Add new expression";

             redirect("/expression","refresh");
        }
        else
        {
            $idTraineer = NULL;
            if($this->isTuteurConnet()){
                $idTraineer = $this->session->userdata('GUSERID');
            }
            $data = array(
                'content_langue_origine' => $this->input->post('original_text_langage'),
                'id_stagiaire'           => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'),                
                'id_category'            => $this->input->post('category'),         
                'target_langue_cible'    => $this->input->post('langage_traduction'),
                'content_langue_cible'   => $this->input->post('target_text_langage'),
                'user_create'            => $this->session->userdata('GUSERID'),
                'date_creation'          => date("Y-m-d H:i:s"),
                'id_tuteur'                       => isset($idTraineer) ? $this->session->userdata('GUSERID') : NULL,
            );          

            $this->databankExpression_model->addExpression($data);
            $this->session->set_flashdata('message', "Expression add succefully");
            if($this->isTuteurConnet()){
                redirect("/tutorExpression","refresh");
            }
            else{
                redirect("/expression","refresh");
            }        
        }
    }
    public function del(){
        if (isset($_GET) && $_GET['id'] != "") {
            $this->databankExpression_model->deleteExpression($_GET['id']);
        }
    }
    
    public function view(){
        if ( isset($_POST['id']) && $_POST['id'] != "" )
        {
            
            $exp                                      = $this->databankExpression_model->Expression($_POST['id'])->row();
            $dataExpression                           = array();
            $dataExpression['id_expression']          = $exp->id_expression;
            $dataExpression['id_stagiaire']           = $exp->id_stagiaire;
            $dataExpression['id_tuteur']              = $exp->id_tuteur;
            $dataExpression['langue']                 = $exp->langue;
            $dataExpression['content_langue_origine'] = $exp->content_langue_origine;
            $dataExpression['target_langue_cible']    = $exp->intitule;
            $dataExpression['content_langue_cible']   = $exp->content_langue_cible;
            $dataExpression['audio_langue_origine']   = $exp->audio_langue_origine;
            $dataExpression['audio_langue_cible']     = $exp->audio_langue_cible;
            $dataExpression['date_creation']          = $exp->date_creation; 

            echo json_encode($dataExpression);

        }
    }

    public function edit(){
        $this->loadTrackingEl(0,0,$this->tracking_type);
        $this->form_validation->set_rules('target_text_langage', 'lang:original_text_langage', 'required');
        $this->form_validation->set_rules('target_text_langage', 'lang:target_text_langage', 'required');

        if($this->form_validation->run() == FALSE)
        {
            redirect('expression', 'refresh');
        }
        else
        {
            $data = array(
                'content_langue_origine' => $this->input->post('original_text_langage'),
                'target_langue_cible'    => $this->input->post('target_langage'),
                'date_creation'          => date("Y-m-d H:i:s"),
                'content_langue_cible'   => $this->input->post('target_text_langage')
            );          

            if ($this->databankExpression_model->editExpression($this->input->post('idE'),$data)){
                redirect('expression', 'refresh');
            }
        }
    }

    public function ajaxEdition()
    {
        if (isset($_POST['dataExpression'])) {

            $data = array(
                'content_langue_origine'          => $_POST['dataExpression']['original_text_langage_mod'],
                'target_langue_cible'             => $_POST['dataExpression']['langage_traduction_mod'],
                'id_category'                     => $_POST['dataExpression']['category_mod'],
                'content_langue_cible'            => $_POST['dataExpression']['target_text_langage_mod'],
                'date_creation'                   => date("Y-m-d H:i:s")
            );
            $this->databankExpression_model->editExpression($_POST['dataExpression']['expression_infos_id_mod'], $data);
            $data['expression_infos_id_mod'] = $_POST['dataExpression']['expression_infos_id_mod'];
            echo json_encode($data);
        }
    }

    public function editExpressionOrigin()
    {
        $return = array();
        if (isset($_POST['idExpression'])) {

            $data = array(
                'content_langue_origine'          => $_POST['contentOrigin'],
                'date_creation'                   => date("Y-m-d H:i:s")
            );
            $return['infosSql'] = $this->databankExpression_model->editExpression($_POST['idExpression'],$data);
            $return['editId'] = $_POST['idExpression'];
            $return['origin'] = $_POST['contentOrigin'];
            echo json_encode($return);
        }
    }

    public function editContentExpressionOrigin()
    {
        $return = array();
        if (isset($_POST['idExpression'])) {

            if (isset($_POST['request']) && $_POST['request'] == "origin") { 
                if (isset($_POST['langage']) && $_POST['langage'] == "fr") {                    
                    $data = array(
                        'content_langue_cible'           => $_POST['contentOrigin'],
                        'date_creation'                   => date("Y-m-d H:i:s")
                    );
                }
                else{                    
                    $data = array(
                        'content_langue_origine'          => $_POST['contentOrigin'],
                        'date_creation'                   => date("Y-m-d H:i:s")
                    );
                }
                $return['infosSql'] = $this->databankExpression_model->editExpression($_POST['idExpression'],$data);
            }
            else{
                $data = array(
                    'transcription_en'                => $_POST['contentOrigin'],
                    'date'                            => time()
                );
                $return['data'] = $data;
                $return['infosSql'] = $this->Rework_audio_model->update($_POST['idExpression'],$data);
            }
            $return['editId'] = $_POST['idExpression'];
            $return['origin'] = $_POST['contentOrigin'];
            echo json_encode($return);
        }
    }

    public function editExpressionCible()
    {
        $return = array();
        if (isset($_POST['idExpression'])) {

            $data = array(
                'content_langue_cible'          => $_POST['contentCible'],
                'date_creation'                   => date("Y-m-d H:i:s")
            );
            $return['infosSql'] = $this->databankExpression_model->editExpression($_POST['idExpression'],$data);
            $return['editId'] = $_POST['idExpression'];
            echo json_encode($return);
        }
    }

    public function record(){
        $this->global['pageTitle'] = 'Record audio';
        if (isset($_GET) && $_GET['id'] != NULL) {
            $this->loadViews("trainee/e-databank/record", $this->global, NULL , NULL);
        }
    }

    public function uploadaudio(){
        if (isset($_GET) && $_GET['id'] != NULL) {
            $repgrp = RP_GROUPES."GRP".$this->session->userdata('GROUPE')."/expression/";
            if ( ! is_dir($repgrp) ) {
                mkdir($repgrp, 0777,true);
            }
            $size = $_FILES['audio_data']['size']; 
            $input = $_FILES['audio_data']['tmp_name'];

            $output = $this->session->userdata ('GUSERID')."_".time().".mp3";
            $destination = $repgrp.$output;
            if(@move_uploaded_file($input, $destination)){
                $data = array('audio_langue_origine' => $output);
                $this->databankExpression_model->addOriginAudio($_GET['id'],$data);
                echo '###'.$destination;
            }
            else{
                echo '###vvvvv'.$repgrp;
            }
        }
    }

    public function export(){
        $exporter = new ExportDataExcel('browser', 'Export_expression.xls');
        $exporter->initialize();
        $exporter->addRow(array("Origin", "Langage cible", "Cible", "Creation date")); 
        if (isset($_POST)) {
            $result = $this->databankExpression_model->listExpression($this->session->userdata ('GUSERID'),$_POST['key'],$_POST['startDate'],$_POST['endDate'])->result();
            foreach ($result as $res) {
                $exporter->addRow(array($res->content_langue_origine,$res->intitule,$res->content_langue_cible,$res->date_creation));   
            }
        }
        $exporter->finalize();
        exit();
    }

    public function addTherme(){
        $return = array();
        if (isset($_POST['dataSerialise'])) {
            $data = array(
                'content_langue_origine' => $_POST['dataSerialise']['original-therme'],
                'id_stagiaire'           => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'),                
                'id_category'            => isset($_POST['dataSerialise']['category-expression']) ? $_POST['dataSerialise']['category-expression'] : NULL,         
                'target_langue_cible'    => 5,
                'content_langue_cible'   => $_POST['dataSerialise']['traduction-therme'],
                'user_create'            => $this->session->userdata('GUSERID'),
                'langue'                 => 'en',
                'date_creation'          => date("Y-m-d H:i:s"),
                'id_tuteur'              => $this->isTuteurConnet() ? $this->session->userdata ('GUSERID') : NULL,
            );          

            $return['id'] = $this->databankExpression_model->addExpression($data);
            $return['status'] = true;
        }
        echo json_encode($return);
    }

    
}
