<?php
    if(!defined('BASEPATH')) exit('No direct script access allowed');
    require APPPATH . '/libraries/CreatorJwt.php';

    class TokenElearning extends CI_Controller
    {
        public function __construct()
        {
            
            parent::__construct();
            $this->load->model('Societe_model');
            $this->load->model('Stag_individu_model');
            $this->load->model('Membres_model');
            $this->load->model('login_model');
            $this->load->model('connexion_model');
            $this->load->model('groupes_model');
            $this->load->model('historik_course_nl_model');
            $this->load->model('classificationFavoris_Model');
            $this->objOfJwt = new CreatorJwt();
            header('Content-Type: application/json');
        }

        /*************Ganerate token this function use**************/

        public function GenerateToken(){
        	$tokenData                = array();
            $return                   = array();
            $error                    = array();
        	$tokenGenerationStatus    = false;
        	if (isset($_GET['refindividu']) && isset($_GET['role']) && isset($_GET['stage'])) {
                $tokenData['tokenNumStage']    = $_GET['stage'];
                switch ($_GET['role']) {
                    case 'intern':
                        $allResultFromMember               = $this->Stag_individu_model->getLastMembersByStageExtranetId($_GET['stage'], $_GET['refindividu']);
                        if (isset($allResultFromMember) && count($allResultFromMember) >= 1) {
                            // check date limit date access
                            if(!empty($allResultFromMember[0]->date_fin_acces) && $allResultFromMember[0]->date_fin_acces+((24*3600)+(60*60)+60) <= time()) {
                                $tokenGenerationStatus    = false;
                                $error['error'] = 'Date d\'accés à la plateforme expiré';

                            }
                            else{
                                $tokenGenerationStatus    = true;
                                $tokenData['tokenMemberId']    = $allResultFromMember[0]->id;
                                $tokenData['tokenTraineeId']   = $allResultFromMember[0]->id;
                                $tokenData['tokenRefIndividu'] = $allResultFromMember[0]->extranetId;
                                $tokenData['tokenGroupId']     = $allResultFromMember[0]->idGroupe;
                            }
                        }
                        $tokenData['tokenUserRole']        = STAGIAIRE;
                        break;
                    case 'prof':
                        $allResultFromMember               = $this->Membres_model->getProfByExtranetId($_GET['refindividu']);
                        if (isset($allResultFromMember) && count($allResultFromMember) >= 1) {
                            if(!empty($allResultFromMember[0]->date_fin_acces) && $allResultFromMember[0]->date_fin_acces+((24*3600)+(60*60)+60) <= time()) {
                                $tokenGenerationStatus    = false;
                                $error['error'] = 'Date d\'accés à la plateforme expiré';

                            }
                            else{
                                $tokenGenerationStatus         = true;
                                $dateNow                       = time();
                                $tokenGroupId                  = $_GET['stage'] == '' ? null : $this->Membres_model->Request('id_groupe',$this->Stag_individu_model->getMaxIdMembresByStage($_GET['stage']));
                                $tokenTraineeId                = $_GET['stage'] == '' ? null : $this->Stag_individu_model->getMaxIdMembresByStage($_GET['stage']);
                                $tokenData['tokenMemberId']    = $allResultFromMember[0]->id;
                                $tokenData['tokenTraineeId']   = $tokenTraineeId;
                                $tokenData['tokenRefIndividu'] = $allResultFromMember[0]->extranet_id;
                                $tokenData['tokenGroupId']     = $tokenGroupId;

                                if($_GET['stage'] != ''){
                                    // on verifie si le stagiaire est affecté au prof
                                    $allResultListGroup = $this->groupes_model->GetInfosTuteur($tokenGroupId,$allResultFromMember[0]->id);
                                    if (isset($allResultListGroup) && count($allResultListGroup) < 1) {
                                        // on réaffecte le stagiaire    
                                        $dataListGroup = array(
                                            'id_groupe'        => $tokenGroupId,
                                            'name'             => $this->Membres_model->Request('prenom',$tokenTraineeId).' '.$this->Membres_model->Request('nom',$tokenTraineeId),
                                            'code'             => 'G'.($tokenGroupId < 10 ? '0'.$tokenGroupId : $tokenGroupId),
                                            'id_tuteur'        => $allResultFromMember[0]->id,
                                            'repertoire'       => 'GRP'.$tokenGroupId,
                                            'glossaireenligne' => 0,
                                            'date_modif'       => $dateNow,
                                        );
                                        $this->groupes_model->addlistgrp($dataListGroup);
                                    }

                                    $resultGroup = $this->groupes_model->getAllByTrainneIdGroupId($tokenTraineeId,$tokenGroupId);
                                    if (count($resultGroup) < 1) {
                                        $dataGroups = array(
                                            'id_groupe'  => $tokenGroupId,
                                            'id_membres' => $tokenTraineeId,
                                            'langue'     => 'Anglais',
                                            'prototype'  => 0,
                                            'date_modif' => $dateNow
                                        );
                                        $this->groupes_model->addgrp($dataGroups);
                                    }

                                }
                            }
                            
                        }
                        $tokenData['tokenUserRole']        = TUTEUR ;
                        break;
                    
                    default:
                        // code...
                        break;
                }
        	}
            elseif (isset($_GET['auth']) && isset($_GET['folow']) && $_GET['auth'] == true && $_GET['folow'] != '') {
                $tokenGenerationStatus         = true;
                $allResultFromMember           = $this->Membres_model->getById($_GET['folow']);
                $tokenData['tokenMemberId']    = isset($allResultFromMember[0]->id) ? $allResultFromMember[0]->id : NULL;
                $tokenData['tokenUserRole']    = (isset($allResultFromMember[0]->type) && $allResultFromMember[0]->type == 0) ? STAGIAIRE : TUTEUR;
            }
            else{

            }

        	if (isset($tokenData) && !empty($tokenData) && $tokenGenerationStatus) {    		
                $tokenData['timeStamp'] = Date('Y-m-d h:i:s');
    	        $return['Token']    = $this->objOfJwt->GenerateToken($tokenData);
        	}
        	else{
                $return['Token']    = false;
        		$return['error']    = $error;
        	}

            if (isset($_GET['cible']) && $_GET['cible'] != '') {
                $this->loadSessionElearning($_GET['cible'],$return);
            }
            else{
                echo json_encode($return);
            }
        }
         
        /*************Use for token then fetch the data**************/
             
        public function DecodeToken($token){
            $return = array();
        	//$received_Token = $this->input->request_headers('Authorization');
            try{
                //$jwtData = isset($received_Token['Token']) ? $this->objOfJwt->DecodeToken($received_Token['Token']) : '';
                $jwtData = isset($token) ? $this->objOfJwt->DecodeToken($token) : '';
                $return = array( 
                    "tokenMemberId"    => isset($jwtData['tokenMemberId']) ? $jwtData['tokenMemberId'] : NULL, 
                    "tokenUserRole"    => isset($jwtData['tokenUserRole']) ? $jwtData['tokenUserRole'] : NULL, 
                    "tokenNumStage"    => isset($jwtData['tokenNumStage']) ? $jwtData['tokenNumStage'] : NULL, 
                    "tokenRefIndividu" => isset($jwtData['tokenRefIndividu']) ? $jwtData['tokenRefIndividu'] : NULL, 
                    "tokenGroupId"     => isset($jwtData['tokenGroupId']) ? $jwtData['tokenGroupId'] : NULL,
                    "tokenTraineeId"   => isset($jwtData['tokenTraineeId']) ? $jwtData['tokenTraineeId'] : NULL,  
                    "timeStamp"        => isset($jwtData['timeStamp']) ? $jwtData['timeStamp'] : NULL, 
                    "response"         => 302, 
                    "status"           => true, 
                    "message"          => ''
                );
            }
            catch (Exception $e){
                $return = array( 
                    "response" => http_response_code('401'), 
                    "status"   => false, 
                    "message"  => $e->getMessage()
                );
            }

            return $return;
        }

        public function Login(){
            if (isset($_GET['ident']) && $_GET['ident'] != '') {
                $results = $this->DecodeToken($_GET['ident']);
                if (isset($results['tokenGroupId']) && $results['tokenGroupId'] != null) {
                    $langageFormation = $this->groupes_model->RequestByGrp('langue',$results['tokenGroupId']);
                    if (preg_match('/Anglais/i', $langageFormation, $matches)) {  
                        $langagePlateform = 'english';
                    } 
                    else if (preg_match('/Français/i', $langageFormation, $matches)){
                        $langagePlateform = 'french';
                    } 
                    else if ($langageFormation == NULL || $langageFormation == ''){
                        $langagePlateform = 'english';
                    }
                    else{
                        $langagePlateform = 'french';
                    }

                    $allResults = $this->Membres_model->getById($results['tokenMemberId']);

                    $sessionArray = array(
                        'GUSERID'                  =>$results['tokenMemberId'],
                        'GEXTRANETID'              =>$results['tokenRefIndividu'],
                        'GUSERLOGIN'               =>$allResults[0]->login,
                        'GUSER'                    =>$allResults[0]->prenom." ".$allResults[0]->nom,
                        'GUSERINITIAL'             =>$allResults[0]->nom[0],
                        'GUSERTYPE'                =>$results['tokenUserRole'],
                        'BAR'                      =>$allResults[0]->acces_bar,
                        'MODE_ACCES'               =>$allResults[0]->mode_acces,
                        'GROUPE'                   =>$results['tokenGroupId'],
                        'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$results['tokenGroupId']),
                        'ACCES_FONCTIONS_ADMIN'    =>$allResults[0]->acces_fonctions_admin,
                        'TUTEUR_ENTREPRISE'        =>$allResults[0]->tuteur_entreprise,
                        'TYPE'                     =>$allResults[0]->type,
                        'ROLE'                     =>$results['tokenUserRole'],
                        'CNX'                      =>$this->connexion_model->newconnexion($results['tokenMemberId'],'EL'),
                        'SOCIETE'                  =>$this->Societe_model->Request('description',$allResults[0]->id_societe),
                        'NBCONNEXION'              =>$allResults[0]->nbconnexion,
                        'IDSOCIETE'                =>$allResults[0]->id_societe,
                        'PDP'                      =>$allResults[0]->nom_photo,
                        'isLoggedIn'               =>TRUE,
                        'IDSTAGE'                  =>$results['tokenNumStage'],
                        'site_lang'                =>$langagePlateform
                    );
                    $this->session->set_userdata($sessionArray);
                    if (isset($_GET['cible']) && $_GET['cible'] != '') {
                        return $this->RedirectUriEl($_GET['cible'],$results['tokenUserRole'], $results['tokenMemberId'], $results['tokenGroupId'], $results['tokenRefIndividu'], $results['tokenNumStage'], $results['tokenTraineeId']);
                    }
                }
                elseif(isset($results['tokenMemberId']) && $results['tokenMemberId'] != ''){
                    $langagePlateform = 'english';

                    $allResults = $this->Membres_model->getById($results['tokenMemberId']);

                    $sessionArray = array(
                        'GUSERID'                  =>$results['tokenMemberId'],
                        'GEXTRANETID'              =>$results['tokenRefIndividu'],
                        'GUSERLOGIN'               =>$allResults[0]->login,
                        'GUSER'                    =>$allResults[0]->prenom." ".$allResults[0]->nom,
                        'GUSERINITIAL'             =>$allResults[0]->nom[0],
                        'GUSERTYPE'                =>$results['tokenUserRole'],
                        'BAR'                      =>$allResults[0]->acces_bar,
                        'MODE_ACCES'               =>$allResults[0]->mode_acces,
                        'GROUPE'                   =>$results['tokenGroupId'],
                        'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$results['tokenGroupId']),
                        'ACCES_FONCTIONS_ADMIN'    =>$allResults[0]->acces_fonctions_admin,
                        'TUTEUR_ENTREPRISE'        =>$allResults[0]->tuteur_entreprise,
                        'TYPE'                     =>$allResults[0]->type,
                        'ROLE'                     =>$results['tokenUserRole'],
                        'CNX'                      =>$this->connexion_model->newconnexion($results['tokenMemberId'],'EL'),
                        'SOCIETE'                  =>$this->Societe_model->Request('description',$allResults[0]->id_societe),
                        'NBCONNEXION'              =>$allResults[0]->nbconnexion,
                        'IDSOCIETE'                =>$allResults[0]->id_societe,
                        'PDP'                      =>$allResults[0]->nom_photo,
                        'isLoggedIn'               =>TRUE,
                        'IDSTAGE'                  =>$results['tokenNumStage'],
                        'site_lang'                =>$langagePlateform
                    );
                    $this->session->set_userdata($sessionArray);
                    if (isset($_GET['cible']) && $_GET['cible'] != '') {
                        return $this->RedirectUriEl($_GET['cible'],$results['tokenUserRole'], $results['tokenMemberId'], $results['tokenGroupId'], $results['tokenRefIndividu'], $results['tokenNumStage'], $results['tokenTraineeId']);
                    }
                }
                else{
                    redirect('/login');
                }
            }
            else{
                redirect('/login');
            }
        }


        public function loadSessionElearning($cible, $tokenData){
            if (isset($tokenData)) {
                $results = $this->DecodeToken($tokenData['Token']);
                if (isset($results['tokenGroupId'])) {
                    $langageFormation = $this->groupes_model->RequestByGrp('langue',$results['tokenGroupId']);
                    if (preg_match('/Anglais/i', $langageFormation, $matches)) {  
                        $langagePlateform = 'english';
                    } 
                    else if (preg_match('/Français/i', $langageFormation, $matches)){
                        $langagePlateform = 'french';
                    } 
                    else if ($langageFormation == NULL || $langageFormation == ''){
                        $langagePlateform = 'english';
                    }
                    else{
                        $langagePlateform = 'french';
                    }

                    $allResults = $this->Membres_model->getById($results['tokenMemberId']);

                    $sessionArray = array(
                        'GUSERID'                  =>$results['tokenMemberId'],
                        'GEXTRANETID'              =>$results['tokenRefIndividu'],
                        'GUSERLOGIN'               =>$allResults[0]->login,
                        'GUSER'                    =>$allResults[0]->prenom." ".$allResults[0]->nom,
                        'GUSERINITIAL'             =>$allResults[0]->nom[0],
                        'GUSERTYPE'                =>$results['tokenUserRole'],
                        'BAR'                      =>$allResults[0]->acces_bar,
                        'MODE_ACCES'               =>$allResults[0]->mode_acces,
                        'GROUPE'                   =>$results['tokenGroupId'],
                        'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$results['tokenGroupId']),
                        'ACCES_FONCTIONS_ADMIN'    =>$allResults[0]->acces_fonctions_admin,
                        'TUTEUR_ENTREPRISE'        =>$allResults[0]->tuteur_entreprise,
                        'TYPE'                     =>$allResults[0]->type,
                        'ROLE'                     =>$results['tokenUserRole'],
                        'CNX'                      =>$this->connexion_model->newconnexion($results['tokenMemberId'],'EL'),
                        'SOCIETE'                  =>$this->Societe_model->Request('description',$allResults[0]->id_societe),
                        'NBCONNEXION'              =>$allResults[0]->nbconnexion,
                        'IDSOCIETE'                =>$allResults[0]->id_societe,
                        'PDP'                      =>$allResults[0]->nom_photo,
                        'isLoggedIn'               =>TRUE,
                        'IDSTAGE'                  =>$results['tokenNumStage'],
                        'site_lang'                =>$langagePlateform
                    );
                    $this->session->set_userdata($sessionArray);
                    if (isset($cible) && $cible != '') {
                        return $this->RedirectUriEl($cible,$results['tokenUserRole'], $results['tokenMemberId'], $results['tokenGroupId'], $results['tokenRefIndividu'], $results['tokenNumStage'], $results['tokenTraineeId']);
                    }
                }
            }
            else{
                redirect('/login');
            }
        }

        public function loadSessionToken(){
            if (isset($_GET['token']) && $_GET['token'] != '') {
                $results = $this->DecodeToken($_GET['token']);
                if (isset($results['tokenMemberId'])) {
                    $result  =$this->el_f2plus_auth->login($this->Membres_model->Request('login',$results['tokenMemberId']), explode('_', $this->Membres_model->Request('register_remember_pwd_time',$results['tokenMemberId']))[1], TRUE);
                    $langagePlateform = '';
                    $matches = array();
                    if(count($result) > 0 && (is_array($result) || is_object($result))){
                        foreach ($result as $res){
                            $langageFormation = $this->groupes_model->RequestByGrp('langue',$res->id_groupe);
                            if (preg_match('/Anglais/i', $langageFormation, $matches)) {  
                                $langagePlateform = 'english';
                            } 
                            else if (preg_match('/Français/i', $langageFormation, $matches)){
                                $langagePlateform = 'french';
                            } 
                            else if ($langageFormation == NULL || $langageFormation == ''){
                                $langagePlateform = 'english';
                            }
                            else{
                                $langagePlateform = 'french';
                            }

                            if ($res->mode_acces == '2') {
                                if ($res->type==0) {
                                    $role = STAGIAIRE;
                                }
                                elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                                    $role = TUTEUR;                            
                                }
                                elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                                    $role = TUTEUR;                            
                                }
                                elseif ($res->type==4) {
                                   $role = SUPERVISEUR;                            
                                }
                                elseif ($res->type==2) {
                                   $role = ADMIN;                            
                                } 
                                else{
                                    $role = ROLEAUTRES;
                                }
                                $CNX = $this->connexion_model->newconnexion($res->id,'EL V3');

                                $sessionArray = array(
                                    'GUSERID'=>$res->id,
                                    'GEXTRANETID'              =>$res->extranet_id,
                                    'GUSER'                    =>$res->prenom." ".$res->nom,
                                    'GUSERINITIAL'             =>$res->nom[0],
                                    'GUSERLOGIN'               =>$res->login,
                                    'GUSERTYPE'                =>$res->type,
                                    'BAR'                      =>$res->acces_bar,
                                    'MODE_ACCES'               =>$res->mode_acces,
                                    'GROUPE'                   =>$res->id_groupe,
                                    'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$res->id_groupe),
                                    'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                                    'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                                    'TYPE'                     =>$res->type,
                                    'ROLE'                     =>$role,
                                    'CNX'                      =>$CNX,
                                    'SOCIETE'                  =>$res->description,
                                    'IDSOCIETE'                =>$res->id_societe,
                                    'NBCONNEXION'              =>$res->nbconnexion,
                                    'PDP'                      =>$res->nom_photo,
                                    'IDSTAGE'                  =>$res->type == 0 ? $this->Stag_individu_model->getMaxNumStageByIdMembers($res->id) : NULL,
                                    'isLoggedIn'               =>TRUE,
                                    'site_lang'                =>($res->id_groupe == 0 && $res->type == 3) ? 'english' : $langagePlateform,                                    
                                    'TOKEN_V1'                =>(isset($_GET['token_v1']) && $_GET['token_v1'] != '' && ($res->type == 0 || $res->type == 3)) ? $_GET['token_v1'] : '',

                                    'TOKEN_EL_VF'             =>(isset($_GET['token']) && $_GET['token'] != '' && ($res->type == 0 || $res->type == 3)) ? $_GET['token'] : ''
                                );
                                            
                                $this->session->set_userdata($sessionArray);
                                if ($res->type==3){
                                    redirect('/tutordashbord');
                                }
                                elseif ($res->type==2){
                                    redirect('/admindashbord');
                                }
                                elseif ($res->type==4){
                                    redirect('/supervisor');
                                }
                                else{
                                    redirect('/dashboard');                                
                                }
                            }
                            elseif (!empty($res->date_fin_acces)) {
                                if($res->date_fin_acces+((24*3600)+(60*60)+60) <= time()) {
                                    $this->session->set_flashdata('error', 'Your date of access to the platform has expired');                
                                    redirect('/login');

                                }
                                else{
                                    if ($res->type==0) {
                                        $role = STAGIAIRE;
                                    }
                                    elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                                        $role = TUTEUR;                            
                                    }
                                    elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                                        $role = TUTEUR;                            
                                    }
                                    elseif ($res->type==4) {
                                       $role = SUPERVISEUR;                            
                                    }
                                    elseif ($res->type==2) {
                                       $role = ADMIN;                            
                                    } 
                                    else{
                                        $role = ROLEAUTRES;
                                    }
                                    $CNX = $this->connexion_model->newconnexion($res->id,'EL V3');

                                    $sessionArray = array(
                                        'GUSERID'                  =>$res->id,
                                        'GEXTRANETID'              =>$res->extranet_id,
                                        'GUSERLOGIN'               =>$res->login,
                                        'GUSER'                    =>$res->prenom." ".$res->nom,
                                        'GUSERINITIAL'             =>$res->nom[0],
                                        'GUSERTYPE'                =>$res->type,
                                        'BAR'                      =>$res->acces_bar,
                                        'MODE_ACCES'               =>$res->mode_acces,
                                        'GROUPE'                   =>$res->id_groupe,
                                        'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$res->id_groupe),
                                        'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                                        'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                                        'TYPE'                     =>$res->type,
                                        'ROLE'                     =>$role,
                                        'CNX'                      =>$CNX,
                                        'SOCIETE'                  =>$res->description,
                                        'IDSOCIETE'                =>$res->id_societe,
                                        'NBCONNEXION'              =>$res->nbconnexion,
                                        'PDP'                      =>$res->nom_photo,
                                        'IDSTAGE'                  =>$res->type == 0 ? $this->Stag_individu_model->getMaxNumStageByIdMembers($res->id) : NULL,
                                        'isLoggedIn'               =>TRUE,
                                        'site_lang'                =>($res->id_groupe == 0 && $res->type == 3) ? 'english' : $langagePlateform,                                        
                                        'TOKEN_V1'                =>(isset($_GET['token_v1']) && $_GET['token_v1'] != '' && ($res->type == 0 || $res->type == 3)) ? $_GET['token_v1'] : '',

                                        'TOKEN_EL_VF'             =>(isset($_GET['token']) && $_GET['token'] != '' && ($res->type == 0 || $res->type == 3)) ? $_GET['token'] : ''
                                    );
                                    $this->session->set_userdata($sessionArray);
                                    if ($res->type==3){
                                        redirect('/tutordashbord');
                                    }
                                    elseif ($res->type==4){
                                        redirect('/supervisor');
                                    }
                                    elseif ($res->type==2){
                                        redirect('/admindashbord');
                                    }
                                    else{
                                        redirect('/dashboard');                                
                                    }
                                }

                            }
                            else{                      

                                if ($res->type==0) {
                                    $role = STAGIAIRE;
                                }
                                elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                                    $role = TUTEUR;                            
                                }
                                elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                                    $role = TUTEUR;                            
                                }
                                elseif ($res->type==4) {
                                   $role = SUPERVISEUR;                            
                                }
                                elseif ($res->type==2) {
                                   $role = ADMIN;                            
                                } 
                                else{
                                    $role = ROLEAUTRES;
                                }
                                $CNX = $this->connexion_model->newconnexion($res->id,'EL V3');

                                $sessionArray = array(
                                    'GUSERID'                  =>$res->id,
                                    'GEXTRANETID'              =>$res->extranet_id,
                                    'GUSER'                    =>$res->prenom." ".$res->nom,
                                    'GUSERINITIAL'             =>$res->nom[0],
                                    'GUSERLOGIN'               =>$res->login,
                                    'GUSERTYPE'                =>$res->type,
                                    'BAR'                      =>$res->acces_bar,
                                    'MODE_ACCES'               =>$res->mode_acces,
                                    'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$res->id_groupe),
                                    'GROUPE'                   =>$res->id_groupe,
                                    'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                                    'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                                    'TYPE'                     =>$res->type,
                                    'ROLE'                     =>$role,
                                    'CNX'                      =>$CNX,
                                    'SOCIETE'                  =>$res->description,
                                    'IDSOCIETE'                =>$res->id_societe,
                                    'NBCONNEXION'              =>$res->nbconnexion,
                                    'PDP'                      =>$res->nom_photo,
                                    'IDSTAGE'                  =>$res->type == 0 ? $this->Stag_individu_model->getMaxNumStageByIdMembers($res->id) : NULL,
                                    'isLoggedIn'               =>TRUE,
                                    'site_lang'                =>($res->id_groupe == 0 && $res->type == 3) ? 'english' : $langagePlateform,
                                    'TOKEN_V1'                =>(isset($_GET['token_v1']) && $_GET['token_v1'] != '' && ($res->type == 0 || $res->type == 3)) ? $_GET['token_v1'] : '',

                                    'TOKEN_EL_VF'             =>(isset($_GET['token']) && $_GET['token'] != '' && ($res->type == 0 || $res->type == 3)) ? $_GET['token'] : ''
                                );
                                            
                                $this->session->set_userdata($sessionArray);
                                if ($res->type==3){
                                    redirect('/tutordashbord');
                                }
                                elseif ($res->type==2){
                                    redirect('/admindashbord');
                                }
                                elseif ($res->type==4){
                                    redirect('/supervisor');
                                }
                                else{
                                    redirect('/dashboard');                                
                                }
                            }
                        }
                    }
                    else
                    {
                        $this->session->set_flashdata('error', 'Email or password mismatch');
                        
                        redirect('/login');
                    }
                }
            }
            else{
                redirect('/login');
            }
        }

        public function RedirectUriEl($action, $userRole, $userId, $userGroup, $userExtranetId, $userStageId, $traineeId){
            if ($userRole == 3) {
                switch ($action) {
                    case 'newtodo':
                        $urlRedirect = '/trainee-todo-in-tutor?extranet_id='.$userExtranetId.'&groupe='.$userGroup.'&id='.$traineeId.'&action='.$action;
                        break;
                    
                    default:
                        $urlRedirect = '';
                        break;
                }
            }
            redirect($urlRedirect);
        }
    }
        