<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Todolist extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('user_model');
        $this->load->model('connexion_model');
        $this->load->model('todolist_model');
        $this->load->library('pagination');
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Todo list';

        $searchText = $this->input->post('searchText');
        $data['searchText'] = $searchText;  
        $count = $this->todolist_model->CountAdminTodo($searchText);

        $returns = $this->paginationCompress ( "admintodo/", $count, 18 );
        $data['todoResult'] = $this->todolist_model->AdminTodo($searchText, $returns["page"], $returns["segment"]);
        
        $this->loadViews("admin/todolist/index", $this->global, $data , NULL);
    }
    
    public function addlink(){

        if($this->isAdmin() == TRUE)
        {
            $this->loadThis();
        }
        else
        {   
            $this->global['pageTitle'] = 'E-learning : Add new Link';
            $this->loadViews("admin/todolist/addnewlink", $this->global, NULL , NULL);            
            
        }
    }
    public function addNewLink(){

        if($this->isAdmin() == TRUE)
        {
            $this->loadThis();
        }
        else
        {
            $this->load->library('form_validation');

            /*if($this->form_validation->run() == FALSE)
            {
                $this->addlink();                         
            }
            else{*/
                $Title   = $this->input->post('Title');
                $link    = $this->input->post('link');
                $comment = $this->input->post('comment');
                $linkInfo = array('titre'=>$Title, 'link'=>$link, 'commentaire'=>$comment, 'type'=>0, 'date_create'=>date('Y-m-d'), 'user_create'=>$this->session->userdata ('GUSERID'));   


                $idNewLink = $this->todolist_model->addnewlink($linkInfo);

                //generate screenshoo usinng api
                $apiusing = 'https://api.site-shot.com/?url=';
                $ourpage = $link;
                $width    = "1200";
                $height    = "1280";

                $file = $apiusing.$link."&width=".$width."&height=".$height."";

                $newscreen = "screen_".time().'.png';

                //copy file in to the server
                copy($file,$newscreen);
                


                if($idNewLink > 0)
                {
                    $this->session->set_flashdata('success', 'New link created successfully');
                }
                else
                {
                    $this->session->set_flashdata('error', 'Link creation failed');
                }
                
                redirect('admin/todolist/addlink');
           // }
        }
    }

    public function getwebpage()
    {            
        /*$return = "";
        $return .= "<p>";
        $return = file_get_contents(urlencode($link));
        $return .= "</p>";*/

        echo  file_get_contents($this->input->post('link'));
    }
    public function viewTodo(){
        $this->global['pageTitle'] = 'E-learning : Forma2+';
        
        $this->loadViews("todolist/viewstodo", $this->global, NULL , NULL);
    }
    
   
}

?>