<?php 
    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\SMTP;
    use PHPMailer\PHPMailer\Exception;
    if(!defined('BASEPATH')) exit('No direct script access allowed');

    require  APPPATH . '/libraries/ElearningForma2PlusController.php';

    class MailSmsCommunication extends ElearningForma2PlusController
    {
        public function __construct()
        {
            parent::__construct();
            $this->load->model('sms_model');
            $this->load->model('membres_model');
            $this->tracking_type = 99;
            $this->isLoggedIn();   
            $this->loadTrackingEl(0,0,$tracking_type);
        }
        
        public function index()
        {
            $this->global['pageTitle'] = 'E-learning : Forma2+ - Communication'; 

            $data['smsResult'] = $this->sms_model->getAll();     
            $data['membersResult'] = $this->membres_model->getAll();     
            $this->loadViews("admin/communic/dataviews", $this->global, $data , NULL);
        }
        public function sendsms(){
            $dataSmsJson = array();
            require_once(APPPATH.'libraries/SmsLib.php');
            $SmsClass = new SmsLib;
            if (isset($_POST['inputPhoneNumbers'])) {            
                $dataSms = $SmsClass->sendSms($_POST['inputPhoneNumbers'],$_POST['inputTextMsg']);
                if($dataSms['code'] == 200 && $dataSms['response']->invalidReceivers == null){
                    if($dataSms['response']->totalCreditsRemoved == 0){
                        $dataSmsJson["envoiSms"] = 0; 
                        $dataSmsJson["response"] = "<span>Sms n'a pas été délivré à ce numero </span><span>".implode(",",$dataSms['response']->invalidReceivers)."</span><br>"; 
                    }
                    else if($dataSms['response']->totalCreditsRemoved > 0){
                        $dataSmsJson["response"] = "<h4>Message délivré au ".implode(",",$dataSms['response']->validReceivers)."</h4><br><p>".$_POST['inputTextMsg']."</p>"; 
                        $dataSmsJson["envoiSms"] = 1;   
                    }

                    $datas  =       $SmsClass->setOutgoing($dataSms['response']->ids);

                    if ($datas != NULL){
                        foreach($datas as $key => $value){
                            $dataSmsHistory = array(
                                'sms_id_history' => NULL,
                                'sms_id' => $value['response']->id,
                                'sms_sender' => $value['response']->sender,
                                'sms_receiver' => $value['response']->receiver,
                                'sms_msg' => addslashes($value['response']->message),
                                'extranet_id' => NULL,
                                'dest_id' => NULL,
                                'sms_date_creation' => date("d/m/Y H:i:s", strtotime($value['response']->creationDatetime)),
                                'sms_date_update' => date('d/m/Y H:i:s')
                            );
                            $dataSmsJson["responseIdSmsHistory"] = $this->sms_model->add($dataSmsHistory); 
                        }
                    }

                }
                else{
                    $dataSmsJson["envoiSms"] = 0; 
                    $dataSmsJson["response"] = "<span>Sms n'a pas été délivré à ce numero </span><span>".implode(",",$dataSms['response']->invalidReceivers)."</span><br>"; 
                }
            }
            echo json_encode($dataSmsJson);
        } 

        public function sendemail(){
            $return = "1";            
            require APPPATH . '/libraries/PHPMailer/src/PHPMailer.php';
            require APPPATH . '/libraries/PHPMailer/src/SMTP.php';
            require APPPATH . '/libraries/PHPMailer/src/Exception.php';
            require APPPATH . '/libraries/PHPMailer/vendor/autoload.php';
            if (isset($_POST)) {
                $setting = [
                    'mail' =>[
                        //'adresse_principale' => 'infos@forma2plus.com',
                        'adresse_principale' => 'boris@forma2plus.com',
                        'adresse_notification' => '',                    
                    ]
                            
                ];
                $recipient           = isset($_POST['inputRecipient']) ? $_POST['inputRecipient'] : '';
                $additionalMailCc    = isset($_POST['mailCc']) ? $_POST['mailCc']: '';
                $Pjs                 = isset($_FILE['attachment']) ? $_FILE['attachment'] : NULL;
                $subject             = isset($_POST['inputObject']) ? $_POST['inputObject'] : '';
                $mailbody            = isset($_POST['inputTextMsgEmail']) ? $_POST['inputTextMsgEmail'] : '';
                $mailAltBody         = '';
                $mail = new PHPMailer(true);
                try {
                    $mail->SMTPDebug = SMTP::DEBUG_SERVER;   
                    $mail->isSMTP();                         
                    $mail->Host       = $this->config->item("smtp_host_f2plus");     
                    $mail->SMTPAuth   = true;                    
                    $mail->Username   = $this->config->item("smtp_username_f2plus");  
                    $mail->Password   = $this->config->item("smtp_password_f2plus");  
                    $mail->SMTPSecure = $this->config->item("smtp_secure_f2plus");
                    $mail->Port       = $this->config->item("smtp_port_f2plus");
                    $mail->isSendmail();   
                    $mail->setFrom($setting['mail']['adresse_principale'], utf8_decode('Forma2+ - E-learning notification'), true);
                    $mail->addAddress($recipient, NULL); 
                    $mail->addReplyTo($setting['mail']['adresse_principale'], NULL);
                    foreach ($additionalMailCc as $key => $value) {
                        $mail->addCC($value);
                    }
                    /*foreach($Pjs as $f){
                        $mail->addAttachment($f, utf8_decode(basename($f)));

                    }*/
                    $mail->isHTML(true);                        
                    $mail->Subject = $subject;
                    $mail->Body    = $mailbody;
                    $mail->AltBody = $mailAltBody;

                    $mail->send();
                    $return = "1";
                } catch (Exception $e) {
                    //echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                    $return = "0";
                }

                echo "###".$return;
            }
        }

        public function deletesms(){
            if (isset($_GET['id'])) {
                $this->sms_model->delete($_GET['id']); 
                echo '1';
            }
        }
    }

?>