<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require  APPPATH . '/libraries/ElearningForma2PlusController.php';
require  APPPATH. '/libraries/ExportData.php';


/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Bors
 re
 * @version : 1.1
 * @since : 22 November 2018
 */
class Etherpad extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('membres_model');
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Forma2+';  
        $data['infosPage'] = '';
        $this->load->library('form_validation');
        $this->form_validation->set_rules('startDate', 'Début de connexion', 'required');
        $this->form_validation->set_rules('endDate', 'Fin de connexion', 'required');
        if($this->form_validation->run() == TRUE){
            $s =  explode('/', $this->input->post('startDate'));
            $startDate = strtotime($s[2]."-".$s[1]."-".$s[0]);

            $e =  explode('/', $this->input->post('endDate'));
            $endDate = strtotime($e[2]."-".$e[1]."-".$e[0]);

            $data['allResults'] = $this->membres_model->getEtherpadInfos($startDate, $endDate);
        }
        
        $this->loadViews("admin/etherpad/list", $this->global, $data , NULL);
    }

    public function detectPadExistOrCreate(){
        $return = array();
        if (isset($_POST['etherpadId']) && isset($_POST['cible'])) {
            $padUrl = $this->config->item('etherpad_api').'p/'.$_POST['etherpadId'];
            $padUrlExport = $padUrl.'/export/'.$_POST['cible'];
            /*$return['padeExist'] = @file_get_contents($padUrlExport);
            if ($return['padeExist'] == false) {
                $return['createPadContent'] = true;
            }
            else{
                $return['createPadContent'] = false;
            }*/
            $return['createPadContent'] = true;

            $return['padUrlExport'] = $padUrlExport;
        }
        elseif (isset($_POST['padInfos'])) {
            $padInfos = $_POST['padInfos'];
            for ($i=0; $i < count($padInfos); $i++) { 
                $padUrlExport = $this->config->item('etherpad_api').'p/'.$padInfos[$i][0].'/export/'.$padInfos[$i][1];
                /*$detectContentExist = @file_get_contents($padUrlExport);
                if ($detectContentExist == false) {
                    $return[$i]['infosExport'] = array(
                        'status' => false, 
                        'message' => $padInfos[$i][0],
                        'url' => ""
                    );
                }
                else{
                    $return[$i]['infosExport'] = array(
                        'status' => true, 
                        'message' => "",
                        'url' => $padUrlExport
                    );
                }*/
                $return[$i]['infosExport'] = array(
                    'status' => true, 
                    'message' => "",
                    'url' => $padUrlExport
                );

            }
        }
        else{

        }
        echo json_encode($return);
    }

    public function getContentById(){
        ini_set("max_execution_time", 0);
        $return = array();
        if (isset($_POST['etherpadId'])) {
            $etherpadUrl               = 'https://fb.forma2plus.com/p/'.$_POST['etherpadId'].'/export/html';
            //$etherpadUrl               = 'https://fb.forma2plus.com/p/'.$_POST['etherpadId'];
            $return['etherpadId']      = $_POST['etherpadId'];
            $return['etherpadUrl']     = $etherpadUrl;
            try {
                $return['etherpadContent'] = $this->file_get_contents_curl($etherpadUrl);               
            } 
            catch (Exception $e) {
                $return['etherpadContent'] = $e->getMessage();    
            }
            
        }
        echo json_encode($return);
    }

    public function file_get_contents_curl($url) {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);       

        $data = curl_exec($ch);
        curl_close($ch);

        return $data;
    }

    public function export(){

        
        /*$documents    = $this->document_model->ListerDocumentsFiltreAdmin($this->input->post('searchText'), $this->input->post('author_'), "", "");
        $exporter = new ExportDataExcel('browser', 'Export_document.xls');
        $exporter->initialize();
        $exporter->addRow(array("Titre", "Author", "Focument/Link", "Creation date", "Trainee")); 
       

        foreach($documents as $doc){
            $exporter->addRow(array($doc['titre'],$doc['user'],$doc['file'],$doc['date'],$this->membres_model->RequestFullNameTrainee($doc['stagiaireGrp'])));  
        }
        $exporter->addRow(array("\r\r","Total lien",count($documents))); 
        $exporter->finalize();
        exit(); */
    }

    /*public function delete(){
        $id   =  $this->input->post('id');
        $this->document_model->delete($id);
        echo $id;
    }*/
}

?>