$(document).ready(function(){
	 var coursePlan = $('#course-plan').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'excel', 'pdf'
        ],
        orderCellsTop: true,
        fixedHeader: true,
        responsive: true,
        "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
        "paging": false,//Dont want paging                
        "bPaginate": false,//Dont want paging   
    });

    var statistique = $('#statistique').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'excel', 'pdf'
        ],
        orderCellsTop: true,
        fixedHeader: true,
        responsive: true,
        "bInfo": true, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
        "paging": true,//Dont want paging                
        "bPaginate": true,//Dont want paging   
    });

    $('.datecoursplanifier').change(function(){
        $(".spinner").fadeIn("slow");
        $('.trainerForm').empty();
        var datecoursplanifier = $(this).val();
        $.ajax({
          type: "POST",
          url: $(".baseURL").val()+'get-tutor-connect-by-date',
          data:  {datecoursplanifier : datecoursplanifier},
          dataType:'json',
          success: function( response ) {
            var options = '<option value="">Tuteur</option>';
            if(response.length) {
                $.each(response, function(key,value) {
                    options += '<option value="'+value.trainer+'">'+value.trainer+'</option>';
                });
            }
            $('.trainerForm').html(options);
            $(".spinner").fadeOut("slow");
          },
          error:function(err){
            console.log(err);
          }
        });
    });

	$('#btn-search-cp').click(function(e){
        e.preventDefault();
        $(".spinner").fadeIn("slow");
        coursePlan.destroy();
        $('#contentCoursePlan').empty();
        var dataFilter=$("#search-form-cp").serializeArray();
        var dataFilterJson = {};
        for (i in dataFilter) {
            dataFilterJson[dataFilter[i].name] = dataFilter[i].value;
        }
        dataFilter=dataFilterJson;  

        $.ajax({
          type: "POST",
          url: $("#search-form-cp").attr('action'),
          data:  {"dataFilter":dataFilter},
          dataType:'json',
          success: function( response ) {
            console.log(response);
            $('#contentCoursePlan').html(response.HtmlReturn);
            $('.totalRows').html(response.countResult);
            coursePlan =$('#course-plan').DataTable({
                destroy: true,
                dom: 'Bfrtip',
                buttons: [
                    'excel', 'pdf'
                ],
                orderCellsTop: true,
                fixedHeader: true,
                responsive: true,
                "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
                "paging": false,//Dont want paging                
                "bPaginate": false,//Dont want paging 
            });
            $(".spinner").fadeOut("slow");
          },
          error:function(err){
            console.log(err);
          }
        });
    });

    $('.creneauhoraireForm, .statusconnexionForm, .trainerForm').on('change', function () {
        console.log('azazaz');
        var dataFIlter = $(this);
        var column = dataFIlter.parents('.filter-container').attr('data-column');
        if (dataFIlter.val() != '') {
            filterColumnForm(column);
        }
        else{
            coursePlan.column(column).search('').draw();
        }
        changeRowsTableForm(coursePlan);
    });

    $('.trainee_filterForm').on('keyup click', function () {
        var dataFIlter = $(this);
        var column = dataFIlter.parents('.filter-container').attr('data-column');
        if (dataFIlter.val() != '') {
            coursePlan.column(column).search(dataFIlter.val()).draw();
        }
        else{
            coursePlan.column(column).search('').draw();
        }
        changeRowsTableForm(coursePlan);
    });

    $('.btn-clear-filter-form').on('click', function (e) {
        e.preventDefault();        
        $('.column_filter').each(function(){
            var columns = $(this);
            coursePlan.column(columns.parents('.filter-container').attr('data-column')).search('').draw();
        });
        $('.creneauhoraireForm').val('');
        $('.statusconnexionForm').val('');
        $('input.column_filter').val('');
        changeRowsTableForm(coursePlan);
    });
});

function changeRowsTableForm(datatable){
    var numRows = datatable.rows( ).count();
    $('.totalRows').text(datatable.page.info().recordsDisplay);
}


function filterColumnForm(i) {
    $('.connected-users')
        .DataTable()
        .column(i)
        .search(
            $('#col' + i + '_filter').val(),
        )
        .draw();
}