var load_rtc_interval = setInterval(function () {
    if (typeof RecordRTC == 'function') {
        clearInterval(load_rtc_interval);
        document.getElementById('record_btn_control').removeAttribute('style');

    }
}, 1000);
var audio = document.querySelector('.audio-new-record');
var containerActionFormSaveRecord = document.querySelector('.action-form-save-record');
function captureMicrophone(callback) {
    if (microphone) {
        callback(microphone);
        return;
    }
    if (typeof navigator.mediaDevices === 'undefined' || !navigator.mediaDevices.getUserMedia) {
        alert('This browser does not supports WebRTC getUserMedia API.');
        if (!!navigator.getUserMedia) {
            alert('This browser seems supporting deprecated getUserMedia API.');
        }
    }
    navigator.mediaDevices.getUserMedia({
        audio: isEdge ? true : {
            echoCancellation: false
        }
    }).then(function (mic) {
        callback(mic);
    }).catch(function (error) {
        alert('Unable to capture your microphone. Please check console logs.');
        console.error(error);
    });
}

function replaceAudio(src) {
    var newAudio = document.createElement('audio');
    newAudio.controls = true;
    newAudio.autoplay = true;

    if (src) {
        newAudio.src = src;
    }
    newAudio.classList.add("main-audio");

    var parentNode = audio.parentNode;
    parentNode.innerHTML = '';
    parentNode.appendChild(newAudio);

    audio = newAudio;
    console.log(audio);
}

function stopRecordingCallback() {
    replaceAudio(URL.createObjectURL(recorder.getBlob()));

    btnStartRecording.disabled = false;

    setTimeout(function () {
        if (!audio.paused) return;

        setTimeout(function () {
            if (!audio.paused) return;
            audio.play();
        }, 1000);

        audio.play();
    }, 300);

    audio.play();
    btnSaveRecording.disabled = false;
    containerActionFormSaveRecord.setAttribute('style','display:flex;');
    //$('.action-form-save-record').fadeIn('slow');


}

var isEdge = navigator.userAgent.indexOf('Edge') !== -1 && (!!navigator.msSaveOrOpenBlob || !!navigator.msSaveBlob);
var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);

var recorder; // globally accessible
var microphone;

var btnStartRecording = document.getElementById('el-btn-start-recording');
var btnStopRecording = document.getElementById('el-btn-stop-recording');
var btnSaveRecording = document.getElementById('el-btn-save-recording');


btnStartRecording.onclick = function () {
    this.disabled = true;
    this.style.border = '';
    this.style.fontSize = '';

    if (!microphone) {
        captureMicrophone(function (mic) {
            microphone = mic;

            if (isSafari) {
                replaceAudio();

                audio.muted = true;
                audio.srcObject = microphone;

                btnStartRecording.disabled = false;
                btnStartRecording.style.border = '1px solid red';
                btnStartRecording.style.fontSize = '150%';

                alert('Please click startRecording button again. First time we tried to access your microphone. Now we will record it.');
                return;
            }

            click(btnStartRecording);
        });
        return;
    }

    replaceAudio();

    audio.muted = true;
    audio.srcObject = microphone;

    var options = {
        type: 'audio',
        numberOfAudioChannels: isEdge ? 1 : 2,
        checkForInactiveTracks: true,
        bufferSize: 16384
    };

    if (isSafari || isEdge) {
        options.recorderType = StereoAudioRecorder;
    }

    if (navigator.platform && navigator.platform.toString().toLowerCase().indexOf('win') === -1) {
        options.sampleRate = 48000; // or 44100 or remove this line for default
    }

    if (isSafari) {
        options.sampleRate = 44100;
        options.bufferSize = 4096;
        options.numberOfAudioChannels = 1;
    }

    if (recorder) {
        recorder.destroy();
        recorder = null;
    }
    options.numberOfAudioChannels = 1;
    options.recorderType = StereoAudioRecorder;
    recorder = RecordRTC(microphone, options);

    recorder.startRecording();

    btnStopRecording.disabled = false;
    containerActionFormSaveRecord.setAttribute('style','display:none;');
    //$('.action-form-save-record').fadeOut('slow');
};

btnStopRecording.onclick = function () {
    this.disabled = true;

    microphone.stop();
    microphone = null;

    recorder.stopRecording(stopRecordingCallback);
};


btnSaveRecording.onclick = function () {
    // this.disabled = true;
    $('.spinner').fadeIn('slow');
    if (!recorder || !recorder.getBlob()) return;

    if (isSafari) {
        recorder.getDataURL(function (dataURL) {
            SaveToDisk(dataURL, getFileName('mp3'));
        });
        return;
    }

    var blob = recorder.getBlob();
    var file = new File([blob], getFileName('mp3'), {
        type: 'audio/mp3'
    });
    // invokeSaveAsDialog(file);
    console.log($('#audio_theme').val());
    if ($('#audio_theme').val() == '' && !($.isNumeric($('#audio_theme').val()))) {
        toastr.error('Please choose or create a theme before');
        $('.spinner').fadeOut('slow');
    }
    else{

        var formData = new FormData();
        formData.append('record_audio_file', file);
        formData.append('record_audio_file_name',getFileName('mp3'));
        formData.append('theme',$('#audio_theme').val());
        formData.append('idGroupe',$('#traineeGroupe').val());
        formData.append('traineeId',$('#traineeId').val());
        formData.append('newLegend',$('#new_legende_rework').val());
        formData.append('langue',$('#langChoice').val());
        formData.append('typeExp','audio');

        $.ajax({
            url: $('.baseURL').val()+'new-record-audio',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                //console.log(response);
                //console.log(response.url);

                //response = JSON.parse(response);
                //console.log(response);


                if(response.status){
                    toastr.success(data_save_ok);
                    location.reload();
                    /*alert('File Successfully Generated.');
                     var a = document.createElement("a");
                     a.href = response.url;
                     a.setAttribute("download", response.file_name);
                     a.click();
                     a.remove();*/

                }
                else{
                    toastr.error(data_saved_ko);
                }
                $('.spinner').fadeOut('slow');
            },
            error: function(response) {
                toastr.error(data_saved_ko);
                $('.spinner').fadeOut('slow');
                //alert('File not downloading, please try again.');
            }
        });
    }
    return false;

};

function click(el) {
    el.disabled = false; // make sure that element is not disabled
    var evt = document.createEvent('Event');
    evt.initEvent('click', true, true);
    el.dispatchEvent(evt);
}

function getRandomString() {
    if (window.crypto && window.crypto.getRandomValues && navigator.userAgent.indexOf('Safari') === -1) {
        var a = window.crypto.getRandomValues(new Uint32Array(3)),
            token = '';
        for (var i = 0, l = a.length; i < l; i++) {
            token += a[i].toString(36);
        }
        return token;
    } else {
        return (Math.random() * new Date().getTime()).toString(36).replace(/\./g, '');
    }
}

function getFileName(fileExtension) {
    var d = new Date();
    var year = d.getFullYear();
    var month = d.getMonth();
    var date = d.getDate();
    return 'new-record-audio-' + year + month + date + '-' + getRandomString() + '.' + fileExtension;
}

function SaveToDisk(fileURL, fileName) {
    console.log(fileURL);
    // for non-IE
    if (!window.ActiveXObject) {
        var save = document.createElement('a');
        save.href = fileURL;
        save.download = fileName || 'unknown';
        save.style = 'display:none;opacity:0;color:transparent;';
        (document.body || document.documentElement).appendChild(save);

        if (typeof save.click === 'function') {
            save.click();
        } else {
            save.target = '_blank';
            var event = document.createEvent('Event');
            event.initEvent('click', true, true);
            save.dispatchEvent(event);
        }

        (window.URL || window.webkitURL).revokeObjectURL(save.href);
    }

    // for IE
    else if (!!window.ActiveXObject && document.execCommand) {
        var _window = window.open(fileURL, '_blank');
        _window.document.close();
        _window.document.execCommand('SaveAs', true, fileName || fileURL)
        _window.close();
    }
}