<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Stat_prg_model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->table      = 'stat_programme';
        $this->table_class= 'classification_favoris';
    }

    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function deleteByClass($idClassification){
        $this->db->where('id_classification_favoris', $idClassification);
        $this->db->delete($this->table);
    }
    public function delByUserCreateAndMembers($user_create,$id_membres){
        $this->db->where('user_create', $user_create);
        $this->db->where('id_membres', $id_membres);
        $this->db->delete($this->table);
    }

    /*public function read($idS='') {
        $ret = array();
        $i = 0 ;
    
        $this->db->select('*');
        $this->db->from($this->table." as e");
        $this->db->join($this->table_lang.' as l', 'e.target_langue_cible=l.id','left');
        if ($idS != "") {
           $this->db->where('e.id_stagiaire ', $idS);
        }
        $this->db->order_by('e.content_langue_origine', 'asc');
        $query = $this->db->get(); 
        $result = $query->result()  ;
        return $result;
    }*/
    public function Request($field,$idu) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $idu);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }
    public function insertStat($data)
    {
        $this->db->trans_start();
        $this->db->insert($this->table, $data);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();        
        return $insert_id;
    }
    

    public function add($data){
        $id = 0;
        $type_prg = $data['type'];
        $this->db->select('*');
        $this->db->from($this->table);
        if (isset($data['user_create']) && $data['user_create'] !=  '') {
            $this->db->where('user_create ', $data['user_create']);
        }
        if (isset($data['numero']) && $data['numero'] !=  '') {
            $this->db->where('numero ', $data['numero']);
        }
        if (isset($data['module_id']) && $data['module_id'] !=  '') {
            $this->db->where('module_id ', $data['module_id']);
        }
        if (isset($data['id_classification_favoris']) && $data['id_classification_favoris'] !=  '') {
            $this->db->where('id_classification_favoris ', $data['id_classification_favoris']);
        }
        if (isset($data['id_prg']) && $data['id_prg'] !=  '') {
            $this->db->where('id_prg ', $data['id_prg']);
        }
        if (isset($data['status']) && $data['status'] !=  '') {
            $this->db->where('status ', $data['status']);
        }
        if (isset($data['id_membres']) && $data['id_membres'] !=  '') {
            $this->db->where('id_membres ', $data['id_membres']);
        }
        if (isset($data['user_create']) && $data['user_create'] !=  '') {
            $this->db->where('user_create ', $data['user_create']);
        }
        if (isset($data['type']) && $data['type'] !=  '') {
            $this->db->where('type ', $data['type']);
        }
        if (isset($data['intitule']) && $data['intitule'] !=  '') {
            $this->db->where('intitule ', $data['intitule']);
        }
        if (isset($data['commentaire']) && $data['commentaire'] !=  '') {
            $this->db->where('commentaire ', $data['commentaire']);
        }
        $query = $this->db->get(); 
        $cnt = $query->num_rows();    
        if ($cnt < 1 && $data['status'] == 1) {
            if ( ! empty($data))
            {
                $this->db->trans_start();
                $this->db->insert($this->table, $data);        
                $id = $this->db->insert_id();        
                $this->db->trans_complete(); 
            }
        }
        elseif($data['status'] == 0){
            if ( ! empty($data))
            {
                $this->db->trans_start();
                $this->db->insert($this->table, $data);        
                $id = $this->db->insert_id();        
                $this->db->trans_complete(); 
            }
        }
        else{
            $result = $query->result();
            foreach ($result as $res){
               $id = $res->id;
            }
        }
        return $id;        
    }
    public function getSatCat($idm){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_membres ', $idm);
        $query = $this->db->get(); 
        return $query;
    }
    public function getFavoris($idm){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_membres ', $idm);
        $this->db->limit(10);
        $query = $this->db->get(); 
        return $query;
    }

    public function getFavorisByIdProgramType($idPr,$type){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_prg', $idPr);
        $this->db->where('type', $type);
        $query = $this->db->get(); 
        return $query->num_rows();
    }

    public function getFavorisByIdProgramTypeStatus($idPr,$type,$status){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_prg', $idPr);
        $this->db->where('type', $type);
        $this->db->where('status', $status);
        $query = $this->db->get(); 
        return $query->result();
    }
    public function getAllResultByActivity($idPr,$numero,$type,$status){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_prg', $idPr);
        $this->db->where('numero', $numero);
        $this->db->where('type', $type);
        $this->db->where('status', $status);
        $query = $this->db->get(); 
        return $query->result();
    }

    public function getAllFavorisByIdMmembres($idm){
        $this->db->select('p.*,c.id AS idClassification,c.intitule AS class');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_class.' as c','p.id_classification_favoris = c.id', 'inner');
        $this->db->where('p.id_membres', $idm);
        $this->db->where('p.id_classification_favoris != ', NULL);
        $this->db->order_by('p.type', 'asc');
        $query = $this->db->get(); 
        return $query;
    }

    public function getAllFavorisByIdMmembresNoClassify($idm){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_membres', $idm);
        $this->db->where('user_create', $idm);
        $this->db->where('status', 1);
        $this->db->where('id_classification_favoris', NULL);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query;
    }
    public function getAllPageContentByIdClassification($id_classification_favoris){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('type', 'page_content');
        $this->db->where('id_classification_favoris', $id_classification_favoris);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result();
    }
    public function getAllFavorisByIdMmembresNoClassifyByTutor($idm){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_membres', $idm);
        $this->db->where('user_create !=', $idm);
        $this->db->where('id_classification_favoris', NULL);
        $this->db->where('status', 1);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query;
    }

    public function getAllDifferentsFavorisByIdMmembres($idm){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_membres', $idm);
        //$this->db->where('user_create', $idm);
        $query = $this->db->get(); 
        return $query;
    }

    public function getAllExcericeByMembres($idm){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_membres', $idm);
        $this->db->where('status', 1);
        $query = $this->db->get(); 
        return $query->result();
    }

    public function getAllFavorisByUserCreate($user_create){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $user_create);
        $this->db->where('status', 1);
        $query = $this->db->get(); 
        return $query;
    }

    public function getAllFavorisByIdMmembresUserCreate($user_create,$id_membres){
        $this->db->select('p.*,c.id AS idClassification,c.intitule AS class');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_class.' as c','p.id_classification_favoris = c.id', 'inner');
        $this->db->where('p.user_create', $user_create);
        $this->db->where('p.id_membres', $id_membres);
        $this->db->where('p.id_classification_favoris != ', NULL);
        $this->db->order_by('p.type', 'asc');
        $query = $this->db->get(); 
        return $query;
    }


    public function getAllFavorisByIdMmembresUserCreateNoClassify($user_create,$id_membres){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $user_create);
        $this->db->where('id_membres', $id_membres);
        $this->db->where('id_classification_favoris', NULL);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query;
    }

    public function getAllDifferentsFavorisByIdMmembresUserCreate($user_create,$id_membres){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $user_create);
        $this->db->where('id_membres', $id_membres);
        $query = $this->db->get(); 
        return $query;
    }
    

    public function getAllFavorisByIdClassIdStagiaire($idClass,$idStagiaire){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_classification_favoris', $idClass);
        $this->db->where('id_membres', $idStagiaire);
        $query = $this->db->get(); 
        return $query;
    }

    public function getAllByIdClassification($idClass){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_classification_favoris', $idClass);
        $this->db->where('status', 1);
        $query = $this->db->get(); 
        return $query;
    }

     public function getAllFavorisByIdClassIdStagiaireUserCreate($idClass,$idStagiaire){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_classification_favoris', $idClass);
        $this->db->where('id_membres', $idStagiaire);
        $this->db->where('user_create', $idStagiaire);
        $query = $this->db->get(); 
        return $query;
    }

     public function getAllFavorisByIdClassIdStagiaireUserCreateByDashbord($idClass,$idStagiaire){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_classification_favoris', $idClass);
        $this->db->where('id_membres', $idStagiaire);
        $this->db->where('user_create', $idStagiaire);
        $this->db->limit(2);
        $query = $this->db->get(); 
        return $query;
    }

    public function getDataArticleByIdAndIntitule($status,$idArticle){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_prg', $idArticle);
        $this->db->where('type', "nl_article");
        $this->db->where('status', $status);
        $query = $this->db->get(); 
        return $query->result();
    }

    public function verifyExistance($dataArray){
        $this->db->select('*');
        $this->db->from($this->table);
        if (isset($dataArray['id_membres'])) {
            $this->db->where('id_membres', $dataArray['id_membres']);
        }
        if (isset($dataArray['user_create'])) {
            $this->db->where('user_create', $dataArray['user_create']);
        }
        if (isset($dataArray['id_prg'])) {
            $this->db->where('id_prg', $dataArray['id_prg']);
        }
        if (isset($dataArray['numero'])) {
            $this->db->where('numero', $dataArray['numero']);
        }
        if (isset($dataArray['id_classification_favoris'])) {
            $this->db->where('id_classification_favoris', $dataArray['id_classification_favoris']);
        }
        if (isset($dataArray['module_id'])) {
            $this->db->where('module_id', $dataArray['module_id']);
        }
        if (isset($dataArray['intitule'])) {
            $this->db->where('intitule', $dataArray['intitule']);
        }
        if (isset($dataArray['status'])) {
            $this->db->where('status', $dataArray['status']);
        }
        if (isset($dataArray['type'])) {
            $this->db->where('type', $dataArray['type']);
        }        
        $query = $this->db->get(); 
        return $query->result();
    }     
}

?>
