<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

	class Stat_model extends CI_Model
	{

		public function __construct(){        
	        parent::__construct();
	        $this->load->model('membres_model');
	        $this->load->model('utilities_model');
	        $this->load->model('log_model');
	        $this->table         = 'stat_connexion';        
	        $this->table_membres = 'membres';        
	        $this->table_soc     = 'list_societe';        
	        $this->table_tracking     = 'tracking';        
	        $this->table_seq     = 'sequence';        
	        $this->table_list_seq= 'list_sequence';        
	    }

	    public function RequestByIdMembres($field,$id) {
	        $this->db->select($field);
	        $this->db->from($this->table);
	        $this->db->where('id_membres', $id);
	        $this->db->order_by('date_cnx', 'DESC');
	        $this->db->limit(1);
	        $query = $this->db->get();
	        $result = $query->result();
	        $ret = "";
	        if ($query->num_rows() != 0) {
	            foreach ($result as $res){
	                $ret .= $res->$field ;
	            }
	        }       
	        return($ret);
	    }

		public function elearningF2plusStat($stagiaire_id) {
		 	$dt           = new DateTime();
		 	$date         =  $dt->format('Y-m-d');
		 	$date_explode = explode("-", $date);
		 	$mois         = $date_explode[1];
		 	$annee        = $date_explode[0];
		 	$d1           = date("U", mktime(0, 0, 0, $mois, 1 ,$annee));
		 	$d2           = date("U", mktime(0, 0, 0, $mois +1, 0, $annee));
		 	$startTime = mktime(0, 0, 0, date('m')-1 , 1 , date('Y')); 
		 	$endTime = mktime(23, 59, 59, date('m'), date('d')-date('j'), date('Y'));
		 	//années en cours
		 	$startTimeYear = mktime(0, 0, 0, 1, 1, date('Y')); 
		 	$endTimeYear = time();


			$ret = array() ;
			$i = 0 ;

			$this->db->select("m.id,m.prenom, m.nom, m.email, s.description as societe,(select SEC_TO_TIME(sum(time_cnx)) from ".$this->table." where id_membres='".$stagiaire_id."' and date_cnx >='".$endTime."' and date_cnx <='".$d2."') as duree_connexion,(select SEC_TO_TIME(sum(time_cnx)) from stat_connexion where id_membres='".$stagiaire_id."' and date_cnx >='".$startTime."' and date_cnx <='".$endTime."') as duree_connexion_month_before,(select SEC_TO_TIME(sum(time_cnx)) from ".$this->table." where id_membres='".$stagiaire_id."' and date_cnx >='".$startTimeYear."' and date_cnx <='".$endTimeYear."') as duree_connexion_for_year, from_unixtime((select date_cnx from ".$this->table." where id_membres='".$stagiaire_id."' order by date_cnx desc limit 1,1)) as date_connexion, m.nbconnexion, m.id_groupe");
	        $this->db->from($this->table_membres." as m");
        	$this->db->join($this->table_soc." as s", 's.id_societe=m.id_societe','left');
	        $this->db->where('m.id', $stagiaire_id);
	        $this->db->limit(1);
	        $query = $this->db->get();        
	        $result =  $query->result();
	        if (is_array($result)) {
	        
		        foreach ($result as $res){
					$ret['id']		                 = $res->id;
					$ret['prenom']	                 = htmlentities($res->prenom);
					$ret['nom']		                 = htmlentities($res->nom);
					$ret['societe']                  = htmlentities($res->societe);
					$ret['date_connexion']           = $res->date_connexion;
					$ret['totalTimeConnexion']       = $res->duree_connexion;
					$ret['totalTimeConnexionBefore'] = $res->duree_connexion_month_before;
					$ret['totalTimeConnexionYear']   = $res->duree_connexion_for_year;
					$ret['nbconnexion']              = $res->nbconnexion;
					$ret['documents']                = $this->elearningF2plusNbDoc($res->id_groupe);
					$ret['liens']                    = $this->elearningF2plusNbLink($res->id_groupe);
					$ret['totaltime']                = $this->elearningF2plusDetailCnx($stagiaire_id,$res->id_groupe);
					$i++ ;
		        }
		    }

			return($ret);
		}


		public function elearningF2plusNbDoc($groupe_id) {

			$this->db->select('*');
	        $this->db->from("document");
	        $this->db->where('groupe', $groupe_id);
	        $this->db->where('lien', "");	      
	        $query = $this->db->get(); 
	        return $query->num_rows();
		}

		public function elearningF2plusNbLink($groupe_id) {

			$this->db->select('count(*) as nbLink');
	        $this->db->from("document");
	        $this->db->where('groupe', $groupe_id);
	        $this->db->where('lien', "lien");	      
	        $query = $this->db->get(); 
	        $result= $query->result();
	        foreach ($result as $res){
	            return ($res->nbLink);	            
	        }
		}

		public function elearningF2plusDetailCnx($idu, $idg) {

            $ret = $this->log_model->read($idu) ;
			if ( $ret['cnt'] > 0 ) {
				$tot = 0 ;
				for ( $i=0; $i<$ret['cnt']; $i++) {
					/*$res = explode(':',$ret[$i]['time']) ;
					$tot = $tot + ($res[0]) + ($res[1]) + $res[2] ;*/
					$tot += $ret[$i]['time'];
				}
				return $this->utilities_model->ReplaceTime($tot);
			}
		}

		public function getTimeCnxGlobal($stagiaire_id){
			$this->db->select("s.cnx, s.id_membres, s.id_groupe,s.date_cnx as date_cnx_unix, date(from_unixtime(s.date_cnx)) as  date_cnx, time(from_unixtime(s.date_cnx)) as heures_cnx, SEC_TO_TIME(sum(time_cnx)) as duree_cnx,sum(time_cnx) as time_cnx_tot,
                (select count(*) from tracking t where t.user_id=".$stagiaire_id." AND t.groupe_id=s.id_groupe and date(from_unixtime(t.`date`))=date(from_unixtime(s.date_cnx))) as total_activite,
                (select count(*) from session_tutoree st where (date(from_unixtime(st.date_debut_cnx))=date(from_unixtime(s.date_cnx)) and st.id_stagiaire=s.id_membres)) as session_tutoree");
	        $this->db->from($this->table." as s");
        	$this->db->join($this->table_membres." as m", 'm.id=s.id_membres','inner');
	        $this->db->where('m.id', $stagiaire_id);
	        $this->db->where('s.date_cnx >=', "m.date_creation");
	        $this->db->group_by('date(from_unixtime(s.date_cnx))');
        	$this->db->order_by('s.date_cnx', 'desc');
	        $query = $this->db->get();        
	        return $query->result();
		}


		public function getTimeCnxForMonth($stagiaire_id){
			$dt                = new DateTime();
            $date              =  $dt->format('Y-m-d');
            $date_explode      = explode("-", $date);
			$mois              = $date_explode[1];
            $annee             = $date_explode[0];
            $d2                = date("U", mktime(0, 0, 0, $mois +1, 0, $annee));
            $endTime           = mktime(23, 59, 59, date('m'), date('d')-date('j'), date('Y'));

			$this->db->select("s.cnx, s.id_membres, s.id_groupe,s.date_cnx as date_cnx_unix, date(from_unixtime(s.date_cnx)) as  date_cnx, time(from_unixtime(s.date_cnx)) as heures_cnx, SEC_TO_TIME(sum(time_cnx)) as duree_cnx,sum(time_cnx) as time_cnx_tot,
                (select count(*) from tracking t where t.user_id=".$stagiaire_id." AND t.user_id=s.id_membres and date(from_unixtime(t.`date`))=date(from_unixtime(s.date_cnx)) and t.groupe_id=s.id_groupe) as total_activite,
                (select count(*) from session_tutoree st where (date(from_unixtime(st.date_debut_cnx))=date(from_unixtime(s.date_cnx)) and st.id_stagiaire=s.id_membres)) as session_tutoree");
	        $this->db->from($this->table." as s");
        	$this->db->join($this->table_membres." as m", 'm.id=s.id_membres','inner');
	        $this->db->where('m.id', $stagiaire_id);
	        $this->db->where('s.date_cnx >=', $endTime);
	        $this->db->where('s.date_cnx <=', $d2);
	        $this->db->group_by('date(from_unixtime(s.date_cnx))');
        	$this->db->order_by('s.date_cnx', 'desc');
	        $query = $this->db->get();        
	        return $query->result();
		}

		public function getTimeCnxForMonthBefore($stagiaire_id){
			$startTime         = mktime(0, 0, 0, date('m')-1 , 1 , date('Y')); 
            $endTime           = mktime(23, 59, 59, date('m'), date('d')-date('j'), date('Y'));

			$this->db->select("s.cnx, s.id_membres, s.id_groupe,s.date_cnx as date_cnx_unix, date(from_unixtime(s.date_cnx)) as  date_cnx, time(from_unixtime(s.date_cnx)) as heures_cnx, SEC_TO_TIME(sum(time_cnx)) as duree_cnx,sum(time_cnx) as time_cnx_tot,
                (select count(*) from tracking t where t.user_id=".$stagiaire_id." AND t.user_id=s.id_membres and date(from_unixtime(t.`date`))=date(from_unixtime(s.date_cnx)) and t.groupe_id=s.id_groupe) as total_activite,
                (select count(*) from session_tutoree st where (date(from_unixtime(st.date_debut_cnx))=date(from_unixtime(s.date_cnx)) and st.id_stagiaire=s.id_membres)) as session_tutoree");
	        $this->db->from($this->table." as s");
        	$this->db->join($this->table_membres." as m", 'm.id=s.id_membres','inner');
	        $this->db->where('m.id', $stagiaire_id);
	        $this->db->where('s.date_cnx >=', $startTime);
	        $this->db->where('s.date_cnx <=', $endTime);
	        $this->db->group_by('date(from_unixtime(s.date_cnx))');
        	$this->db->order_by('s.date_cnx', 'desc');
	        $query = $this->db->get();        
	        return $query->result();
		}
		public function getTimeCnxForYear($stagiaire_id){
			$startTimeYear     = mktime(0, 0, 0, 1, 1, date('Y')); 
            $endTimeYear       = time();
            //$endTimeYear       = mktime();

			$this->db->select("s.cnx, s.id_membres, s.id_groupe,s.date_cnx as date_cnx_unix, month(from_unixtime(s.date_cnx)) as  date_cnx, SEC_TO_TIME(sum(time_cnx)) as duree_cnx,sum(time_cnx) as time_cnx_tot, 
                (select count(*) from tracking t where  t.user_id=".$stagiaire_id." AND t.user_id=s.id_membres and month(from_unixtime(t.`date`))=month(from_unixtime(s.date_cnx)) and t.groupe_id=s.id_groupe) as total_activite");
	        $this->db->from($this->table." as s");
        	$this->db->join($this->table_membres." as m", 'm.id=s.id_membres','inner');
	        $this->db->where('m.id', $stagiaire_id);
	        $this->db->where('s.date_cnx >=', $startTimeYear);
	        $this->db->where('s.date_cnx <=', $endTimeYear);
	        $this->db->group_by('month(from_unixtime(s.date_cnx))');
        	$this->db->order_by('s.date_cnx', 'asc');
	        $query = $this->db->get();        
	        return $query->result();
		}

		/*public function getDetailStat($stagiaire_id,$group,$date_connexion, $limit=NULL, $offset=NULL){
			$date_convert = date('d-m-Y', $date_connexion);
			$date_convert_explode = explode("-", $date_convert);
			$date_end_request = mktime(23, 59, 59, $date_convert_explode[1],$date_convert_explode[0],$date_convert_explode[2]);

			$this->db->select("date(FROM_unixtime(t.`date`)) as date_exercice , time(FROM_unixtime(t.`date`)) as heure_exercice ,SEC_TO_TIME (t.time) as duree_exercice,
                l.sequence_titre as sequence, s.titre as exercice");
	        $this->db->from($this->table_tracking." as t");
        	$this->db->join($this->table_seq." as s", 's.numero=t.chapitre_id AND s.id_sequence=t.sequence_id','inner');
        	$this->db->join($this->table_list_seq." as l", 'l.sequence_id=t.sequence_id ','inner');
	        $this->db->where('t.date >=', $date_connexion);
	        $this->db->where('t.date <=', $date_end_request);
	        $this->db->where('t.user_id', $stagiaire_id);
	        $this->db->where('t.groupe_id', $group);
        	$this->db->order_by('zt.date', 'desc');
        	if ($limit != NULL || $offset != NULL) {
        		$this->db->limit($limit, $offset);
        	}        	
	        $query = $this->db->get();        
	        return $query->result();
		}*/

		public function getDetailStat($stagiaire_id,$group,$date_connexion){
			$date_convert = date('d-m-Y', $date_connexion);
			$date_convert_explode = explode("-", $date_convert);
			$date_end_request = mktime(23, 59, 59, $date_convert_explode[1],$date_convert_explode[0],$date_convert_explode[2]);

			$this->db->select("*");
	        $this->db->from($this->table_tracking);
	        $this->db->where('date >=', $date_connexion);
	        $this->db->where('date <=', $date_end_request);
	        $this->db->where('user_id', $stagiaire_id);
	        $this->db->where('groupe_id', $group);
        	$this->db->order_by('date', 'desc');     	
	        $query = $this->db->get();        
	        return $query->result();
		}


		public function getCountTimeCnxGlobal($stagiaire_id){
			$this->db->select("*");
			$this->db->from($this->table." as s");
        	$this->db->join($this->table_membres." as m", 'm.id=s.id_membres','inner');
	        $this->db->where('m.id', $stagiaire_id);
	        $this->db->where('s.date_cnx >=', "m.date_creation");
	        $this->db->group_by('date(from_unixtime(s.date_cnx))');
        	$this->db->order_by('s.date_cnx', 'desc');
	        $query = $this->db->get();        
	        return $query->num_rows();
		}

		public function getCountTimeCnxForMonth($stagiaire_id){
			$dt                = new DateTime();
            $date              =  $dt->format('Y-m-d');
            $date_explode      = explode("-", $date);
			$mois              = $date_explode[1];
            $annee             = $date_explode[0];
            $d2                = date("U", mktime(0, 0, 0, $mois +1, 0, $annee));
            $endTime           = mktime(23, 59, 59, date('m'), date('d')-date('j'), date('Y'));
            
			$this->db->select("*");
			$this->db->from($this->table." as s");
        	$this->db->join($this->table_membres." as m", 'm.id=s.id_membres','inner');
	        $this->db->where('m.id', $stagiaire_id);
	        $this->db->where('s.date_cnx >=', $endTime);
	        $this->db->where('s.date_cnx <=', $d2);
	        $this->db->group_by('date(from_unixtime(s.date_cnx))');
        	$this->db->order_by('s.date_cnx', 'desc');
	        $query = $this->db->get();        
	        return $query->num_rows();
		}

		public function getCountTimeCnxForYear($stagiaire_id){
			$startTimeYear     = mktime(0, 0, 0, 1, 1, date('Y')); 
            $endTimeYear       = time();
			$this->db->select("*");
	        $this->db->from($this->table." as s");
        	$this->db->join($this->table_membres." as m", 'm.id=s.id_membres','inner');
	        $this->db->where('m.id', $stagiaire_id);
	        $this->db->where('s.date_cnx >=', $startTimeYear);
	        $this->db->where('s.date_cnx <=', $endTimeYear);
	        $this->db->group_by('date(from_unixtime(s.date_cnx))');
        	$this->db->order_by('s.date_cnx', 'desc');
	        $query = $this->db->get();         
	        return $query->num_rows();
		}
		public function getCountTimeCnxForMonthBefore($stagiaire_id){
			$startTime         = mktime(0, 0, 0, date('m')-1 , 1 , date('Y')); 
            $endTime           = mktime(23, 59, 59, date('m'), date('d')-date('j'), date('Y'));
			$this->db->select("*");
	        $this->db->from($this->table." as s");
        	$this->db->join($this->table_membres." as m", 'm.id=s.id_membres','inner');
	        $this->db->where('m.id', $stagiaire_id);
	        $this->db->where('s.date_cnx >=', $startTime);
	        $this->db->where('s.date_cnx <=', $endTime);
	        $this->db->group_by('date(from_unixtime(s.date_cnx))');
        	$this->db->order_by('s.date_cnx', 'desc');
	        $query = $this->db->get();        
	        return $query->num_rows();
		}

	}