<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Newsletter_model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->db_newsletter = $this->load->database("newsletter",TRUE);
        $this->table_article = 'nl_articles';        
        $this->table_terme   = 'nl_termes';        
        $this->table_month   = 'nl_monthnewsletters';  
        $this->table_level   = 'nl_niveau';           
        $this->table_nl_articles_nl_themes   = 'nl_articles_nl_themes';           
    }

    public function getMonthById($id) {
        $this->db_newsletter->select('monthNewsletter');
        $this->db_newsletter->from($this->table_month);
        $this->db_newsletter->where('id', $id);
        $query = $this->db_newsletter->get(); 
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->monthNewsletter ;
            }
        }       
        return($ret);
    }

    public function updateArticle($ID,$data) {
        $this->db_newsletter->where('ID', $ID);
        $this->db_newsletter->update($this->table_article, $data);
        $this->db_newsletter->affected_rows();
    }

    public function listMonth() {
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_month);
        $this->db_newsletter->order_by('id', 'DESC');
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        return $result;
    }

    public function getArticleOfTheMonth() {
        return $this->listArticle($this->getMaxIdInMonth());
    }

    public function getActualMonth() {
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_month);
        $this->db_newsletter->order_by('id', 'desc');
        $this->db_newsletter->limit(1);
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        return $result;
    }

    public function getLastMonth($maxId) {
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_month);
        $this->db_newsletter->where('id !=',$maxId);
        $this->db_newsletter->order_by('id', 'desc');
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        return $result;
    }

    public function getMaxIdInMonth(){
        $maxId = 0;
        $this->db_newsletter->select('MAX(id) AS idMax');
        $this->db_newsletter->from($this->table_month);
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        foreach ($result as $m) {
            $maxId = $m->idMax;
        }
        return $maxId;
    }
    public function listArticle($idM) {
        $this->db_newsletter->select('art.*,if(n.id = 0, 0, if(n.id = 1, 1, if(n.id = 2, 2, if(n.id = 3, 3, "")))) AS nbLevel, if(n.id = 0, "", if(n.id = 1, "PREINTERMEDIATE", if(n.id = 2, "INTERMEDIATE", if(n.id = 3, "ADVANCED", "")))) AS level, if(n.id = 0, "", if(n.id = 1, "level-pre-intermediate", if(n.id = 2, "level-intermediate", if(n.id = 3, "level-advenced", "")))) AS levelClassContainer, if(n.id = 0, "", if(n.id = 1, "level_preintermediate", if(n.id = 2, "level_intermediate", if(n.id = 3, "level_advanced", "")))) AS levelTranslateLang');
        $this->db_newsletter->from($this->table_article.' AS art');
        $this->db_newsletter->join($this->table_level.' AS n', 'n.id = art.niveau_id','LEFT');
        $this->db_newsletter->where('art.nl_monthnewsletter_id', $idM);
        $this->db_newsletter->where('art.publier', true);
        $this->db_newsletter->order_by('art.ID','DESC');
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        return $result;
    }

    public function allListArticle($idM) {
        $this->db_newsletter->select('art.*,if(n.id = 0, 0, if(n.id = 1, 1, if(n.id = 2, 2, if(n.id = 3, 3, "")))) AS nbLevel, if(n.id = 0, "", if(n.id = 1, "PREINTERMEDIATE", if(n.id = 2, "INTERMEDIATE", if(n.id = 3, "ADVANCED", "")))) AS level, if(n.id = 0, "", if(n.id = 1, "level-pre-intermediate", if(n.id = 2, "level-intermediate", if(n.id = 3, "level-advenced", "")))) AS levelClassContainer, if(n.id = 0, "", if(n.id = 1, "level_preintermediate", if(n.id = 2, "level_intermediate", if(n.id = 3, "level_advanced", "")))) AS levelTranslateLang');
        $this->db_newsletter->from($this->table_article.' AS art');
        $this->db_newsletter->join($this->table_level.' AS n', 'n.id = art.niveau_id','LEFT');
        $this->db_newsletter->where('art.nl_monthnewsletter_id', $idM);
        $this->db_newsletter->order_by('art.ID','DESC');
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        return $result;
    }

    public function getAllArticle() {
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_article);
        $this->db_newsletter->order_by('niveau_id','ASC');
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        return $result;
    }

    public function getArticle($idA) {
        $this->db_newsletter->select('art.*, if(n.id = 0, "", if(n.id = 1, "level-pre-intermediate", if(n.id = 2, "level-intermediate", if(n.id = 3, "level-advenced", "")))) AS levelClassContainer, n.id AS levelId, if(n.id = 0, "", if(n.id = 1, "level_preintermediate", if(n.id = 2, "level_intermediate", if(n.id = 3, "level_advanced", "")))) AS levelTranslateLang, if(n.id = 0, 0, if(n.id = 1, 1, if(n.id = 2, 2, if(n.id = 3, 3, "")))) AS nbLevel');
        $this->db_newsletter->from($this->table_article.' AS art');
        $this->db_newsletter->join($this->table_level.' AS n', 'n.id = art.niveau_id','LEFT');
        $this->db_newsletter->where('art.ID', $idA);
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        return $result;
    }

    public function getEndArticle($url){
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_article);
        $this->db_newsletter->where('origine', $url);
        //$this->db_newsletter->order_by('ID', 'DESC');
        //$this->db_newsletter->limit(1);
        $query = $this->db_newsletter->get(); 
        return $query->result()  ;   
    }

    public function getTerme($idA) {
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_terme);
        $this->db_newsletter->where('nl_article_id', $idA);
        $query = $this->db_newsletter->get(); 
        return $query->result()  ;        
    }
    public function getAllTerme() {
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_terme);
        $query = $this->db_newsletter->get(); 
        return $query->result()  ;        
    }
    public function getTermes($idT) {
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_terme);
        $this->db_newsletter->where('ID', $idT);
        $query = $this->db_newsletter->get(); 
        return $query->result()  ;        
    }

    public function listCategories() {
        $this->db_newsletter->select('theme');
        $this->db_newsletter->from($this->table_article);
        $this->db_newsletter->group_by('theme');
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        return $result;
    }

    public function getCntArticleWithTheme($theme) {
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_article);
        $this->db_newsletter->where('theme', $theme);
        $this->db_newsletter->order_by('niveau_id','ASC');
        $query = $this->db_newsletter->get(); 
        return $query;        
    }
    public function getArticleWithTheme($theme,$rowperpage, $rowno) {
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_article);
        $this->db_newsletter->where('theme', $theme);
        $this->db_newsletter->limit($rowperpage, $rowno);
        $this->db_newsletter->order_by('niveau_id','ASC');
        $query = $this->db_newsletter->get(); 
        return $query;        
    }
    public function Request($field,$idu) {
        $this->db_newsletter->select($field);
        $this->db_newsletter->from($this->table_article);
        $this->db_newsletter->where('ID', $idu);
        $query = $this->db_newsletter->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
    public function RequestMonth($field,$id) {
        $this->db_newsletter->select($field);
        $this->db_newsletter->from($this->table_month);
        $this->db_newsletter->where('id', $id);
        $query = $this->db_newsletter->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function getArticleWithThemeAndL($nl_theme_id) {
        $this->db_newsletter->select('art.*,if(n.id = 0, 0, if(n.id = 1, 1, if(n.id = 2, 2, if(n.id = 3, 3, "")))) AS nbLevel, if(n.id = 0, "", if(n.id = 1, "PREINTERMEDIATE", if(n.id = 2, "INTERMEDIATE", if(n.id = 3, "ADVANCED", "")))) AS level, if(n.id = 0, "", if(n.id = 1, "level-pre-intermediate", if(n.id = 2, "level-intermediate", if(n.id = 3, "level-advenced", "")))) AS levelClassContainer, if(n.id = 0, "", if(n.id = 1, "level_preintermediate", if(n.id = 2, "level_intermediate", if(n.id = 3, "level_advanced", "")))) AS levelTranslateLang');
        $this->db_newsletter->from($this->table_article.' AS art');
        $this->db_newsletter->join($this->table_level.' AS n', 'n.id = art.niveau_id','LEFT');
        $this->db_newsletter->join($this->table_nl_articles_nl_themes.' AS theme', 'art.ID = theme.nl_article_id', 'LEFT');
        $this->db_newsletter->where('theme.nl_theme_id', $nl_theme_id);
        $this->db_newsletter->where('art.publier', true);
        $this->db_newsletter->order_by('art.ID','DESC');
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        return $result;
    }

    public function getAllArticleWithThemeAndL($nl_theme_id) {
        $this->db_newsletter->select('art.*,if(n.id = 0, 0, if(n.id = 1, 1, if(n.id = 2, 2, if(n.id = 3, 3, "")))) AS nbLevel, if(n.id = 0, "", if(n.id = 1, "PREINTERMEDIATE", if(n.id = 2, "INTERMEDIATE", if(n.id = 3, "ADVANCED", "")))) AS level, if(n.id = 0, "", if(n.id = 1, "level-pre-intermediate", if(n.id = 2, "level-intermediate", if(n.id = 3, "level-advenced", "")))) AS levelClassContainer, if(n.id = 0, "", if(n.id = 1, "level_preintermediate", if(n.id = 2, "level_intermediate", if(n.id = 3, "level_advanced", "")))) AS levelTranslateLang');
        $this->db_newsletter->from($this->table_article.' AS art');
        $this->db_newsletter->join($this->table_level.' AS n', 'n.id = art.niveau_id','LEFT');
        $this->db_newsletter->join($this->table_nl_articles_nl_themes.' AS theme', 'art.ID = theme.nl_article_id', 'LEFT');
        $this->db_newsletter->where('theme.nl_theme_id', $nl_theme_id);
        $this->db_newsletter->order_by('art.ID','DESC');
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        return $result;
    }

    public function getByLevel($level) {
        $this->db_newsletter->select('art.*,if(n.id = 0, 0, if(n.id = 1, 1, if(n.id = 2, 2, if(n.id = 3, 3, "")))) AS nbLevel, if(n.id = 0, "", if(n.id = 1, "PREINTERMEDIATE", if(n.id = 2, "INTERMEDIATE", if(n.id = 3, "ADVANCED", "")))) AS level, if(n.id = 0, "", if(n.id = 1, "level-pre-intermediate", if(n.id = 2, "level-intermediate", if(n.id = 3, "level-advenced", "")))) AS levelClassContainer, if(n.id = 0, "", if(n.id = 1, "level_preintermediate", if(n.id = 2, "level_intermediate", if(n.id = 3, "level_advanced", "")))) AS levelTranslateLang');
        $this->db_newsletter->from($this->table_article.' AS art');
        $this->db_newsletter->join($this->table_level.' AS n', 'n.id = art.niveau_id','INNER');
        $this->db_newsletter->where('n.id',$level);
        $this->db_newsletter->where('art.publier', true);
        $this->db_newsletter->order_by('art.ID','DESC');
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        return $result;
    }

     public function getALLByLevel($level) {
        $this->db_newsletter->select('art.*');
        $this->db_newsletter->from($this->table_article.' as art');
        $this->db_newsletter->join($this->table_level.' as lvl','lvl.id=art.niveau_id','inner');
        $this->db_newsletter->where('lvl.id',$level);
        //$this->db_newsletter->order_by('art.niveau_id', 'ASC');
        $this->db_newsletter->order_by('art.ID','DESC');
        $query = $this->db_newsletter->get(); 
        return $query->result(); 
           
    }


    public function getAllLevel() {
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_level);
        $this->db_newsletter->order_by('id', 'ASC');
        $query = $this->db_newsletter->get(); 
        return $query->result(); 
           
    }

    public function RequestByLevel($field,$id) {
        $this->db_newsletter->select($field);
        $this->db_newsletter->from($this->table_level);
        $this->db_newsletter->where('id', $id);
        $query = $this->db_newsletter->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    /*public function getArticleWithThemeAndLimits($theme,$limit,$start) {
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_article);
        $this->db_newsletter->where('theme', $theme);
        $this->db_newsletter->limit($limit, $start);
        echo $this->db_newsletter->get_compiled_select();
        die();
        $query = $this->db_newsletter->get(); 
        return $query->result();
    }*/

}

?>
