<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class DatabankExpression_Model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->table        = 'expressions_stagiaires';
        $this->table_lang   = 'langage_list';
        $this->table_membre = 'membres';
        $this->table_cat    = 'category_expression';
    }

    public function countByIdStagiaire($id_stagiaire){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_stagiaire', $id_stagiaire);
        $query = $this->db->get();         
        return $query->num_rows();        
    }

    public function addCategory($data){
        $this->db->trans_start();
        $this->db->insert($this->table_cat, $data);       
        $id = $this->db->insert_id(); 
        $this->db->trans_complete();
        return $id;
    }

    public function getLangageList() {
        $this->db->select('*');
        $this->db->from($this->table_lang);
        $query = $this->db->get(); 
        return $query->result()  ;
    }
    public function getExistCatByIntituleAndGroup($intitule,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table_cat);
        $this->db->where('id_groupe ', $idGroup);
        $this->db->where('intitule ', $intitule);
        $query = $this->db->get(); 
        return $query->num_rows();
    }

    public function getCategoryByIdGroup($idGroup) {
        $this->db->select('*');
        $this->db->from($this->table_cat); 
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('intitule', 'ASC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }
     public function getCategoryByUserCreateInGroup($userCreate,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table_cat);
        $this->db->where('user_create', $userCreate);
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('intitule', 'desc');
        $query = $this->db->get(); 
        return $query->result()  ;
    }
     public function getCategoryByUserCreate($user_create) {
        $this->db->select('*');
        $this->db->from($this->table_cat);
        $this->db->where('user_create', $user_create);
        $this->db->order_by('intitule', 'desc');
        $query = $this->db->get(); 
        return $query->result()  ;
    }
    public function read($idS='') {
        $this->db->select('*');
        $this->db->from($this->table." as e");
        $this->db->join($this->table_lang.' as l', 'e.target_langue_cible=l.id','left');
        if ($idS != "") {
           $this->db->where('e.id_stagiaire ', $idS);
        }
        $this->db->order_by('e.content_langue_origine', 'asc');
        $query = $this->db->get(); 
        $result = $query->result()  ;
        return $result;
    }

    public function readExpressionAdmin($idS='') {
        $this->db->select('m.*,e.*,l.intitule');
        $this->db->from($this->table." as e");
        $this->db->join($this->table_membre.' as m', 'e.id_stagiaire=m.id','left');
        $this->db->join($this->table_lang.' as l', 'l.id=e.target_langue_cible','inner');
        if ($idS != "") {
           $this->db->where('e.id_stagiaire ', $idS);
        }
        $this->db->order_by('e.content_langue_origine', 'asc');
        $query = $this->db->get(); 
        $result = $query->result()  ;
        return $result;
    }

    public function readExpressionTuteur($idS){
        $this->db->select("e.*,l.id,l.intitule");
        $this->db->from($this->table." as e");
        $this->db->join($this->table_lang." as l", 'e.target_langue_cible=l.id');
        $this->db->where("e.id_stagiaire",$idS);
        $query = $this->db->get(); 
        $result = $query->result()  ;
        return $result;
    }

    public function deleteExpression($id){
        $this->db->delete($this->table, array('id_expression' => $id));
    }

    public function editExpression($id, array $data)
    {
        
        $this->db->update($this->table, $data, array('id_expression' => $id));

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            return FALSE;
        }
        $this->db->trans_commit();
        return TRUE;
    }

    public function Expression($idE){
        $this->db->select('*');
        $this->db->from($this->table." as e");
        $this->db->join($this->table_lang." as l", 'e.target_langue_cible=l.id');
        $this->db->where('e.id_expression', $idE);
        return $this->db->get(); 
    }

    public function addExpression($data){
        $this->db->trans_start();
        $this->db->insert($this->table, $data);       
        $id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $id;
    }
    public function getListLangage(){   

        $this->db->select('*');
        $this->db->from($this->table_lang);
        $query = $this->db->get(); 
        return $query->result();


    }

    public function getNameOfCategory($idCat){
        if ($idCat != NULL || $idCat != '') {          
            $this->db->select('*');
            $this->db->from($this->table_cat);
            $this->db->where("id",$idCat);
            $query = $this->db->get(); 
            foreach ($query->result() as $res) {
                return $res->intitule;
            }
        }
        else{
            return '';
        }
    }

    public function traineeExpressions($idS){
        $this->db->select("e.*,l.id,l.intitule,l.abrev");
        $this->db->from($this->table." as e");
        $this->db->join($this->table_lang." as l", 'e.target_langue_cible=l.id');
        $this->db->where("e.id_stagiaire",$idS);
        $this->db->group_by('e.id_expression');          
        return $this->db->get();
    }

    public function getAllNotInCat($idS){
        $this->db->select("e.*,l.id,l.intitule,l.abrev");
        $this->db->from($this->table." as e");
        $this->db->join($this->table_lang." as l", 'e.target_langue_cible=l.id');
        $this->db->where("e.id_stagiaire",$idS);
        $this->db->where("e.id_category",NULL);
        $this->db->where("e.type_exp",'text');
        $this->db->group_by('e.id_expression');  
        return $this->db->get();
    }

    public function getAllByCat($idS){
        $this->db->select("e.*,l.id,l.intitule,l.abrev");
        $this->db->from($this->table." as e");
        $this->db->join($this->table_lang." as l", 'e.target_langue_cible=l.id');
        $this->db->where("e.id_stagiaire",$idS);
        $this->db->where("e.id_category != ",NULL);
        $this->db->group_by('e.id_expression');          
        return $this->db->get();
    }

    public function traineeExpression($idS,$key="",$startDate="",$endDate=""){
        $this->db->select("e.*,l.id,l.intitule,l.abrev");
        $this->db->from($this->table." as e");
        $this->db->join($this->table_lang." as l", 'e.target_langue_cible=l.id');

        if (isset($key) && $key != "") {
            $key = "(e.content_langue_origine  LIKE '%".$key."%'
                            OR e.content_langue_cible  LIKE '%".$key."%') ";
            $this->db->where($key);
        }

        if (isset($startDate) && $startDate != "") {
           $this->db->where('e.date_creation >=', date('Y-m-d H:i:s', strtotime($startDate)));
        }

        if (isset($endDate) && $endDate != "") {
           $this->db->where('e.date_creation <=', date('Y-m-d H:i:s', strtotime($endDate)));
        }

        $this->db->where("e.id_stagiaire",$idS);
        $this->db->group_by('e.id_expression');  
        
        return $this->db->get();
    }

    public function getAllByCategory($idS,$idCategory){
        $this->db->select("*");
        $this->db->from($this->table);
        $this->db->where("id_stagiaire",$idS);
        $this->db->where("id_category",$idCategory);
        $this->db->order_by('id_expression', 'desc');
        $query = $this->db->get();
        return $query->result();
    }

    public function getListByCat($idStagiaire,$idCategory){
        $this->db->select("*");
        $this->db->from($this->table);
        $this->db->where("id_category",$idCategory);
        $this->db->where("id_stagiaire",$idStagiaire);
        $this->db->order_by('id_expression', 'desc');
        $query = $this->db->get();
        return $query->result();
    }


    public function getAllByTrainee($idStagiaire){
        $this->db->select("*");
        $this->db->from($this->table);
        $this->db->where("id_stagiaire",$idStagiaire);
        $this->db->order_by('id_expression', 'desc');
        $query = $this->db->get();
        return $query->result();
    }


    public function getByCat($idCategory){
        $this->db->select("*");
        $this->db->from($this->table);
        $this->db->where("id_category",$idCategory);
        $this->db->order_by('id_expression', 'desc');
        $query = $this->db->get();
        return $query->result();
    }

    public function listExpression($idS,$likeCriteria="",$startDate="",$endDate="",$limit=NULL, $offset=NULL){
        $this->db->select("e.*,l.id,l.intitule");
        $this->db->from($this->table." as e");
        $this->db->join($this->table_lang." as l", 'e.target_langue_cible=l.id');

        if (isset($likeCriteria) && $likeCriteria != "") {
            $likeCriteria = "(e.content_langue_origine  LIKE '%".$likeCriteria."%'
                            OR e.content_langue_cible  LIKE '%".$likeCriteria."%') ";
            $this->db->where($likeCriteria);
        }

        if (isset($startDate) && $startDate != "") {
           $this->db->where('e.date_creation >=', date('Y-m-d H:i:s', strtotime($startDate)));
        }

        if (isset($endDate) && $endDate != "") {
           $this->db->where('e.date_creation <=', date('Y-m-d H:i:s', strtotime($endDate)));
        }

        $this->db->where("e.id_stagiaire",$idS);
        if ($limit != NULL || $offset != NULL) {
            $this->db->limit($limit, $offset);
        }
        return $this->db->get();
    }

    public function addOriginAudio($id,$data){

        $this->db->update($this->table, $data, array('id_expression' => $id));

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            return FALSE;
        }
        $this->db->trans_commit();
        return TRUE;

    }

    public function Request($field,$id_expression) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id_expression', $id_expression);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
    public function RequestCat($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table_cat);
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

   
     
}

?>
