<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Connexion_model extends CI_Model
{
    
    public function __construct(){        
        parent::__construct();
        $this->load->model('membres_model');
        $this->load->model('utilities_model');
        $this->load->model('Stag_individu_model');
        $this->table           = 'stat_connexion';        
        $this->table_list_grp  = 'list_groupe';        
        $this->table_connexion = 'connexion';        
        $this->table_membres   = 'membres';      
        $this->table_stag_individu   = 'stag_individu';     
        $this->table_cours_plannifier   = 'cours_plannifier';        
        $this->table_tracking   = 'tracking';        
        $this->table_cours_history   = 'historique_cours';        
    }

    public function newconnexion($idu,$app_active)
    {
        $this->IncNbCnx($idu)   ;
        $this->db->where('id_user', $idu);
        $this->db->delete($this->table_connexion);      
        $date = $this->utilities_model->FormatDate();
        $ids  = $this->GetIdCnx();


        $this->db->trans_start();
        $cnxInfo = array('id_user'=>$idu, 'id_connexion'=>$ids, 'date_connexion'=>$date);
        $this->db->insert($this->table_connexion, $cnxInfo);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
     
        $this->newLog($idu,$ids,$app_active);
        return($ids);
    }

    public function IncNbCnx($idu) {
        $date = $this->utilities_model->FormatDate();

        $result = $this->membres_model->getInfoMembres($idu);
        foreach ($result as $res){
            $nbConnexionF = $res->nbconnexion+1;
        }

        $cnxInfo = array('nbconnexion'=>$nbConnexionF, 'date_connexion'=>$date);
        $this->db->where('id', $idu);
        $this->db->update('membres', $cnxInfo);
        return true;    
    }

    public function GetIdCnx() {
        list($usec, $sec) = explode(' ', microtime());
        $seed =  (float) $sec + ((float) $usec * 100000);
        srand($seed);
        $prefix = '' ;
        $taille = 50  ;
        $value = '' ;
        $value = "abcdefghijklmnopqrstuvwxyz" ;
        $value.= "1234567890" ;
        $value.= "ABCDEFGHIJKLMNOPQRSTUVWXYZ" ;
        $id = '' ;
        for ( $i=0; $i<$taille; $i++ ) {
            $id .= substr($value,(rand()%(strlen($value))),1);
        }
        define('CNX', $prefix.$id)  ;
        return ($prefix.$id) ;
    }   

    public function Activity($idu) {
           
        $this->db->select('activity');
        $this->db->from($this->table_connexion);
        $this->db->where('id_user', $idu);
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ;   
        if (is_array($result)) {
            foreach ($result as $res){
                return($res->activity);               
            }
        } 
        else{
            return "";
        }

    }


    
    public function newLog($idu, $cnx, $app_active) {
        $date = $this->utilities_model->FormatDate();        
        require_once('Browser.php');
        $browser = new Browser();  


        $groupeId = $this->membres_model->Request('id_groupe',$idu);

        $statInfo = array(
            'cnx'=>$cnx, 
            'id_membres'=>$idu, 
            "date_cnx" => $date, 
            "time_cnx" => '0', 
            "date_logout" => $date, 
            'id_groupe' => $this->membres_model->Request('id_groupe',$idu), 
            'navigateur' => $browser->getBrowser()." ".$browser->getVersion(), 
            'platform' => $browser->getPlatform(),
            'id_adresse' => $this->input->ip_address(),
            'app_active' => $app_active,
            'id_stage' => $this->Stag_individu_model->getMaxNumStageByIdMembers($idu) != null ? $this->Stag_individu_model->getMaxNumStageByIdMembers($idu) : null
        );

        //Create a new connexion in db
        $this->db->trans_start();
        $this->db->insert($this->table, $statInfo);        
        $idcnxstat = $this->db->insert_id();        
        $this->db->trans_complete();



        $cnxUserInfo = array('id_cnx'=>$cnx, 'id_user'=>$idu, "date_login" => $date, "date_logout" => '0', 'navigateur' => $browser->getBrowser()." ".$browser->getVersion(),'platform' => $browser->getPlatform());

        //add user in log data user db
        $this->db->trans_start();
        $this->db->insert('cnx_user', $cnxUserInfo);        
        $idcnxuser = $this->db->insert_id();        
        $this->db->trans_complete();
        return true;
    }   
     

    public function destroyManual($cnx,$dateUpdate) {  
        
        //Refresh page to update time cnx from user
        $this->updateTimeCnxManual($cnx,$dateUpdate);

        //update date logout from user
        $cnxInfo = array('date_logout'=>$dateUpdate);
        if ($cnxInfo) {
            $this->db->where('id_cnx', $cnx);
            $this->db->update('cnx_user', $cnxInfo);
        } 

        //delete cnx from user
        $this->db->where('id_connexion', $cnx);
        $this->db->delete($this->table_connexion);    
        return true;        

    }  



    public function updateTimeCnxManual($cnx,$dateUpdate)
    {
        $cnxInfo = array('date_logout'=>$dateUpdate);
        $this->db->where('cnx', $cnx);
        $this->db->update($this->table, $cnxInfo);
        return $cnx;
    }  

    public function update($cnx,$dataArray)
    {
        $this->db->where('cnx', $cnx);
        $this->db->update($this->table, $dataArray);
        return $cnx;
    }  
     

    public function destroy($cnx) {
        $date = $this->utilities_model->FormatDate();       
        
        //Refresh page to update time cnx from user
        $this->utilities_model->updateTimeCnx($cnx);

        //update date logout from user
        $cnxInfo = array('date_logout'=>$date);
        if ($cnxInfo) {
            $this->db->where('id_cnx', $cnx);
            $this->db->update('cnx_user', $cnxInfo);
        } 

        //delete cnx from user
        $this->db->where('id_connexion', $cnx);
        $this->db->delete($this->table_connexion);    
        return true;        

    }

    public function updateUserCnx($cnx,$data){
        $this->db->where('id_cnx', $cnx);
        $this->db->update('cnx_user', $data);
    }


    public function destroyCnx($cnx){
        $this->db->where('id_connexion', $cnx);
        $this->db->delete($this->table_connexion);  
    }


    public function checkOnline($idu) {
        $this->db->select('date_connexion');
        $this->db->from($this->table_connexion);
        $this->db->where('id_user', $idu);
        $query = $this->db->get(); 
        $row = $query->num_rows();
        if ( $row > 0 ) {        
            $isOnline = true;
        } 
        else{
            $isOnline = false;
        }
        return $isOnline;
    }

    public function getOnlineIdConnexion($idu) {
        $idConnexion = '';
        $this->db->select('id_connexion');
        $this->db->from($this->table_connexion);
        $this->db->where('id_user', $idu);
        $query = $this->db->get();     
        if ($query->num_rows() > 0 ) {        
            foreach ($query->result() as $res) {
               $idConnexion = $res->id_connexion;
            }        
        } 
        else{
            $idConnexion = "";
        }
        return $idConnexion;
    }

    public function LastTimeConnection($idu) {
        $this->db->select('TIME(FROM_UNIXTIME(s.date_cnx)) as Last_connection');
        $this->db->from('stat_connexion as s');
        $this->db->where('s.id_membres', $idu);
        $this->db->group_by('s.date_cnx', 'desc');
        $this->db->limit(1);
        $query = $this->db->get(); 
        $row = $query->num_rows();
        if ( $row > 0 ) {        
            $ret = $query->result()  ;          
        } 
        else{
            $ret = "";
        }
        return $ret;
    }

    public function LastConnection($idu) {
        $this->db->select('DATE(FROM_UNIXTIME(MAX(s.date_cnx))) as Last_connection');
        $this->db->from('stat_connexion as s');
        $this->db->where('s.id_membres', $idu);
        $this->db->order_by('s.date_cnx', 'desc');
        $this->db->limit(1);
        $query = $this->db->get(); 
        $row = $query->num_rows();
        if ( $row > 0 ) {        
            $ret = $query->result();          
        } 
        else{
            $ret = "";
        }
        return $ret;
    }
    public function GetNbConnexionGroupe($idg) {
        $this->db->select('SUM(nbconnexion) as nb');
        $this->db->from('membres as m');
        $this->db->join('groupe as g', 'g.id_membres=m.id','left');
        $this->db->where('g.id_membres', $idg);
        $query = $this->db->get();
        $result = $query->result();          
        
        return $result;
    }


    public function connectionGlobal($idu) {

        $this->db->select('SEC_TO_TIME(SUM(time_cnx)) as cnxg');
        $this->db->from('stat_connexion');
        $this->db->where('id_membres', $idu);
        $query = $this->db->get();
        $result = $query->result();          
        
        return $result;

    }

    public function getIdCnxUser($idu){
        $this->db->select('id_connexion');
        $this->db->from($this->table_connexion);
        $this->db->where('id_user', $idu);
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ;   
        if (is_array($result)) {
            foreach ($result as $res){
                return($res->id_connexion);               
            }
        } 
        else{
            return "";
        }
    }

     public function getInfoSessionByCnx($cnx){
        $this->db->select('id_connexion');
        $this->db->from($this->table_connexion);
        $this->db->where('id_connexion', $cnx);
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ;   
        if (is_array($result)) {
            foreach ($result as $res){
                return($res->id_connexion);               
            }
        } 
        else{
            return "";
        }
    }
    public function refresh($cnx) {
        $ret = array();
        $now = time();
        $this->db->select('date_cnx');
        $this->db->from($this->table);
        $this->db->where('cnx', $cnx);
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ;   
        if (is_array($result)) {
            foreach ($result as $res){
                $time = $now - $res->date_cnx;
                $cnxInfo = array('time_cnx'=>$time);
                $this->db->where('cnx', $cnx);                
                $ret['update_cnx'] = $this->db->update($this->table, $cnxInfo);          
            }
        }
        return $ret;
    }

    public function readCnxActive() {
        $ret = array() ;        
        $i = 0 ;
        $this->db->select('DATE(FROM_UNIXTIME(m.date_connexion)) as debutConnexion, m.prenom, m.nom, m.id, m.type, c.activity, c.id_connexion, if(m.type = 0, "STAGIAIRE", if (m.type = 2, "ADMIN", if (m.type=3 and m.tuteur_entreprise = 0, "TUTEUR", if (m.type=3 and m.tuteur_entreprise = 1, "RF", if (m.type = 4, "SUPERVISEUR","auteur???"))))) as ROLE, (SELECT TIME(FROM_UNIXTIME(tr.date)) FROM '.$this->table_tracking.' AS tr WHERE tr.user_id = c.id_user ORDER BY tr.id_tracking DESC LIMIT 1) AS dernierClick');
        $this->db->from($this->table_connexion.' AS c');
        $this->db->join($this->table_membres.' AS m', 'c.id_user=m.id','INNER');
        $this->db->order_by('c.date_connexion', 'DESC');
        $query = $this->db->get(); 
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;   
        if (is_array($result)) {
            foreach ($result as $res){
                $ret[$i]['prenom']          = $res->prenom;
                $ret[$i]['nom']             = $res->nom;
                $ret[$i]['utilisateur']     = $res->nom.' '.$res->prenom;
                $ret[$i]['id']              = $res->id;
                $ret[$i]['type']            = $res->type;
                $ret[$i]['role']            = $res->ROLE;
                $ret[$i]['activity']        = $res->activity ;
                $ret[$i]['id_connexion']    = $res->id_connexion ;
                $ret[$i]['dernierClick']    = $res->dernierClick ;
                $ret[$i]['debutConnexion']  = $res->debutConnexion ;
                $i++ ;           
            }
        }
        return $ret;
    }


     public function LastTimeConnectionPorteteuille($idu) {
        $this->db->select('TIME(FROM_UNIXTIME(s.date_cnx)) as Last_connection');
        $this->db->from('stat_connexion as s');
        $this->db->where('s.id_membres', $idu);
        $this->db->group_by('s.date_cnx', 'desc');
        $this->db->limit(1);
        $query = $this->db->get(); 
        $row = $query->num_rows();
        if ( $row > 0 ) {        
            foreach ($query->result() as $res) {
               $ret = $res->Last_connection;
            }        
        } 
        else{
            $ret = "";
        }
        return $ret;
    }

    public function LastConnectionPortefeuille($idu) {
        $this->db->select('DATE(FROM_UNIXTIME(MAX(s.date_cnx))) as Last_connection');
        $this->db->from('stat_connexion as s');
        $this->db->where('s.id_membres', $idu);
        $this->db->order_by('s.date_cnx', 'desc');
        $this->db->limit(1);
        $query = $this->db->get(); 
        $row = $query->num_rows();
        if ( $row > 0 ) {        
            foreach ($query->result() as $res) {
                $ret = $res->Last_connection;
            }
        } 
        else{
            $ret = "";
        }
        return $ret;
    }
    public function GetNbConnexionGroupePortefeuille($idg) {
        $this->db->select('SUM(nbconnexion) as nb');
        $this->db->from('membres as m');
        $this->db->join('groupe as g', 'g.id_membres=m.id','left');
        $this->db->where('g.id_membres', $idg);
        $query = $this->db->get();
        $result = $query->result();
        foreach ($result as $res) {
           return $res->nb;
        }
    }


    public function connectionGlobalPortefeuille($idu) {

        $this->db->select('SEC_TO_TIME(SUM(time_cnx)) as cnxg');
        $this->db->from('stat_connexion');
        $this->db->where('id_membres', $idu);
        $query = $this->db->get();
        $result = $query->result();          
        foreach ($result as $res) {
            return $res->cnxg;
        }

    }

    public function getAllUserConnected($dateNow){
        $this->db->select('*,s.time_cnx,SEC_TO_TIME(s.time_cnx) AS total_time_connexion, m.id AS idUsers');
        $this->db->from($this->table_connexion.' as c');
        $this->db->join($this->table_membres.' as m', 'm.id=c.id_user','inner');
        $this->db->join($this->table.' as s', 's.cnx=c.id_connexion','inner');
        $this->db->where('DATE(from_unixtime(s.date_cnx))', $dateNow);
        $this->db->where('m.type !=', 2);
        $this->db->order_by('m.type', 'ASC');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }
    public function getAllCnxRestante($idUser) {
        $ret = array();
        $this->db->select('*');
        $this->db->from($this->table_connexion);
        $this->db->where('id_user', $idUser);
        $query = $this->db->get();
        $ret['count'] = $query->num_rows();
        $result = $query->result();
        if ($ret['count'] >= 1) {
            foreach ($result as $res){
                $ret['date_connexion']= $res->date_connexion ;
                $ret['id_connexion']  = $res->id_connexion ;
            }
        }       
        return($ret);
    }

    public function RequestByIdCnx($field,$idCnx) {
        $this->db->select($field);
        $this->db->from($this->table_connexion);
        $this->db->where('id_connexion', $idCnx);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function RequestByStatCnx($field,$cnx) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('cnx', $cnx);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function Request($field,$idUser) {
        $this->db->select($field);
        $this->db->from($this->table_connexion);
        $this->db->where('id_user', $idUser);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
    public function getMaxDataFirstConnexion($idUser) {
        $this->db->select('MAX(date_cnx) AS dateFirstMaxCnx');
        $this->db->from($this->table);
        $this->db->where('id_membres', $idUser);
        $this->db->where('DATE(from_unixtime(date_cnx))', date("Y-m-d"));
        $this->db->limit(1);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->dateFirstMaxCnx ;
            }
        }       
        return($ret);
    }
    public function getMaxDataEndConnexion($idUser) {
        $this->db->select('MAX(date_logout) AS dateEndMaxCnx');
        $this->db->from($this->table);
        $this->db->where('id_membres', $idUser);
        $this->db->where('DATE(from_unixtime(date_cnx))', date("Y-m-d"));
        $this->db->limit(1);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->dateEndMaxCnx ;
            }
        }       
        return($ret);
    }
    public function getMaxDataDureeConnexion($idUser) {
        $this->db->select('SEC_TO_TIME(SUM(time_cnx)) AS timeMaxCnx');
        $this->db->from($this->table);
        $this->db->where('id_membres', $idUser);
        $this->db->where('DATE(from_unixtime(date_cnx))', date("Y-m-d"));
        $this->db->limit(1);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->timeMaxCnx ;
            }
        }       
        return($ret);
    }


    public function getMaxDataEndConnexionNowByUser($idUser) {
        $ret = array();
        $this->db->select('time_cnx AS unixTimeCnx, SEC_TO_TIME(time_cnx) AS dureeCnx, TIME(FROM_UNIXTIME(date_cnx)) AS debutCnx, TIME(FROM_UNIXTIME(date_logout)) AS finCnx, date_logout AS unixTimeFinCnx,, cnx AS idCnx, navigateur, platform, id_adresse AS ipAdress, id_groupe AS idGroupe');
        $this->db->from($this->table);
        $this->db->where('id_membres', $idUser);
        $this->db->where('DATE(from_unixtime(date_cnx))', date("Y-m-d"));
        $this->db->order_by('date_cnx', 'desc');
        $this->db->limit(1);
        $query = $this->db->get();
        $ret['count'] = $query->num_rows();
        $result = $query->result();
        if ($ret['count'] > 0) {
            foreach ($result as $res){
                $ret['dureeCnx']      = $res->dureeCnx ;
                $ret['debutCnx']      = $res->debutCnx ;
                $ret['finCnx']        = $res->finCnx ;
                $ret['idCnx']         = $res->idCnx ;
                $ret['navigateur']    = $res->navigateur ;
                $ret['platform']      = $res->platform ;
                $ret['ipAdress']      = $res->ipAdress ;
                $ret['idGroupe']      = $res->idGroupe ;
                $ret['unixTimeCnx']   = $res->unixTimeCnx ;
                $ret['unixTimeFinCnx']= $res->unixTimeFinCnx ;
            }
        }       
        return($ret);
    }
    public function getMaxDataEndConnexionByUser($idUser) {
        $ret = array();
        $this->db->select('SEC_TO_TIME(time_cnx) AS dureeCnx, DATE(FROM_UNIXTIME(date_cnx)) AS dateDebutCnx, TIME(FROM_UNIXTIME(date_cnx)) AS debutCnx, TIME(FROM_UNIXTIME(date_logout)) AS finCnx, cnx AS idCnx, navigateur, platform, id_adresse AS ipAdress, id_groupe AS idGroupe, app_active');
        $this->db->from($this->table);
        $this->db->where('id_membres', $idUser);
        $this->db->order_by('date_cnx', 'desc');
        $this->db->limit(1);
        $query = $this->db->get();
        $ret['count'] = $query->num_rows();
        $result = $query->result();
        if ($ret['count'] > 0) {
            foreach ($result as $res){
                $ret['dureeCnx']   = $res->dureeCnx ;
                $ret['debutCnx']   = $res->debutCnx ;
                $ret['finCnx']     = $res->finCnx ;
                $ret['idCnx']      = $res->idCnx ;
                $ret['navigateur'] = $res->navigateur ;
                $ret['platform']   = $res->platform ;
                $ret['ipAdress']   = $res->ipAdress ;
                $ret['idGroupe']   = $res->idGroupe ;
                $ret['dateDebutCnx']   = $res->dateDebutCnx ;
                $ret['app_active']   = $res->app_active ;
            }
        }       
        return($ret);
    }


    public function getInfosCnxByCnx($cnx) {
        $ret = array();
        $this->db->select('time_cnx, date_cnx, SEC_TO_TIME(time_cnx) AS dureeCnx, DATE(FROM_UNIXTIME(date_cnx)) AS dateDebutCnx, TIME(FROM_UNIXTIME(date_cnx)) AS debutCnx, TIME(FROM_UNIXTIME(date_logout)) AS finCnx, cnx AS idCnx, navigateur, platform, id_adresse AS ipAdress, id_groupe AS idGroupe');
        $this->db->from($this->table);
        $this->db->where('cnx', $cnx);
        $query = $this->db->get();
        return $query->result();
    }

    public function getAllCnxByUsers($idUser) {
        $ret = array();
        $this->db->select('cnx, time_cnx, date_cnx, SEC_TO_TIME(time_cnx) AS dureeCnx, DATE(FROM_UNIXTIME(date_cnx)) AS dateDebutCnx, TIME(FROM_UNIXTIME(date_cnx)) AS debutCnx, TIME(FROM_UNIXTIME(date_logout)) AS finCnx, cnx AS idCnx, navigateur, platform, id_adresse AS ipAdress, id_groupe AS idGroupe');
        $this->db->from($this->table);
        $this->db->order_by('date_cnx','DESC');
        $this->db->where('id_membres', $idUser);
        $query = $this->db->get();
        return $query->result();
    }

    public function getAllTraineeConnecter(){
        $return = array();
        $i = 0;
        $this->db->select('c.*');
        $this->db->from($this->table_connexion. ' AS c');
        $this->db->join($this->table_membres. ' AS m', 'c.id_user = m.id', 'INNER');
        $this->db->where('m.type', 0);
        $query  = $this->db->get(); 
        $result = $query->result(); 
        foreach($result as $res){
            $return[$i] = $res->id_user;
            $i++;
        }
        return $return;

    }

    public function getDataScreenPiloting($arrayKeySearch){
        $return = array();
        $i = 0;
        /*$this->db->select('DATE(`cp`.`dateHeureCoursPlannifier`) AS datePlannification, (SELECT `ch`.`intitule` FROM '.$this->table_cours_history.' AS `ch` WHERE `ch`.`id_groupe` = `m`.`id_groupe` AND `ch`.`user_create` IN (SELECT `id` FROM `membres` WHERE `extranet_id` = `cp`.`refIndividuProfCoursPlannifier`) AND `ch`.`date_planification` = DATE(cp.dateHeureCoursPlannifier) LIMIT 1) AS `courseHistory`, if(`id_connexion` = `cnx`, `id_connexion`, "") AS `idConnexion`, `m`.`mode_acces` AS `profilEl`, `cp`.`typeDeCoursCoursPlannifier`, `s`.`cnx` AS `idCnx`, `cp`.`idStageCoursPlannifier`, `cp`.`dateHeureCoursPlannifier`, `cp`.`refIndividuProfCoursPlannifier`, `cp`.`dureeCoursPlannifier`, `cp`.`typeDureeCoursPlannifier`, CONCAT(cp.nomStagiaireCoursPlannifier, " ", cp.prenomStagiaireCoursPlannifier) as stagiaireCoursPlanifier, CONCAT(cp.nomProfCoursPlannifier, " ", cp.prenomProfCoursPlannifier) as profCoursPlanifier, TIME(FROM_UNIXTIME(s.date_cnx)) AS debutCnx, DATE(FROM_UNIXTIME(s.date_cnx)) AS dernierCnx, if(`typeDureeCoursPlannifier` = null and `dureeCoursPlannifier` = 30, "30", if(`typeDureeCoursPlannifier` = null and `dureeCoursPlannifier` = 1, "30", if(`typeDureeCoursPlannifier` = 2 and `dureeCoursPlannifier` = 30, "30", if (typeDureeCoursPlannifier = 2 and dureeCoursPlannifier = null, "30", if (typeDureeCoursPlannifier = 1 and dureeCoursPlannifier = 3, "180", if (typeDureeCoursPlannifier = 1 and dureeCoursPlannifier = 0.5, "30", if (typeDureeCoursPlannifier = 1 and dureeCoursPlannifier = 1.5, "90", if (typeDureeCoursPlannifier = 1 and dureeCoursPlannifier = 0, "0", if (typeDureeCoursPlannifier = 1 and dureeCoursPlannifier = 1, "60", ""))))))))) AS dureCoursPlannifier, if(`app_active` = "EL", "V1", if(`app_active` = "EL V1", "V1", if(`app_active` = "EL V3", "V3", if(`app_active` = "MYODB", "MYODB", "Inconnu")))) as plateformeEL');*/
        $this->db->select('DATE(`cp`.`dateHeureCoursPlannifier`) AS datePlannification, (SELECT `ch`.`intitule` FROM '.$this->table_cours_history.' AS `ch` WHERE `ch`.`id_groupe` = `m`.`id_groupe` AND `ch`.`user_create` IN (SELECT `id` FROM `membres` WHERE `extranet_id` = `cp`.`refIndividuProfCoursPlannifier`) AND `ch`.`date_planification` = DATE(cp.dateHeureCoursPlannifier) LIMIT 1) AS `courseHistory`, if(`id_connexion` = `cnx`, `id_connexion`, "") AS `idConnexion`, `m`.`mode_acces` AS `profilEl`, `cp`.`typeDeCoursCoursPlannifier`, `s`.`cnx` AS `idCnx`, `cp`.`idStageCoursPlannifier`, `cp`.`dateHeureCoursPlannifier`, `cp`.`refIndividuProfCoursPlannifier`, `cp`.`dureeCoursPlannifier`, `cp`.`typeDureeCoursPlannifier`, CONCAT(cp.nomStagiaireCoursPlannifier, " ", cp.prenomStagiaireCoursPlannifier) as stagiaireCoursPlanifier, CONCAT(cp.nomProfCoursPlannifier, " ", cp.prenomProfCoursPlannifier) as profCoursPlanifier, TIME(FROM_UNIXTIME(s.date_cnx)) AS debutCnx, DATE(FROM_UNIXTIME(s.date_cnx)) AS dernierCnx, if(`typeDureeCoursPlannifier` = null and `dureeCoursPlannifier` = 30, "30", if(`typeDureeCoursPlannifier` = null and `dureeCoursPlannifier` = 1, "30", if(`typeDureeCoursPlannifier` = 2 and `dureeCoursPlannifier` = 30, "30", if (typeDureeCoursPlannifier = 2 and dureeCoursPlannifier = null, "30", if (typeDureeCoursPlannifier = 1 and dureeCoursPlannifier = 3, "180", if (typeDureeCoursPlannifier = 1 and dureeCoursPlannifier = 0.5, "30", if (typeDureeCoursPlannifier = 1 and dureeCoursPlannifier = 1.5, "90", if (typeDureeCoursPlannifier = 1 and dureeCoursPlannifier = 0, "0", if (typeDureeCoursPlannifier = 1 and dureeCoursPlannifier = 1, "60", ""))))))))) AS dureCoursPlannifier');
        $this->db->from($this->table_cours_plannifier. ' AS cp');
        $this->db->join($this->table_membres. ' AS m', 'm.extranet_id = cp.refIndividuStagiaireCoursPlannifier', 'INNER');
        $this->db->join($this->table. ' AS s', 's.id_stage = cp.idStageCoursPlannifier', 'LEFT');  

        /*switch ($arrayKeySearch['statusConnexion']) {
            case 1: // Connected
                $this->db->join($this->table_connexion. ' AS c', '`c`.`id_user` = `s`.`id_membres` AND `c`.`id_connexion` = `s`.`cnx`', 'INNER');
                break;
            case 2: // Disconnected
                //$this->db->join($this->table_connexion. ' AS c', '`c`.`id_user` = `s`.`id_membres` AND `s`.`cnx` NOT IN (SELECT id_connexion FROM '.$this->table_connexion.' WHERE id_user = s.id_membres)', 'INNER');
                $this->db->join($this->table_connexion. ' AS c', '`c`.`id_connexion` != `s`.`cnx`', 'INNER');
                //$this->db->where_not_in('`s`.`cnx`', 'SELECT id_connexion FROM connexion');
                //$this->db->where('`s`.`cnx` !=', '');
                break;
            
            default:
                $this->db->join($this->table_connexion. ' AS c', '`c`.`id_user` = `s`.`id_membres` AND `c`.`id_connexion` = `s`.`cnx`', 'LEFT');
                break;
        }*/

        $this->db->join($this->table_connexion. ' AS c', '`c`.`id_user` = `s`.`id_membres` AND `c`.`id_connexion` = `s`.`cnx`', 'LEFT');

        if (isset($arrayKeySearch['datePlannification'])) {
            if ($arrayKeySearch['datePlannification'][0] != '' && $arrayKeySearch['datePlannification'][1] != '') {
                $this->db->where('DATE(cp.dateHeureCoursPlannifier) BETWEEN "'.$arrayKeySearch['datePlannification'][0].'" AND "'.$arrayKeySearch['datePlannification'][1].'" ');
            }
            else{
                $this->db->where_in('DATE(cp.dateHeureCoursPlannifier)', $arrayKeySearch['datePlannification'][0]);
            }
        }

        if (isset($arrayKeySearch['crenneauHoraire'])) {
            $this->db->where_in('TIME(cp.dateHeureCoursPlannifier)', $arrayKeySearch['crenneauHoraire']);
        }

        $this->db->where('m.type', 0);
        $this->db->group_by(array("cp.dateHeureCoursPlannifier", "cp.idStageCoursPlannifier"));
        $this->db->order_by('cp.dateHeureCoursPlannifier', 'ASC');
        $query  = $this->db->get(); 
        return $query->result(); 

    }
}

?>
