<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/asset/v1/asset_service.proto

namespace Google\Cloud\Asset\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request message for
 * [AssetService.AnalyzeOrgPolicyGovernedAssets][google.cloud.asset.v1.AssetService.AnalyzeOrgPolicyGovernedAssets].
 *
 * Generated from protobuf message <code>google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest</code>
 */
class AnalyzeOrgPolicyGovernedAssetsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The organization to scope the request. Only organization
     * policies within the scope will be analyzed. The output assets will
     * also be limited to the ones governed by those in-scope organization
     * policies.
     * * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
     *
     * Generated from protobuf field <code>string scope = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $scope = '';
    /**
     * Required. The name of the constraint to analyze governed assets for. The
     * analysis only contains analyzed organization policies for the provided
     * constraint.
     *
     * Generated from protobuf field <code>string constraint = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $constraint = '';
    /**
     * The expression to filter the governed assets in result. The only supported
     * fields for governed resources are `governed_resource.project` and
     * `governed_resource.folders`. The only supported fields for governed iam
     * policies are `governed_iam_policy.project` and
     * `governed_iam_policy.folders`. The only supported operator is `=`.
     * Example 1: governed_resource.project="projects/12345678" filter will return
     * all governed resources under projects/12345678 including the project
     * ifself, if applicable.
     * Example 2: governed_iam_policy.folders="folders/12345678" filter will
     * return all governed iam policies under folders/12345678, if applicable.
     *
     * Generated from protobuf field <code>string filter = 3;</code>
     */
    private $filter = '';
    /**
     * The maximum number of items to return per page. If unspecified,
     * [AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets]
     * will contain 100 items with a maximum of 200.
     *
     * Generated from protobuf field <code>optional int32 page_size = 4;</code>
     */
    private $page_size = null;
    /**
     * The pagination token to retrieve the next page.
     *
     * Generated from protobuf field <code>string page_token = 5;</code>
     */
    private $page_token = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $scope
     *           Required. The organization to scope the request. Only organization
     *           policies within the scope will be analyzed. The output assets will
     *           also be limited to the ones governed by those in-scope organization
     *           policies.
     *           * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
     *     @type string $constraint
     *           Required. The name of the constraint to analyze governed assets for. The
     *           analysis only contains analyzed organization policies for the provided
     *           constraint.
     *     @type string $filter
     *           The expression to filter the governed assets in result. The only supported
     *           fields for governed resources are `governed_resource.project` and
     *           `governed_resource.folders`. The only supported fields for governed iam
     *           policies are `governed_iam_policy.project` and
     *           `governed_iam_policy.folders`. The only supported operator is `=`.
     *           Example 1: governed_resource.project="projects/12345678" filter will return
     *           all governed resources under projects/12345678 including the project
     *           ifself, if applicable.
     *           Example 2: governed_iam_policy.folders="folders/12345678" filter will
     *           return all governed iam policies under folders/12345678, if applicable.
     *     @type int $page_size
     *           The maximum number of items to return per page. If unspecified,
     *           [AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets]
     *           will contain 100 items with a maximum of 200.
     *     @type string $page_token
     *           The pagination token to retrieve the next page.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Asset\V1\AssetService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The organization to scope the request. Only organization
     * policies within the scope will be analyzed. The output assets will
     * also be limited to the ones governed by those in-scope organization
     * policies.
     * * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
     *
     * Generated from protobuf field <code>string scope = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * Required. The organization to scope the request. Only organization
     * policies within the scope will be analyzed. The output assets will
     * also be limited to the ones governed by those in-scope organization
     * policies.
     * * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
     *
     * Generated from protobuf field <code>string scope = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkString($var, True);
        $this->scope = $var;

        return $this;
    }

    /**
     * Required. The name of the constraint to analyze governed assets for. The
     * analysis only contains analyzed organization policies for the provided
     * constraint.
     *
     * Generated from protobuf field <code>string constraint = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getConstraint()
    {
        return $this->constraint;
    }

    /**
     * Required. The name of the constraint to analyze governed assets for. The
     * analysis only contains analyzed organization policies for the provided
     * constraint.
     *
     * Generated from protobuf field <code>string constraint = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setConstraint($var)
    {
        GPBUtil::checkString($var, True);
        $this->constraint = $var;

        return $this;
    }

    /**
     * The expression to filter the governed assets in result. The only supported
     * fields for governed resources are `governed_resource.project` and
     * `governed_resource.folders`. The only supported fields for governed iam
     * policies are `governed_iam_policy.project` and
     * `governed_iam_policy.folders`. The only supported operator is `=`.
     * Example 1: governed_resource.project="projects/12345678" filter will return
     * all governed resources under projects/12345678 including the project
     * ifself, if applicable.
     * Example 2: governed_iam_policy.folders="folders/12345678" filter will
     * return all governed iam policies under folders/12345678, if applicable.
     *
     * Generated from protobuf field <code>string filter = 3;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * The expression to filter the governed assets in result. The only supported
     * fields for governed resources are `governed_resource.project` and
     * `governed_resource.folders`. The only supported fields for governed iam
     * policies are `governed_iam_policy.project` and
     * `governed_iam_policy.folders`. The only supported operator is `=`.
     * Example 1: governed_resource.project="projects/12345678" filter will return
     * all governed resources under projects/12345678 including the project
     * ifself, if applicable.
     * Example 2: governed_iam_policy.folders="folders/12345678" filter will
     * return all governed iam policies under folders/12345678, if applicable.
     *
     * Generated from protobuf field <code>string filter = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * The maximum number of items to return per page. If unspecified,
     * [AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets]
     * will contain 100 items with a maximum of 200.
     *
     * Generated from protobuf field <code>optional int32 page_size = 4;</code>
     * @return int
     */
    public function getPageSize()
    {
        return isset($this->page_size) ? $this->page_size : 0;
    }

    public function hasPageSize()
    {
        return isset($this->page_size);
    }

    public function clearPageSize()
    {
        unset($this->page_size);
    }

    /**
     * The maximum number of items to return per page. If unspecified,
     * [AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets]
     * will contain 100 items with a maximum of 200.
     *
     * Generated from protobuf field <code>optional int32 page_size = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * The pagination token to retrieve the next page.
     *
     * Generated from protobuf field <code>string page_token = 5;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * The pagination token to retrieve the next page.
     *
     * Generated from protobuf field <code>string page_token = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

}

