<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/study.proto

namespace Google\Cloud\AIPlatform\V1\StudySpec\MetricSpec;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Used in safe optimization to specify threshold levels and risk tolerance.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig</code>
 */
class SafetyMetricConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Safety threshold (boundary value between safe and unsafe). NOTE that if
     * you leave SafetyMetricConfig unset, a default value of 0 will be used.
     *
     * Generated from protobuf field <code>double safety_threshold = 1;</code>
     */
    private $safety_threshold = 0.0;
    /**
     * Desired minimum fraction of safe trials (over total number of trials)
     * that should be targeted by the algorithm at any time during the
     * study (best effort). This should be between 0.0 and 1.0 and a value of
     * 0.0 means that there is no minimum and an algorithm proceeds without
     * targeting any specific fraction. A value of 1.0 means that the
     * algorithm attempts to only Suggest safe Trials.
     *
     * Generated from protobuf field <code>optional double desired_min_safe_trials_fraction = 2;</code>
     */
    private $desired_min_safe_trials_fraction = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type float $safety_threshold
     *           Safety threshold (boundary value between safe and unsafe). NOTE that if
     *           you leave SafetyMetricConfig unset, a default value of 0 will be used.
     *     @type float $desired_min_safe_trials_fraction
     *           Desired minimum fraction of safe trials (over total number of trials)
     *           that should be targeted by the algorithm at any time during the
     *           study (best effort). This should be between 0.0 and 1.0 and a value of
     *           0.0 means that there is no minimum and an algorithm proceeds without
     *           targeting any specific fraction. A value of 1.0 means that the
     *           algorithm attempts to only Suggest safe Trials.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\Study::initOnce();
        parent::__construct($data);
    }

    /**
     * Safety threshold (boundary value between safe and unsafe). NOTE that if
     * you leave SafetyMetricConfig unset, a default value of 0 will be used.
     *
     * Generated from protobuf field <code>double safety_threshold = 1;</code>
     * @return float
     */
    public function getSafetyThreshold()
    {
        return $this->safety_threshold;
    }

    /**
     * Safety threshold (boundary value between safe and unsafe). NOTE that if
     * you leave SafetyMetricConfig unset, a default value of 0 will be used.
     *
     * Generated from protobuf field <code>double safety_threshold = 1;</code>
     * @param float $var
     * @return $this
     */
    public function setSafetyThreshold($var)
    {
        GPBUtil::checkDouble($var);
        $this->safety_threshold = $var;

        return $this;
    }

    /**
     * Desired minimum fraction of safe trials (over total number of trials)
     * that should be targeted by the algorithm at any time during the
     * study (best effort). This should be between 0.0 and 1.0 and a value of
     * 0.0 means that there is no minimum and an algorithm proceeds without
     * targeting any specific fraction. A value of 1.0 means that the
     * algorithm attempts to only Suggest safe Trials.
     *
     * Generated from protobuf field <code>optional double desired_min_safe_trials_fraction = 2;</code>
     * @return float
     */
    public function getDesiredMinSafeTrialsFraction()
    {
        return isset($this->desired_min_safe_trials_fraction) ? $this->desired_min_safe_trials_fraction : 0.0;
    }

    public function hasDesiredMinSafeTrialsFraction()
    {
        return isset($this->desired_min_safe_trials_fraction);
    }

    public function clearDesiredMinSafeTrialsFraction()
    {
        unset($this->desired_min_safe_trials_fraction);
    }

    /**
     * Desired minimum fraction of safe trials (over total number of trials)
     * that should be targeted by the algorithm at any time during the
     * study (best effort). This should be between 0.0 and 1.0 and a value of
     * 0.0 means that there is no minimum and an algorithm proceeds without
     * targeting any specific fraction. A value of 1.0 means that the
     * algorithm attempts to only Suggest safe Trials.
     *
     * Generated from protobuf field <code>optional double desired_min_safe_trials_fraction = 2;</code>
     * @param float $var
     * @return $this
     */
    public function setDesiredMinSafeTrialsFraction($var)
    {
        GPBUtil::checkDouble($var);
        $this->desired_min_safe_trials_fraction = $var;

        return $this;
    }

}


