<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH . '/libraries/ElearningSupervisorForma2PlusController.php';

/**
 * Class : BaseController
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Statistique extends ElearningSupervisorForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();    
        $this->load->model('coursHistorik_model');
        $this->load->model('historik_course_nl_model');
        $this->load->model('todolist_model'); 
        $this->isLoggedIn(); 
        ini_set('memory_limit', -1);
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index() {
    }

    public function coursehistory() {    
        $this->global['pageTitle'] = 'E-learning : Statistique historique de cours'; 
        $data['allResultHistoriqCours'] = $this->coursHistorik_model->getAll();
        $this->loadViews("supervisor/statistique/historiqcours", $this->global, $data , NULL);
    }

    public function linksdocument() {    
        $this->global['pageTitle'] = 'E-learning : Statistique My links & documents'; 
        $data['allResultRepertoryDocument'] = $this->document_repository_model->getAllByTypeMmebres(STAGIAIRE);
        $data['allResultDocument'] = $this->document_model->getAll();
        $this->loadViews("supervisor/statistique/linksdocument", $this->global, $data , NULL);
    }

    public function trainingarea() {    
        $this->global['pageTitle'] = 'E-learning : Statistique historique de cours'; 
        $data['allResultHistoriqCours'] = $this->coursHistorik_model->getAll();
        $this->loadViews("supervisor/statistique/historiqcours", $this->global, $data , NULL);
    }

    public function alldata(){
        $this->global['pageTitle'] = 'E-learning : Statistique de toutes les données des stagiaires'; 
        $data['allTraineeResult'] = $this->membres_model->filtrer('', STAGIAIRE, 2);
        $this->loadViews("supervisor/statistique/alldata", $this->global, $data , NULL);
    }
}

?>