<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH . '/libraries/ElearningSupervisorForma2PlusController.php';
/**
 * Class : BaseController
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Dashboard extends ElearningSupervisorForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('document_model');
        $this->load->model('todolist_model');
        $this->load->model('stat_model');
        $this->load->model('Tracking_model');       
        $this->isLoggedIn(); 
        $this->tracking_type = 18;  
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        
        $trackingid = $this->Tracking_model->Add(0,0,$this->tracking_type);
        $sessionArray = array('TRACKINGID'=>$trackingid);                                    
        $this->session->set_userdata($sessionArray);
        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
        $this->global['pageTitle'] = 'E-learning : Dashboard';
        $this->global['groupe'] = $this->session->userdata ('GROUPE'); 
        $this->loadViews("supervisor/dashboard", $this->global, NULL , NULL);
    }
}

?>