<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Newsletter extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();    
        $this->isLoggedIn();   
        $this->load->model('societe_model');
        $this->load->helper('url');
        $this->load->library('pagination');

        $this->tracking_type = 6;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
    }


    public function read()
    {
      $this->global['pageTitle']  = 'E-learning : Newsletter'.isset($_GET['id']) ? $this->newsletter_model->Request('article',$_GET['id']) : '';
      $views = '';
      if ($this->session->userdata ('GUSERTYPE') == TUTEUR) {
          $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
      }
      
      if (isset($_GET)) {        
        $id                       = $_GET['id'];
        if (isset($_GET['page_name']) && $_GET['page_name'] == 'favoris') {
            $this->tracking_type = 24;
        }
        
        if (isset($_GET['id_st'])) {
          $this->loadTrackingEl($_GET['id_st'],$_GET['id'],$this->tracking_type);
        }
        else{
          $this->loadTrackingEl(0,$_GET['id'],$this->tracking_type);
        }
        
        $data['artcile']          = $this->newsletter_model->getArticle($id);
        $data['terme']            = $this->newsletter_model->getTerme($id);

        if ($this->session->userdata ('GUSERTYPE') == TUTEUR) {
          $data['classification_favoris'] = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));
          //$views = 'newsletter/read-art-pr';
        }
        else{
          $data['classification_favoris'] = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('GROUPE'));
          
        }

        $views = 'newsletter/read';

        $this->loadViews($views, $this->global,$data, NULL );
      }
    }

    public function addTermeExpression(){
      if (isset($_POST) && !empty($_POST['id'])) {
          $terme = $this->newsletter_model->getTermes($_POST['id']);
          if ($this->session->userdata ('GUSERTYPE') == STAGIAIRE) {
            $idStagiaire =  $this->session->userdata ('GUSERID');
          }
          else{
            $idStagiaire = $this->session->userdata ('STAGIAIREID');
          }
          foreach ($terme as $t) {
            if($this->isTuteurConnet()){
                $idTraineer = $this->session->userdata('GUSERID');
            }
            $data = array(
                'content_langue_origine' => $t->terme,
                'id_stagiaire'           => $idStagiaire,                
                'target_langue_cible'    => 5,
                'date_creation'          => date("Y-m-d H:i:s"),
                'content_langue_cible'   => $t->traduction_fr,
                'user_create'            => $this->session->userdata('GUSERID'),
                'id_tuteur'                       => isset($idTraineer) ? $this->session->userdata('GUSERID') : NULL,
            );          

            $this->databankExpression_model->addExpression($data);
            echo "##1";
          }
      }
    }

    public function getArticleUsingLink(){
      $this->global['pageTitle']  = 'E-learning : Newsletter';
      $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
      if (isset($_GET['theme'])) {
        $rowno=0;
        $rowperpage = 12;
 
        if($rowno != 0){
          $rowno = ($rowno-1) * $rowperpage;
        }

        $allcount = $this->newsletter_model->getCntArticleWithTheme($_GET['theme'])->num_rows();
        $article  = $this->newsletter_model->getArticleWithTheme($_GET['theme'],$rowperpage, $rowno)->result();
        $config['base_url'] = current_url();
        $config['use_page_numbers'] = TRUE;
        $config['full_tag_open']    = '<div class="pagging text-center"><nav><ul class="pagination">';
        $config['full_tag_close']   = '</ul></nav></div>';
        $config['num_tag_open']     = '<li class="page-item"><span class="page-link">';
        $config['num_tag_close']    = '</span></li>';
        $config['cur_tag_open']     = '<li class="page-item active"><span class="page-link">';
        $config['cur_tag_close']    = '<span class="sr-only">(current)</span></span></li>';
        $config['next_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['next_tag_close']  = '<span aria-hidden="true"></span></span></li>';
        $config['prev_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['prev_tag_close']  = '</span></li>';
        $config['first_tag_open']   = '<li class="page-item"><span class="page-link">';
        $config['first_tag_close'] = '</span></li>';
        $config['last_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['last_tag_close']  = '</span></li>';
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Previous';

        $config['total_rows'] = $allcount;
        $config['per_page'] = $rowperpage;
        $this->pagination->initialize($config);
        $data['pagination'] = $this->pagination->create_links_nl();
        $data['article'] = $article;
        $data['allcount']    = $allcount;
        if ($this->session->userdata ('GUSERTYPE') == TUTEUR) {
          $nav = new Navigation() ;
          $url = base_url()."&groupe=".$this->session->userdata ('STAGIAIREGRP') ;  
          $nav->add(htmlentities($this->groupes_model->Name($this->session->userdata ('STAGIAIREGRP'))),$url);
          $nav->add($this->membres_model->GetNom($this->session->userdata ('STAGIAIREID'))." ".$this->membres_model->GetPrenom($this->session->userdata ('STAGIAIREID')),"#");     
          $this->global['navigation'] = $nav->toHTML(); 
          $this->global['ficheMmebre'] = $this->displayFicheStagiaireTracking($this->session->userdata ('STAGIAIREID'), $this->session->userdata ('GROUPE'));
          $this->global['photos'] = $this->displayhpotos($this->session->userdata ('STAGIAIREID'));
          $this->global['program'] = $this->displaySessionTracking($this->session->userdata ('STAGIAIREID'), $this->session->userdata ('STAGIAIREGRP'),'');
        }
        $this->loadViews("newsletter/viewArticleWithTheme", $this->global,$data, NULL );
      }

    }
    public function getAllArticleByOtherUserInFav(){
      if (isset($_POST['page_name']) && $_POST['page_name'] == 'favoris') {
            $this->tracking_type = 24;
      }
      if (isset($_POST['id'])) {        
        $this->loadTrackingEl($_POST['id'],0,$this->tracking_type);
      }
      $html = "";
      $html .='<p class="notification"></p>
               <div class="loader-nl"></div>';
      $html .='<div class="row container-cat-article">';    
      if (isset($_POST['theme'])) {          
        $rowno=0;
        $rowperpage = 12;
 
        if($rowno != 0){
          $rowno = ($rowno-1) * $rowperpage;
        }
        $allcount = $this->newsletter_model->getCntArticleWithTheme($_POST['theme'])->num_rows();
        $article  = $this->newsletter_model->getArticleWithTheme($_POST['theme'],$rowperpage, $rowno)->result();
           
        // Pagination Configuration
        $config['base_url'] = current_url();
        $config['use_page_numbers'] = TRUE;
        $config['full_tag_open']    = '<ul class="pagination">';
        $config['full_tag_close']   = '</ul>';
        $config['num_tag_open']     = '<li class="page-item"><span class="page-link">';
        $config['num_tag_close']    = '</span></li>';
        $config['cur_tag_open']     = '<li class="page-item active"><span class="page-link">';
        $config['cur_tag_close']    = '<span class="sr-only">(current)</span></span></li>';
        $config['next_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['next_tag_close']  = '<span aria-hidden="true"></span></span></li>';
        $config['prev_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['prev_tag_close']  = '</span></li>';
        $config['first_tag_open']   = '<li class="page-item"><span class="page-link">';
        $config['first_tag_close'] = '</span></li>';
        $config['last_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['last_tag_close']  = '</span></li>';
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Previous';

        $config['total_rows'] = $allcount;
        $config['per_page'] = $rowperpage;
        $this->pagination->initialize($config);
        $pagination = $this->pagination->create_links_nl_fav();
        $data['result'] = $article;
        $data['row'] = $rowno;

        if ($allcount >= 1) {
          
            foreach ($article as $res) {
                $thumb = $this->utilities_model->getthumbNL($res->ID);
                if ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                   $img  = base_url()."groupes/ACTIVITES/".$thumb;
                }
                else{
                    $img  = base_url()."groupes/default.png";
                }
                $suite = "";
                $nb_word = strlen(htmlentities($res->article));

                $nb_restant = $nb_word - 40;
                $original_text =  substr(htmlentities($res->article),0,40);
                if ($nb_restant >= 1) {
                    $suite .= "<a href='#' style='text-decoration:none;font-size:1rem;font-weight:400;color:#fff;'> ...</a>";
                }
                else{
                    $suite .= "";
                }

                $html .='<div class="col-md-2 padding-col">';            
                  $html .='<div class="container-image hovereffect">';            
                      $html .='<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$img.'">';            
                      $html .='<div class="legend"><span class="titleTumbnail">'.$original_text.$suite.'</span></div>';   

                      $html .='<div class="overlay">'; 
                          $html .='<div class="btn-group-vertical" style="float: right !important;">'; 
                              $html .='<input type="hidden" class="idCat" value="'.$res->ID.'">';
                              $html .='<a href="#" class="btn link-action-nl btn-add-comment"  onclick="addArtComm(this);" title="Add comment">'; 
                                 $html .=' <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">'; 
                              $html .='</a>'; 

                              /*$html .='<a href="#" class="btn link-action-nl" title="Add in favorite" onclick="addArtFav(this);">'; 
                                  $html .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" width="40%" class="image-action-nl img-favorite-nl">'; 
                              $html .='</a>';*/

                              $html .='<a href="#" class="btn link-action-nl" title="Access to the video">'; 
                                  $html .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Video-vignette-Normal.png" width="40%" class="image-action-nl img-video-nl">'; 
                              $html .='</a>'; 
                      
                          $html .='</div>'; 
                          $html .='<div style="float: left !important;">'; 
                              $html .='<a href="'.base_url().'read-data?id='.$res->ID.'&page_name='.$_POST['page_name'].'&id_st='.$_POST['id'].'" class="btn link-loop-article" title="Access the article">'; 
                                  $html .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                              $html .='</a>'; 
                          $html .='</div>'; 
                      $html .='</div>'; 
                  $html .='</div>'; 
                $html .='</div>'; 

            }
            
        }
        else{
            $html .='<div class="col-xs-12">
                        <ul class="">
                            <li><h2>Nothing Found.</h2></li>     
                        </ul>
                    </div>';
            
        }

      }
      $html .='</div> <div class="modal fade modal_elearning" id="modal_elearning" role="dialog">
      <div class="modal-dialog" style="display:none;">
      
        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">Add your comment from this <span class="data-intitule-header"></span></h4>
          </div>
          <div class="modal-body">
            <p class="error-saisie"></p>
            <input type="hidden" name="data-id" class="data-id">
            <input type="hidden" name="data-intitule" class="data-intitule">
            <input type="hidden" name="data-type" class="data-type" value="nl_article">
            <textarea class="form-control data-comment" name="data-comment" rows="10" placeholder="Add your comment"></textarea>
          </div>
          <div class="modal-footer">
            <a type="button" class="btn btn-primary btn-save-comment btn-action-el-ok" onclick="saveArtCom(this);">Add</a>
            <button type="button" class="btn btn-default btn-close-modal btn-action-el-cancel" data-dismiss="modal">Close</button>
          </div>
        </div>
        
      </div>
      <input type="hidden" name="url-stat-article" class="url-stat-article" value="'.base_url().'stat-article">
      <input type="hidden" class="clsvaluepage" value="newsletter">';
      $html .='</div></div>';
      $html .='<div class="col-sm-12"><div class="text-center">'.$pagination.'</div></div>';
      echo "html_artcile".$html."html_artcile".json_encode($data);
    }
    public function getAllArticleByOtherUser(){
      if (isset($_POST['page_name']) && $_POST['page_name'] == 'favoris') {
            $this->tracking_type = 24;
      }
      if (isset($_POST['module_id'])) {        
        $this->loadTrackingEl(0,0,$this->tracking_type,$_POST['module_id']);        
      }

      $html = "";
      $html .='<div class="row container-cat-article">';    
      if (isset($_POST['theme'])) {          
        $rowno=0;
        $rowperpage = 12;
 
        if($rowno != 0){
          $rowno = ($rowno-1) * $rowperpage;
        }
        $allcount = $this->newsletter_model->getCntArticleWithTheme($_POST['theme'])->num_rows();
        $article  = $this->newsletter_model->getArticleWithTheme($_POST['theme'],$rowperpage, $rowno)->result();
           
        // Pagination Configuration
        $config['base_url'] = current_url();
        $config['use_page_numbers'] = TRUE;
        $config['full_tag_open']    = '<ul class="pagination">';
        $config['full_tag_close']   = '</ul>';
        $config['num_tag_open']     = '<li class="page-item"><span class="page-link">';
        $config['num_tag_close']    = '</span></li>';
        $config['cur_tag_open']     = '<li class="page-item active"><span class="page-link">';
        $config['cur_tag_close']    = '<span class="sr-only">(current)</span></span></li>';
        $config['next_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['next_tag_close']  = '<span aria-hidden="true"></span></span></li>';
        $config['prev_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['prev_tag_close']  = '</span></li>';
        $config['first_tag_open']   = '<li class="page-item"><span class="page-link">';
        $config['first_tag_close'] = '</span></li>';
        $config['last_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['last_tag_close']  = '</span></li>';
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Previous';

        $config['total_rows'] = $allcount;
        $config['per_page'] = $rowperpage;
        $this->pagination->initialize($config);
        $pagination = $this->pagination->create_links_nl();
        $data['result'] = $article;
        $data['row'] = $rowno;

        if ($allcount >= 1) {
          
            foreach ($article as $res) {
                $thumb = $this->utilities_model->getthumbNL($res->ID);
                if ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                   $img  = base_url()."groupes/ACTIVITES/".$thumb;
                }
                else{
                    $img  = base_url()."groupes/default.png";
                }
                $suite = "";
                $nb_word = strlen(htmlentities($res->article));

                $nb_restant = $nb_word - 40;
                $original_text =  substr(htmlentities($res->article),0,40);
                if ($nb_restant >= 1) {
                    $suite .= "<a href='#' style='text-decoration:none;font-size:1rem;font-weight:400;color:#fff;'> ...</a>";
                }
                else{
                    $suite .= "";
                }

                $html .='<div class="col-md-2 padding-col">';            
                  $html .='<div class="container-image hovereffect">';            
                      $html .='<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$img.'">';            
                      $html .='<div class="legend"><span class="titleTumbnail">'.$original_text.$suite.'</span></div>';   

                      $html .='<div class="overlay">'; 
                          $html .='<div class="btn-group-vertical" style="float: right !important;">'; 
                              $html .='<input type="hidden" class="idCat" value="'.$res->ID.'">';
                              $html .='<a href="#" class="btn link-action-nl btn-add-comment"  onclick="addArtComm(this);" title="Add comment">'; 
                                 $html .=' <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">'; 
                              $html .='</a>'; 

                              $html .='<a href="#" class="btn link-action-nl" title="Add in favorite" onclick="addArtFav(this);">'; 
                                  $html .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" width="40%" class="image-action-nl img-favorite-nl">'; 
                              $html .='</a>'; 

                              $html .='<a href="#" class="btn link-action-nl" title="Access to the video">'; 
                                  $html .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Video-vignette-Normal.png" width="40%" class="image-action-nl img-video-nl">'; 
                              $html .='</a>'; 
                      
                          $html .='</div>'; 
                          $html .='<div style="float: left !important;">'; 
                              $html .='<a href="'.base_url().'read-data?id='.$res->ID.'" class="btn link-loop-article" title="Access the article">'; 
                                  $html .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                              $html .='</a>'; 
                          $html .='</div>'; 
                      $html .='</div>'; 
                  $html .='</div>'; 
                $html .='</div>'; 

            }
            
        }
        else{
            $html .='<div class="col-xs-12">
                        <ul class="">
                            <li><h2>Nothing Found.</h2></li>     
                        </ul>
                    </div>';
            
        }

      }
      $html .='</div> <div class="modal fade modal_elearning" id="modal_elearning" role="dialog">
      <div class="modal-dialog" style="display:none;">
      
        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">Add your comment from this <span class="data-intitule-header"></span></h4>
          </div>
          <div class="modal-body">
            <p class="error-saisie"></p>
            <input type="hidden" name="data-id" class="data-id">
            <input type="hidden" name="data-intitule" class="data-intitule">
            <input type="hidden" name="data-type" class="data-type" value="nl_article">
            <div class="content-comment-todo"></div>
            <textarea class="form-control data-comment" name="data-comment" rows="10" placeholder="Add your comment"></textarea>
          </div>
          <div class="modal-footer">
            <a type="button" class="btn btn-primary btn-save-comment btn-action-el-ok" onclick="saveArtCom(this);">Add</a>
            <button type="button" class="btn btn-default btn-close-modal btn-action-el-cancel" data-dismiss="modal">Close</button>
          </div>
        </div>
        
      </div>
      <input type="hidden" name="url-stat-article" class="url-stat-article" value="'.base_url().'stat-article">
      <input type="hidden" class="clsvaluepage" value="newsletter">';
      $html .='</div></div>';
      $html .='<div class="col-sm-12"><div class="text-center">'.$pagination.'</div></div>';
      echo "html_artcile".$html."html_artcile".json_encode($data);
    }
    public function getArticlePageByOtherUser(){        
        $html = "";
   
        $html .='<div class="row container-cat-article">';    
        if (isset($_POST)) {
          if ($_POST['rowno'] != "") {
            $rowno=$_POST['rowno'];
          }
          else{
            $rowno=0;
          }
          $rowperpage = 5;
   
          if($rowno != 0){
            $rowno = ($rowno-1) * $rowperpage;
          }
          $allcount = $this->newsletter_model->getCntArticleWithTheme($_POST['theme'])->num_rows();
          $article  = $this->newsletter_model->getArticleWithTheme($_POST['theme'],$rowperpage, $rowno)->result();
         

          if ($allcount >= 1) {
            
              foreach ($article as $res) {
                  $thumb = $this->utilities_model->getthumbNL($res->ID);
                  if ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                     $img  = base_url()."groupes/ACTIVITES/".$thumb;
                  }
                  else{
                      $img  = base_url()."groupes/default.png";
                  }
                  $suite = "";
                  $nb_word = strlen(htmlentities($res->article));

                  $nb_restant = $nb_word - 40;
                  $original_text =  substr(htmlentities($res->article),0,40);
                  if ($nb_restant >= 1) {
                      $suite .= "<a href='#' style='text-decoration:none;font-size:1rem;font-weight:400;color:#fff;'> ...</a>";
                  }
                  else{
                      $suite .= "";
                  }

                  $html .='<div class="col-md-2 padding-col">';            
                    $html .='<div class="container-image hovereffect">';        
                      $html .='<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$img.'">';            
                      $html .='<div class="legend"><span class="titleTumbnail">'.$original_text.$suite.'</span></div>';   
                      $html .='<div class="overlay">'; 
                        $html .='<div class="btn-group-vertical" style="float: right !important;">'; 
                      
                            $html .='<input type="hidden" class="idCat" value="'.$res->ID.'">';
                            $html .='<a href="#" class="btn link-action-nl btn-add-comment"  onclick="addArtComm(this);" title="Add comment">'; 
                               $html .=' <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl">'; 
                            $html .='</a>'; 

                            $html .='<a href="#" class="btn link-action-nl" title="Add in favorite" onclick="addArtFav(this);">'; 
                                $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" width="40%" class="image-action-nl">'; 
                            $html .='</a>'; 

                            $html .='<a href="#" class="btn link-action-nl btn-add-favorite" title="Access to the video">'; 
                                $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Video-vignette-Normal.png" width="40%" class="image-action-nl">'; 
                            $html .='</a>'; 
                    
                        $html .='</div>'; 
                        $html .='<div style="float: left !important;">'; 
                            $html .='<a href="'.base_url().'read-data?id='.$res->ID.'" class="btn link-loop-article" title="Access the article">'; 
                                $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                            $html .='</a>'; 
                        $html .='</div>'; 
                      $html .='</div>'; 
                  $html .='</div>'; 
                $html .='</div>'; 

              }
              
          }
          else{
              $html .='<div class="text-center col-xs-12">
                          <ul class="pagination">
                              <li><h2>Nothing Found.</h2></li>     
                          </ul>
                      </div>';
              
          }

        }
        $html .='</div>';    
       
        echo "html_artcile".$html;

    }
    public function getArticle(){        
        $html = "";
        $html .='<p class="notification"></p>
                 <div class="loader-nl"></div>';
        $html .='<div class="row container-cat-article">';    
        if (isset($_POST)) {          
          $rowno=0;
          $rowperpage = 12;
   
          if($rowno != 0){
            $rowno = ($rowno-1) * $rowperpage;
          }
          $allcount = $this->newsletter_model->getCntArticleWithTheme($_POST['theme'])->num_rows();
          $article  = $this->newsletter_model->getArticleWithTheme($_POST['theme'],$rowperpage, $rowno)->result();
             
          // Pagination Configuration
          $config['base_url'] = current_url();
          $config['use_page_numbers'] = TRUE;
          $config['full_tag_open']    = '<div class="pagging text-center"><nav><ul class="pagination">';
          $config['full_tag_close']   = '</ul></nav></div>';
          $config['num_tag_open']     = '<li class="page-item"><span class="page-link">';
          $config['num_tag_close']    = '</span></li>';
          $config['cur_tag_open']     = '<li class="page-item active"><span class="page-link">';
          $config['cur_tag_close']    = '<span class="sr-only">(current)</span></span></li>';
          $config['next_tag_open']    = '<li class="page-item"><span class="page-link">';
          $config['next_tag_close']  = '<span aria-hidden="true"></span></span></li>';
          $config['prev_tag_open']    = '<li class="page-item"><span class="page-link">';
          $config['prev_tag_close']  = '</span></li>';
          $config['first_tag_open']   = '<li class="page-item"><span class="page-link">';
          $config['first_tag_close'] = '</span></li>';
          $config['last_tag_open']    = '<li class="page-item"><span class="page-link">';
          $config['last_tag_close']  = '</span></li>';
          $config['next_link'] = 'Next';
          $config['prev_link'] = 'Previous';

          $config['total_rows'] = $allcount;
          $config['per_page'] = $rowperpage;
          $this->pagination->initialize($config);
          $pagination = $this->pagination->create_links_nl();
          $data['result'] = $article;
          $data['row'] = $rowno;

          if ($allcount >= 1) {
            
              foreach ($article as $res) {
                  $thumb = $this->utilities_model->getthumbNL($res->ID);
                  if ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                     $img  = base_url()."groupes/ACTIVITES/".$thumb;
                  }
                  else{
                      $img  = base_url()."groupes/default.png";
                  }
                  $suite = "";
                  $nb_word = strlen(htmlentities($res->article));

                  $nb_restant = $nb_word - 40;
                  $original_text =  substr(htmlentities($res->article),0,40);
                  if ($nb_restant >= 1) {
                      $suite .= "<a href='#' style='text-decoration:none;font-size:1rem;font-weight:400;color:#fff;'> ...</a>";
                  }
                  else{
                      $suite .= "";
                  }

                  $html .='<div class="column container-image hovereffect">';            
                      $html .='<img class="image-timthumb" title="" alt="Avatar" src="'.$img.'">';            
                      $html .='<div class="legend"><span class="titleTumbnail">'.$original_text.$suite.'</span></div>';   

                      $html .='<div class="overlay">'; 
                          $html .='<div class="btn-group-vertical" style="float: right !important;">'; 
                              $html .='<input type="hidden" class="idCat" value="'.$res->ID.'">';
                              $html .='<a href="#" class="btn link-action-nl btn-add-comment"  onclick="addArtComm(this);" title="Add comment">'; 
                                 $html .=' <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">'; 
                              $html .='</a>'; 

                              $html .='<a href="#" class="btn link-action-nl btn-add-favorite" title="Access to the video">'; 
                                  $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Video-vignette-Normal.png" width="40%" class="image-action-nl img-video-nl">'; 
                              $html .='</a>'; 
                      
                          $html .='</div>'; 
                          $html .='<div style="float: left !important;">'; 
                              //$html .='<a href="#" onclick="readArticle('.$res->ID.');" class="btn link-loop-article" title="Access the article">'; 
                              $html .='<a href="'.base_url().'read-data?id='.$res->ID.'" class="btn link-loop-article" title="Access the article">'; 
                                  $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                              $html .='</a>'; 
                          $html .='</div>'; 
                      $html .='</div>'; 
                  $html .='</div>'; 

              }
              
          }
          else{
              $html .='<div class="text-center col-xs-12">
                          <ul class="pagination">
                              <li><h2>Nothing Found.</h2></li>     
                          </ul>
                      </div>';
              
          }

        }
        $html .='</div> <div class="modal fade modal_elearning" id="modal_elearning" role="dialog">
        <div class="modal-dialog">
        
          <!-- Modal content-->
          <div class="modal-content">
            <div class="modal-header">
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              <h4 class="modal-title">Add your comment from this <span class="data-intitule-header"></span></h4>
            </div>
            <div class="modal-body">
              <p class="error-saisie"></p>
              <input type="hidden" name="data-id" class="data-id">
              <input type="hidden" name="data-intitule" class="data-intitule">
              <input type="hidden" name="data-type" class="data-type" value="nl_article">
              <textarea class="form-control data-comment" name="data-comment" rows="10" placeholder="Add your comment"></textarea>
            </div>
            <div class="modal-footer">
              <a type="button" class="btn btn-primary btn-save-comment" onclick="saveArtCom(this);">Add</a>
              <button type="button" class="btn btn-default btn-close-modal" data-dismiss="modal">Close</button>
            </div>
          </div>
          
        </div>
        <input type="hidden" name="url-stat-article" class="url-stat-article" value="'.base_url().'stat-article">
        <input type="hidden" class="clsvaluepage" value="newsletter">';
        $html .='</div></div>';
        $html .='<div class="row"><div class="col-xs-12"><div class="pagging text-center">
                        <nav>
                        <ul class="pagination pagination-lg">                          
                          '.$pagination.'
                        </ul>
                        </nav>
                      </div>
                    </div>
                  </div>';
        echo "html_artcile".$html."html_artcile".json_encode($data);

    }
    public function getArticlePage(){        
        $html = "";
   
        $html .='<div class="row container-cat-article">';    
        if (isset($_POST)) {
          if ($_POST['rowno'] != "") {
            $rowno=$_POST['rowno'];
          }
          else{
            $rowno=0;
          }
          $rowperpage = 5;
   
          if($rowno != 0){
            $rowno = ($rowno-1) * $rowperpage;
          }
          $allcount = $this->newsletter_model->getCntArticleWithTheme($_POST['theme'])->num_rows();
          $article  = $this->newsletter_model->getArticleWithTheme($_POST['theme'],$rowperpage, $rowno)->result();
         

          if ($allcount >= 1) {
            
              foreach ($article as $res) {
                  $thumb = $this->utilities_model->getthumbNL($res->ID);
                  if ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                     $img  = base_url()."groupes/ACTIVITES/".$thumb;
                  }
                  else{
                      $img  = base_url()."groupes/default.png";
                  }
                  $suite = "";
                  $nb_word = strlen(htmlentities($res->article));

                  $nb_restant = $nb_word - 40;
                  $original_text =  substr(htmlentities($res->article),0,40);
                  if ($nb_restant >= 1) {
                      $suite .= "<a href='#' style='text-decoration:none;font-size:1rem;font-weight:400;color:#fff;'> ...</a>";
                  }
                  else{
                      $suite .= "";
                  }

                  $html .='<div class="column container-image hovereffect">';            
                      $html .='<img class="image-timthumb" title="" alt="Avatar" src="'.$img.'">';            
                      $html .='<div class="legend"><span class="titleTumbnail">'.$original_text.$suite.'</span></div>';   

                      $html .='<div class="overlay">'; 
                          $html .='<div class="btn-group-vertical" style="float: right !important;">'; 
                        
                              $html .='<input type="hidden" class="idCat" value="'.$res->ID.'">';
                              $html .='<a href="#" class="btn link-action-nl btn-add-comment"  onclick="addArtComm(this);" title="Add comment">'; 
                                 $html .=' <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl">'; 
                              $html .='</a>'; 

                              $html .='<a href="#" class="btn link-action-nl" title="Add in favorite" onclick="addArtFav(this);">'; 
                                  $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" width="40%" class="image-action-nl">'; 
                              $html .='</a>'; 

                              $html .='<a href="#" class="btn link-action-nl btn-add-favorite" title="Access to the video">'; 
                                  $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Video-vignette-Normal.png" width="40%" class="image-action-nl">'; 
                              $html .='</a>'; 
                      
                          $html .='</div>'; 
                          $html .='<div style="float: left !important;">'; 
                              $html .='<a href="'.base_url().'read-data?id='.$res->ID.'" class="btn link-loop-article" title="Access the article">'; 
                                  $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                              $html .='</a>'; 
                          $html .='</div>'; 
                      $html .='</div>'; 
                  $html .='</div>'; 

              }
              
          }
          else{
              $html .='<div class="text-center col-xs-12">
                          <ul class="pagination">
                              <li><h2>Nothing Found.</h2></li>     
                          </ul>
                      </div>';
              
          }

        }
        $html .='</div>';    
       
        echo "html_artcile".$html;

    }

    public function addStat(){
        if (isset($_POST)) {
            $data = array(
                          'id_membres'    => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'), 
                          'user_create'   => $this->session->userdata ('GUSERID'),
                          'id_prg'        => $_POST['id'],
                          //'numero'        => isset($_POST['numero']) ? 0 : $_POST['numero'],
                          'intitule'      => $_POST['intitule'],
                          'status'        => $_POST['status'],
                          'type'          => $_POST['type'],
                          'commentaire'   => $_POST['comment'],
                          'module_id'     => (isset($_POST['module_id']) && $_POST['module_id'] != '') ? $_POST['module_id'] : NULL,
                          'date_creation' => time()
                         );


            $ret = $this->stat_prg_model->add($data);
            echo '##'.$ret;
        }
        else{
            echo "error";
        }

    }

    public function publish(){
      $return = array();
      if (isset($_POST['articleId'])) {
        $data = array(
          'publier' => true
        );
        $return['status'] = $this->newsletter_model->updateArticle($_POST['articleId'],$data);
      }
      echo json_encode($return);
    }


}

?>


  
  
  