<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Bno
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Bno extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
        define('GROUPE',    $_GET['groupe']);
        define('MENU',      $_GET['menu']);
        
        $this->tracking_type = 14; 
        global $trad_Menu_BNO;       




    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->loadTrackingEl(0,0,$tracking_type);
        $this->global['pageTitle'] = 'E-learning : Bno';  
        $html = "";

        
        $id_modif   = "";
        $type_outil = "";
        $contenu    = "" ;

        if (isset($_GET['type_outil'])) {
            $type_outil .= $_GET['type_outil'];
        } 
        

        if (isset($_GET['id_modif'])) {
            $id_modif .= $_GET['id_modif'];
        } 

        if (isset($_POST['Ta'])) {
            $contenu .= $_POST['Ta'];
            $message = $this->bno_model->Replace($type_outil, $id_modif, GROUPE, $_POST['Ta']);

        }

        $html.= $this->bno_model->HeaderBNOTuteur(MENU,GROUPE,$type_outil,$id_modif);  
        $html.= '<section class="content">';  
            /*$html.= '<div class="box">';  
                $html.= '<div class="row">';  
                    $html.= '<div class="col-xs-12">'; */ 

                        if ($id_modif!="aucun" && MENU==1) {

                            $html.= $this->AfficheTa($contenu,$id_modif, GROUPE, $type_outil,true);   
                        }
                        elseif (MENU==1) {
                        
                            $html.= $this->AfficheTa($contenu,0, GROUPE, $type_outil, true);
                        }       
                        elseif (MENU==2){
                            $html.= $this->AfficheTa($contenu,0, GROUPE, $type_outil);
                        }
                        else{

                        }
                    /*$html.= '</div>';  
                $html.= '</div>';  
            $html.= '</div>'; */ 
        $html.= '</section>';  
        $data['pagecontenbno'] = $html;
        $data['groupe'] = GROUPE;
        if ($this->isTuteurConnet()) { 
            $this->loadViews("tutor/bno/view", $this->global, $data , NULL);
        }
        else{
            $this->loadViews("bno/index", $this->global, $data , NULL);
        }


      
  
    }

    public function AfficheTa($contenu,$id_modif, $groupe, $type_outil,$autoselect_modif=false) {
        if ($autoselect_modif==true) {
            $id_modif = $this->membres_model->getStagiaireIDByGroupID($groupe) ;
        }
        else{

        }
        $ret = '' ;
        
        $BNO = $this->bno_model->Lire($id_modif,$groupe, $type_outil) ;
        if ( isset($BNO['contenu']) && strlen($BNO['contenu'])>0) {
            $ret.= $this->VoirBNO($BNO) ;
        }
        //die($ret);
        $action = HTTP_BNO."?index.php&groupe=".$groupe."&menu=".MENU."&type_outil=".$type_outil."&id_modif=".$id_modif ;
        $enregistrement = $this->bno_model->Lire($id_modif, $groupe, $type_outil);
        $ret .= "<form action='".$action."' method='post'><input type='hidden' name='identite'>";
            $ret.= '<div class="box box-bno">';  
                $ret.= '<div class="row">';  
                    $ret.= '<div class="col-xs-12 col-textarea">'; 
                        $ret .= "<textarea class='form-control rounded-0 btn-content' name=\"Ta\" rows=\"10\">\n";
                            $ret.= isset($enregistrement['contenu'])?stripslashes($enregistrement['contenu']):'';
                        $ret.= "</textarea>\n";
                    $ret.= '</div>'; 
                $ret.= '</div>'; 
            $ret.= '</div>'; 
            $ret.='<p style="text-align:center;""><input type="submit" name="btn" class="btn btn-primary btn-edit-bno" value="MODIFY"></p>';
        $ret.= "</form>";

        return $ret;
    }


    public function VoirBNO($val) {

        $ret = '';
        $affiche = "";
        //var_dump($val);
        $id_membre = isset($val['id_membre'])?$val['id_membre']:'';
        $contenu   = isset($val['contenu'])?$val['contenu']:''  ;
        $type_outil = isset($val['type_outil'])?$val['type_outil']:''   ;
        $date_maj   = isset($val['date_maj'])?$val['date_maj']:''   ;
        $date_exp0 = explode(" ", $date_maj);
        $date_exp1 = explode("-", $date_exp0[0]);
    
        //echo "outil : ".$_GET['type_outil'];
        switch ($_GET['type_outil']) {
            case 1 : 
                $nom_outil = ($id_membre==0?$this->lang->line('trainee_obectif_general_notpad'):$this->lang->line('trainee_obectif_notepad')) ;
                break;
            case 2 : 
                $nom_outil = ($id_membre==0?$this->lang->line('trainee_obectif_professional'):$this->lang->line('trainee_obectif_individual')) ; 
                break;
        }

        $nv_contenu = $this->bno_model->SecuriseHTML($contenu)    ;
        $nv_contenu = stripslashes($nv_contenu) ;

        //$ret.= "<br>";
        //$image = $id_membre==0?IMG_GROUPE:IMG_BNO;
        $image = $id_membre==0?"<span class='fa fa-group'></span>":"<span class='fa fa-exclamation'></span>";
        if ($this->session->userdata ('GUSERTYPE') != TUTEUR) {
            $ret.= $this->SubTitle($image.' '.$nom_outil)  ;
        }
        if ($date_exp1[2].'/'.$date_exp1[1].'/'.$date_exp1[0]=="00/00/0000") {
            $affiche .= "";
        }
        else{
            $affiche .= $date_exp1[2].'/'.$date_exp1[1].'/'.$date_exp1[0];
        }  
        $ret.= '<div class="box box-bno">';  
            $ret.= '<div class="row">';  
                $ret.= '<div class="col-xs-12">'; 
                    $ret .= "<table class='table'>";
                        $ret .= "<thead><tr><td class=''><span class='bno_title'>".$nom_outil.'</span>&nbsp;&nbsp;<i class="fa fa-calendar fa-calender-bno" aria-hidden="true"></i>&nbsp;<span class="bno_title_date">'.$affiche."</span></td></tr></thead>";
                        $ret .= "<tbody><tr><td class='btn-content'>".nl2br(utf8_encode($nv_contenu))."</td></tr></tbody>";
                    $ret .= "</table>";
                $ret.= '</div>'; 
            $ret.= '</div>'; 
        $ret.= '</div>'; 

        return $ret;
    }

    public function SubTitle($title, $width="230" ) {
        $ret = '';
         if ( true ) {
            $ret.= '<p align="left"><h3>'.$title.'</h3></p>'."\n";
         }
        return $ret;
    }

    public function adminBno(){
        $this->global['pageTitle'] = 'E-learning : Bno';  
        $html = "";        
        $id_modif   = "";
        $type_outil = "";
        $contenu    = "" ;
        if (isset($_GET['type_outil'])) {
            $type_outil .= $_GET['type_outil'];
        } 
        

        if (isset($_GET['id_modif'])) {
            $id_modif .= $_GET['id_modif'];
        } 

        if (isset($_POST['Ta'])) {
            $contenu .= $_POST['Ta'];
        }

        if (strlen($contenu)>0 != "") {
            $this->membres_model->addUserCreate(GROUPE,$this->session->userdata ('GUSERID'));
            $this->membres_model->addUserModif(GROUPE,$this->session->userdata ('GUSERID'));
            $message = $this->bno_model->Replace($type_outil, $id_modif, GROUPE, $contenu);

        }

        $html.= $this->bno_model->HeaderBNOTuteur(MENU,GROUPE,$type_outil,$id_modif);  

        if ($id_modif!="aucun" && MENU==1) {

            $html.= $this->AfficheTa($contenu,$id_modif, GROUPE, $type_outil,true);   
        }
        elseif (MENU==1) {
        
            $html.= $this->AfficheTa($contenu,0, GROUPE, $type_outil, true);
        }       
        elseif (MENU==2){
            $html.= $this->AfficheTa($contenu,0, GROUPE, $type_outil);
        }
        else{

        }       
        $this->global['pagecontenbno'] = $html;
        $this->global['groupe'] = GROUPE;
        $this->loadViews("bno/admin/view", $this->global, NULL , NULL);      
  
    }

   

}

?>