<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Class : AunthentificationEL
 * AunthentificationEL to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 26 Mars 2024
 */
class AunthentificationEL extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct(); 
        $this->load->model('login_model');
        $this->load->model('connexion_model');
        $this->load->model('groupes_model');
        $this->load->model('historik_course_nl_model');
        $this->load->model('Stag_individu_model');
        $this->load->model('classificationFavoris_Model'); 
    }  

    public function login()
    {
    	$return = array();
    	$userdata = array();
    	$authentification = false;
    	$message = '';
        
        $this->load->library('form_validation');
        
        $this->form_validation->set_rules('email', 'Email', 'required');
        $this->form_validation->set_rules('password', 'Password', 'required|max_length[32]');
        $this->form_validation->set_rules('remember', 'Remember me', '');
        
        if($this->form_validation->run() == FALSE)
        {
            $authentification = false;
            $message          = $this->form_validation->error();
        }        
        else
        {
            $result  =$this->el_f2plus_auth->login($this->input->post('email'), $this->input->post('password'), $this->input->post('remember') == 'on' ? TRUE : FALSE);
            $langagePlateform = '';
            $matches = array();
            if(count($result) > 0 && (is_array($result) || is_object($result))){
                foreach ($result as $res){
                    $langageFormation = $this->groupes_model->RequestByGrp('langue',$res->id_groupe);
                    if (preg_match('/Anglais/i', $langageFormation, $matches)) {  
                        $langagePlateform = 'english';
                    } 
                    else if (preg_match('/Français/i', $langageFormation, $matches)){
                        $langagePlateform = 'french';
                    } 
                    else if ($langageFormation == NULL || $langageFormation == ''){
                        $langagePlateform = 'english';
                    }
                    else{
                        $langagePlateform = 'french';
                    }

                    if ($res->mode_acces == '2') {
                        if ($res->type==0) {
                            $role = STAGIAIRE;
                        }
                        elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                            $role = TUTEUR;                            
                        }
                        elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                            $role = TUTEUR;                            
                        }
                        elseif ($res->type==4) {
                           $role = SUPERVISEUR;                            
                        }
                        elseif ($res->type==2) {
                           $role = ADMIN;                            
                        } 
                        else{
                            $role = ROLEAUTRES;
                        }
                        $CNX = $this->connexion_model->newconnexion($res->id,'MYODB');

                        $userdata  = array(
                            'GUSERID'=>$res->id,
                            'GEXTRANETID'              =>$res->extranet_id,
                            'GUSER'                    =>$res->prenom." ".$res->nom,
                            'GUSERINITIAL'             =>$res->nom[0],
                            'GUSERLOGIN'               =>$res->login,
                            'GUSERTYPE'                =>$res->type,
                            'BAR'                      =>$res->acces_bar,
                            'MODE_ACCES'               =>$res->mode_acces,
                            'GROUPE'                   =>$res->id_groupe,
                            'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$res->id_groupe),
                            'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                            'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                            'TYPE'                     =>$res->type,
                            'ROLE'                     =>$role,
                            'CNX'                      =>$CNX,
                            'SOCIETE'                  =>$res->description,
                            'IDSOCIETE'                =>$res->id_societe,
                            'NBCONNEXION'              =>$res->nbconnexion,
                            'PDP'                      =>$res->nom_photo,
                            'IDSTAGE'                  =>$res->type == 0 ? $this->Stag_individu_model->getMaxNumStageByIdMembers($res->id) : NULL,
                            'isLoggedIn'               =>TRUE,
                            'site_lang'                =>($res->id_groupe == 0 && $res->type == 3) ? 'english' : $langagePlateform
                        );
                        $authentification = true;
            			$message          = '';
                    }
                    elseif (!empty($res->date_fin_acces)) {
                        if($res->date_fin_acces+((24*3600)+(60*60)+60) <= time()) {
				            $authentification = false;
            				$message          = 'Your date of access to the platform has expired';

                        }
                        else{
                            if ($res->type==0) {
                                $role = STAGIAIRE;
                            }
                            elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                                $role = TUTEUR;                            
                            }
                            elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                                $role = TUTEUR;                            
                            }
                            elseif ($res->type==4) {
                               $role = SUPERVISEUR;                            
                            }
                            elseif ($res->type==2) {
                               $role = ADMIN;                            
                            } 
                            else{
                                $role = ROLEAUTRES;
                            }
                            $CNX = $this->connexion_model->newconnexion($res->id,'MYODB');

                            $userdata = array(
                            	'GUSERID'=>$res->id,
                                'GEXTRANETID'              =>$res->extranet_id,
                                'GUSERLOGIN'               =>$res->login,
                                'GUSER'                    =>$res->prenom." ".$res->nom,
                                'GUSERINITIAL'             =>$res->nom[0],
                                'GUSERTYPE'                =>$res->type,
                                'BAR'                      =>$res->acces_bar,
                                'MODE_ACCES'               =>$res->mode_acces,
                                'GROUPE'                   =>$res->id_groupe,
                                'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$res->id_groupe),
                                'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                                'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                                'TYPE'                     =>$res->type,
                                'ROLE'                     =>$role,
                                'CNX'                      =>$CNX,
                                'SOCIETE'                  =>$res->description,
                                'IDSOCIETE'                =>$res->id_societe,
                                'NBCONNEXION'              =>$res->nbconnexion,
                                'PDP'                      =>$res->nom_photo,
                                'IDSTAGE'                  =>$res->type == 0 ? $this->Stag_individu_model->getMaxNumStageByIdMembers($res->id) : NULL,
                                'isLoggedIn'               =>TRUE,
                                'site_lang'                =>($res->id_groupe == 0 && $res->type == 3) ? 'english' : $langagePlateform
                            );
                            $authentification = true;
            				$message          = '';
                        }

                    }
                    else{                      

                        if ($res->type==0) {
                            $role = STAGIAIRE;
                        }
                        elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                            $role = TUTEUR;                            
                        }
                        elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                            $role = TUTEUR;                            
                        }
                        elseif ($res->type==4) {
                           $role = SUPERVISEUR;                            
                        }
                        elseif ($res->type==2) {
                           $role = ADMIN;                            
                        } 
                        else{
                            $role = ROLEAUTRES;
                        }
                        $CNX = $this->connexion_model->newconnexion($res->id,'MYODB');

                        $userdata = array(
                        	'GUSERID'=>$res->id,
                            'GEXTRANETID'              =>$res->extranet_id,
                            'GUSER'                    =>$res->prenom." ".$res->nom,
                             'GUSERINITIAL'             =>$res->nom[0],
                            'GUSERLOGIN'               =>$res->login,
                            'GUSERTYPE'                =>$res->type,
                            'BAR'                      =>$res->acces_bar,
                            'MODE_ACCES'               =>$res->mode_acces,
                            'GLOSSAIREONLINE'          =>$this->groupes_model->Request('glossaireenligne',$res->id_groupe),
                            'GROUPE'                   =>$res->id_groupe,
                            'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                            'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                            'TYPE'                     =>$res->type,
                            'ROLE'                     =>$role,
                            'CNX'                      =>$CNX,
                            'SOCIETE'                  =>$res->description,
                            'IDSOCIETE'                =>$res->id_societe,
                            'NBCONNEXION'              =>$res->nbconnexion,
                            'PDP'                      =>$res->nom_photo,
                            'IDSTAGE'                  =>$res->type == 0 ? $this->Stag_individu_model->getMaxNumStageByIdMembers($res->id) : NULL,
                            'isLoggedIn'               =>TRUE,
                            'site_lang'                =>($res->id_groupe == 0 && $res->type == 3) ? 'english' : $langagePlateform
                        );
                        $authentification = true;
            			$message          = '';
                    }
                }
            }
            else
            {
	            $authentification = false;
            	$message          = 'Email or password mismatch';
            }
        }

        $return = array(
        	'authentification' => $authentification,
        	'message'          => $message,
        	'userdata'         => $userdata,
        );

        echo json_encode($return);
    }
}

?>