<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Domains
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 31 January 2019
 */
class Module extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('matieres_model');
        $this->load->model('formations_model');
        $this->load->model('domaines_model');
        $this->load->model('NiveauCorrespondantElExtranet_model');
        $this->isLoggedIn();   
        
    }
  
    public function index(){
        $this->global['pageTitle'] = 'E-learning : Gestion de module';
        $data['allResults']    = $this->modules_model->adminGetModuleList();      
        $data['domaineResults'] = $this->domaines_model->getAll();      
        $this->loadViews("admin/module/list", $this->global,$data, NULL );
    }

    public function getInfos(){
        $return = array();
        if (isset($_POST['module_id'])) {
            $return['sequencesResultsNotInModule'] = $this->modules_model->readSequence($_POST['module_id'], false);  
            $return['allResults']                  = $this->modules_model->readSequence($_POST['module_id'], true);  
        }
        echo json_encode($return);
    }

    public function afficheDetailParcours($idp,$loc,$position=false){
        
    }

    public function withDrawSequence(){
        $return = array();
        if (isset($_POST['module_id'])) {
            $this->formations_model->delItemByGroupAndModuleAndSequence(-1,$_POST['module_id'],$_POST['sequence_id']);
            $this->modules_model->delSequence($_POST['module_id'],$_POST['sequence_id'],1);
            $return['status'] = true;
        }
        echo json_encode($return);
    }

    public function deleteSequence(){
        $return = array();
        if (isset($_POST['module_id'])) {
            $this->load->model('tracking_model');
            $this->tracking_model->deleteByModuleSequenceType($_POST['module_id'],$_POST['sequence_id'],array(7,8));
            $this->sequence_model->del($_POST['sequence_id']);
            $this->formations_model->delItemByGroupAndModuleAndSequence(-1,$_POST['module_id'],$_POST['sequence_id']);
            $this->modules_model->delSequence($_POST['module_id'],$_POST['sequence_id'],1);
            $return['status'] = true;
        }
        echo json_encode($return);
    }

    public function delListModule(){
        $return = array();
        if (isset($_POST['idModule'])) {
            // delete from formation
            $this->formations_model->deleteByModule($_POST['idModule']);
            // delete content content by module
            /*$allSequenceList = $this->modules_model->getAllSequenceByModuleId($_POST['idModule']);
            foreach($allSequenceList as $sq){
                //delete sequence list by id
                $this->sequence_model->del($sq->sequence_id);
            }*/
            // delete from content module
            $this->modules_model->deleteContentByModule($_POST['idModule']);
            // delete from list module
            $this->modules_model->deleteByModule($_POST['idModule']);
            $return['delete'] = true;
        }
        echo json_encode($return);
    }

    public function deletematerial(){
        $id = $this->input->post('id');
        $this->matieres_model->del($id) ;
        $this->sequence_model->delMatiere($id);
        $this->modules_model->delMatiere($id);
        $this->parcours_model->delMatiere($id);
    }

    public function delete(){
        $id = $this->input->post('idDomains');
        $this->domaines_model->del($id) ;
        $this->matieres_model->delAll($id) ;
        $this->sequence_model->delDomaine($id);
        $this->modules_model->delDomaine($id);
        $this->parcours_model->delDomaine($id);
        return true;
    }
  
    public function add(){
        $name   = $this->input->post('domain_name');
        $id     = $this->domaines_model->add($name);
        redirect("/managedomains","refresh");
    }

    public function edit(){
        
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $this->domaines_model->update($id, $name);
        echo "###".$id."###";
    }

    public function editmatiere(){
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $this->matieres_model->update($id, $name);
        echo "###".$id."###";
    }

    public function addmaterial(){
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $id     = $this->matieres_model->add($name, $id);
        echo "###".$id."###";
    }

    public function showall(){
        $idMaterial     = $this->input->post('idMaterial');
        $idDomains      = $this->input->post('idDomains');
        $dom            = $this->domaines_model->read(-1,LOC);
        $ret            = "";
        for($i=0;$i<$dom['cnt'];$i++)  {
            if ( in_array($dom[$i]['id'],$idDomains) ) {
                $cursor         = "not-allowed";
            } 
            else {
                $cursor         = "pointer";
            }
            $ret .= '<p><a class="movematerials" onclick="movematerial(this);">';
            $ret .= '<input type="hidden" class="materialid" value="'.$idMaterial.'">';
            $ret .= '<input type="hidden" class="domainsid" value="'.$dom[$i]['id'].'">';
            $ret .= '<span class="glyphicon glyphicon-plus" style="cursor:'.$cursor.';"></span>&nbsp;&nbsp;'.$dom[$i]['name'].'</a></p>';
        }
        echo "###".$ret."###";
    }

    public function movematerial(){
        $idMaterial     = $this->input->post('idMaterial');
        $idDomains      = $this->input->post('idDomains');
        $this->matieres_model->move($idMaterial,$idDomains,LOC);
        $this->sequence_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);
        $this->modules_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);
        $this->parcours_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);

    }

    public function addListModule(){
        $return = array();
        $idGroupe = '';
        $idStagiaire = '';
        if ($this->isTuteurConnet()) {
            $idGroupe = $this->session->userdata ('STAGIAIREGRP');
            $idStagiaire = $this->session->userdata ('STAGIAIREID');
        }
        else{
            $idGroupe = $this->session->userdata ('GROUPE');
            $idStagiaire = $this->session->userdata ('GUSERID');
        }
        if (isset($_POST['module_titre'])) {
            $data = array(
                'module_titre'       => $_POST['module_titre'],
                'module_objectifs'   => $_POST['module_objectifs'],
                'module_duree'       => 0,
                'auteur_id'          => $this->session->userdata ('GUSERID'),
                'code'               => 'M'.$this->modules_model->getNextId(),
                'domaine_id'         => $_POST['domaine_id'],
                'matiere_id'         => 0,
            );
            
            $this->modules_model->add($data);            
            $return['moduleListInfos'] = $data;
            $module_id = $this->modules_model->getMaxModuleId();
            if ($_POST['sequence_list_action_valide'] == 0) { //array sequence list
                $sequenceArray = $_POST['sequencesModule'];
                for ($i=0; $i < count($sequenceArray) ; $i++) { 
                    $return['sequenceInfos'][$i] = $this->sequence_model->getInfoListSequenceById($sequenceArray[$i]);
                    //ajouter la sequence dans le module
                    $orderModule = $this->modules_model->getNextOrderFormModule($module_id);
                    $moduleData = array(
                        'module_id'  => $module_id,
                        'ordre'      => $orderModule,
                        'sequence_id'=> $sequenceArray[$i],
                        'type'       => 0,
                        'loc'        => 1,
                    );
                    $this->modules_model->addModule($moduleData);
                    $return['moduleInfos'][$i] = $moduleData;

                    $parcoursIdFinal = '';
                    //ajouter la sequence dans la formation
                    if ($_POST['action_btn'] == 'maj_for_presence_trainee') { // MAJ for presence trainee                
                        $parcoursId = $this->formations_model->getIdByGroupe($idGroupe);
                        $return['parcoursId'] = $parcoursId;
                        if ($parcoursId >= 1) {
                           $parcoursIdFinal = $parcoursId;
                        }
                        else{
                            $parcoursIdFinal = $this->NiveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('id_parcours_el',$this->membres_model->Request('StageSociete',$idGroupe),$this->groupes_model->RequestByGrp('langue',$idGroupe));
                            $return['parcoursIdFinals'] = $parcoursIdFinal;
                        }
                        $formationData = array(
                            'user_id'        => $idStagiaire,
                            'groupe_id'      => $idGroupe,
                            'sequence_id'    => $sequenceArray[$i],
                            'locs'           => 1,
                            'module_id'      => $module_id,
                            'locm'           => 1,
                            'parcours_id'    => $parcoursIdFinal,
                            'locp'           => 1,
                            'ordre'          => $orderModule,
                            'note'           => 0
                        );
                        $this->formations_model->add($formationData);
                        $return['formationInfos'] = $formationData;
                    }
                    elseif ($_POST['action_btn'] == 'maj_for_my_trainee') { //MAJ for all trainee from tutor
                        $allResultTraineeFormTutot   = $this->groupes_model->readGrpTutor($this->session->userdata ('GUSERID'));
                        foreach ($allResultTraineeFormTutot as $res){
                            $parcoursId = $this->formations_model->getIdByGroupe($res->id_groupe);
                            $return['parcoursId'] = $parcoursId;
                            if ($parcoursId >= 1) {
                               $parcoursIdFinal = $parcoursId;
                            }
                            else{
                                $parcoursIdFinal = $this->NiveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('id_parcours_el',$this->membres_model->Request('StageSociete',$res->id_groupe),$this->groupes_model->RequestByGrp('langue',$res->id_groupe));
                                $return['parcoursIdFinals'] = $parcoursIdFinal;
                            }
                            $formationData = array(
                                'user_id'        => $res->id,
                                'groupe_id'      => $res->id_groupe,
                                'sequence_id'    => $sequenceArray[$i],
                                'locs'           => 1,
                                'module_id'      => $module_id,
                                'locm'           => 1,
                                'parcours_id'    => $parcoursIdFinal,
                                'locp'           => 1,
                                'ordre'          => $orderModule,
                                'note'           => 0
                            );
                            $this->formations_model->add($formationData);
                            $return['formationInfos'] = $formationData;
                        }
                    }
                    else{  //MAJ for all trainee active
                        $allResultTrainee   = $this->membres_model->filtrer('',STAGIAIRE,'2');
                        for ($i=0; $i < count($allResultTrainee) ; $i++) { 
                            $parcoursId = $this->formations_model->getIdByGroupe($allResultTrainee[$i]['groupeId']);
                            $return['parcoursId'] = $parcoursId;
                            if ($parcoursId >= 1) {
                               $parcoursIdFinal = $parcoursId;
                            }
                            else{
                                $parcoursIdFinal = $this->NiveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('id_parcours_el',$this->membres_model->Request('StageSociete',$allResultTrainee[$i]['groupeId']),$this->groupes_model->RequestByGrp('langue',$allResultTrainee[$i]['groupeId']));
                                $return['parcoursIdFinals'] = $parcoursIdFinal;
                            }
                            $formationData = array(
                                'user_id'        => $allResultTrainee[$i]['id'],
                                'groupe_id'      => $allResultTrainee[$i]['groupeId'],
                                'sequence_id'    => $sequenceArray[$i],
                                'locs'           => 1,
                                'module_id'      => $module_id,
                                'locm'           => 1,
                                'parcours_id'    => $parcoursIdFinal,
                                'locp'           => 1,
                                'ordre'          => $orderModule,
                                'note'           => 0
                            );
                            $this->formations_model->add($formationData);
                            $return['formationInfos'] = $formationData;
                        }
                    }
                }
            }
            else{ //add new sequence list
                $dataSequenceList = array(
                    'sequence_titre'    => $_POST['sequence_titre'],
                    'sequence_objectifs'=> $_POST['sequence_objectifs'],
                    'sequence_duree'    => 0,
                    'repertoire'        => '',
                    'auteur_id'         => -1,
                    'code'              => 'S'.$this->sequence_model->getNextCodeFormListSequence(),
                    'domaine_id'        => $_POST['domaine_id'],
                    'matiere_id'        => 0,
                    'user_create'       => $this->session->userdata ('GUSERID'),
                );
                
                $idSequence  = $this->sequence_model->addSequenceList($dataSequenceList);
                $return['sequenceInfos'] = $dataSequenceList;
                $return['sequenceInfos']['idSequence'] = $idSequence;

                //ajouter la sequence dans le module
                $orderModule = $this->modules_model->getNextOrderFormModule($module_id);
                $moduleData = array(
                    'module_id'  => $module_id,
                    'ordre'      => $orderModule,
                    'sequence_id'=> $idSequence,
                    'type'       => 0,
                    'loc'        => 1,
                );
                $this->modules_model->addModule($moduleData);
                $return['moduleInfos'] = $moduleData;

                $parcoursIdFinal = '';
                //ajouter la sequence dans la formation
                if ($_POST['action_btn'] == 'maj_for_presence_trainee') { // MAJ for presence trainee                
                    $parcoursId = $this->formations_model->getIdByGroupe($idGroupe);
                    $return['parcoursId'] = $parcoursId;
                    if ($parcoursId >= 1) {
                       $parcoursIdFinal = $parcoursId;
                    }
                    else{
                        $parcoursIdFinal = $this->NiveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('id_parcours_el',$this->membres_model->Request('StageSociete',$idGroupe),$this->groupes_model->RequestByGrp('langue',$idGroupe));
                        $return['parcoursIdFinals'] = $parcoursIdFinal;
                    }
                    $formationData = array(
                        'user_id'        => $idStagiaire,
                        'groupe_id'      => $idGroupe,
                        'sequence_id'    => $idSequence,
                        'locs'           => 1,
                        'module_id'      => $module_id,
                        'locm'           => 1,
                        'parcours_id'    => $parcoursIdFinal,
                        'locp'           => 1,
                        'ordre'          => $orderModule,
                        'note'           => 0
                    );
                    $this->formations_model->add($formationData);
                    $return['formationInfos'] = $formationData;
                }
                elseif ($_POST['action_btn'] == 'maj_for_my_trainee') { //MAJ for all trainee from tutor
                    $allResultTraineeFormTutot   = $this->groupes_model->readGrpTutor($this->session->userdata ('GUSERID'));
                    foreach ($allResultTraineeFormTutot as $res){
                        $parcoursId = $this->formations_model->getIdByGroupe($res->id_groupe);
                        $return['parcoursId'] = $parcoursId;
                        if ($parcoursId >= 1) {
                           $parcoursIdFinal = $parcoursId;
                        }
                        else{
                            $parcoursIdFinal = $this->NiveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('id_parcours_el',$this->membres_model->Request('StageSociete',$res->id_groupe),$this->groupes_model->RequestByGrp('langue',$res->id_groupe));
                            $return['parcoursIdFinals'] = $parcoursIdFinal;
                        }
                        $formationData = array(
                            'user_id'        => $res->id,
                            'groupe_id'      => $res->id_groupe,
                            'sequence_id'    => $idSequence,
                            'locs'           => 1,
                            'module_id'      => $module_id,
                            'locm'           => 1,
                            'parcours_id'    => $parcoursIdFinal,
                            'locp'           => 1,
                            'ordre'          => $orderModule,
                            'note'           => 0
                        );
                        $this->formations_model->add($formationData);
                        $return['formationInfos'] = $formationData;
                    }
                }
                else{  //MAJ for all trainee active
                    $allResultTrainee   = $this->membres_model->filtrer('',STAGIAIRE,'2');
                    for ($i=0; $i < count($allResultTrainee) ; $i++) { 
                        $parcoursId = $this->formations_model->getIdByGroupe($allResultTrainee[$i]['groupeId']);
                        $return['parcoursId'] = $parcoursId;
                        if ($parcoursId >= 1) {
                           $parcoursIdFinal = $parcoursId;
                        }
                        else{
                            $parcoursIdFinal = $this->NiveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('id_parcours_el',$this->membres_model->Request('StageSociete',$allResultTrainee[$i]['groupeId']),$this->groupes_model->RequestByGrp('langue',$allResultTrainee[$i]['groupeId']));
                            $return['parcoursIdFinals'] = $parcoursIdFinal;
                        }
                        $formationData = array(
                            'user_id'        => $allResultTrainee[$i]['id'],
                            'groupe_id'      => $allResultTrainee[$i]['groupeId'],
                            'sequence_id'    => $idSequence,
                            'locs'           => 1,
                            'module_id'      => $module_id,
                            'locm'           => 1,
                            'parcours_id'    => $parcoursIdFinal,
                            'locp'           => 1,
                            'ordre'          => $orderModule,
                            'note'           => 0
                        );
                        $this->formations_model->add($formationData);
                        $return['formationInfos'] = $formationData;
                    }
                }
            }
        }
        echo json_encode($return);
    }

    public function addModulePostData(){

        if (isset($_POST['module_titre'])) {
            $data = array(
                'module_titre'       => $_POST['module_titre'],
                'module_objectifs'   => $_POST['module_objectifs'],
                'module_duree'       => 0,
                'auteur_id'          => $this->session->userdata ('GUSERID'),
                'code'               => 'M'.$this->modules_model->getNextId(),
                'domaine_id'         => isset($_POST['module_domaine']) ? $_POST['module_domaine'] : 0,
                'matiere_id'         => isset($_POST['module_matiere']) ? $_POST['module_matiere'] : 0,
            );
            
            $module_insert_id = $this->modules_model->add($data); 
            //MAJ info formation trainee from personnal interest
            if (isset($_POST['module_parcours'])) {
                $this->load->model('admin_model');
                // Add module to parcours
                for ($p=0; $p < count($_POST['module_parcours']) ; $p++) {
                    if (isset($_POST['module_parcours'][$p])) {
                        $this->admin_model->ajouterUnModuleParcours($_POST['module_parcours'][$p],$module_insert_id,1);
                    }
                }

                if (isset($_POST['module_maj_formation']) && $_POST['module_maj_formation'] == '1') {
                    $parcoursIdFinal = 0;

                    //get all users have parcours in formation

                    $arrayFormationParams = array(
                        'parcours_id'       => $_POST['module_parcours'],
                    );
                    $formationResult = $this->formations_model->getInfosUsersActifByParams1($arrayFormationParams);
                    
                    foreach($formationResult as $forma){
                        $return['formationInfos'] = $this->admin_model->ajouterModuleFormation($forma->user_id,0,1,$module_insert_id,1,$forma->parcours_id,1,$forma->groupe_id,$_POST['module_domaine']);
                    }
                }         
            }         
        }
        redirect("/managemodules","refresh");
    }

    public function ajaxEditModule()
    {        
        $return = array();
        $infosUpdate = array();
        $return['module_maj_formation_edit'] = isset($_POST['module_maj_formation_edit']) ? $_POST['module_maj_formation_edit'] : 'tsis';
        $return['post'] = $_POST;
        if (isset($_POST['module_id'])) {
            $data = array(
                'module_titre'     => $_POST['module_titre'],
                'module_objectifs' => $_POST['module_objectif'],
                'domaine_id'       => $_POST['module_domaine'],
                'matiere_id'       => $_POST['module_matiere'],
            );

            $arrayParcoursParams = array(
                'domaine_id'       => $_POST['module_domaine'],
                'matiere_id'       => $_POST['module_matiere'],
            );

            $this->modules_model->update($_POST['module_id'],$data);

            //MAJ info formation trainee from personnal interest
            if (isset($_POST['module_parcours'])) {
                $this->load->model('admin_model');
                // Add module to parcours
                for ($p=0; $p < count($_POST['module_parcours']) ; $p++) { 
                    if (isset($_POST['module_parcours'][$p])) {
                        $this->admin_model->ajouterUnModuleParcours($_POST['module_parcours'][$p],$_POST['module_id'],1);
                    }                    
                }

                if (isset($_POST['module_maj_formation_edit']) && $_POST['module_maj_formation_edit'] == '1') {
                    //get all users have parcours in formation
                    $arrayFormationParams = array(
                        'parcours_id'       => $_POST['module_parcours'],
                    );
                    $formationResult = $this->formations_model->getInfosUsersActifByParams1($arrayFormationParams);
                    $f = 0;
                    foreach($formationResult as $forma){
                        //check is module if exist                        
                        $arrayFormationParams = array(
                            //'parcours_id'       => $_POST['module_parcours'],
                            'module_id'         => $_POST['module_id'],
                            'groupe_id'         => $forma->groupe_id,
                        );
                        $contentResult = $this->formations_model->getData($arrayFormationParams);
                        if (count($contentResult) < 1) {
                            $infosUpdate[$f] = $this->admin_model->ajouterModuleFormation($forma->user_id,0,1,$_POST['module_id'],1,$forma->parcours_id,1,$forma->groupe_id,$_POST['module_domaine']);

                            $f++;
                        }
                    }

                   

                }
            }
            $return = array(
                'data'        => $data,
                'infosUpdate' => $infosUpdate,
            );
        }
        echo json_encode($return);
    }

    public function addSequence()
    {
        $return = array();
        if (isset($_POST['module_id'])) {
            $data = array(
                'module_id'   => $_POST['module_id'],
                'ordre'       => 1,
                'sequence_id' => $_POST['sequence_id'],
                'type'        => 0,
                'loc'         => 1,
            );
            
            //add sequence to module
            $this->modules_model->addModule($data);
            $return = $data;

            // select a group where formation have a module
            $allResutls = $this->formations_model->getInfosByModules($_POST['module_id']);
            $f = 0;
            $infosFormation = array();
            $this->load->model('admin_model');
            if (count($allResutls) >= 1) {
                foreach($allResutls as $res){
                    $this->admin_model->ajouterSequenceFormation($res->user_id,$_POST['sequence_id'],1,$_POST['module_id'],1,$res->parcours_id,1,$res->groupe_id,$_POST['domaine_id']);
                }
            }
            $return['infosFormation'] = $infosFormation;
            // update formation from traine's

        }
        echo json_encode($return);
    }

}

?>