<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Groupes extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('niveau_model');
        $this->load->model('admin_model');
        $this->load->model('sessions_model');
        $this->isLoggedIn();   
    }
     
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Groups members';
        $this->load->library('pagination');
        $searchText = $this->input->post('searchText');
        $data['searchText'] = $searchText;  
        if (isset($_GET['idmembres'])) {
           $data['traineeGroupes'] = $this->makeArray($this->groupes_model->readGroupStagiaire($_GET['idmembres']));  
        }

        $count = $this->groupes_model->readCountfiltrer($searchText);
        $returns = $this->paginationCompress ("listesGroupes/", $count, 18 );
        
        $data['groupes'] = $this->groupes_model->filtrer($searchText,$returns["page"], $returns["segment"]);  
  
        $this->loadViews("admin/groupe/liste",$this->global, $data, NULL);
    } 

    public function list()
    {
        $this->global['pageTitle'] = 'E-learning : Groups members';
        $this->load->library('form_validation');
        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('code', 'Code', '');
        $this->form_validation->set_rules('directory', 'Create a directory', '');
        $this->form_validation->set_rules('glossary', 'Glossary online', '');
        if($this->form_validation->run() == TRUE){
            $code = '';
            $idGroupe = $this->groupes_model->getMaxIdGroupes() + 1;
            if ( trim($this->input->post('code')) == '' ) {
                $code = 'G'.($idGroupe < 10 ? '0'.$idGroupe : $idGroupe) ;
            }
            $data = array(
                'id_groupe' => $idGroupe,
                'name' => $this->input->post('name'),
                'code' => $code,
                'id_tuteur' => 0,
                'repertoire' => 'GRP'.$idGroupe,
                'glossaireenligne' => $this->input->post('glossary'),
                'date_modif' => time(),
            );
            $this->groupes_model->addlistgrp($data);
            if ($this->input->post('directory')) {
                // code...
            }
        }
        $this->load->library('pagination');
        $searchText = $this->input->post('searchText');
        $data['searchText'] = $searchText;  
        if (isset($_GET['idmembres'])) {
           $data['traineeGroupes'] = $this->makeArray($this->groupes_model->readGroupStagiaire($_GET['idmembres']));  
        }

        $count = $this->groupes_model->readCountfiltrer($searchText);
        $returns = $this->paginationCompress ("managegroups/", $count, 18 );        
        $data['groupes'] = $this->groupes_model->filtrer($searchText,$returns["page"], $returns["segment"]);  
  
        $this->loadViews("admin/groupe/list",$this->global, $data, NULL);
    }

    public function removegroup(){
        if (isset($_GET['idmembres']) && $_GET['usertype'] == 0) {
            $data = array(
                'id_groupe' => NULL
                );
            $this->membres_model->update($_GET['idmembres'],$data);
            $this->admin_model->supprimerStagiaireGroupe($_GET['idmembres'], $_GET['idgroupes']);
            
        }
        else{ // supprimer un groupe dans le portefeuille d'un prof
            $this->admin_model->supprimerStagiairePortefeuille($_GET['idmembres'], $_GET['idgroupes']);
        }

        if (isset($_GET['ret']) && $_GET['ret'] == 'edit') {
            redirect('editmembers?id='.$_GET['idmembres'].'&type=0', 'refresh');
        }
        else{
            redirect('listesGroupes?idmembres='.$_GET['idmembres'], 'refresh');
        }

    }

    public function remove(){
        if (isset($_GET['idmembres'])) {
            $data = array(
                'id_groupe' => NULL
                );
            $this->membres_model->update($_GET['idmembres'],$data);
            
        }
        if (isset($_GET['idgroupes'])) {
            $data = array(
                'id_groupe' => $_GET['idgroupes']
            );
            $this->admin_model->supprimerStagiaireGroupe($_GET['idmembres'], $_GET['idgroupes']);
        }
        if (isset($_GET['ret']) && $_GET['ret'] == 'edit') {
            redirect('editmembers?id='.$_GET['idmembres'].'&type=0', 'refresh');
        }
        else{
            redirect('listesGroupes?idmembres='.$_GET['idmembres'], 'refresh');
        }

    }

    public function addtutor(){
        if (isset($_GET['id_groupes'])) {
            $this->membres_model->addUserCreate($_GET['id_groupes'],$this->session->userdata ('GUSERID'));
            $this->membres_model->addUserModif($_GET['id_groupes'],$this->session->userdata ('GUSERID'));

            $this->admin_model->ajouterTuteurGroupe($_GET['tutorid'],$_GET['id_groupes']);
            redirect('tutorlist?id_groupes='.$_GET['id_groupes'], 'refresh');
        }
    }

    public function addtutorjson(){
        $return = array();
        if (isset($_GET['id_groupes'])) {
            $return['addUserCreate'] = $this->membres_model->addUserCreate($_GET['id_groupes'],$this->session->userdata ('GUSERID'));
            $return['addUserModif'] = $this->membres_model->addUserModif($_GET['id_groupes'],$this->session->userdata ('GUSERID'));

            $return['ajouterTuteurGroupe'] = $this->admin_model->ajouterTuteurGroupe($_GET['tutorid'],$_GET['id_groupes']);
        }
        echo json_encode($return);
    }
    public function tutorlist(){
        if (isset($_GET['id_groupes'])) {
            $this->global['pageTitle']    = 'E-learning : Edition Groups';
            $this->load->library('pagination');
            $data['searchText'] = $this->input->post('searchText');
            $data['id_groupes']   = $_GET['id_groupes'];   
            $data['tutorInGroup'] = $this->makeArray($this->membres_model->GetTuteur($_GET['id_groupes']));    
            $data['tutorResults'] = $this->membres_model->adminFilter(TUTEUR,2,$data['searchText']); 
            $this->loadViews("admin/members/tutorlist",$this->global, $data, NULL);
        }
    }

    public function tutorlistJson(){
        $return = array();
        if (isset($_POST['id_groupe'])) {
            $return = array(
                'id_groupes'    => $_POST['id_groupe'],
                'tutorInGroup'  => $this->makeArray($this->membres_model->GetTuteur($_POST['id_groupe'])),
                'tutorResults'  => $this->membres_model->adminFilter(TUTEUR,2,''),
            ); 
        }
        echo json_encode($return);
    }

     public function traineelistJson(){
        $return = array();
        if (isset($_POST['id_groupe'])) {
            $return = array(
                'id_groupes'      => $_POST['id_groupe'],
                'traineeInGroup'  => $this->makeArray($this->groupes_model->Members($_POST['id_groupe'])),
                'traineeResults'  => $this->membres_model->adminFilter(STAGIAIRE,2,''),
            ); 
        }
        echo json_encode($return);
    }

    public function removetutor(){
        if (isset($_GET['id_groupes'])) {
            $this->groupes_model->delTuteur($_GET['id_groupes'],$_GET['id_tuteur']);
            if (isset($_GET['fenetre']) && $_GET['fenetre'] == 'popup') {
                redirect('tutorlist?id_groupes='.$_GET['id_groupes'], 'refresh');
            }
            else{
                redirect('editgroupes?id='.$_GET['id_groupes'], 'refresh');
            }
        }
    }

    public function removetutorjson(){
        $return = array();
        if (isset($_GET['id_groupes'])) {
            $return['traitement'] = $this->groupes_model->delTuteur($_GET['id_groupes'],$_GET['id_tuteur']);
        }
        echo json_encode($return);
    }

    public function removetrainee(){
        $return = array();
        if (isset($_GET['id'])) {
            $return['traitement'] = $this->groupes_model->deleteByMember($_GET['id']);
        }
        echo json_encode($return);
    }

    public function addtrainee(){
        $return = array();
        if (isset($_POST['id'])) {
            $data = array(
                'id_groupe'  => $_POST['id_groupe'],
                'id_membres' => $_POST['id'],
                'langue'     => $this->groupes_model->RequestByGrp('langue', $_POST['id_groupe']),
                'prototype'  => $this->groupes_model->RequestByGrp('prototype', $_POST['id_groupe']),
                'allowed_commande_papers_glossary'  => $this->groupes_model->RequestByGrp('allowed_commande_papers_glossary', $_POST['id_groupe']),
                'date_modif' => time()
            );

            $return['traitement'] = $this->groupes_model->addgrp($data);
        }
        echo json_encode($return);
    }

    public function edit(){
        if((isset($_POST['prototype']) || isset($_POST['glossaire_en_ligne']) || isset($_POST['creation_pad'])) && isset($_POST['id_groupes'])){
            //$glossaire_en_ligne = $_POST['glossaire_en_ligne'];
            //$creation_pad       = $_POST['creation_pad'];
            $prototype          = isset($_POST['prototype']) ? implode(',', $_POST['prototype']) : null;
            $date   = getdate() ;
            $date   = $date["0"];
            $data = array(
                'prototype'  => $prototype,
                'date_modif' => $date
            );
            $dataL = array(
                'glossaireenligne'  => $_POST['glossaire_en_ligne'],
                'date_modif' => $date
            );

            $dataBddl = array(
                'ref_individu'       => $this->membres_model->RequestByGrp('extranet_id',$_POST['id_groupes']),
                'id_stagiaire_el'    => $this->membres_model->RequestByGrp('id',$_POST['id_groupes']),
                'num_stage'          => $this->Stag_individu_model->getMaxNumStageByIdMembers($this->membres_model->RequestByGrp('id',$_POST['id_groupes'])),
                'id_groupe'           => $_POST['id_groupes'],
                'prototype'           => $_POST['prototype'],
            );

            //$this->postDataPrototypeToBddl($dataBddl);


            $this->groupes_model->updatelistgrp($_POST['id_groupes'],$dataL); 
            $this->groupes_model->updategrp($_POST['id_groupes'],$data); 
            $this->membres_model->addUserCreate($_POST['id_groupes'],$this->session->userdata ('GUSERID'));
            $this->membres_model->addUserModif($_POST['id_groupes'],$this->session->userdata ('GUSERID'));

            redirect('editgroupes?id='.$_POST['id_groupes'], 'refresh');
        }

        if (isset($_GET['id'])) {
            $this->global['pageTitle']   = 'E-learning : Edition Groups';
            $del                         = base_url().'delete-session-groupe?action=del_item&id='.$_GET['id'];
            $data['groupes']             = $this->groupes_model->readGroupe($_GET['id']);  
            $data['glossaireenligne']    = count($this->groupes_model->checkGlossaireOnline($_GET['id']));  
            $data['formationResults']    = $this->formations_model->readV3($_GET['id'],$this->groupes_model->RequestByGrpLimit1('id_membres',$_GET['id']));
            //var_dump($formationResult);
            //die();  
            

            //$data['sessionsGroupesAdmin'] = $this->ListSessionGroupeAdminDelV3($formationResult, $del,0,'',$_GET['id']); 
            //$data['atelier_thematique'] = $this->groupes_model->Atelier($_GET['id']); 
            $data['atelier_thematique']   = ''; 
            //$data['allprototype']         = $this->bddl_model->getAllPrototypeAcess(); 

            $data['prototypeResults']      = $this->getPrototypeBddl(); 

            //var_dump($data['prototypeResults']);
            //die();
            $data['prototypebygroup']     = $this->groupes_model->readPrototypeGroupe($_GET['id']); 
            $pres = array();
            $prototypeExistant = isset($data['prototypebygroup']['prototype']) ? $data['prototypebygroup']['prototype'] : null;
            
            if(!empty($prototypeExistant)) {
                $prx = explode(",", $prototypeExistant);
                for ($i=0; $i < count($prx); $i++) { 
                    $pres[$i] = $prx[$i];
                }
            }

            $data['prototypesArray']       = $pres; 

            $data['stagiaires']           = $this->groupes_model->Members($_GET['id']); 
            $data['tuteurs']              = $this->membres_model->GetTuteur($_GET['id']); 
            $data['groupeId']             = $_GET['id']; 
            $this->loadViews("admin/groupe/edit",$this->global, $data, NULL);
        }
    }

    public function deleteSession(){
        if (isset($_GET['id'])) {
            $this->admin_model->supprimerItemFormation(
                    $this->groupes_model->RequestByGrp('id_membres',$_GET['id']),
                    $_GET['sequence_id'],
                    $_GET['locs'],
                    $_GET['module_id'],
                    $_GET['locm'],
                    $_GET['parcours_id'],
                    $_GET['locp'],
                    $_GET['id']
                ); 
            redirect('editgroupes?id='.$_GET['id'], 'refresh');
        }
    }

    public function updategrpmembers(){
        if (isset($_GET['idgroupes'])) {
            $this->admin_model->ajouterStagiaireGroupe($_GET['idmembres'], $_GET['idgroupes']);
            $this->membres_model->addUserCreate($_GET['idmembres'],$this->session->userdata ('GUSERID'));
            $this->membres_model->addUserModif($_GET['idmembres'],$this->session->userdata ('GUSERID'));
        }
        redirect('listesGroupes?idmembres='.$_GET['idmembres'], 'refresh');
    }

    public function updateTrainerGroupes(){
        $return = array();
        $groupes = array();
        $return['POST'] = $_POST;
        $i = 0;
        $trainer = isset($_POST['trainer']) ? $_POST['trainer'] : null;
        if (isset($_POST['groupes']) && $trainer != null) {
            foreach ($_POST['groupes'] as $key => $value) {
                $groupes[$i] = $value;

                $affectionsResults = $this->groupes_model->RequestByParams(array('id_groupe' => $value, 'id_tuteur' => $trainer));
                if (count($affectionsResults) < 1) {
                    $this->groupes_model->addlistgrp(array(
                        'id_groupe' => $value,
                        'name' => $this->membres_model->RequestByGrp('nom',$value).' '.$this->membres_model->RequestByGrp('prenom',$value),
                        'code' => 'G'.$value,
                        'id_tuteur' => $trainer,
                        'repertoire' => 'GRP'.$value,
                        'glossaireenligne' => 0,
                        'date_modif' => time(),
                    ));
                }

                $i++;
            }
        }

        if (isset($groupes)) {           

            //Nettoyages groupes list trainer
            $this->groupes_model->deleteListGroupesNotInParams($groupes,$trainer);
        }

        $return['groupes'] = $groupes;
        echo json_encode($return);
    }

    public function addItemsFormation(){
        $return = array();
        if (isset($_POST['content_type'])) {            
            switch ($_POST['content_type']) {
                case TYPE_SEQUENCE:
                    if ((isset($_POST['contentPost']) && $_POST['contentPost'] != '') || isset($_POST['domainePost']) && $_POST['domainePost'] != '') {
                        $module_id = (isset($_POST['contentPost']) && $_POST['contentPost'] != '') ? $_POST['contentPost'] : 0;
                        $domaine_id = (isset($_POST['domainePost']) && $_POST['domainePost'] != '') ? $_POST['domainePost'] : $_POST['domaine_id'];

                        $return['results'] = $this->admin_model->ajouterSequenceFormation($this->groupes_model->RequestByGrp('id_membres',$_POST['groupe_id']),$_POST['content_id'],1,$module_id,1,0,1,$_POST['groupe_id'],$domaine_id);
                    }
                    else{
                        $return['results'] = $this->admin_model->ajouterSequenceFormation($this->groupes_model->RequestByGrp('id_membres',$_POST['groupe_id']),$_POST['content_id'],1,0,1,0,1,$_POST['groupe_id'],$_POST['domaine_id']);
                    }
                    break;
                case TYPE_MODULE:
                    if ((isset($_POST['contentPost']) && $_POST['contentPost'] != '') || isset($_POST['domainePost']) && $_POST['domainePost'] != '') {
                        $parcours_id = (isset($_POST['contentPost']) && $_POST['contentPost'] != '') ? $_POST['contentPost'] : 0;
                        $domaine_id = (isset($_POST['domainePost']) && $_POST['domainePost'] != '') ? $_POST['domainePost'] : $_POST['domaine_id'];

                        $return['results'] = $this->admin_model->ajouterModuleFormation($this->groupes_model->RequestByGrp('id_membres',$_POST['groupe_id']),0,1,$_POST['content_id'],1,$parcours_id,1,$_POST['groupe_id'],$domaine_id);
                    }
                    else{
                        $return['results'] = $this->admin_model->ajouterModuleFormation($this->groupes_model->RequestByGrp('id_membres',$_POST['groupe_id']),0,1,$_POST['content_id'],1,0,1,$_POST['groupe_id'],$_POST['domaine_id']);
                    }
                    break;
                case TYPE_PARCOURS:
                    $return['post'] = $_POST;
                    $return['results'] = $this->admin_model->ajouterParcoursFormation($this->groupes_model->RequestByGrp('id_membres',$_POST['groupe_id']),0,1,0,1,$_POST['content_id'],1,$_POST['groupe_id'],$_POST['domaine_id']);
                    break;
                
                default:
                    // code...
                    break;
            }
        }
        echo json_encode($return);
    }

     public function delItemsFormation(){
        $return      = array();
        $sequence_id = -1;
        $module_id   = -1;
        $parcours_id = -1;
        $groupe_id   = isset($_POST['groupe_id']) ? $_POST['groupe_id'] : -1;
        $membres_id  = isset($_POST['groupe_id']) ? $this->groupes_model->RequestByGrp('id_membres',$_POST['groupe_id']) : -1;
        if (isset($_POST['content_type'])) {
            switch ($_POST['content_type']) {
                case TYPE_SEQUENCE:
                    $sequence_id = $_POST['content_id'];
                    break;
                case TYPE_MODULE:
                    $module_id  = $_POST['content_id'];
                    break;
                case TYPE_PARCOURS:
                    $parcours_id = $_POST['content_id'];
                    break;
                
                default:
                    // code...
                    break;
            }
            $return['results'] = $this->admin_model->supprimerItemFormation($membres_id, $sequence_id, 1, $module_id, 1, $parcours_id, 1, $groupe_id); 
        }
        $return['POST'] = $_POST;
        echo json_encode($return);
    }
   
}

?>