const tabsDocument = document.querySelector('#content-1');
const dropDownButton = document.querySelectorAll('[role="dropDownButton"]');
const dropDownMenu = document.querySelectorAll('[role="dropDownMenu"]');
const bodyDocument = document.querySelectorAll(".elearning");

$(document).ready(function(){ 

  var tablePortefeuille = $('.el-table-document').DataTable( {
    "lengthChange": false,
    responsive: true,
    "order": [[ 3, "desc" ]],
    pageLength: 4,                
    language: {
      search:         "",
      searchPlaceholder: searcPlaceholder,
      "paginate": {
          "first":      datatablePaginateFirst,
          "last":       datatablePaginateLast,
          "next":       datatablePaginateNext,
          "previous":   datatablePaginatePreview
      },
      "emptyTable":     datatableEmptyData,
      "info":           datatableInfos,
      "infoEmpty":      datatableInfosEmpty,
    },
  });

  var tablePersonnalDocuments = $('.el-table-document-personnel').DataTable( {
    "lengthChange": false,
    responsive: true,
    "order": [[ 2, "desc" ]],
    pageLength: 3,                
    language: {
      search:         "",
      searchPlaceholder: label_search,
      "paginate": {
          "first":      datatablePaginateFirst,
          "last":       datatablePaginateLast,
          "next":       datatablePaginateNext,
          "previous":   datatablePaginatePreview
      },
      "emptyTable":     datatableEmptyData,
      "info":           datatableInfos,
      "infoEmpty":      datatableInfosEmpty,
    },
  });

  $('.btn-go-back-folder').click(function(e){
    e.preventDefault();
    $('.repertory-inner').attr('aria-loop',false);
    $('.parent-repertory').attr('aria-loop',true);
  });

  $('.repertory-container').each(function(){
    $('.dataTables_filter input').addClass('el-form mb-3 input-search-document');
  });

  $('.btn-delete-repertory').click(function(){
    $('#id_repertory_document').val($(this).attr('data-idrep'));
    $('#modal_dele_repertory_document').addClass('open');
  });

  $('.parent-repertory').click(function(){
    var module_id = $(this).attr('data-rep');
    $('#current_module').val(module_id);
    $.ajax({
      url : $('.baseURL').val()+"add-tracking-document",
      type:'POST',
      data:{module_id: module_id, tracking_type: $('#lib').val()},   
      success:function(response){
        return true;
      }
    });
  });

  $('.confirm-delete-repertory-document').click(function(){
    var btn = $(this);
    var idRep = $('#id_repertory_document').val();
    $('.spinner').fadeIn('slow');
    $.ajax({
      url : $('.baseURL').val()+"delete-repertory",
      type:'POST',
      data:{id_repertory : idRep},   
      success:function(response){
            $('#modal_dele_repertory_document').removeClass('open');
            var folderBefore = '';
            var folderBack = '';
            $('.parent-repertory').each(function(){
              if ($(this).attr('data-rep') == idRep) {
                var folder = $(this).attr('data-id').split('-');
                folderBefore += 'folder-'+(parseInt(folder[1]) - 1);
                folderBack   += 'folder-'+(parseInt(folder[1]) + 1);
                $(this).remove();
              }
            });

            $('.repertory-inner').each(function(){
              if ($(this).attr('data-repdoc') == idRep) {
                $(this).remove();
              }
            });

            //console.log('folderBefore : ' + folderBefore);
            //console.log('folderBack : ' + folderBack);

            $('.parent-repertory').each(function(){
              var newFolderClik  = $(this);
              console.log(newFolderClik.attr('data-id')+' : ' + folderBefore);
              if (newFolderClik.attr('data-id') == folderBefore) {
                newFolderClik.click();
              }
              else if (newFolderClik.attr('data-id') == folderBack) {
                newFolderClik.click();
              }
              else{
                console.log('aucun folder');
              }
            });

            $('.spinner').fadeOut('slow');
            toastr.success(data_delete_ok);
          }
    });
  });
  $('.confirm-delete-repertory-repertory-community').click(function(){
    var btn = $(this);
    var idRep = $('#id_repertory_document').val();
    $('.spinner').fadeIn('slow');
    $.ajax({
      url : $('.baseURL').val()+"delete-repertory-community-library-f2plus",
      type:'POST',
      data:{id_repertory : idRep},   
      success:function(response){
            $('#modal_dele_repertory_document').removeClass('open');
            var folderBefore = '';
            var folderBack = '';
            $('.parent-repertory').each(function(){
              if ($(this).attr('data-rep') == idRep) {
                var folder = $(this).attr('data-id').split('-');
                folderBefore += 'folder-'+(parseInt(folder[1]) - 1);
                folderBack   += 'folder-'+(parseInt(folder[1]) + 1);
                $(this).remove();
              }
            });

            $('.repertory-inner').each(function(){
              if ($(this).attr('data-repdoc') == idRep) {
                $(this).remove();
              }
            });

            $('.parent-repertory').each(function(){
              var newFolderClik  = $(this);
              console.log(newFolderClik.attr('data-id')+' : ' + folderBefore);
              if (newFolderClik.attr('data-id') == folderBefore) {
                newFolderClik.click();
              }
              else if (newFolderClik.attr('data-id') == folderBack) {
                newFolderClik.click();
              }
              else{
                console.log('aucun folder');
              }
            });

            $('.spinner').fadeOut('slow');
            toastr.success(data_delete_ok);
          }
    });
  });
  $('.confirm-delete-repertory-lib').click(function(){
    var btn = $(this);
    var idRep = $('#id_repertory_document').val();
    $('.spinner').fadeIn('slow');
    $.ajax({
      url : $('.baseURL').val()+"delete-repertory-library",
      type:'POST',
      data:{id_repertory : idRep},   
      success:function(response){
            $('#modal_dele_repertory_document').removeClass('open');
            var folderBefore = '';
            var folderBack = '';
            $('.parent-repertory').each(function(){
              if ($(this).attr('data-rep') == idRep) {
                var folder = $(this).attr('data-id').split('-');
                folderBefore += 'folder-'+(parseInt(folder[1]) - 1);
                folderBack   += 'folder-'+(parseInt(folder[1]) + 1);
                $(this).remove();
              }
            });

            $('.repertory-inner').each(function(){
              if ($(this).attr('data-repdoc') == idRep) {
                $(this).remove();
              }
            });

            //console.log('folderBefore : ' + folderBefore);
            //console.log('folderBack : ' + folderBack);

            $('.parent-repertory').each(function(){
              var newFolderClik  = $(this);
              console.log(newFolderClik.attr('data-id')+' : ' + folderBefore);
              if (newFolderClik.attr('data-id') == folderBefore) {
                newFolderClik.click();
              }
              else if (newFolderClik.attr('data-id') == folderBack) {
                newFolderClik.click();
              }
              else{
                console.log('aucun folder');
              }
            });

            $('.spinner').fadeOut('slow');
            toastr.success(data_delete_ok);
          }
    });
  });

  $('.confirm-delete-repertory-corporate').click(function(){
    var btn = $(this);
    var idRep = $('#id_repertory_document').val();
    $('.spinner').fadeIn('slow');
    $.ajax({
      url : $('.baseURL').val()+"delete-repertory-library-soc",
      type:'POST',
      data:{id_repertory : idRep},   
      success:function(response){
          $('#modal_dele_repertory_document').removeClass('open');
          var folderBefore = '';
          var folderBack = '';
          $('.parent-repertory').each(function(){
            if ($(this).attr('data-rep') == idRep) {
              var folder = $(this).attr('data-id').split('-');
              folderBefore += 'folder-'+(parseInt(folder[1]) - 1);
              folderBack   += 'folder-'+(parseInt(folder[1]) + 1);
              $(this).remove();
            }
          });

          $('.repertory-inner').each(function(){
            if ($(this).attr('data-repdoc') == idRep) {
              $(this).remove();
            }
          });

          //console.log('folderBefore : ' + folderBefore);
          //console.log('folderBack : ' + folderBack);

          $('.parent-repertory').each(function(){
            var newFolderClik  = $(this);
            console.log(newFolderClik.attr('data-id')+' : ' + folderBefore);
            if (newFolderClik.attr('data-id') == folderBefore) {
              newFolderClik.click();
            }
            else if (newFolderClik.attr('data-id') == folderBack) {
              newFolderClik.click();
            }
            else{
              console.log('aucun folder');
            }
          });

          $('.spinner').fadeOut('slow');
          toastr.success(data_delete_ok);
        }
    });
  });

  $('.btn-edit-repertory').click(function(){
    $("#id_repertory_edit").val($(this).attr('data-iprep'));
    $("#repertory-document-edit").val($(this).attr('data-namerep'));
    $("#description-cat-edit").val($(this).attr('data-descrep'));
    $('#modal_edit_repository').addClass('open');
  });

  $('.btn-save-edit-repertory').click(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');

    var form = $('#form-edit-rep');
    var dataRep=form.serializeArray();
  
    var dataRepjson = {};
    for (i in dataRep) {
      dataRepjson[dataRep[i].name] = dataRep[i].value;
    }
    dataRep=dataRepjson;
    $.ajax({
        url : form.attr('action'),
        type: form.attr('method'),
        data:{dataRep:dataRep},   
        success:function(response){
          $('#modal_edit_repository').removeClass('open');
          $('.parent-repertory').each(function(){
            var rep = $(this);
            if (rep.attr('data-rep') == $("#id_repertory_edit").val()) {
              rep.find('.content-repertory').find('h4').html($("#repertory-document-edit").val());
            }
          });
          $('.folder-open').each(function(){
            var repf = $(this);
            if (repf.attr('data-repf') == $("#id_repertory_edit").val()) {
              repf.find('h4').html($("#repertory-document-edit").val());
            }
          });
          toastr.success(data_save_ok);
          $('.spinner').fadeOut('slow');
        }
    });
  });

  $('#add-document-in-database').on('submit', function(e){
    e.preventDefault();
    var retour = "";  
    var dialodSendMail = false;  
    $('.spinner').fadeIn('slow');
    $(this).css("opacity",".5");
    // Call ajax for pass data to other place
    $.ajax({
      type: $(this).attr('method'),
      url:  $(this).attr('action'),
      data:  new FormData(this),
      contentType: false,
      cache: false,
      processData:false,
      dataType: 'json',
      success: function(data){
        if (data.upload == true) {
          toastr.success(data_save_ok);
          location.reload(true);
        }
        else{
          toastr.error(data_saved_ko);
          $(this).css("opacity","1");
        }
        
        $('.spinner').fadeOut('slow');
        
      }
    });
  });  

  $('.btn-add-link-in-database').click(function(e){
    e.preventDefault();
    var form = $('#add-link-in-database');
    var dataLink=form.serializeArray();  
    $('.spinner').fadeIn('slow');
    var dataLinkjson = {};
    for (i in dataLink) {
      dataLinkjson[dataLink[i].name] = dataLink[i].value;
    }
    dataLink=dataLinkjson;
    // Call ajax for pass data to other place
    $.ajax({
      type: form.attr('method'),
      url:  form.attr('action'),
      data:  {"dataLink":dataLink},
      success: function(msg){
          $('.spinner').fadeOut('slow');
          toastr.success(data_save_ok); 
          location.reload(true);
        }
    });
  });

  $('.btn-save-new-repertory').click(function(e){
    e.preventDefault();
    var form = $('#new-form-rep');
    $('.spinner').fadeIn('slow');
    var repertory = $('#repertory-document').val();
    var description = $('#description_cat').val();
    $.ajax({
      url : form.attr('action'),
      type : 'POST',     
      data : {repertory : repertory , description : description},
      success : function(data){
        toastr.success(data_save_ok);
        location.reload(true);
        $('.spinner').fadeOut('slow');
      }
    });
  });

  $('#editDocOrLink').on('submit', function(e){
    $('.spinner').fadeIn('slow');
    e.preventDefault();
    $.ajax({
      type: $(this).attr('method'),
      url:  $(this).attr('action'),
      data:  new FormData(this),
      contentType: false,
      cache: false,
      processData:false,
      dataType: 'json',
      success: function(data){
        //console.log(data);
        //console.log('test : ' + data.idDoc);
        $('#modal_edit_links_or_doc').removeClass('open');
        /*if(typeof(data.idDoc) != "undefined" && data.idDoc >= 1) {
          toastr.success(data_save_ok);
        }
        else{
          toastr.error(data_saved_ko);
        }*/
        $('.case-title').each(function(){
          if ($(this).attr('data-docid') == $('#id_doc_edit').val()) {
            $(this).find('a').html($('#inputTitleDoc_edit').val());
          }
        });
        toastr.success(data_save_ok);      
        $('.spinner').fadeOut('slow');
      }
    });
  });

  $('.confirm-delete-content-corporate').click(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    var idDoc = $("#id_content_doc").val();
    $.ajax({
      url : $('.baseURL').val()+'delete-data-library-soc',
      type : 'POST',
      data : {"id" : idDoc},    
      success : function(data){
        $('#modal_confirm_delete_content_database').removeClass('open');     
        $('.line-database-doc').each(function(){
          if ($(this).attr('data-docid') == idDoc) {
            $(this).remove();
          }
        });
        $('.el-dropdown').attr('aria-current',false);    
        toastr.success(data_delete_ok);
        tablePortefeuille.draw();
        $('.spinner').fadeOut('slow');
      }
    });
  });

  $('.confirm-delete-content-database').click(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    var idDoc = $("#id_content_doc").val();
    $.ajax({
      url : $('.baseURL').val()+'deletedoc',
      type : 'POST',
      data : {"id" : idDoc},    
      success : function(data){
        $('#modal_confirm_delete_content_database').removeClass('open');     
        $('.line-database-doc').each(function(){
          if ($(this).attr('data-docid') == idDoc) {
            $(this).remove();
          }
        });
        $('.el-dropdown').attr('aria-current',false);    
        toastr.success(data_delete_ok);
        tablePortefeuille.draw();
        $('.spinner').fadeOut('slow');
      }
    });
  });

  $('.confirm-delete-content-personal-document').click(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    var idDoc = $("#id_content_doc").val();
    $.ajax({
      url : $('.baseURL').val()+'deletedoc',
      type : 'POST',
      data : {"id" : idDoc},    
      success : function(data){
        $('#modal_confirm_delete_content_database').removeClass('open');     
        $('.line-personal-document').each(function(){
          var line = $(this);
          console.log(line.attr('data-docid') +" = "+ idDoc);
          if (line.attr('data-docid') == idDoc) {
            line.remove();
          }
        });
        $('.el-dropdown').attr('aria-current',false);    
        toastr.success(data_delete_ok);
        tablePersonnalDocuments.draw();
        location.reload(true); 
        $('.spinner').fadeOut('slow');
      }
    });
  });

  $('.confirm-delete-content-library').click(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    var idDoc = $("#id_content_doc").val();
    $.ajax({
      url : $('.baseURL').val()+'deletedoc-in-library',
      type : 'POST',
      data : {"id" : idDoc},    
      success : function(data){
        $('#modal_confirm_delete_content_database').removeClass('open');     
        $('.line-database-doc').each(function(){
          if ($(this).attr('data-docid') == idDoc) {
            $(this).remove();
          }
        });
        $('.el-dropdown').attr('aria-current',false);    
        toastr.success(data_delete_ok);
        tablePortefeuille.draw();
        $('.spinner').fadeOut('slow');
      }
    });
  });

  $('.confirm-delete-content-community-library-forma2plus').click(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    var idDoc = $("#id_content_doc").val();
    $.ajax({
      url : $('.baseURL').val()+'del-data-community-library-f2plus',
      type : 'POST',
      data : {"id" : idDoc},    
      success : function(data){
        $('#modal_confirm_delete_content_database').removeClass('open');     
        $('.line-database-doc').each(function(){
          if ($(this).attr('data-docid') == idDoc) {
            $(this).remove();
          }
        });
        $('.el-dropdown').attr('aria-current',false);    
        toastr.success(data_delete_ok);
        tablePortefeuille.draw();
        $('.spinner').fadeOut('slow');
      }
    });
  });

  $('.btn-save-content-database-to-fav').click(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    $.ajax({
      type: "POST",
      url:  $('.baseURL').val()+'add-stat-program-user-commun',
      data:  {classification : $('#classification').val(), intitule : $('#document_name').val(), id : $('#document_id').val(), status : 1, comment : "", type : $('#document_type').val(), module_id : parseInt($('#document_module').val())},
      success: function(data){ 
        $('#modal_classification_favoris').removeClass('open');               
        var ret = data.split('##');   
        if (ret[1] >= "1") {
          toastr.success(data_save_ok);
        }
        else{
          toastr.error(data_saved_ko);
        }
        $('.spinner').fadeOut('slow');
      }
    });
  });

  $('.btn-save-dtb-course-historik').click(function(e){
    e.preventDefault();
    var notify = '';
    $('.spinner').fadeIn('slow');
    if ($('#send_mail').is(":checked")) {
        notify = 'on';
    }
    $.ajax({
      type: "POST",
      url:  $('.baseURL').val()+'add-database-document-in-todo',
      data:  {"ch":$('#course-historik').val(),"id":$('#document_id_c').val(),"notify":notify},
      success: function(data){
        console.log(data);
        var ret = data.split('###');   
        $('#modal_add_content_database_historik_course').removeClass('open');    
        if ($('#send_mail').is(":checked")) {
          if(ret[1] == '0'){
            toastr.error(el_send_mail_infos_send_erno);
          }
          else{
            toastr.success(el_send_mail_infos_trainee_data);
          }          
        }
        toastr.success(data_save_ok);
        $('.spinner').fadeOut('slow');
      }
    });
  });
  $('.btn-save-community-lib-forma2plus-to-course-historik').click(function(e){
    e.preventDefault();
    var notify = '';
    $('.spinner').fadeIn('slow');
    if ($('#send_mail').is(":checked")) {
        notify = 'on';
    }
    $.ajax({
      type: "POST",
      url:  $('.baseURL').val()+'add-content-community-library-f2plus-to-ch',
      data:  {"ch":$('#course-historik').val(),"id":$('#document_id_c').val(),"notify":notify},
      success: function(data){
        console.log(data);
        var ret = data.split('###');   
        $('#modal_add_content_database_historik_course').removeClass('open');    
        if ($('#send_mail').is(":checked")) {
          if(ret[1] == '0'){
            toastr.error(el_send_mail_infos_send_erno);
          }
          else{
            toastr.success(el_send_mail_infos_trainee_data);
          }          
        }
        toastr.success(data_save_ok);
        $('.spinner').fadeOut('slow');
      }
    });
  });
  $('.btn-save-lib-course-historik').click(function(e){
    e.preventDefault();
    var notify = '';
    $('.spinner').fadeIn('slow');
    if ($('#send_mail').is(":checked")) {
        notify = 'on';
    }
    $.ajax({
      type: "POST",
      url:  $('.baseURL').val()+'add-lib-in-todo',
      data:  {"ch":$('#course-historik').val(),"id":$('#document_id_c').val(),"notify":notify},
      success: function(data){
        console.log(data);
        var ret = data.split('###');   
        $('#modal_add_content_database_historik_course').removeClass('open');    
        if ($('#send_mail').is(":checked")) {
          if(ret[1] == '0'){
            toastr.error(el_send_mail_infos_send_erno);
          }
          else{
            toastr.success(el_send_mail_infos_trainee_data);
          }          
        }
        toastr.success(data_save_ok);
        $('.spinner').fadeOut('slow');
      }
    });
  });
  $('.btn-save-dtb-corporate-course-historik').click(function(e){
    e.preventDefault();
    var notify = '';
    $('.spinner').fadeIn('slow');
    if ($('#send_mail').is(":checked")) {
        notify = 'on';
    }
    $.ajax({
      type: "POST",
      url:  $('.baseURL').val()+'add-data-lib-cop-in-todo',
      data:  {"ch":$('#course-historik').val(),"id":$('#document_id_c').val(),"notify":notify},
      success: function(data){
        console.log(data);
        var ret = data.split('###');   
        $('#modal_add_content_database_historik_course').removeClass('open');    
        if ($('#send_mail').is(":checked")) {
          if(ret[1] == '0'){
            toastr.error(el_send_mail_infos_send_erno);
          }
          else{
            toastr.success(el_send_mail_infos_trainee_data);
          }          
        }
        toastr.success(data_save_ok);
        $('.spinner').fadeOut('slow');
      }
    });
  });

  $('#form-edit-comment-data-lib').on('submit', function(e){
    e.preventDefault();  
    $('.spinner').fadeIn('slow');
    // Call ajax for pass data to other place
    $.ajax({
      type: $(this).attr('method'),
      url:  $(this).attr('action'),
      data:  new FormData(this),
      contentType: false,
      cache: false,
      processData:false,
      dataType: 'json',
      success: function(data){
        toastr.success(data_save_ok);
        location.reload(true);  
        $('#moda_comment_content').removeClass('open');     
        $('.spinner').fadeOut('slow');
      }
    });
  }); 

  $(window).resize(function(){  
    /*if ($(window).width() < 600) {
      $('.mobile-hidden').each(function(){
        $(this).attr('aria-data-view',false);
      });
    }
    else{
      $('.mobile-hidden').each(function(){
        $(this).attr('aria-data-view',true);
      });
    }*/
  });
});

function editDataBaseDoc(btn){
  var line = $(btn);
  $('#id_doc_edit').val(line.attr('data-idDoc'));
  $('#inputTitleDoc_edit').val(line.attr('data-title'));
  $('#type_doc_edit').val(line.attr('data-type'));

  if (line.attr('data-type') == 0) {
    $('#divLink').fadeIn('slow');
    $('#divDoc').fadeOut('slow');
    $('#inputLink_edit').val(line.attr('data-content'));
  }
  else{
    $('#divLink').fadeOut('slow');
    $('#divDoc').fadeIn('slow');
    //console.log(line.attr('data-content'));
    //$('#inputFileDoc_edit').val(line.attr('data-content'));
  }

  $('#repertory_edit').val(line.attr('data-rep'));
  $('#textareaCommentDoc_edit').val(line.attr('data-comment'));
  $('#modal_edit_links_or_doc').addClass('open');
}

function deletedoc(link) {
  $('#id_content_doc').val($(link).attr('data-idDoc'));
  $('#modal_confirm_delete_content_database').addClass('open');
}

function addDocToFav(btn){
  $('#document_id').val($(btn).attr('data-id'));
  $('#document_name').val($(btn).attr('data-title'));
  $('#document_type').val($(btn).attr('data-typedoc'));
  $('#document_module').val($(btn).attr('data-rep'));
  $('#modal_classification_favoris').addClass('open');
}

function addDocToHistorikCourse(btn){
  $('#document_id_c').val($(btn).attr('data-id'));
  $('#modal_add_content_database_historik_course').addClass('open');
  return false;
}

function viewCommentContent(lib){
  var btn = $(lib);
  var idNewSeq = btn.attr('data-id');
  var comment  = btn.attr('data-comment');
  console.log('idNewSeq : ' + idNewSeq);
  console.log('comment : ' + comment);
  $('#id_new_content').val(idNewSeq);
  $('#comment_content').val(comment);
  $('#moda_comment_content').addClass('open');
}


const tabButtonsDocument = tabsDocument != null ? tabsDocument.querySelectorAll('[role="tabNav"]') : null;
const tabPanelsDocument = tabsDocument != null ? tabsDocument.querySelectorAll('[role="tabPanel"]') : null;
  
if(tabsDocument != null){
  tabButtonsDocument.forEach(button => button.addEventListener('click', tabClick));
}

if(dropDownMenu != null){
  dropDownButton.forEach(button => button.addEventListener('click', dropDownClick));
}

function tabClick(event) {    
  tabPanelsDocument.forEach(panel => {
    panel.setAttribute('aria-current', false)
  });    
  tabButtonsDocument.forEach(tab => {
    tab.setAttribute('aria-selected', false);
    tab.setAttribute('aria-loop', false);
  });
  event.currentTarget.setAttribute('aria-selected', true);
  const  id  = event.currentTarget.getAttribute('data-id');
  const panel = document.getElementById(id);    
  panel.setAttribute('aria-current', true);
  panel.setAttribute('aria-loop', true);
  $("html, body").animate({ scrollTop: 0 }, "slow");
}

function dropDownClick(event) {    
  dropDownMenu.forEach(menu => {
    menu.setAttribute('aria-current', false)
  });
  const  id  = event.currentTarget.getAttribute('data-id');

  const panel = document.getElementById(id);
  
  panel.setAttribute('aria-current', true);
}


