<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Societe_model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->table         = 'list_societe';
        $this->table_members = 'membres';
        $this->load->model('utilities_model');        
    }

    public function read($ids='') {
        $ret = array();
        $i = 0 ;
        if ( $ids == '' ) {
            $this->db->select('description,id_societe,ville,adresse,adresse_facturation,codetiers,id_access');
            $this->db->from($this->table);
            $this->db->where('id_societe >', 0);
            $this->db->order_by('description', 'asc');
            $query = $this->db->get(); 
            $ret['cnt'] = $query->num_rows();
            $result = $query->result()  ;
            
            foreach ($result as $res){
                $ret[$i]['name']    = $res->description ;
                $ret[$i]['id']      = $res->id_societe ;
                $ret[$i]['ville']   = $res->ville ;
                $ret[$i]['adresse'] = $res->adresse ;
                $ret[$i]['adresse_facturation'] = $res->adresse_facturation ;
                $ret[$i]['codetiers']   = $res->codetiers ;
                $ret[$i]['id_access']   = $res->id_access ;
                $i++ ;
            }
        } 
        else {            
            $this->db->select('description,id_societe,ville,adresse,adresse_facturation,codetiers,id_access');
            $this->db->from($this->table);
            $this->db->where('id_societe ',$ids);
            $query = $this->db->get(); 
            $result = $query->result()  ;
            foreach ($result as $res){
                $ret[$i]['name']    = $res->description ;
                $ret[$i]['id']      = $res->id_societe ;
                $ret[$i]['ville']   = $res->ville ;
                $ret[$i]['adresse'] = $res->adresse ;
                $ret[$i]['adresse_facturation'] = $res->adresse_facturation ;
                $ret[$i]['codetiers']   = $res->codetiers ;
                $ret[$i]['id_access']   = $res->id_access ;
            }
        }
        return($ret);
    }
    public function readByAdmin($key,$page,$segment) {
        $ret = array();
        $i = 0 ;
        $this->db->select('description,id_societe,ville,adresse,adresse_facturation,CodeTiers,id_access');
        $this->db->from($this->table);
        $this->db->where('id_societe >', 0);
        if(!empty($key)) {
            $likeCriteria = "ville LIKE '%".$key."%'";
            $this->db->where($likeCriteria);
        }
        $this->db->order_by('description', 'asc');
        $this->db->limit($page, $segment); 
        $query = $this->db->get(); 
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;
        
        foreach ($result as $res){
            $ret[$i]['name']    = $res->description ;
            $ret[$i]['id']      = $res->id_societe ;
            $ret[$i]['ville']   = $res->ville ;
            $ret[$i]['adresse'] = $res->adresse ;
            $ret[$i]['adresse_facturation'] = $res->adresse_facturation ;
            $ret[$i]['codetiers']   = $res->CodeTiers ;
            $ret[$i]['id_societe']  = $res->id_societe ;
            $ret[$i]['id_access']   = $res->id_access ;
            $i++ ;
        }
        
        return($ret);
    }
    public function readCountByAdmin($key) {
        $ret = array();
        $i = 0 ;          
        $this->db->select('s.*');
        $this->db->from($this->table.' as s');
        $this->db->join($this->table_members.' as m', 's.id_societe=m.id_societe','inner');
        $this->db->where('s.id_societe >', 0);
        if(!empty($key)) {
            $likeCriteria = "s.ville LIKE '%".$key."%'";
            $this->db->where($likeCriteria);
        }
        $this->db->order_by('description', 'asc');
        $query = $this->db->get(); 
        $result = $query->result()  ;
    
        return(count($result));
    }
    public function getAll() {        
        $this->db->select('*');
        $this->db->from($this->table);
        $query = $this->db->get(); 
        return $query->result();
    }

    function GetSociete($idM) { 
        $ret = "";
        $this->db->select('s.description,s.ville');
        $this->db->from($this->table.' as s');
        $this->db->join($this->table_members.' as m', 's.id_societe=m.id_societe','left');
        $this->db->where('m.id ',$idM);
        $query = $this->db->get(); 
        $result = $query->result()  ;
        foreach ($result as $res){
            if ($res->ville != "") {
                $ret .= $res->description." (".$res->ville.")";
            }
            else{
                $ret .= $res->description;
            }            
        }
        return($ret);
    }

    public function Request($field,$id_societe) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id_societe', $id_societe);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }  

    public function RequestByCodeTiersAndName($field,$codetiers,$description) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('codetiers', $codetiers);
        $this->db->where('description', $description);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    } 

    public function add($data) {     
        $this->db->trans_start();
        $this->db->insert($this->table, $data);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $id;
    }

    public function update($id_societe,$data) {
        $this->db->where('id_societe', $id_societe);
        $this->db->update($this->table, $data);
        $this->db->affected_rows();
    }
     
}

?>
