<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class ExpressionRecording_model extends CI_Model
{
    
    public function __construct(){        
        parent::__construct();
        $this->table      = 'expression_recording';   
        $this->table_cat  = 'category_expression';     
        $this->table_lang = 'langage_list';     
    }    

    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }

    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function add($arrayData){
        $this->db->trans_start();
        $this->db->insert($this->table, $arrayData);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function getAll() {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getAllByGroup($id_groupe) {
        $this->db->select('e.id AS expressionId, e.name_audio AS audioName, e.transcription_langage AS langageTranscription, e.transcription AS transcription, e.translation, e.translate_langage AS languageTranslation, c.intitule AS categoryExpression, e.user_create, e.timer, e.id_groupe');
        $this->db->from($this->table.' AS e');
        $this->db->join($this->table_cat.' AS c', 'e.id_category = c.id', 'LEFT');
        $this->db->where('e.id_groupe', $id_groupe);
        $this->db->order_by('e.id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getAllNotInCat($id_groupe){
        $this->db->select("id AS expressionId, name_audio AS audioName, transcription_langage AS langageTranscription, transcription AS transcription, translation, translate_langage AS languageTranslation, user_create, timer, id_groupe");
        $this->db->from($this->table);
        $this->db->where("id_groupe",$id_groupe);
        $this->db->where("id_category",NULL); 
        return $this->db->get();
    }

    public function getAllByGroupNotInCategory($id_groupe) {
        $this->db->select('e.id AS expressionId, e.name_audio AS audioName, e.transcription_langage AS langageTranscription, e.transcription AS transcription, e.translation, e.translate_langage AS languageTranslation, c.intitule AS categoryExpression, e.user_create, e.timer, e.id_groupe');
        $this->db->from($this->table.' AS e');
        $this->db->join($this->table_cat.' AS c', 'e.id_category = c.id', 'LEFT');
        $this->db->where('e.id_groupe', $id_groupe);
        $this->db->where_in('e.id_category', array(NULL,0));
        $this->db->order_by('e.id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getByCat($id_category) {
        $this->db->select('e.id AS expressionId, e.name_audio AS audioName, e.transcription_langage AS langageTranscription, e.transcription AS transcription, e.translation, e.translate_langage AS languageTranslation, c.intitule AS categoryExpression, e.user_create, e.timer, e.id_groupe');
        $this->db->from($this->table.' AS e');
        $this->db->join($this->table_cat.' AS c', 'e.id_category = c.id', 'LEFT');
        $this->db->where('e.id_category', $id_category);
        $this->db->order_by('e.id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function Request($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function getMaxId() {
        $this->db->select('MAX(id) AS idMax');
        $this->db->from($this->table);
        $query = $this->db->get();
        $result = $query->result();
        return $result[0]->idMax;
    }
    
}

?>
