
<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Bno_model extends CI_Model
{
    
    public function __construct(){        
        parent::__construct();
        $this->load->model('membres_model');
        $this->load->model('utilities_model');
        $this->table = 'bno'; 
        global $trad_Menu_BNO;       
    }
    

    public function Lire($id_membre, $id_groupe, $type_outil) {
        $ret  = array();
        $this->db->select("contenu,date_maj,id_membre");
        $this->db->from($this->table);
        $this->db->where('id_membre', $id_membre);
        $this->db->where('id_groupe', $id_groupe);
        $this->db->where('type_outil', $type_outil);
        $query = $this->db->get();
        $result =  $query->result();

        $ret['id_membre']   = $id_membre    ;
        $ret['id_groupe']   = $id_groupe    ;
        $ret['type_outil']  = $type_outil   ;

        if (is_array($result)) {
           foreach ($result as $res) {
                $ret['contenu']  = $res->contenu;
                $ret['date_maj'] = $res->date_maj;
            }
        }
        return($ret);

    }



    public function Replace($type_outil, $id_membre, $id_groupe, $contenu) {
        $nv_contenu = $this->SecuriseHTML($contenu);
        $msg_replace="";
        $dateTwo = new DateTime();
        $date   = $dateTwo->format('Y-m-d H:i:s');;

        $this->db->select("*");
        $this->db->from($this->table);
        $this->db->where('id_membre', $id_membre);
        $this->db->where('id_groupe', $id_groupe);
        $this->db->where('type_outil', $type_outil);
        $query = $this->db->get();
        $count = $query->num_rows();
        if ($count >= 1) {
            $data = array(
            'type_outil' => $type_outil,
            'id_membre'  => $id_membre,
            'id_groupe'  => $id_groupe,
            'date_maj'   => $date,
            'contenu'    => $nv_contenu
            );

            $this->db->where('id_groupe', $id_groupe);
            $this->db->where('id_membre', $id_membre);
            $this->db->update($this->table, $data);
            $query = $this->db->affected_rows();

        }
        else{
            $datainsert = array(
            'type_outil' => $type_outil,
            'id_membre'  => $id_membre,
            'id_groupe'  => $id_groupe,
            'date_maj'   => $date,
            'contenu'    => $nv_contenu
            );

            $this->db->trans_start();
            $this->db->insert($this->table, $datainsert);        
            $this->db->insert_id();        
            $this->db->trans_complete();
            $query = 1;
        }

        if ($query) {
            $msg_replace .= 'Replace_OK';
        }
        else {
            $msg_replace .= 'Replace_PB';
        }
        return($msg_replace);

    }

    public function SecuriseHTML($contenu) {
        $contenu = str_replace("<?", "< ?", $contenu);
        $contenu = str_replace("?>", "? >", $contenu);
        $contenu = str_replace("<SCRIPT", "< SCRIPT", $contenu);
        $contenu = str_replace("/SCRIPT", "< / SCRIPT", $contenu);
        $contenu = str_replace("?", "< ?", $contenu);
        $contenu = str_replace("?>", "? >", $contenu);
        $contenu = str_replace("<script", "< script", $contenu);
        $contenu = str_replace("/script", "< / script", $contenu);
        $contenu = addslashes($contenu);
        $nv_contenu = $contenu;
        return($nv_contenu);
    }

    public function HeaderBNOTuteur($menu,$id_groupe,$type_outil,$id_modif) {

        $ret = '';
        $url = HTTP_BNO.'?index.php&type_outil='.$type_outil.'&groupe='.$id_groupe.'&menu=' ;
        $text = array(1=>array(1=>'BN_Stag',2=>'BN_Gl'),2=>array(1=>'O_Stag',2=>'O_Gl'));
        $menu2_ = array(1=>array('url'=>$url.'1','val'=>"Individual training programs"),
                      2=>array('url'=>$url.'2','val'=>"Professional objectives"));
        $ret .= "<section class='content-header'>";
            $ret .= "<div class='row'>";
                $ret .= "<div class='col-xs-12'>";
                    $col1 = $menu==1?$this->script->LienClick($menu2_[1]):$this->script->LienNormal($menu2_[1]);
                    $col2 = $menu==2?$this->script->LienClick($menu2_[2]):$this->script->LienNormal($menu2_[2]);
                    //$ret .="<tr><td>".$col1."</td><td>".$col2."</td></tr>";
                    $ret .="<h4 class='action-menu-nl home-bno-h4'>";
                        $ret .= '<span class="link-all-users"><i class="fa fa-users" aria-hidden="true"></i>'.$col1.'</span>';
                        $ret .= '<span class="link-all-users"><i class="fa fa-user" aria-hidden="true"></i>'.$col2
                        .'</span>';
                    $ret .="</h4>";
                    if ($menu==1 ) {
                        if ($this->session->userdata ('GUSERTYPE') != TUTEUR) {
                            $ret .="Trainee";
                        }

                        $params = "type_outil=".$type_outil."&menu=".$menu ;
                        $params.= "&connexion=".$this->session->userdata ('CNX')."&groupe=".$id_groupe;
                        $url   = HTTP_BNO."index.php?".$params."&id_modif=" ;

                        if ($this->session->userdata ('GUSERTYPE') != TUTEUR) {
                            $app = $this->TableUtilisateur($id_groupe);
                            $ret .='<select class="form formAutoStafiaire form-control" name="select" size="1" onchange="parent.parent.window.location.href=this.options[this.selectedIndex].value;">';
                            for($i=0;$i<count($app);$i++) {
                              $app[$i]['selected'] = (isset($id_modif) && $id_modif==$app[$i]['id']?1:0) ;
                              $app[$i]['id'] = $url.$app[$i]['id'] ;
                              $ret .="<option value='".$app[$i]['id']."'>".$app[$i]['name']."</option>";
                            }
                            $ret .='</select>';
                        }
                        $ret .= "";
                    }
                $ret .= "</div>";
            $ret .= "</div>";
        $ret .= "</section>";
        return ($ret);
    }

    public function TableUtilisateur($id_groupe) {      
        $i = 0 ;
        $ret  = array();
        $this->db->select("m.prenom,m.nom,m.id, m.date_connexion");
        $this->db->from("membres as m");
        $this->db->join('groupe as g', 'm.id=g.id_membres','left');
        $this->db->where('m.type', 0);
        $this->db->where('g.id_groupe', $id_groupe);
        $query = $this->db->get();
        $result =  $query->result();
        if (is_array($result)) {
           foreach ($result as $res) {
                $ret[$i]['id'] = $res->id;
                $ret[$i]['name']= $res->prenom." ".$res->nom;
                $i++ ;
            }
        }
        return($ret);


    }

    public function add($data){
        $this->db->trans_start();
        $this->db->insert($this->table, $data);       
        $id = $this->db->insert_id(); 
        $this->db->trans_complete();
        return $id;
    }
     public function addPr($sql){
        if ($this->db->simple_query($sql)) {
            return 'success';
        }
        else{
            $ret['error'] = $this->db->error();
            $ret['query'] = $this->db->last_query();
            return $ret;        
        }
    }

    public function AfficheBNO($idgroupe,$guserid,$type) {
        $codeHTML = '' ;
        $BNO_general = Array();
        $BNO_stagiaire = Array();
        $BNO_general = $this->Lire(0, $idgroupe, $type) ;
        $BNO_stagiaire = $this->Lire($guserid, $idgroupe, $type) ;
        $codeHTML.= $this->VoirBnoTrainee($BNO_general,$type);
        $codeHTML.= $this->VoirBnoTrainee($BNO_stagiaire,$type);
        return($codeHTML);
    }
   

    public function VoirBnoTrainee($val,$type) {

        $ret = '';
        $affiche = "";
        $id_membre = isset($val['id_membre'])?$val['id_membre']:'';
        $contenu   = isset($val['contenu'])?$val['contenu']:''  ;
        $type_outil = isset($val['type_outil'])?$val['type_outil']:''   ;      
    
        switch ($type) {
            case 1 : 
                $nom_outil = ($id_membre==0?$this->lang->line('trainee_obectif_general_notpad'):$this->lang->line('trainee_obectif_notepad')) ;
                break;
            case 2 : 
                $nom_outil = ($id_membre==0?$this->lang->line('trainee_obectif_professional'):$this->lang->line('trainee_obectif_individual')) ; 
                break;
        }

        $nv_contenu = $this->SecuriseHTML($contenu)    ;
        $nv_contenu = stripslashes($nv_contenu) ;

        $image = $id_membre==0?"<i class='fa fa-users'></i>":"<i class='fa fa-user'></i>";
        $ret.= $this->SubTitle($image.' '.$nom_outil)  ;
        if (isset($val['date_maj'])) {
            $date_maj   = isset($val['date_maj'])?$val['date_maj']:''   ;
            $date_exp0 = explode(" ", $date_maj);
            $date_exp1 = explode("-", $date_exp0[0]);
            if ($date_exp1[2].'/'.$date_exp1[1].'/'.$date_exp1[0]=="00/00/0000") {
                $affiche .= "";
            }
            else{
                $affiche .= $date_exp1[2].'/'.$date_exp1[1].'/'.$date_exp1[0];
            }  
        }
        
        $ret.= '<div class="box box-bno">';  
            $ret.= '<div class="row">';  
                $ret.= '<div class="col-xs-12">'; 
                    $ret .= "<table class='table'>";
                        $ret .= "<thead><tr><td class=''><span class='bno_title'>".$nom_outil.'</span>&nbsp;&nbsp;<i class="fa fa-calendar fa-calender-bno" aria-hidden="true"></i>&nbsp;<span class="bno_title_date">'.$affiche."</span></td></tr></thead>";
                        $ret .= "<tbody><tr><td class='btn-content'>".nl2br(utf8_encode($nv_contenu))."</td></tr></tbody>";
                    $ret .= "</table>";
                $ret.= '</div>'; 
            $ret.= '</div>'; 
        $ret.= '</div>'; 


        return $ret;
    }

    public function SubTitle($title, $width="230" ) {
        $ret = '';
         if ( true ) {
            $ret.= '<p align="left"><span class="link-all-users">'.$title.'</span></p>'."\n";
         }
        return $ret;
    }

    public function VoirBNO($val) {

        $ret = '';
        $affiche = "";
        //var_dump($val);
        $id_membre = isset($val['id_membre'])?$val['id_membre']:'';
        $contenu   = isset($val['contenu'])?$val['contenu']:''  ;
        $type_outil = isset($val['type_outil'])?$val['type_outil']:''   ;
        $date_maj   = isset($val['date_maj'])?$val['date_maj']:''   ;
        $date_exp0 = explode(" ", $date_maj);
        $date_exp1 = explode("-", $date_exp0[0]);
    
        //echo "outil : ".$_GET['type_outil'];
        switch ($_GET['type_outil']) {
            case 1 : 
                $nom_outil = ($id_membre==0?$this->lang->line('trainee_obectif_general_notpad'):$this->lang->line('trainee_obectif_notepad')) ;
                break;
            case 2 : 
                $nom_outil = ($id_membre==0?$this->lang->line('trainee_obectif_professional'):$this->lang->line('trainee_obectif_individual')) ; 
                break;
        }

        $nv_contenu = $this->bno_model->SecuriseHTML($contenu)    ;
        $nv_contenu = stripslashes($nv_contenu) ;

        $ret.= "<br>";
        //$image = $id_membre==0?IMG_GROUPE:IMG_BNO;
        $image = $id_membre==0?"<span class='fa fa-group'></span>":"<span class='fa fa-exclamation'></span>";
        $ret.= $this->SubTitle($image.' '.$nom_outil)  ;
        if ($date_exp1[2].'/'.$date_exp1[1].'/'.$date_exp1[0]=="00/00/0000") {
            $affiche .= "";
        }
        else{
            $affiche .= '('.$date_exp1[2].'/'.$date_exp1[1].'/'.$date_exp1[0].')';
        }  

        $ret .= "<table class='table'>";
        $ret .= "<thead><tr><td class='bno_title'>".$nom_outil.'&nbsp;&nbsp;'.$affiche."</td></tr></thead>";
        $ret .= "<tbody><tr><td>".nl2br(utf8_encode($nv_contenu))."</td></tr></tbody>";
        $ret .= "</table>";


        return $ret;
    }
    
     
}

?>
