<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Bddl_model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->db_newsletter = $this->load->database("newsletter",TRUE);
        $this->table_prototype_access              = 'prototype_access';         
        $this->table_vocabulaire                   = 'vocabulaire';         
        $this->table_vocabulaire_prototype_access  = 'vocabulaire_prototype_access';         
        $this->table_vocabulaire_theme             = 'vocabulaire_theme';         
        $this->table_theme                         = 'theme';                 
        $this->table_lexique                       = 'lexique';                 
        $this->table_vocabulaire_societe           = 'vocabulaire_societe';                 
        $this->table_societe                       = 'societe';                           
        $this->table_prototype_stagiaire           = 'prototype_stagiaire';                 
        $this->table_stagiaire                     = 'stagiaire';                 
    }

    public function getDataByStagiaireElAndPrototype($idStagiaireEl,$idPrototype){
        $ret = array();
        $this->db_newsletter->select('ps.id AS idPrototypePrototypeStagiaire');
        $this->db_newsletter->from($this->table_prototype_stagiaire.' as ps');
        $this->db_newsletter->join($this->table_stagiaire.' as s', 'ps.stagiaire = s.id','inner');
        $this->db_newsletter->where('ps.prototype', $idPrototype);
        $this->db_newsletter->where('s.id_stagiaire', $idStagiaireEl);
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;       
        foreach ($result as $res) {
            $ret['idPrototypePrototypeStagiaire']           = $res->idPrototypePrototypeStagiaire;
        }
        return $ret;
    }

    public function getAllPrototypeAcess() {
        $ret = array();
        $this->db_newsletter->select('*');
        $this->db_newsletter->from($this->table_prototype_access);
        $query = $this->db_newsletter->get(); 
        $result = $query->result()  ;        
        foreach ($result as $res) {
            $ret[] = array("id" => $res->id_prototype_access, "name" => utf8_decode($res->type));
        }
        return $ret;
    }
    public function getVocabPrototypeListByArrayPrototype($arrayPrototype) {
        $this->db_newsletter->select('pa.*, COUNT(vpa.id_prototype_access) AS nb_vocab');
        $this->db_newsletter->from($this->table_vocabulaire_prototype_access.' as vpa');
        $this->db_newsletter->join($this->table_prototype_access.' as pa', 'pa.id_prototype_access = vpa.id_prototype_access','inner');
        $this->db_newsletter->where_in('pa.id_prototype_access', $arrayPrototype);
        $this->db_newsletter->group_by('pa.id_prototype_access');
        $query = $this->db_newsletter->get(); 
        return $query->result()  ;  
    }
    public function getAllVocabByArrayPrototype($arrayPrototype,$key,$idPrototypeAccess=NULL) {
        $this->db_newsletter->select('v.langue_origine, v.langue_traduction, v.id_vocabulaire,v.date_creation');
        $this->db_newsletter->from($this->table_vocabulaire.' as v');
        $this->db_newsletter->join($this->table_vocabulaire_prototype_access.' as vp', 'v.id_vocabulaire = vp.id_vocabulaire','inner');
        if($idPrototypeAccess != NULL){
            $this->db_newsletter->where('vp.id_prototype_access', $idPrototypeAccess);
        }
        else{
            $this->db_newsletter->where_in('vp.id_prototype_access', $arrayPrototype);
        }
        if(!empty($key)) {
            if($key == 'anglais') {
                $likeCriteria = "(v.`langue_traduction` LIKE '%".$key."%')";
            } 
            elseif ($key == 'francais') {
                $likeCriteria = "(v.`langue_origine` LIKE '%".$key."%')";
            }
            else{
                $likeCriteria = "(v.`langue_origine` LIKE '%".$key."%' OR v.langue_traduction LIKE '%" .$key. "%')";
            }
            $this->db_newsletter->where($likeCriteria);
        }
        $query = $this->db_newsletter->get(); 
        if ($query) {
            return $query->result()  ;  
        }
    }
    public function getThemesByIdVocab($idVocabulaire) {
        $this->db_newsletter->select('t.libelle_theme');
        $this->db_newsletter->from($this->table_theme.' as t');
        $this->db_newsletter->join($this->table_vocabulaire_theme.' as vt', 'vt.id_theme = t.id_theme','inner');
        $this->db_newsletter->where('vt.id_vocabulaire', $idVocabulaire);
        $query = $this->db_newsletter->get(); 
        foreach ($query->result() as $t) {
            return $t->libelle_theme;
        }
    }
    public function getVocabPrototypeByPrototypeAccess($idPrototypeAccess,$key) {
        $ret = array();
        $this->db_newsletter->select('v.`langue_origine`, v.`langue_traduction`, theme.`libelle_theme`');
        $this->db_newsletter->from($this->table_vocabulaire.' as v');
        $this->db_newsletter->join($this->table_vocabulaire_prototype_access.' as vp', 'v.`id_vocabulaire` = vp.`id_vocabulaire`','inner');
        $this->db_newsletter->join($this->table_vocabulaire_theme.' as vt', 'vt.`id_vocabulaire` = v.`id_vocabulaire`','inner');
        $this->db_newsletter->join($this->table_theme.' as theme', 'theme.`id_theme` = vt.`id_theme`','inner');
        $this->db_newsletter->where('vp.`id_prototype_access`', $idPrototypeAccess);
        if(!empty($key)) {
            if($key == 'anglais') {
                $likeCriteria = "(v.`langue_traduction` LIKE '%".$key."%')";
            } 
            elseif ($key == 'francais') {
                $likeCriteria = "(v.`langue_origine` LIKE '%".$key."%')";
            }
            else{
                $likeCriteria = "(v.`langue_origine` LIKE '%".$key."%' OR v.langue_traduction LIKE '%" .$key. "%')";
            }
            $this->db_newsletter->where($likeCriteria);
        }
        $query = $this->db_newsletter->get(); 
        return $query->result()  ;  
    }
    public function getVocabPrototypeByArrayPrototypeAccess($ArrayPrototypeAccess,$key) {
        $ret = array();
        $this->db_newsletter->select('v.`langue_origine`, v.`langue_traduction`, theme.`libelle_theme`');
        $this->db_newsletter->from($this->table_vocabulaire.' as v');
        $this->db_newsletter->join($this->table_vocabulaire_prototype_access.' as vp', 'v.`id_vocabulaire` = vp.`id_vocabulaire`','inner');
        $this->db_newsletter->join($this->table_vocabulaire_theme.' as vt', 'vt.`id_vocabulaire` = v.`id_vocabulaire`','inner');
        $this->db_newsletter->join($this->table_theme.' as theme', 'theme.`id_theme` = vt.`id_theme`','inner');
        $this->db_newsletter->where_in('vp.`id_prototype_access`', $ArrayPrototypeAccess);
        if(!empty($key)) {
            if($key == 'anglais') {
                $likeCriteria = "(v.`langue_traduction` LIKE '%".$key."%')";
            } 
            elseif ($key == 'francais') {
                $likeCriteria = "(v.`langue_origine` LIKE '%".$key."%')";
            }
            else{
                $likeCriteria = "(v.`langue_origine` LIKE '%".$key."%' OR v.langue_traduction LIKE '%" .$key. "%')";
            }
            $this->db_newsletter->where($likeCriteria);
        }
        $query = $this->db_newsletter->get(); 
        return $query->result()  ;  
    }

    public function getLeByIdPrototypeAccess($idPrototypeAccess){
        $this->db_newsletter->select('le.id_lexique AS id_lexique, le.rang, le.id_theme, le.id_prototype_access, le.id_societe');
        $this->db_newsletter->from($this->table_lexique.' as le');
        $this->db_newsletter->join($this->table_prototype_access.' as p', 'le.id_prototype_access = p.id_prototype_access','inner');
        $this->db_newsletter->where_in('p.id_prototype_access', $idPrototypeAccess);
        $query = $this->db_newsletter->get(); 
        return $query->result()  ; 
    }
    public function getLeGenericByIdPrototypeAccess($idPrototypeAccess){
        $this->db_newsletter->select('le.id_lexique AS id_lexique, le.rang, le.id_theme, le.id_prototype_access, le.id_societe');
        $this->db_newsletter->from($this->table_lexique.' as le');
        $this->db_newsletter->join($this->table_prototype_access.' as p', 'le.id_prototype_access = p.id_prototype_access','inner');
        $this->db_newsletter->where_in('p.id_prototype_access', $idPrototypeAccess);
        $this->db_newsletter->where('le.id_societe', 653);
        $query = $this->db_newsletter->get(); 
        return $query->result()  ; 
    }

    public function getAllVocabularyByIdPrototypeAccess($idPrototypeAccess){
        $this->db_newsletter->select('*');   
        $this->db_newsletter->from($this->table_vocabulaire_prototype_access);   
        $this->db_newsletter->where('id_prototype_access', $idPrototypeAccess);   
        $query = $this->db_newsletter->get(); 
        return $query->result()  ; 
    }

    public function getAllVocabByIdPrototypeAccessAndIdLexiqueAndIdTheme($idTheme,$idPrototypeAccess,$idSociete) {
        $this->db_newsletter->distinct('v0.`langue_origine`, v0.`langue_traduction`, t1.`libelle_theme`');
        $this->db_newsletter->from($this->table_vocabulaire.' as v0');
        $this->db_newsletter->join($this->table_vocabulaire_societe.' as v2', 'v0.id_vocabulaire = v2.id_vocabulaire','inner');    
        $this->db_newsletter->join($this->table_vocabulaire_prototype_access.' as v3', 'v0.id_vocabulaire = v3.id_vocabulaire','inner');    
        $this->db_newsletter->join($this->table_societe.' as s4', 'v2.id_societe = s4.id_societe','inner');    
        $this->db_newsletter->join($this->table_vocabulaire_theme.' as v5', 'v0.id_vocabulaire = v5.id_vocabulaire','inner');    
        $this->db_newsletter->join($this->table_theme.' as t1', 'v5.id_theme = t1.id_theme','inner');    
        $this->db_newsletter->join($this->table_prototype_access.' as p6', 'v3.id_prototype_access = p6.id_prototype_access','inner');    
        $this->db_newsletter->where('t1.id_theme', $idTheme);    
        $this->db_newsletter->where('p6.id_prototype_access', $idPrototypeAccess);    
        $this->db_newsletter->where('s4.id_societe', $idSociete);    
        $query = $this->db_newsletter->get(); 
        return $query->result()  ;  
    }

    public function RequestPrototypeAccess($field,$idPrototypeAccess){
        $this->db_newsletter->select($field);
        $this->db_newsletter->from($this->table_prototype_access);
        $this->db_newsletter->where('id_prototype_access', $idPrototypeAccess);
        $query = $this->db_newsletter->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function RequestTheme($field,$idTheme){
        $this->db_newsletter->select($field);
        $this->db_newsletter->from($this->table_theme);
        $this->db_newsletter->where('id_theme', $idTheme);
        $query = $this->db_newsletter->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

}

?>
