<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataplex/v1/service.proto

namespace Google\Cloud\Dataplex\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Create lake request.
 *
 * Generated from protobuf message <code>google.cloud.dataplex.v1.CreateLakeRequest</code>
 */
class CreateLakeRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the lake location, of the form:
     * projects/{project_number}/locations/{location_id}
     * where `location_id` refers to a GCP region.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Required. Lake identifier.
     * This ID will be used to generate names such as database and dataset names
     * when publishing metadata to Hive Metastore and BigQuery.
     * * Must contain only lowercase letters, numbers and hyphens.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     * * Must be between 1-63 characters.
     * * Must be unique within the customer project / location.
     *
     * Generated from protobuf field <code>string lake_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $lake_id = '';
    /**
     * Required. Lake resource
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Lake lake = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $lake = null;
    /**
     * Optional. Only validate the request, but do not perform mutations.
     * The default is false.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $validate_only = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The resource name of the lake location, of the form:
     *           projects/{project_number}/locations/{location_id}
     *           where `location_id` refers to a GCP region.
     *     @type string $lake_id
     *           Required. Lake identifier.
     *           This ID will be used to generate names such as database and dataset names
     *           when publishing metadata to Hive Metastore and BigQuery.
     *           * Must contain only lowercase letters, numbers and hyphens.
     *           * Must start with a letter.
     *           * Must end with a number or a letter.
     *           * Must be between 1-63 characters.
     *           * Must be unique within the customer project / location.
     *     @type \Google\Cloud\Dataplex\V1\Lake $lake
     *           Required. Lake resource
     *     @type bool $validate_only
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataplex\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the lake location, of the form:
     * projects/{project_number}/locations/{location_id}
     * where `location_id` refers to a GCP region.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The resource name of the lake location, of the form:
     * projects/{project_number}/locations/{location_id}
     * where `location_id` refers to a GCP region.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. Lake identifier.
     * This ID will be used to generate names such as database and dataset names
     * when publishing metadata to Hive Metastore and BigQuery.
     * * Must contain only lowercase letters, numbers and hyphens.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     * * Must be between 1-63 characters.
     * * Must be unique within the customer project / location.
     *
     * Generated from protobuf field <code>string lake_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getLakeId()
    {
        return $this->lake_id;
    }

    /**
     * Required. Lake identifier.
     * This ID will be used to generate names such as database and dataset names
     * when publishing metadata to Hive Metastore and BigQuery.
     * * Must contain only lowercase letters, numbers and hyphens.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     * * Must be between 1-63 characters.
     * * Must be unique within the customer project / location.
     *
     * Generated from protobuf field <code>string lake_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setLakeId($var)
    {
        GPBUtil::checkString($var, True);
        $this->lake_id = $var;

        return $this;
    }

    /**
     * Required. Lake resource
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Lake lake = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Dataplex\V1\Lake|null
     */
    public function getLake()
    {
        return $this->lake;
    }

    public function hasLake()
    {
        return isset($this->lake);
    }

    public function clearLake()
    {
        unset($this->lake);
    }

    /**
     * Required. Lake resource
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Lake lake = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Dataplex\V1\Lake $var
     * @return $this
     */
    public function setLake($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\Lake::class);
        $this->lake = $var;

        return $this;
    }

    /**
     * Optional. Only validate the request, but do not perform mutations.
     * The default is false.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getValidateOnly()
    {
        return $this->validate_only;
    }

    /**
     * Optional. Only validate the request, but do not perform mutations.
     * The default is false.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setValidateOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->validate_only = $var;

        return $this;
    }

}

