<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/datacatalog/v1/usage.proto

namespace Google\Cloud\DataCatalog\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Detailed statistics on the entry's usage.
 * Usage statistics have the following limitations:
 * - Only BigQuery tables have them.
 * - They only include BigQuery query jobs.
 * - They might be underestimated because wildcard table references
 *   are not yet counted. For more information, see
 *   [Querying multiple tables using a wildcard table]
 *   (https://cloud.google.com/bigquery/docs/querying-wildcard-tables)
 *
 * Generated from protobuf message <code>google.cloud.datacatalog.v1.UsageStats</code>
 */
class UsageStats extends \Google\Protobuf\Internal\Message
{
    /**
     * The number of successful uses of the underlying entry.
     *
     * Generated from protobuf field <code>float total_completions = 1;</code>
     */
    private $total_completions = 0.0;
    /**
     * The number of failed attempts to use the underlying entry.
     *
     * Generated from protobuf field <code>float total_failures = 2;</code>
     */
    private $total_failures = 0.0;
    /**
     * The number of cancelled attempts to use the underlying entry.
     *
     * Generated from protobuf field <code>float total_cancellations = 3;</code>
     */
    private $total_cancellations = 0.0;
    /**
     * Total time spent only on successful uses, in milliseconds.
     *
     * Generated from protobuf field <code>float total_execution_time_for_completions_millis = 4;</code>
     */
    private $total_execution_time_for_completions_millis = 0.0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type float $total_completions
     *           The number of successful uses of the underlying entry.
     *     @type float $total_failures
     *           The number of failed attempts to use the underlying entry.
     *     @type float $total_cancellations
     *           The number of cancelled attempts to use the underlying entry.
     *     @type float $total_execution_time_for_completions_millis
     *           Total time spent only on successful uses, in milliseconds.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Datacatalog\V1\Usage::initOnce();
        parent::__construct($data);
    }

    /**
     * The number of successful uses of the underlying entry.
     *
     * Generated from protobuf field <code>float total_completions = 1;</code>
     * @return float
     */
    public function getTotalCompletions()
    {
        return $this->total_completions;
    }

    /**
     * The number of successful uses of the underlying entry.
     *
     * Generated from protobuf field <code>float total_completions = 1;</code>
     * @param float $var
     * @return $this
     */
    public function setTotalCompletions($var)
    {
        GPBUtil::checkFloat($var);
        $this->total_completions = $var;

        return $this;
    }

    /**
     * The number of failed attempts to use the underlying entry.
     *
     * Generated from protobuf field <code>float total_failures = 2;</code>
     * @return float
     */
    public function getTotalFailures()
    {
        return $this->total_failures;
    }

    /**
     * The number of failed attempts to use the underlying entry.
     *
     * Generated from protobuf field <code>float total_failures = 2;</code>
     * @param float $var
     * @return $this
     */
    public function setTotalFailures($var)
    {
        GPBUtil::checkFloat($var);
        $this->total_failures = $var;

        return $this;
    }

    /**
     * The number of cancelled attempts to use the underlying entry.
     *
     * Generated from protobuf field <code>float total_cancellations = 3;</code>
     * @return float
     */
    public function getTotalCancellations()
    {
        return $this->total_cancellations;
    }

    /**
     * The number of cancelled attempts to use the underlying entry.
     *
     * Generated from protobuf field <code>float total_cancellations = 3;</code>
     * @param float $var
     * @return $this
     */
    public function setTotalCancellations($var)
    {
        GPBUtil::checkFloat($var);
        $this->total_cancellations = $var;

        return $this;
    }

    /**
     * Total time spent only on successful uses, in milliseconds.
     *
     * Generated from protobuf field <code>float total_execution_time_for_completions_millis = 4;</code>
     * @return float
     */
    public function getTotalExecutionTimeForCompletionsMillis()
    {
        return $this->total_execution_time_for_completions_millis;
    }

    /**
     * Total time spent only on successful uses, in milliseconds.
     *
     * Generated from protobuf field <code>float total_execution_time_for_completions_millis = 4;</code>
     * @param float $var
     * @return $this
     */
    public function setTotalExecutionTimeForCompletionsMillis($var)
    {
        GPBUtil::checkFloat($var);
        $this->total_execution_time_for_completions_millis = $var;

        return $this;
    }

}

