<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/appengine/v1/domain_mapping.proto

namespace Google\Cloud\AppEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * SSL configuration for a `DomainMapping` resource.
 *
 * Generated from protobuf message <code>google.appengine.v1.SslSettings</code>
 */
class SslSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * ID of the `AuthorizedCertificate` resource configuring SSL for the
     * application. Clearing this field will remove SSL support.
     * By default, a managed certificate is automatically created for every
     * domain mapping. To omit SSL support or to configure SSL manually, specify
     * `SslManagementType.MANUAL` on a `CREATE` or `UPDATE` request. You must
     * be authorized to administer the `AuthorizedCertificate` resource to
     * manually map it to a `DomainMapping` resource.
     * Example: `12345`.
     *
     * Generated from protobuf field <code>string certificate_id = 1;</code>
     */
    private $certificate_id = '';
    /**
     * SSL management type for this domain. If `AUTOMATIC`, a managed certificate
     * is automatically provisioned. If `MANUAL`, `certificate_id` must be
     * manually specified in order to configure SSL for this domain.
     *
     * Generated from protobuf field <code>.google.appengine.v1.SslSettings.SslManagementType ssl_management_type = 3;</code>
     */
    private $ssl_management_type = 0;
    /**
     * ID of the managed `AuthorizedCertificate` resource currently being
     * provisioned, if applicable. Until the new managed certificate has been
     * successfully provisioned, the previous SSL state will be preserved. Once
     * the provisioning process completes, the `certificate_id` field will reflect
     * the new managed certificate and this field will be left empty. To remove
     * SSL support while there is still a pending managed certificate, clear the
     * `certificate_id` field with an `UpdateDomainMappingRequest`.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>string pending_managed_certificate_id = 4;</code>
     */
    private $pending_managed_certificate_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $certificate_id
     *           ID of the `AuthorizedCertificate` resource configuring SSL for the
     *           application. Clearing this field will remove SSL support.
     *           By default, a managed certificate is automatically created for every
     *           domain mapping. To omit SSL support or to configure SSL manually, specify
     *           `SslManagementType.MANUAL` on a `CREATE` or `UPDATE` request. You must
     *           be authorized to administer the `AuthorizedCertificate` resource to
     *           manually map it to a `DomainMapping` resource.
     *           Example: `12345`.
     *     @type int $ssl_management_type
     *           SSL management type for this domain. If `AUTOMATIC`, a managed certificate
     *           is automatically provisioned. If `MANUAL`, `certificate_id` must be
     *           manually specified in order to configure SSL for this domain.
     *     @type string $pending_managed_certificate_id
     *           ID of the managed `AuthorizedCertificate` resource currently being
     *           provisioned, if applicable. Until the new managed certificate has been
     *           successfully provisioned, the previous SSL state will be preserved. Once
     *           the provisioning process completes, the `certificate_id` field will reflect
     *           the new managed certificate and this field will be left empty. To remove
     *           SSL support while there is still a pending managed certificate, clear the
     *           `certificate_id` field with an `UpdateDomainMappingRequest`.
     *           &#64;OutputOnly
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Appengine\V1\DomainMapping::initOnce();
        parent::__construct($data);
    }

    /**
     * ID of the `AuthorizedCertificate` resource configuring SSL for the
     * application. Clearing this field will remove SSL support.
     * By default, a managed certificate is automatically created for every
     * domain mapping. To omit SSL support or to configure SSL manually, specify
     * `SslManagementType.MANUAL` on a `CREATE` or `UPDATE` request. You must
     * be authorized to administer the `AuthorizedCertificate` resource to
     * manually map it to a `DomainMapping` resource.
     * Example: `12345`.
     *
     * Generated from protobuf field <code>string certificate_id = 1;</code>
     * @return string
     */
    public function getCertificateId()
    {
        return $this->certificate_id;
    }

    /**
     * ID of the `AuthorizedCertificate` resource configuring SSL for the
     * application. Clearing this field will remove SSL support.
     * By default, a managed certificate is automatically created for every
     * domain mapping. To omit SSL support or to configure SSL manually, specify
     * `SslManagementType.MANUAL` on a `CREATE` or `UPDATE` request. You must
     * be authorized to administer the `AuthorizedCertificate` resource to
     * manually map it to a `DomainMapping` resource.
     * Example: `12345`.
     *
     * Generated from protobuf field <code>string certificate_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setCertificateId($var)
    {
        GPBUtil::checkString($var, True);
        $this->certificate_id = $var;

        return $this;
    }

    /**
     * SSL management type for this domain. If `AUTOMATIC`, a managed certificate
     * is automatically provisioned. If `MANUAL`, `certificate_id` must be
     * manually specified in order to configure SSL for this domain.
     *
     * Generated from protobuf field <code>.google.appengine.v1.SslSettings.SslManagementType ssl_management_type = 3;</code>
     * @return int
     */
    public function getSslManagementType()
    {
        return $this->ssl_management_type;
    }

    /**
     * SSL management type for this domain. If `AUTOMATIC`, a managed certificate
     * is automatically provisioned. If `MANUAL`, `certificate_id` must be
     * manually specified in order to configure SSL for this domain.
     *
     * Generated from protobuf field <code>.google.appengine.v1.SslSettings.SslManagementType ssl_management_type = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setSslManagementType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AppEngine\V1\SslSettings\SslManagementType::class);
        $this->ssl_management_type = $var;

        return $this;
    }

    /**
     * ID of the managed `AuthorizedCertificate` resource currently being
     * provisioned, if applicable. Until the new managed certificate has been
     * successfully provisioned, the previous SSL state will be preserved. Once
     * the provisioning process completes, the `certificate_id` field will reflect
     * the new managed certificate and this field will be left empty. To remove
     * SSL support while there is still a pending managed certificate, clear the
     * `certificate_id` field with an `UpdateDomainMappingRequest`.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>string pending_managed_certificate_id = 4;</code>
     * @return string
     */
    public function getPendingManagedCertificateId()
    {
        return $this->pending_managed_certificate_id;
    }

    /**
     * ID of the managed `AuthorizedCertificate` resource currently being
     * provisioned, if applicable. Until the new managed certificate has been
     * successfully provisioned, the previous SSL state will be preserved. Once
     * the provisioning process completes, the `certificate_id` field will reflect
     * the new managed certificate and this field will be left empty. To remove
     * SSL support while there is still a pending managed certificate, clear the
     * `certificate_id` field with an `UpdateDomainMappingRequest`.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>string pending_managed_certificate_id = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setPendingManagedCertificateId($var)
    {
        GPBUtil::checkString($var, True);
        $this->pending_managed_certificate_id = $var;

        return $this;
    }

}

