# Info

In this directory you can find the required binaries of [PhantomJS](http://phantomjs.org) v2.1.1.

You can update them by downloading the binaries from [phantomjs.org](http://phantomjs.org/download.html).

We got all the info from the [Wiki](https://github.com/ariya/phantomjs/wiki/Screen-Capture).

# [PhantomJS](http://phantomjs.org) - Scriptable Headless WebKit

PhantomJS ([phantomjs.org](http://phantomjs.org)) is a headless WebKit scriptable with JavaScript.  The latest [stable release](http://phantomjs.org/release-2.0.html) is version 2.0.

**Note**: Please **do not** create a GitHub pull request **without** reading the [Contribution Guide](https://github.com/ariya/phantomjs/blob/master/CONTRIBUTING.md) first. Failure to do so may result in the rejection of the pull request.

## Use Cases

- **Headless web testing**. Lightning-fast testing without the browser is now possible!
- **Page automation**. [Access and manipulate](http://phantomjs.org/page-automation.html) web pages with the standard DOM API, or with usual libraries like jQuery.
- **Screen capture**. Programmatically [capture web contents](http://phantomjs.org/screen-capture.html), including CSS, SVG and Canvas. Build server-side web graphics apps, from a screenshot service to a vector chart rasterizer.
- **Network monitoring**. Automate performance analysis, track [page loading](http://phantomjs.org/network-monitoring.html) and export as standard HAR format.

## Features

- **Multiplatform**, available on major operating systems: Windows, Mac OS X, Linux, and other Unices.
- **Fast and native implementation** of web standards: DOM, CSS, JavaScript, Canvas, and SVG. No emulation!
- **Pure headless (no X11) on Linux**, ideal for continuous integration systems. Also runs on Amazon EC2, Heroku, and Iron.io.
- **Easy to install**: [Download](http://phantomjs.org/download.html), unpack, and start having fun in just 5 minutes.

## Questions?

- Explore the complete [documentation](http://phantomjs.org/documentation/).
- Read tons of [user articles](http://phantomjs.org/buzz.html) on using PhantomJS.
- Join the [mailing-list](http://groups.google.com/group/phantomjs) and discuss with other PhantomJS fans.

PhantomJS is free software/open source, and is distributed under the [BSD license](http://opensource.org/licenses/BSD-3-Clause). It contains third-party code, see the included `third-party.txt` file for the license information on third-party code.

PhantomJS is created and maintained by [Ariya Hidayat](http://ariya.ofilabs.com/about) (Twitter: [@ariyahidayat](http://twitter.com/ariyahidayat)), with the help of [many contributors](https://github.com/ariya/phantomjs/contributors). Follow the official Twitter stream [@PhantomJS](http://twitter.com/PhantomJS) to get the frequent development updates.

## Here is a list of Third Party Software included with PhantomJS, along with the license information.

Third Party Software may impose additional restrictions and it is the user's responsibility to ensure that they have met the licensing requirements of PhantomJS and the relevant license of the Third Party Software they are using.

[**Qt**](http://qt-project.org/)

**License**: GNU Lesser General Public License (LGPL) version 2.1.

**Reference**: http://qt-project.org/doc/qt-4.8/lgpl.html.

[**WebKit**](http://www.webkit.org/)

**License**: GNU Lesser General Public License (LGPL) version 2.1 and BSD.

**Reference**: http://www.webkit.org/coding/lgpl-license.html and http://www.webkit.org/coding/bsd-license.html.

[**Mongoose**](https://github.com/cesanta/mongoose)

**License**: MIT

**Reference**: https://github.com/cesanta/mongoose/commit/abbf27338ef554cce0281ac157aa71a9c1b82a55

[**OpenSSL**](http://www.openssl.org/)

**License**: OpenSSL License, SSLeay License.

**Reference**: http://www.openssl.org/source/license.html.

[**Linenoise**](https://github.com/tadmarshall/linenoise)

**License**: BSD.

**Reference**: https://github.com/tadmarshall/linenoise/blob/master/linenoise.h.

[**QCommandLine**](http://xf.iksaif.net/dev/qcommandline.html)

**License**: GNU Lesser General Public License (LGPL) version 2.1.

**Reference**: http://dev.iksaif.net/projects/qcommandline/repository/revisions/master/entry/COPYING

[**wkhtmlpdf**](http://code.google.com/p/wkhtmltopdf/)

**License**: GNU Lesser General Public License (LGPL)

**Reference**: http://code.google.com/p/wkhtmltopdf/
