<?php
	
	class File
	{
		
		public function __construct()
		{
			
		}

		public function file_autorise($fichier) {
			global $FICHIER_AUTORIZ, $FICHIER_EXCLUDE ;
			// récuperation de l'extension
			$path_parts = pathinfo($fichier['name']);
	        $ext = $path_parts['extension'];

	        switch (FILE_UPLOAD_AUTHORIZATION_METHOD) {
	          case 0 :    // moins sécurisée, mais moins de probleme
	        		if ( (!in_array ($fichier['type'],$FICHIER_EXCLUDE)) && (!in_array ($ext,$FICHIER_EXCLUDE)) ) {
	        			return(true);
	        		}
	          break;

	          case 1 :    // plus sécurisé mais plus de problemes
	      		if ( (in_array ($fichier['type'],$FICHIER_AUTORIZ)) && (in_array ($ext,$FICHIER_AUTORIZ)) ) {
	      			return(true);
	      		}
	          break;

	        }
	        // on est toujours là ? Donc le fichier n'est pas authorisé => renommé en .txt
	        return(false);
		}

		/**
		* Verifie le type d'extension
		*
		* Fonction mise à jour pour le SP1 [pyg]
		* @return	string	Retourne le nom du fichier modifie
		* @access	public
		*/
		public function ext_autorise($fichier) {
			global $FICHIER_AUTORIZ, $FICHIER_EXCLUDE ;
			// récuperation de l'extension
			$path_parts = pathinfo($fichier);
	    	$ext = isset($path_parts['extension'])?$path_parts['extension']:'';

	    	/*switch (FILE_UPLOAD_AUTHORIZATION_METHOD) {
	      		case 0 :    // moins sécurisée, mais moins de probleme
	    			if ( !in_array ($ext,$FICHIER_EXCLUDE)) {
	    			return(true);
	    		}
	      		break;

	      		case 1 :    // plus sécurisé mais plus de problemes
	  				if ( in_array ($ext,$FICHIER_AUTORIZ)) {
	  					return(true);
	  				}
	      		break;
	    	}*/
	    	// on est toujours là ? Donc le fichier n'est pas authorisé => renommé en .txt
	    	return(true);

		}

		/**
		* Copie un fichier dans le repertoire upload.
		* @access	public
		*/
		public function copier_fichier($fichier, $dest) {
			// ini_set('display_errors', TRUE);
			// error_reporting(-1);

			debugf(__FILE__,$dest);
			$name =  basename($dest);
			//chmod($dest,0666); 
			if ( !file_autorise($fichier)) {
	    		$tab = explode('.', $dest);
				$dest = $tab[0].'.'.$tab[1].'.txt' ;
				$tab = explode('.', $name);
				$name = $tab[0].'.'.$tab[1].'.txt' ;
			}
			//echo "dessst : ".$dest."</br>";
			//chmod ($dest, 0777);
			if ( is_uploaded_file($fichier['tmp_name']) ) {
				// SP1 [pyg]
				
				@move_uploaded_file($fichier['tmp_name'],$dest) ;
				//die("temp : ".$fichier['tmp_name']." déstination : ".$dest);
				//copy($fichier['tmp_name'], $dest) ;
				return($name);
			} else {
				die('erreur tmp_file -> '.$fichier['error']);
				return(false) ;
			}
		}

		/**
		* Traite les noms de fichiers a copier sur le serveur.
		* @param	string	$user	Nom du membre qui copie la fichier
		* @param	string	$file_name Nom du fichier a verifier
		* @return	string	Retourne le nom du fichier modifie
		* @access	public
		*/
		public function MakeFileName($user,$file_name) {
			$server_fichier = $file_name ;
			$server_fichier=str_replace("'","",$server_fichier);
			$server_fichier=str_replace("\"","",$server_fichier);
			$server_fichier=str_replace("\"","",$server_fichier);
			$server_fichier=str_replace("&","",$server_fichier);
			$server_fichier=str_replace(",","",$server_fichier);
			$server_fichier=str_replace(";","",$server_fichier);
			$server_fichier=str_replace("/","",$server_fichier);
			$server_fichier=str_replace("\\","",$server_fichier);
			$server_fichier=str_replace("`","",$server_fichier);
			$server_fichier=str_replace("<","",$server_fichier);
			$server_fichier=str_replace(">","",$server_fichier);
			$server_fichier=str_replace(" ","_",$server_fichier);
			$server_fichier=str_replace(":","",$server_fichier);
			$server_fichier=str_replace("*","",$server_fichier);
			$server_fichier=str_replace("|","",$server_fichier);
			$server_fichier=str_replace("?","",$server_fichier);
			$server_fichier=str_replace("é","e",$server_fichier);
			$server_fichier=str_replace("è","e",$server_fichier);
			$server_fichier=str_replace("ç","c",$server_fichier);
			$server_fichier=str_replace("@","",$server_fichier);
			$server_fichier=str_replace("â","a",$server_fichier);
			$server_fichier=str_replace("ê","e",$server_fichier);
			$server_fichier=str_replace("î","i",$server_fichier);
			$server_fichier=str_replace("ô","o",$server_fichier);
			$server_fichier=str_replace("û","u",$server_fichier);
			$server_fichier=str_replace("ù","u",$server_fichier);
			$server_fichier=str_replace("à","a",$server_fichier);
			$server_fichier=str_replace("!","",$server_fichier);
			$server_fichier=str_replace("§","",$server_fichier);
			$server_fichier=str_replace("+","",$server_fichier);
			$server_fichier=str_replace("^","",$server_fichier);
			$server_fichier=str_replace("(","",$server_fichier);
			$server_fichier=str_replace(")","",$server_fichier);
			$server_fichier=str_replace("#","",$server_fichier);
			$server_fichier=str_replace("=","",$server_fichier);
			$server_fichier=str_replace("$","",$server_fichier);
			$server_fichier=str_replace("%","",$server_fichier);
			$server_fichier = eregi_replace("[^a-z0-9\.]", "_", $server_fichier);
			$server_fichier = date("m-j-H-i-s-").$user.".".$server_fichier		;
			return($server_fichier) ;
		}

		/**
		* Sécurise les noms de fichiers a copier sur le serveur.
		* cherche dans $server_fichier les fichiers commençant par une lettre minuscule ou un chiffre
		* et les remplace par _
		* @param	string	$file_name Nom du fichier a verifier
		* @return	string	Retourne le nom du fichier modifie
		* @access	public
		*/
		public function SecureFileName($file_name) {
			$server_fichier = $file_name ;
			$server_fichier = eregi_replace("[^a-z0-9\.]", "_", $server_fichier);
			return($server_fichier) ;
		}

		/**
		* remplace tous les caracteres
		* @param	string	$file_name Nom du fichier a modifier
		* @return	string	Retourne le nom du fichier modifie
		* @access	public
		*/
		public function Purge($file_name) {
			$ret = eregi_replace("[^a-z0-9]", "_", $file_name);
			$ret = str_replace("\\", "", $ret);
			return($ret) ;
		}

		/**
		* Extrait le nom du fichier
		* @param	string	$file	Nom du fichier modifie
		* @return	string	Retourne le nom du fichier
		* @access	public
		*/
		public function ExtractFileName($file) {
			if ( strlen(trim($file))==0) {
			   return('');
			}
			//die($file);
			$tbl_date = explode ( "-", $file)			;
			/*$jour		= $tbl_date[0]					;
			$mois		= $tbl_date[1]					;
			$heure		= $tbl_date[2]					;
			$minute		= $tbl_date[3]					;
			$seconde	= $tbl_date[4]					;
			$tbl_file	= explode ( ".", $tbl_date[5])	;*/
			$tbl_file	= explode ( ".", $file)	;
			
			$fichier = '' ;
			for($i=1;$i<count($tbl_file);$i++) {
				if ( $i==1) {
					$fichier = $tbl_file[$i] ;
				} else {
					$fichier.= '.'.$tbl_file[$i];
				}
			}
			return($fichier);
		}

		/**
		* Copie un fichier dans le repertoire du groupe.
		* Utilise pour les fichiers attaches aux messages.
		* @param	integer	$idm	Id du membre
		* @param	integer	$idg	Id du groupe
		* @param	string	$fichier Description du fichier a copier
		* @return	string	Retourne le nom du fichier modifie
		* @access	public
		*/
		public function CopyFileGroupe($idm,$idg,$fichier) {
		 global $ClsGroupe, $ClsMembre ;
			$rep = $ClsGroupe->Directory($idg)	;
			if ( ! is_dir(RP_GROUPES.$rep."/messages/") ) {
			   return(false);
			}
			$login = $ClsMembre->GetLogin($idm)	;
			$server_fichier = MakeFileName($login,$fichier['name']) ;
			$server_fichier = copier_fichier($fichier,RP_GROUPES.$rep."/messages/".$server_fichier) ;
			return($server_fichier) ;
		}

		/**
		* Copie un fichier dans le repertoire du groupe
		* Utilise pour les fichiers postes dans la zone document
		* @param	integer	$idm	Id du membre
		* @param	integer	$idg	Id du groupe
		* @param	string	$fichier Description du fichier a copier
		* @return	string	Retourne le nom du fichier modifie
		* @access	public
		*/
		public function CopyDocument($idm,$idg,$fichier) {
		 global $ClsGroupe, $ClsMembre ;
			$rep	=  $ClsGroupe->Directory($idg);
			if ( ! is_dir(RP_GROUPES.$rep) ) {
				//mkdir(RP_GROUPES.$rep, 0777);
				mkdir(RP_GROUPES.$rep, 0777,true);
			}
			$login  = $ClsMembre->GetPrenom($idm);
			//$server_fichier = MakeFileName($login,$fichier['fichier']['name']);
			$server_fichier = copier_fichier( $fichier['fichier'],RP_GROUPES.$rep."/".$fichier['fichier']['name']);
			return($server_fichier) ;
		}

		public function CopyDocumentToSign($idm,$idg,$fichier) {
		 global $ClsGroupe, $ClsMembre ;
			$rep	        =  $ClsGroupe->Directory($idg);
			$rep_doc_sign	=  'doctosign';
			if ( ! is_dir(RP_GROUPES.$rep.'/'.$rep_doc_sign) ) {
				//mkdir(RP_GROUPES.$rep, 0777);
				mkdir(RP_GROUPES.$rep, 0777,true);
				mkdir(RP_GROUPES.$rep.'/'.$rep_doc_sign, 0777,true);
			}
			//die("rep : ".RP_GROUPES.$rep.'/'.$rep_doc_sign);
			$login  = $ClsMembre->GetPrenom($idm);
			//$server_fichier = MakeFileName($login,$fichier['fichier']['name']);
			$server_fichier = copier_fichier( $fichier['fichier'],RP_GROUPES.$rep.'/'.$rep_doc_sign."/".$fichier['fichier']['name']);
			chmod(RP_GROUPES.$rep.'/'.$rep_doc_sign."/".$fichier['fichier']['name'], 0777);
			return($server_fichier) ;
		}

		public function CopyDocumentTodoList($idm,$idg,$fichier) {
		 	global $ClsGroupe, $ClsMembre ;
			$rep	        =  "GRPT".GUSERID;
			$rep_doc_todo	=  'documentTodo';
			if ( ! is_dir(RP_GROUPES.$rep.'/'.$rep_doc_todo) ) {
				mkdir(RP_GROUPES.$rep, 0777,true);
				mkdir(RP_GROUPES.$rep.'/'.$rep_doc_todo, 0777,true);
			}
			//die(RP_GROUPES.$rep.'/'.$rep_doc_todo."/".$fichier['fichier']['name']);
			$server_fichier = copier_fichier( $fichier['fichier'],RP_GROUPES.$rep.'/'.$rep_doc_todo."/".$fichier['fichier']['name']);		
			return($server_fichier) ;
		}

		/**
		* CopyPhotoMembre()
		* Copie la photo d'un membre.
		* @param	string	$file		Description du fichier a copier
		* @param	integer	$id			id du membre
		* @access public
		**/
		public function CopyPhotoMembre($file, $id) {
			global $ClsMembre;
			$type_file_tab = explode('.', $file['name']);
			$ret = false ;
			//Vérifie l'extension de l'image et sauvegarde le fichier avec la même extension
			if(count($type_file_tab)>0) {
				$type_file = '.'.$type_file_tab[count($type_file_tab)-1];
				$nomPhoto = 'user_'.$id.$type_file;
				$ret = copier_fichier($file, RP_UPLOAD_PHOTOS.$nomPhoto);
				$ancienNomPhoto = $ClsMembre->Request('nom_photo', $id);
				if($ancienNomPhoto != $nomPhoto) {
					$ClsMembre->ModifierNomPhoto($id, $nomPhoto);
					if($ancienNomPhoto!='') {
						DeleteDocument(RP_UPLOAD_PHOTOS.$ancienNomPhoto);
					}
				}

			}
			return($ret);
		}

		/**
		* Detruit un repertoire
		* http://fr2.php.net/manual/fr/public function.rmdir.php
		* @param	string	$file	Repertoire a supprimer
		* @access	public
		*/
		public function deldir($file) {
			debugf(__FILE__,$file);
			@chmod($file,0777);
			if (is_dir($file)) {
				$handle = opendir($file);
				while($filename = readdir($handle)) {
					if ($filename != "." && $filename != "..") {
					deldir($file."/".$filename);
					}
				}
				@closedir($handle);
				@rmdir($file);
			} else {
				@unlink($file);
			}
		}

		/**
		* lecture d'un repertoire
		* @param	string	$location	Repertoire a lire
		* @access	public
		*/
		public function readir($location) {
			if ( substr($location,-1) <> "/" ) {
				$location = $location."/";
			}
			$i = 0 ;
			$ret = array();
			$all=opendir($location);
			while ($file=readdir($all)) {
				if($file=="." or $file=="..") continue;
				if ( is_dir($location.$file) ) {
					$ret[$i]['type'] = 'directory'	;
					$ret[$i]['name'] = $file		;
				} elseif ( ! @is_dir($location.$file) ) {
					$ret[$i]['type'] = 'file'	;
					$ret[$i]['name'] = $file	;
				}
				$i++ ;
			}
			$ret['cnt'] = $i;
			return($ret)	;
		}

		/**
		* retourne la taille d'un fichier
		* mailto:clambert@gamespy.com
		* @param	string	$fichier	Nom du fichier
		* @return	string	Retourne la taille du fichier
		* @access	public
		*/
		public function taille($fichier) {
		 global $st_texte ;
		 	if ( ! is_file($fichier)) {
		 	  return('');
			}
			$taille=filesize($fichier);
			if ( $taille >= 1073741824 ) {
				$taille = round($taille / 1073741824 * 100) / 100 . " ".$st_texte['go']	;
			} elseif ( $taille >= 1048576 ) {
				$taille = round($taille / 1048576 * 100) / 100 . " ".$st_texte['mo']	;
			} elseif ( $taille >= 1024 ) {
				$taille = round($taille / 1024 * 100) / 100 . " ".$st_texte['ko']		;
			} else {
				$taille = $taille . "  ".$st_texte['octets'];
			}
			if( $taille == 0 ) {
				$taille="-";
			}
			return($taille);
		}


		public function taille2($taille) {
		 global $st_texte ;
			if ( $taille >= 1073741824 ) {
				$taille = round($taille / 1073741824 * 100) / 100 . " ".$st_texte['go']	;
			} elseif ( $taille >= 1048576 ) {
				$taille = round($taille / 1048576 * 100) / 100 . " ".$st_texte['mo']	;
			} elseif ( $taille >= 1024 ) {
				$taille = round($taille / 1024 * 100) / 100 . " ".$st_texte['ko']		;
			} else {
				$taille = $taille . "  ".$st_texte['octets'];
			}
			if( $taille == 0 ) {
				$taille="-";
			}
			return($taille);
		}

		/**
		* supprime un fichier
		* @param	string	$fichier	Fichier a supprimer
		* @access	public
		*/
		public function DeleteDocument($fichier) {
			if ( file_exists($fichier) ) {
				unlink($fichier);
			}
		}

		/**
		* Cre un repertoire
		* @param	string	$path	Chemin et nom du repertoire a creer
		* @return	integer	retourne le resultat de la creation
		* @access	public
		*/
		public function CreateDirectorie($path) {
			if ( strlen( $path) == 0) {
				return 0;
			}
			if ( is_dir( $path)) {
				return 0;
			}
			if ( dirname( $path) == $path) {
				return 0;
			}
			return(mkdir($path,0777));
			//return(mkdir($path,0775));
		}

		/**
		* Cre un repertoire
		* @param	string	$oldname	repertoire a renommer
		* @param	string	$newname	nouveau repertoire
		* @access	public
		*/
		public function renameDirectorie($oldname, $newname) {
			if ( strlen( $oldname) == 0) {
				return(false);
			}
			if ( ! is_dir( $oldname)) {
				return(false);
			}
			if ( is_dir( $newname)) {
				return(false);
			}
			if ( ! rename($oldname,$newname) ) {
				return(false);
			}
			return(true);
		}

		/**
		* verifie l'extension du fichier.
		* @param	string	$file	nom du fichier a traiter
		* @access	public
		*/
		public function extensionSequence($file){
			if(eregi("\.html$",$file)){return(true);}
			else if(eregi("\.htm$",$file)){return(true);}
			else if(eregi("\.zip$",$file)){return(true);}
			else if(eregi("\.wav$",$file)){return(true);}
			else if(eregi("\.php$",$file)){return(true);}
			else if(eregi("\.php3$",$file)){return(true);}
			else if(eregi("\.phtml$",$file)){return(true);}
			else if(eregi("\.xls$",$file)){return(true);}
			else if(eregi("\.doc$",$file)){return(true);}
			else if(eregi("\.pdf$",$file)){return(true);}
			else if(eregi("\.swf$",$file)){return(true);}
			return(false);
		}

		/**
		* Creer un fichier index.htm
		* @param	string	$path	Chemin du repertoire ou doit etre place le fichier index.htm
		* @access	public
		*/
		public function CreateIndexFile($path) {
			$data = "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n"	;
			$data.= "<HTML><HEAD>\n"											;
			$data.= "<TITLE>401 Authorization Required</TITLE>\n"				;
			$data.= "</HEAD><BODY>\n"											;
			$data.= "<H1>Authorization Required</H1>\n"							;
			$data.= "This server could not verify that you\n"					;
			$data.= "are authorized to access the document\n"					;
			$data.= "requested.  Either you supplied the wrong\n"				;
			$data.= "credentials (e.g., bad password), or your\n"				;
			$data.= "browser doesn't understand how to supply\n"				;
			$data.= "the credentials required.<P>\n"							;
			$data.= "<HR>\n"													;
			$data.= "<ADDRESS>Apache/1.3.19 Server </ADDRESS>\n"				;
			$data.= "</BODY></HTML>\n"											;
			$fp = fopen($path."/index.htm", "w")								;
			fputs($fp, $data)													;
			fclose($fp)															;
		}

		/**
		* Cre un fichier index.htm
		* @param	string	$path	Chemin du repertoire ou doit etre place le fichier index.htm
		* @access	public
		*/
		public function CeateFile($file,$data) {
	        $fp = @fopen($file, "w") or die("Erreur creation fichier !");
	   		@fwrite($fp, $data)	or die("Erreur ecriture fichier !");
	   		@fclose($fp) or die("Erreur fermeture fichier !"); ;
		}

		/**
		* Cre un fichier index.htm
		* @param	string	$path	Chemin du repertoire ou doit etre place le fichier index.htm
		* @access	public
		*/
		public function AddDataFile($file,$data) {
	        $fp = fopen($file, "a+") ;
			fwrite($fp, $data)	;
			fflush($fp);
			fclose($fp);
		}

		/**
		 * formatDirPath()
		 * Renvoie le chemin bien formaté (avec un '/' à la fin)
		 * @param	string	path
		 * @return string le même chemin qu'en entrée, avec un / à la fin.
		 **/
		public function formatDirPath($dir) {
			return dirname($dir).'/'.basename($dir).'/';
		}

		/**
		* dir_formation()
		* Renvoie le chemin du repertoire formation en fonction du mode d'installation
		* @return array
		**/
		public function dir_formation($loc) {
	 	    switch( $loc ) {
	 	    case LOCAL :
				 $ret['rp']	= RP_FORMATION_LOC	;
				 $ret['url']= HTTP_FORMATION_LOC;
				 break;
			case NATIONAL:
				 $ret['rp']	= RP_FORMATION_NAT	;
				 $ret['url']= HTTP_FORMATION_NAT;
				 break;
		    case STANDARD :
				 $ret['rp']	= RP_FORMATION	;
				 $ret['url']= HTTP_FORMATION;
				 break;
			}
			return($ret);
		}

		/**
		* unzip()
		* dzippe un fichier : JG
		* @param	string	$file nom du fichier
	    * @param	string	path  chemin du fichier
		* @return array
		**/
		public function unzip($file, $path, $create=1) {
		  $ret = array() ;
		  $ret['imsmanifest'] = '' ;
		  $zip = zip_open($file);
		  if ($zip) {
		   while ($zip_entry = zip_read($zip)) {
		     if (zip_entry_filesize($zip_entry) > 0) {
		       if ($path[0]=='/'){
		       	  $complete_path = $path.dirname(zip_entry_name($zip_entry));
		       	  $complete_name = $path.zip_entry_name($zip_entry);
		       	  $car_explode = '/' ;
	     	   } else {
	     	      // windows
		       	  // str_replace must be used under windows to convert "/" into "\"
		       	  $complete_path = $path.str_replace('/','\\',dirname(zip_entry_name($zip_entry)));
		       	  $complete_name = $path.str_replace ('/','\\',zip_entry_name($zip_entry));
		       	  $car_explode = "\\" ;
			   }
		       if ( (strtolower(basename(zip_entry_name($zip_entry))) == "imsmanifest.xml" ) ) {
		       	  $ret['imsmanifest'] = $path.zip_entry_name($zip_entry) ;
		       	  $ret['maindir'] = dirname(zip_entry_name($zip_entry))."/" ;
			   }

		       if(!file_exists($complete_path)) {
		         $tmp = '';
		         foreach(explode($car_explode,$complete_path) as $k) {
		           $tmp .= $k.'/';
		           if(!file_exists($tmp)) {
		             if ( $create ) {
					 	//mkdir($tmp, 0755);
					 	mkdir($tmp, 0755);
			 	 	 } else {
			 	 	    print_r('<b>Directory=>'.$tmp);
			 	 	    print('</b><br />');
					 }
		           }
		         }
		       }
		       if (zip_entry_open($zip, $zip_entry, "r")) {
		         if ( $create ) {
			         $fd = fopen($complete_name, 'w');
			         fwrite($fd, zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)));
			         fclose($fd);
			         //chmod($path.zip_entry_name($zip_entry), ereg("(\.php$)",$zip_entry)?0755:0755);
			         chmod($path.zip_entry_name($zip_entry), 0755);
		         } else {
		           print_r($complete_name);
		           print('<br />');
				 }
		         zip_entry_close($zip_entry);
		       }
		     }
		   }
		   zip_close($zip);
		  }
		  return($ret);
		}

		/**
		* scann()
		* scan un repertoire pour le zipper : JG
		* @param	string	$diir repertoire a scanner
		* @return array
		**/
		public function scann($diir) {
			global $ClsZip,$racinezip;
			$fold=@opendir($diir);
			while ($fichier=readdir($fold)) {
				if ($fichier!="." && $fichier!="..") {
					if (is_dir("$diir/$fichier")) {
						scann("$diir/$fichier");
					} else {
						$fp = @fopen ("$diir/$fichier", 'r');
						if ($fp) {
							$content = fread($fp, filesize("$diir/$fichier"));
							fclose ($fp);
							$name="$diir/$fichier";
							$name=substr($name,strlen($racinezip)+1);
							$ClsZip->addfile($content, $name);
						}
					}
				}
			}
		}
	}