<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Document extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();       
        $this->isLoggedIn();  
        $this->tracking_type = 4; 
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {   
        
      
        $this->global['pageTitle'] = 'E-learning : Database document';

        $trackingid = $this->tracking_model->Add(0,0,$this->tracking_type);
        $sessionArray = array('TRACKINGID'=>$trackingid);                                    
        $this->session->set_userdata($sessionArray);
        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');

        $this->global['groupe']    = $this->session->userdata ('STAGIAIREGRP');

        $order = '';
        if (isset($_GET['order']) && $_GET['order'] != '') {
            $order = $_GET['order'];
        }
        $data['classification_favoris'] = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));
        $data['document_not_in_repository']  = $this->document_model->ListerDocumentsByTraineeAndTuteur($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'),$this->session->userdata ('STAGIAIREID'));
        $data['historik_course'] = $this->coursHistorik_model->getByUserCreateIdGroupTraineeCreate($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREID'),$this->session->userdata ('STAGIAIREGRP'));
        $data['document_repertory'] = $this->document_repository_model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'),$order);
        $data['repertory_dc'] = $this->document_repository_model->getByUserCreateIdGroupNotInDocument($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'),$order);
        $data['all_repertory_dc'] = $this->document_repository_model->getByUserCreateIdGroupAndTraineeSession($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'),$this->session->userdata ('STAGIAIREID'),$order);
        //$data['trainee_infos_send_mail'] = $this->lang->line('el_send_mail_infos_trainee_data').' '.$this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID')).' '.$this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID')).' < '.$this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID')).' > ';

        $this->loadViews("tutor/document/index", $this->global, $data , NULL);

    }

    public function mine(){
        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('my_document_');
        $data['allResults']  = $this->document_model->MesDocuments_($this->session->userdata ('GUSERID'));
        $this->loadViews("tutor/document/mine", $this->global, $data , NULL);
    }

    public function addMine(){
        $date      = date('d/m/Y H:i:s');
        $mycomment = "" ;
        $retour = "" ;
       
        $rep = RP_GROUPES.'GRPT'.$this->session->userdata ('GUSERID');
       

        if ( ! is_dir($rep) ) {
            mkdir($rep, 0755,true);
        }

        $config['upload_path']=$rep;       

        //$config['allowed_types']='*';
        $config['allowed_types']='gif|jpg|png|doc|docx|pdf|ppt|csv|xls|xlsx|mid|wma|ogg|wav|mp3|3gp|3g2|avi|mpg|mp4|mp4a|mp4b, .mp4r|mp4v|mp4p|asf|wmv|wma|flv|nut|rm|mov|mkv|ogg|ogv|oga|ogx|spx|opus|ogm|vob|ifo|webm|weba';
        $config['encrypt_name'] = TRUE;
        $config['max_size'] = '100000';
        
         
        $this->load->library('upload');
        $this->upload->initialize($config);  
        if($this->upload->do_upload("inputFileDoc")){
            $data = array('upload_data' => $this->upload->data());
 
            if (strlen(trim($this->input->post('textareaCommentDoc'))) == 0) {
                $mycomment .= "" ;
                $nb   = 0 ;
            }
            else{
                $mycomment .= "<DEB>".$this->session->userdata('GUSER')." a écrit le ".$date."<MID>".$this->input->post('textareaCommentDoc')."<FIN>" ;
                $nb   = 1 ;
            }

            $additional_data = array(
                'titre'          => $this->input->post('inputTitleDoc'),
                'comment'        => $mycomment,
                'fichier'        => $data['upload_data']['file_name'],
                'prop'           => $this->session->userdata('GUSERID'),       
                'groupe'         => 0,       
                'type'           => 3,       
                'priv'           => 0,       
                'date'           => $date,       
                'taille'         => "",       
                'nbcomment'      => $nb,       
                'lien'           => '',       
            );


            $result= $this->document_model->add($additional_data);
            $retour .= 1 ;
        }
        else{
            $retour .= 0 ;
        }

        echo "retour".$retour;


    }

    public function editMine(){
        $fichier = '';

        if (isset($_POST['inputTitleDoc_edit'])) {
            $rep = RP_GROUPES.'GRPT'.$this->session->userdata ('GUSERID');
            if ( ! is_dir($rep) ) {
                mkdir($rep, 0755,true);
            }
            $config['upload_path']=$rep;
            $config['allowed_types']='*';
            $config['encrypt_name'] = TRUE;
            $config['max_size'] = '100000';
            $this->load->library('upload');
            $this->upload->initialize($config); 
            if($this->upload->do_upload("inputFileDoc_edit")){
                $data = array('upload_data' => $this->upload->data());
                $fichier   = $data['upload_data']['file_name'];
                $retour['upload'] = true;
            }
                
            if ($_POST['textareaCommentDoc_edit'] != "") {
                if (isset($fichier) && $fichier != '') {                
                    $edit_data = array(
                        'titre'          => $_POST['inputTitleDoc_edit'],
                        'fichier'        => $fichier,
                        'id_repertory'   => $_POST['repertory_edit'],
                        'comment'        => $_POST['textareaCommentDoc_edit']
                    );
                }
                else{
                    $edit_data = array(
                        'titre'          => $_POST['inputTitleDoc_edit'],
                        'id_repertory'   => $_POST['repertory_edit'],
                        'comment'        => $_POST['textareaCommentDoc_edit']
                    );
                }
            }
            else{
                if (isset($fichier) && $fichier != '') {                    
                    $edit_data = array(
                        'titre'          => $_POST['inputTitleDoc_edit'],
                        'fichier'        => $fichier,
                        'id_repertory'   => $_POST['repertory_edit']
                    );
                }
                else{
                    $edit_data = array(
                        'titre'          => $_POST['inputTitleDoc_edit'],
                        'id_repertory'   => $_POST['repertory_edit']
                    );
                }
            }
            $this->document_model->update($_POST['id_doc_edit'],$edit_data);
            redirect('/tutor-document');
        }
    }
    public function addlink(){

        $this->global['pageTitle'] = 'E-learning : Add new Link';
        $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
        $this->loadViews("tutor/todolist/addnewlink", $this->global, NULL , NULL);            
            
        
    }

    public function listLinkAndDocs(){

        $this->global['pageTitle'] = 'E-learning : List Link and document';
        
        $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
        $searchText = $this->input->post('searchText');
        $count      = $this->todolist_model->countLinksDocs($searchText);
        $returns    = $this->paginationCompress ( "listLinkDocs/", $count,12);
        $data['listDocLink'] = $this->todolist_model->listLinksDocs($searchText, $returns["page"], $returns["segment"]);
        $this->loadViews("tutor/todolist/listLinkAndDocs", $this->global,$data, NULL );    
            
        
    }

    public function edit(){
        $this->global['pageTitle'] = 'E-learning : Edition document';
        $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
        if (isset($_GET['id']) && $_GET['id'] != NULL) {
            $this->global['document_repertory'] = $this->document_repository_model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));
            $this->global['document']  = $this->document_model->getDocumentById($_GET['id'])->result();
            $this->loadViews("tutor/document/edit", $this->global,NULL, NULL );    
        }
    }


    public function comment(){
        
        $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
        $codeHTML = '';
        $DEB      = '!!##!!' ;
        $MID      = '!!##!!' ;
        $FIN      = '!!##!!' ;
        $idDoc    = $_GET['idDoc'];
        $grp      = $_GET['groupe'];

        if (isset($_POST['comment']) && $_POST['comment'] != "") {
            $this->document_model->InsertComment($idDoc, $_POST['comment']);
        }
        $doc      = $this->document_model->read($idDoc);
        $comment  = nl2br($doc['comment']) ;
        $this->global['pageTitle'] = 'E-learning : Comment';
        $this->global['comment'] = $comment;
        $this->loadViews("tutor/document/comment", $this->global, NULL , NULL);

    }



    public function getwebpage()
    { 
        echo  file_get_contents($this->input->post('link'));
    }

    public function viewTodo(){
        $this->global['pageTitle'] = 'E-learning : Forma2+';
        
        $this->loadViews("todolist/viewstodo", $this->global, NULL , NULL);
    }

    public function copier_fichier($fichier, $dest) {

        $name =  basename($dest);
        $extension = $this->check_docs_extension($fichier['name']);
        if ($extension) {        
            if ( is_uploaded_file($fichier['tmp_name']) ) {
         
                @move_uploaded_file($fichier['tmp_name'],$dest) ;
                return($name);
            } else {
                die('erreur tmp_file -> '.$fichier['error']);
                return(false) ;
            }
        }
    }

    public function check_docs_extension($docs){

        $docs_extentions = array("pdf","doc","docx");

        $docs_parts = explode(".",$docs);

        $docs_end_part = end($docs_parts);

        if(in_array($docs_end_part,$docs_extentions ) == true){

            return true;


        }else{

            return false;
        }


    }

   
}

?>