<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class CommunityLibraryForma2Plus extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
        $this->tracking_type = 77;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle']        = 'E-learning : '.$this->lang->line('educational_library_community_forma2plus');
        $this->loadTrackingEl(0,0,$this->tracking_type);         
        $this->global['groupe']           = $this->session->userdata ('STAGIAIREGRP');
        $ordered = isset($_GET['order']) ? $_GET['order'] : 'did';
        $data['community_library_forma2plus_result']           = $this->Community_library_forma2plus_model->getAll($ordered); 
        $data['historik_course']          = $this->coursHistorik_model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP')); 
        $data['classification_favoris']   = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));
        $this->loadViews("tutor/community-library-forma2plus/list", $this->global,$data, NULL );  
      
    }
    public function add(){
        if (isset($_POST)) {                                     
            $data_lib = array(
                'name'        => $_POST['repertory'],
                'description' => $_POST['description'],
                'user_create' => $this->session->userdata ('GUSERID'),
                'date'        => time(),
            );
            $ret = $this->Community_library_forma2plus_model->add($data_lib);
            echo '##'.$ret;
        }
        else{
            echo "error";
        }

    }  

    public function delete(){
        if (isset($_POST['id_repertory'])) {
            $this->Content_community_library_forma2plus_model->deleteByIdCommunityLibraryForma2Plus($_POST['id_repertory']);
            $this->Community_library_forma2plus_model->delete($_POST['id_repertory']); 
            echo "1";
        } 
    }

    public function update(){
        if (isset($_POST['dataRep'])) {
            $data = array(
                'name'        => $_POST['dataRep']['repertory-document-edit'],
                'description' => $_POST['dataRep']['description-cat-edit']
            );
            echo $this->Community_library_forma2plus_model->update($_POST['dataRep']['id_repertory_edit'],$data);
        }
    }
}

?>