<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Document
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Document extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn(); 
        $this->tracking_type = 4;    
    }
    
    /**
     * This function used to load the first screen of the user
     */
   
    public function index()
    {
        $this->loadTrackingEl(0,0,$this->tracking_type);

        $this->global['pageTitle'] = 'E-learning : Database document';
        $order = '';
        if (isset($_GET['order']) && $_GET['order'] != '') {
            $order = $_GET['order'];
        }
        
        $data['classification_favoris'] = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('GROUPE'));
        $data['document_not_in_repository']  = $this->document_model->ListerDocumentsByGroup($this->session->userdata ('GROUPE'),NULL);
        $data['document_repertory'] = $this->document_repository_model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('GROUPE'),$order);
        $data['all_repertory_dc'] = $this->document_repository_model->getByIdGroup($this->session->userdata ('GROUPE'),$order);

        $this->Notification_model->deleteByIdDataTypeAndGroupe('databasedoc',$this->session->userdata ('GROUPE'));


        $this->loadViews("trainee/document/index", $this->global, $data , NULL);
    }

    public function comment(){
        $this->loadTrackingEl(0,0,$this->tracking_type);
        $codeHTML = '';
        $DEB      = '!!##!!' ;
        $MID      = '!!##!!' ;
        $FIN      = '!!##!!' ;
        $idDoc    = $_GET['idDoc'];
        $grp      = $_GET['groupe'];

        if (isset($_POST['comment']) && $_POST['comment'] != "") {
            $this->document_model->InsertComment($idDoc, $_POST['comment']);
        }
        $doc      = $this->document_model->read($idDoc);
        $comment  = nl2br($doc['comment']) ;

        $this->global['pageTitle'] = 'E-learning : Comment';
        $this->global['comment'] = $comment;
        $this->loadViews("trainee/document/comment", $this->global, NULL , NULL);

    }

    public function edit(){
        if (isset($_POST['docType']) && isset($_POST['docId'])) {
            if ($_POST['docType'] == 0) {
                $fichier          = $_POST['inputLink'];
            }
            else{
                if ($this->isTuteurConnet()) {
                    $rep = "groupes/".$this->groupes_model->Directory($this->session->userdata ('STAGIAIREGRP'));
                }
                else{
                    $rep = "groupes/".$this->groupes_model->Directory($this->session->userdata ('GROUPE'));
                }
                
                if ( ! is_dir($rep) ) {
                    mkdir($rep, 0755,true);
                }
                $config['upload_path']=$rep;
                $config['allowed_types']='*';
                $config['encrypt_name'] = TRUE;
                $config['max_size'] = '100000';
                $this->load->library('upload');
                $this->upload->initialize($config); 
                if($this->upload->do_upload("inputFileDoc")){
                    $data = array('upload_data' => $this->upload->data());
                    $fichier   = $data['upload_data']['file_name'];
                }
                
            }

            if ($_POST['comment'] != "") {              
                $edit_data = array(
                    'titre'          => $_POST['docTitle'],
                    'fichier'        => $fichier,
                    'id_repertory'   => $_POST['repertory'],
                    'comment'        => "<DEB>".$this->session->userdata('GUSER')." a écrit le ".date('d/m/Y H:i:s')."<MID>".$_POST['comment']."<FIN>"
                );
            }
            else{
                $edit_data = array(
                    'titre'          => $_POST['docTitle'],
                    'id_repertory'   => $_POST['repertory'],
                    'fichier'        => $fichier
                );
            }
            $this->document_model->update($_POST['docId'],$edit_data);
            redirect("/traineedoc","refresh");
        }
        else{

            $this->loadTrackingEl(0,0,$this->tracking_type);
            $this->global['pageTitle'] = 'E-learning : Edition document';
            $this->global['document_repertory'] = $this->document_repository_model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('GROUPE'));
            if (isset($_GET['id']) && $_GET['id'] != NULL) {
                $this->global['document']  = $this->document_model->getDocumentById($_GET['id'])->result();
                $this->loadViews("trainee/document/edit", $this->global,NULL, NULL );    
            }
        }
    }

    
    public function pageNotFound()
    {
        $this->global['pageTitle'] = 'CodeInsect : 404 - Page Not Found';
        
        $this->loadViews("404", $this->global, NULL, NULL);
    }
}

?>