<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH . '/libraries/ElearningSupervisorForma2PlusController.php';

/**
 * Class : BaseController
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class ScreenPiloting extends ElearningSupervisorForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();    
        $this->isLoggedIn(); 
        $this->load->model('CoursPlannifier_model');
        $this->load->model('Membres_model');
        $this->load->model('Tracking_model');
        ini_set('memory_limit', -1);
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index() {
        $this->global['pageTitle'] = 'E-learning : Ecran de pilotage'; 
        $this->load->library('form_validation');
        $this->form_validation->set_rules('date_planification', 'Date début', 'required');
        $this->form_validation->set_rules('creneau_horaire', 'Créneau horaire', '');
        //$this->form_validation->set_rules('utilisateur_status', 'Status de connexion', '');
        $data['creneauHoraire']  = $this->CoursPlannifier_model->getAllCrenauRes(); 
        if ($this->form_validation->run() != FALSE) {
            $dateCoursPlannifier = explode(' - ', $this->input->post('date_planification'));
            $dateFormaCh0 = isset($dateCoursPlannifier[0]) ? explode('-', $dateCoursPlannifier[0]) : '';
            $dateFormaCh1 = isset($dateCoursPlannifier[1]) ? explode('-', $dateCoursPlannifier[1]) : '';
            $postData = array(
                'datePlannification'   => array(
                    0 => isset($dateCoursPlannifier[0]) ? $dateCoursPlannifier[0] : '',
                    1 => isset($dateCoursPlannifier[1]) ? $dateCoursPlannifier[1] : ''
                ),
                'crenneauHoraire'      => $this->input->post('creneau_horaire'),
                //'statusConnexion'      => $this->input->post('utilisateur_status'),
                'dateFormaCh'   => array(
                    0 => isset($dateFormaCh0) ? $dateFormaCh0[2].'/'.$dateFormaCh0[1].'/'.$dateFormaCh0[0] : '',
                    1 => (isset($dateFormaCh1[2]) && isset($dateFormaCh1[1]) && isset($dateFormaCh1[0])) ? $dateFormaCh1[2].'/'.$dateFormaCh1[1].'/'.$dateFormaCh1[0] : '',
                ),
            );
            $data['postData']   = $postData; 
            $data['allResults'] = $this->connexion_model->getDataScreenPiloting($postData); 
        }

        $this->loadViews("supervisor/screenpiloting/view", $this->global, $data , NULL);
    }
}

?>