<?php 
	if(!defined('BASEPATH')) exit('No direct script access allowed');
	require APPPATH . '/libraries/ElearningForma2PlusController.php';
	/**
	 * Class : DocumentController
	 * Base Class to control over all the classes
	 * @author : Alexandre Bors
	 * @version : 1.1
	 * @since :01-04-2018
	 */
	class Document extends ElearningForma2PlusController
	{
	    /**
	     * This is default constructor of the class
	     */
	    public function __construct()
	    {
	        parent::__construct();
	        $this->load->model('login_model');
	        $this->load->model('connexion_model');
	        $this->load->model('document_model');
	        $this->form_validation->set_error_delimiters($this->config->item('error_prefix'), $this->config->item('error_suffix'));
	        $this->isLoggedIn();   
	    }

	    public function index()
    	{
	    
	    	$this->global['pageTitle'] = 'E-learning : Document';
	        $this->global['doc'] = $this->document_model->ListerDocuments($this->session->userdata ('GROUPE'));
	        
	        
	        $this->loadViews("document/index", $this->global, NULL , NULL);

	    }
	   
	}