<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Statpgr extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();        
        $this->isLoggedIn(); 
        $this->type_nl_cat   = "nl_categories";  
        $this->type_nl_art   = "nl_article";  
        $this->sequence_activity = "sequence_activite";  
        $this->type_activity = "activity_sequence";  
        $this->type_todo     = "todolist";  
        $this->community_library_forma2plus     = "community_library_forma2plus"; 
        $this->tracking_type = 24;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    /*get favorite stat*/
    public function index()
    {
        $this->global['pageTitle'] = 'Stat program';
        //$html                      = '<h4 class="text-center title-asidebar">My favourites</h4>'; 
        $html                      = '<ul class="list-group">'; 
        $statpgr                   = $this->stat_prg_model->getFavoris($this->session->userdata ('GUSERID'))->result();
        foreach ($statpgr as $res) {
            if ($res->status == 1 && $res->type == $this->type_nl_cat) {
                $html             .= '<input type="hidden" value="'.$res->type.'" class="type_view_pgr">'; 
                $html             .= '<li class="list-group-item list-group-cat" onclick="readCat(this);"><img src="'.base_url().'groupes/NEWSLETTER/CATEGORIES/'.$res->intitule.'.jpg" class="img-stat-pgr"> <!--span class="badge"--> <span class="badge-category-pgr">'.$res->intitule.'</span></li>'; 
            }

            if ($res->status == 1 && $res->type == $this->type_nl_art) {
                $thumb = $this->utilities_model->getthumbNL($res->id_prg);
                if ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                   $img  = base_url()."groupes/ACTIVITES/".$thumb;
                }
                else{
                    $img  = base_url()."groupes/default.png";
                }    

                $html             .= '<li class="list-group-item list-group-cat"><a href="'.base_url().'read-data?id='.$res->id_prg.'"><img src="'.$img.'" class="img-stat-pgr"></a><span class="badge-category-pgr">'.$this->convert_utf8($res->intitule).'</span></li>'; 
            }

            if ($res->status == 1 && $res->type == $this->type_activity) {
                $thumb = $this->utilities_model->getThumActivity($res->id_prg,$res->numero);
                if ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                   $img  = base_url()."groupes/ACTIVITES/".$thumb;
                }
                else{
                    $img  = base_url()."groupes/default.png";
                }    

                $html             .= '<li style="cursor:pointer;" data-brew="redirect" data-link="'.$this->sequence_model->RequestSeqByIdAndNumero('final_url',$res->id_prg,$res->numero).'"  onclick="viewActivity(this);" data-id="'.$res->id_prg.'" data-num="'.$res->numero.'" data-statusurl="'.$this->sequence_model->RequestSeqByIdAndNumero('status_url',$res->id_prg,$res->numero).'" data-finalurl="'.$this->sequence_model->RequestSeqByIdAndNumero('final_url',$res->id_prg,$res->numero).'" class="list-group-item list-group-cat"><img src="'.$img.'" class="img-stat-pgr"><span class="badge-category-pgr">'.$this->convert_utf8($res->intitule).'</span></li>';
            }

            if ($res->status == 1 && $res->type == $this->sequence_activity) {
                $thumb = $this->sequence_model->getThumbFromLastSequence($res->id_prg);
                if ($thumb != '') {
                    $img = HTTP_MAIN."groupes/ACTIVITES/".$thumb;
                }
                else{
                    $img = base_url()."groupes/img_default.jpg";
                }
                $html .='<li class="list-group-item list-group-cat" style="cursor:pointer;"   onclick="readAllActivityInSequence(this);" value="'.$res->id_prg.'" data-name="'.$this->convert_utf8($res->intitule).'" data-id="'.$res->id_prg.'"><img src="'.$img.'" class="img-stat-pgr"><span class="badge-category-pgr">'.$this->convert_utf8($res->intitule).'</span></li>';

            }

            if ($res->status == 1 && $res->type == $this->type_todo) {
                $return = $this->utilities_model->getThumbTodo($res->id_prg);  
                
                if ($return['thumbnail'] != "" && is_file(RP_GROUPES."GRPT".$return['user_create'].'/THUMBNAIL'.$return['user_create'].'/'.$return['thumbnail'])) {
                    $img  = base_url()."groupes/GRPT".$return['user_create'].'/THUMBNAIL'.$return['user_create'].'/'.$return['thumbnail'];
                }
                else{
                    $img  = base_url()."groupes/default.png";
                }


                $html .= '<li class="list-group-item list-group-cat"><a href="'.base_url().'read-todo?id='.$return['id_plan_w'].'"><img src="'.$img.'" class="img-stat-pgr"></a><span class="badge-category-pgr">'.$this->convert_utf8($res->intitule).'</span></li>';
            }
            
        }


        $html  .= '</ul>';
        echo $html;
    }

    public function getlatest(){
        $this->global['pageTitle'] = 'Latest view';
        //$html                       = '<h4 class="text-center title-asidebar">The last views</h4>'; 
        $html                      = '<ul class="list-group">'; 
        $result = $this->tracking_model->getlatest()->result();
        foreach ($result as $res) {
            if ($res->type == 6) {
                $article = $this->newsletter_model->getArticle($res->sequence_id);
                foreach ($article as $art) {
                    $thumb = $this->utilities_model->getthumbNL($art->ID);
                    if ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                       $img  = base_url()."groupes/ACTIVITES/".$thumb;
                    }
                    else{
                        $img  = base_url()."groupes/default.png";
                    }    

                    $html             .= '<li class="list-group-item list-group-cat"><a href="'.base_url().'read-data?id='.$art->ID.'"><img src="'.$img.'" class="img-stat-pgr"></a><span class="badge-category-pgr">'.$this->convert_utf8($art->article).'</span></li>'; 
                }
            }          
            
        }
        $html                     .= '</ul>';
        echo $html;
    }

    public function mostviewed(){
        $this->global['pageTitle'] = 'Most viewed';
        //$html                       = '<h4 class="text-center title-asidebar">The most watched programs</h4>'; 
        $html                      = '<ul class="list-group">'; 
        $result = $this->tracking_model->mostviewed()->result();
        foreach ($result as $res) {
            if ($res->type == 6) {
                $article = $this->newsletter_model->getArticle($res->sequence_id);
                foreach ($article as $art) {
                    $thumb = $this->utilities_model->getthumbNL($art->ID);
                    if ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                       $img  = base_url()."groupes/ACTIVITES/".$thumb;
                    }
                    else{
                        $img  = base_url()."groupes/default.png";
                    }    

                    $html             .= '<li class="list-group-item list-group-cat"><a href="'.base_url().'read-data?id='.$art->ID.'"><img src="'.$img.'" class="img-stat-pgr"></a><span class="badge-category-pgr">'.$this->convert_utf8($art->article).'</span></li>'; 
                }
            }          
            
        }
        $html                     .= '</ul>';
        echo $html;
    }

    public function addstat(){
        $retour = array();
        if (isset($_POST)) {
            $retour['contentType'] = $_POST['contentType'];
            $retour['contentTitle'] = $_POST['contentTitle'];
            if ($_POST['contentType'] == 'local_file' || $_POST['contentType'] == 'embend_url' || $_POST['contentType'] == 'nl_article') {
                $retour['urlFinal'] = $_POST['contentLink'];
            }
            elseif($_POST['contentType'] == 'sequence_activity'){
                $retour['responses'] = $this->getContentSequence($_POST['contentProgram'],$_POST['contentFavoris'],$_POST['contentModule']);
            }
            else{ // simple link                
                $retour['urlFinal']  = $this->findUltimateDestination($_POST['contentLink'],10);
                $retour['responses'] = $this->getHeaderResponses($_POST['contentLink']);
            }
            $retour['trackingid'] = $this->loadTrackingEl($_POST['contentProgram'],$_POST['contentNumero'],$this->tracking_type,$_POST['contentModule']); 
        }
        echo json_encode($retour);
    }

    public function getContentSequence($idSequence,$idFav,$idModule)
    {
        $html = '
            <div class="tab-title title-active-menu-pg">
                <h2 class="content_title">'.$this->lang->line('other_init_activity_empty').' '.$this->sequence_model->Request('sequence_titre',$idSequence).' )</h2>
            </div>
            <div class="card-container">';
        $allResult = $this->sequence_model->getAllById($idSequence);
        foreach ($allResult as $res) {
            $type = '';
            if ($res->type == 1) {
                $type = 0;
            }
            else{
                $type = 2;
            }
            $activityLinks = str_replace('/redir.php?url=', '', $res->link);
            $activityLinks1 = str_replace('redir.php?url=', '', $activityLinks);
            $activityLinksF = '';
            if (strpos($activityLinks1, 'forma2plus.com/') !== false) {
                $explodeLink = explode('forma2plus.com/', $activityLinks1);                               
                $activityLinksF = base_url().$explodeLink[1];
            }
            else{
                $activityLinksF = $activityLinks1;
            }
            $finalUrl = $this->getFinalUrlFromGroupMain($activityLinksF,$type,RP_GROUPES.'GRPT'.$this->stat_prg_model->Request('user_create',$idFav).'/documentTodo/',HTTP_MAIN.'groupes/GRPT'.$this->stat_prg_model->Request('user_create',$idFav).'/documentTodo/');

            $html .= '
                <div class="card-style-3 container-content-fav">
                    <div class="card">
                        <a href="#" onclick="readContentInTrainingArea(this);" data-link="'.$finalUrl['linkF'].'" data-id-prog="'.$res->id_sequence.'" data-id-fav="'.$idFav.'" data-module="'.$idModule.'" data-numero="'.$res->numero.'" data-doc-type="'.$finalUrl['infoContent'].'">'.$this->convert_utf8($res->titre).'</a>
                    </div> 
                </div>';
        }
        $html .= '</div>';

        return ($html);
    }

    /*public function addstat(){
        if (isset($_POST)) {
            $trackingsession          = $this->tracking_model->Add($_POST['idStatPr'],$_POST['id_prog'],$this->tracking_type,$_POST['module_id']);
            $sessionArray = array('TRACKINGID'=>$trackingsession);                                    
            $this->session->set_userdata($sessionArray);
            $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
            echo "##".$trackingsession;
        }
    }*/

    public function add(){
        if (isset($_POST)) { 
            if ($this->isTuteurConnet()) {           
                if (isset($_POST['type']) && $_POST['type'] == 'library_professor') {
                    /*if (isset($_POST['status']) && $_POST['status'] == 0) {
                        $data = array(
                            'id_membres'    => $this->session->userdata ('STAGIAIREID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_classification_favoris'   =>  $_POST['classification'],
                            'id_prg'        => $_POST['id'],
                            'numero'        => null,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'type'          => $_POST['type'],
                            'commentaire'   => $_POST['comment'],
                            'module_id'     => isset($_POST['module_id']) ? $_POST['module_id'] : NULL,
                            'date_creation' => time()
                        );
                    }
                    else{                        
                        if (is_numeric($_POST['classification'])) {
                            $id_classification = $_POST['classification'];
                        } 
                        else{
                            $data_classification = array(
                                'intitule'    => $_POST['classification'],
                                'user_create' => $this->session->userdata ('GUSERID'),
                                'id_groupe' => $this->session->userdata ('STAGIAIREGRP'),
                                'date'        => time(),
                            );
                            $id_classification = $this->classificationFavoris_Model->add($data_classification);
                        }
                        $data = array(
                            'id_membres'    => $this->session->userdata ('STAGIAIREID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_classification_favoris'   =>  $id_classification,
                            'id_prg'        => $_POST['id'],
                            'numero'        => null,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'type'          => $_POST['type'],
                            'module_id'     => $_POST['module_id'],
                            'commentaire'   => $_POST['comment'],
                            'date_creation' => time()
                        );

                    }*/
                    $data = array(
                        'id_membres'    => $this->session->userdata ('STAGIAIREID'), 
                        'user_create'   => $this->session->userdata ('GUSERID'),
                        'id_classification_favoris'   =>  isset($_POST['classification']) ? $_POST['classification'] : null,
                        'id_prg'        => isset($_POST['id']) ? $_POST['id'] : null,
                        'numero'        => null,
                        'intitule'      => isset($_POST['intitule']) ? $this->convert_utf8($_POST['intitule']) : null,
                        'status'        => isset($_POST['status']) ? $_POST['status'] : null,
                        'type'          => isset($_POST['type']) ? $_POST['type'] : null,
                        'module_id'     => isset($_POST['module_id']) ? $_POST['module_id'] : null,
                        'commentaire'   => isset($_POST['comment']) ? $_POST['comment'] : null,
                        'date_creation' => time()
                    );
                }           
                elseif (isset($_POST['type']) && $_POST['type'] == 'document') {
                    if (isset($_POST['status']) && $_POST['status'] == 0) {
                        $data = array(
                            'id_membres'    => $this->session->userdata ('STAGIAIREID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_classification_favoris'   =>  NULL,
                            'id_prg'        => $_POST['id'],
                            'numero'        => null,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'type'          => $_POST['type'],
                            'commentaire'   => $_POST['comment'],
                            'module_id'     => isset($_POST['module_id']) ? $_POST['module_id'] : NULL,
                            'date_creation' => time()
                        );
                    }
                    else{                        
                        if (is_numeric($_POST['classification'])) {
                            $id_classification = $_POST['classification'];
                        } 
                        else{
                            $data_classification = array(
                                'intitule'    => $_POST['classification'],
                                'user_create' => $this->session->userdata ('GUSERID'),
                                'id_groupe' => $this->session->userdata ('STAGIAIREGRP'),
                                'date'        => time(),
                            );
                            $id_classification = $this->classificationFavoris_Model->add($data_classification);
                        }
                        $data = array(
                            'id_membres'    => $this->session->userdata ('STAGIAIREID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_classification_favoris'   =>  $id_classification,
                            'id_prg'        => $_POST['id'],
                            'numero'        => null,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'type'          => $_POST['type'],
                            'module_id'     => $_POST['module_id'],
                            'commentaire'   => $_POST['comment'],
                            'date_creation' => time()
                        );

                    }
                }           
                elseif (isset($_POST['type']) && $_POST['type'] == 'community_library_forma2plus') {
                    if (isset($_POST['status']) && $_POST['status'] == 0) {
                        $data = array(
                            'id_membres'    => $this->session->userdata ('STAGIAIREID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_classification_favoris'   =>  NULL,
                            'id_prg'        => $_POST['id'],
                            'numero'        => null,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'type'          => $_POST['type'],
                            'commentaire'   => $_POST['comment'],
                            'module_id'     => isset($_POST['module_id']) ? $_POST['module_id'] : NULL,
                            'date_creation' => time()
                        );
                    }
                    else{                        
                        if (is_numeric($_POST['classification'])) {
                            $id_classification = $_POST['classification'];
                        } 
                        else{
                            $data_classification = array(
                                'intitule'    => $_POST['classification'],
                                'user_create' => $this->session->userdata ('GUSERID'),
                                'id_groupe' => $this->session->userdata ('STAGIAIREGRP'),
                                'date'        => time(),
                            );
                            $id_classification = $this->classificationFavoris_Model->add($data_classification);
                        }
                        $data = array(
                            'id_membres'    => $this->session->userdata ('STAGIAIREID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_classification_favoris'   =>  $id_classification,
                            'id_prg'        => $_POST['id'],
                            'numero'        => null,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'type'          => $_POST['type'],
                            'module_id'     => $_POST['module_id'],
                            'commentaire'   => $_POST['comment'],
                            'date_creation' => time()
                        );

                    }
                }
                elseif (isset($_POST['type']) && $_POST['type'] == 'corporate_library') {
                    if (isset($_POST['status']) && $_POST['status'] == 0) {
                        $data = array(
                            'id_membres'    => $this->session->userdata ('STAGIAIREID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_classification_favoris'   =>  NULL,
                            'id_prg'        => $_POST['id'],
                            'numero'        => null,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'module_id'     => isset($_POST['module_id']) ? $_POST['module_id'] : NULL,
                            'type'          => $_POST['type'],
                            'commentaire'   => $_POST['comment'],
                            'date_creation' => time()
                        );
                    }
                    else{                        
                        if (is_numeric($_POST['classification'])) {
                            $id_classification = $_POST['classification'];
                        } 
                        else{
                            $data_classification = array(
                                'intitule'    => $_POST['classification'],
                                'user_create' => $this->session->userdata ('GUSERID'),
                                'id_groupe' => $this->session->userdata ('STAGIAIREGRP'),
                                'date'        => time(),
                            );
                            $id_classification = $this->classificationFavoris_Model->add($data_classification);
                        }
                        $data = array(
                            'id_membres'    => $this->session->userdata ('STAGIAIREID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_classification_favoris'   =>  $id_classification,
                            'id_prg'        => $_POST['id'],
                            'numero'        => null,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'module_id'     => $_POST['module_id'],
                            'status'        => $_POST['status'],
                            'type'          => $_POST['type'],
                            'commentaire'   => $_POST['comment'],
                            'date_creation' => time()
                        );

                    }
                }
                else{
                    if (isset($_POST['numero'])) {
                        $data = array(
                            'id_membres'    => $this->session->userdata ('STAGIAIREID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_prg'        => $_POST['id'],
                            'numero'        => $_POST['numero'],
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'type'          => $_POST['type'],
                            'module_id'     => isset($_POST['module_id']) ? $_POST['module_id'] : NULL,
                            'commentaire'   => $_POST['comment'],
                            'date_creation' => time()
                        );
                    }
                    else{
                        $data = array('id_membres'    => $this->session->userdata ('STAGIAIREID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_prg'        => $_POST['id'],
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'type'          => $_POST['type'],
                            'module_id'     => isset($_POST['module_id']) ? $_POST['module_id'] : NULL,
                            'commentaire'   => $_POST['comment'],
                            'date_creation' => time()
                        );
                    }
                }
            }
            else{
                if (isset($_POST['type']) && $_POST['type'] == 'document') {
                    if (isset($_POST['status']) && $_POST['status'] == 0) {
                        $data = array(
                            'id_membres'    => $this->session->userdata ('GUSERID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_classification_favoris'   =>  NULL,
                            'id_prg'        => $_POST['id'],
                            'numero'        => null,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'module_id'     => isset($_POST['module_id']) ? $_POST['module_id'] : NULL,
                            'type'          => $_POST['type'],
                            'commentaire'   => $_POST['comment'],
                            'date_creation' => time()
                        );
                    }
                    else{
                        if (is_numeric($_POST['classification'])) {
                            $id_classification = $_POST['classification'];
                        } 
                        else{
                            $data_classification = array(
                                'intitule'    => $_POST['classification'],
                                'user_create' => $this->session->userdata ('GUSERID'),
                                'id_groupe' => $this->session->userdata ('GROUPE'),
                                'date'        => time(),
                            );
                            $id_classification = $this->classificationFavoris_Model->add($data_classification);
                        }

                        $data = array(
                            'id_membres'    => $this->session->userdata ('GUSERID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_classification_favoris'   =>  $id_classification,
                            'id_prg'        => $_POST['id'],
                            'numero'        => null,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'module_id'     => $_POST['module_id'],
                            'type'          => $_POST['type'],
                            'commentaire'   => $_POST['comment'],
                            'date_creation' => time()
                        );
                    }

                }
                elseif (isset($_POST['type']) && $_POST['type'] == 'corporate_library') {
                    if (isset($_POST['status']) && $_POST['status'] == 0) {
                        $data = array(
                            'id_membres'    => $this->session->userdata ('GUSERID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_classification_favoris'   =>  NULL,
                            'id_prg'        => $_POST['id'],
                            'numero'        => null,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'module_id'     => isset($_POST['module_id']) ? $_POST['module_id'] : NULL,
                            'type'          => $_POST['type'],
                            'commentaire'   => $_POST['comment'],
                            'date_creation' => time()
                        );
                    }
                    else{
                        if (is_numeric($_POST['classification'])) {
                            $id_classification = $_POST['classification'];
                        } 
                        else{
                            $data_classification = array(
                                'intitule'    => $_POST['classification'],
                                'user_create' => $this->session->userdata ('GUSERID'),
                                'id_groupe' => $this->session->userdata ('GROUPE'),
                                'date'        => time(),
                            );
                            $id_classification = $this->classificationFavoris_Model->add($data_classification);
                        }

                        $data = array(
                            'id_membres'    => $this->session->userdata ('GUSERID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_classification_favoris'   =>  $id_classification,
                            'id_prg'        => $_POST['id'],
                            'numero'        => null,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => $_POST['status'],
                            'module_id'     => $_POST['module_id'],
                            'type'          => $_POST['type'],
                            'commentaire'   => $_POST['comment'],
                            'date_creation' => time()
                        );
                    }

                }
                else{
                    if (isset($_POST['numero'])) {
                        $data = array(
                            'id_membres'    => $this->session->userdata ('GUSERID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_prg'        => isset($_POST['id']) ? $_POST['id'] : NULL,
                            'numero'        => isset($_POST['numero']) ? $_POST['numero'] : NULL,
                            'intitule'      => $this->convert_utf8($_POST['intitule']),
                            'status'        => isset($_POST['status']) ? $_POST['status'] : NULL,
                            'module_id'     => isset($_POST['module_id']) ? $_POST['module_id'] : NULL,
                            'type'          => isset($_POST['type']) ? $_POST['type'] : NULL,
                            'commentaire'   => isset($_POST['comment']) ? $this->convert_utf8($_POST['comment']) : '',
                            'date_creation' => time()
                        );
                    }
                    else{
                        $data = array(
                            'id_membres'    => $this->session->userdata ('GUSERID'), 
                            'user_create'   => $this->session->userdata ('GUSERID'),
                            'id_prg'        => isset($_POST['id']) ? $_POST['id'] : NULL,
                            'intitule'      => isset($_POST['intitule']) ? $this->convert_utf8($_POST['intitule']) : '',
                            'status'        => isset($_POST['status']) ? $_POST['status'] : NULL,
                            'module_id'     => isset($_POST['module_id']) ? $_POST['module_id'] : NULL,
                            'type'          => isset($_POST['type']) ? $_POST['type'] : NULL,
                            'commentaire'   => isset($_POST['comment']) ? $this->convert_utf8($_POST['comment']) : '',
                            'date_creation' => time()
                        );
                    }
                }
            }  
            $ret = $this->stat_prg_model->add($data);
            echo '##'.$ret;
        }
        else{
            echo "error";
        }

    }

    public function addArticle(){
        if (isset($_POST['dataSerialise'])) {
            $data = array(
                'id_membres'    => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'),
                'user_create'   => $this->session->userdata ('GUSERID'),
                'id_prg'        => $_POST['dataSerialise']['data_id_art'],
                'intitule'      => $this->convert_utf8($_POST['dataSerialise']['data_art_title']),
                'status'        => 1,
                'module_id'     => (isset($_POST['dataSerialise']['data_module_id']) && $_POST['dataSerialise']['data_module_id'] != '') ? $_POST['dataSerialise']['data_module_id'] : NULL,
                'type'          => $_POST['dataSerialise']['data_art_type'],
                'id_classification_favoris'          => $_POST['dataSerialise']['classification_article'],
                'commentaire'   => '',
                'date_creation' => time()
            );
            echo $this->stat_prg_model->add($data);
        }
    }

    public function addTherme(){
        if (isset($_POST['dataSerialise'])) {
            $data = array(
                'id_membres'    => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'),
                'user_create'   => $this->session->userdata ('GUSERID'),
                'id_prg'        => $_POST['dataSerialise']['data_id_therme'],
                'intitule'      => $this->convert_utf8($_POST['dataSerialise']['data_therme_title']),
                'status'        => 1,
                'module_id'     => (isset($_POST['dataSerialise']['data_module_id']) && $_POST['dataSerialise']['data_module_id'] != '') ? $_POST['dataSerialise']['data_module_id'] : NULL,
                'type'          => $_POST['dataSerialise']['data_therme_type'],
                'id_classification_favoris'          => $_POST['dataSerialise']['classification_therme'],
                'commentaire'   => $this->convert_utf8($_POST['dataSerialise']['data_therme_comment']),
                'date_creation' => time()
            );
            echo $this->stat_prg_model->add($data);
        }
    }

    public function addCommentTherme(){
        if (isset($_POST['dataSerialise'])) {
            $data = array(
                'id_membres'    => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'),
                'user_create'   => $this->session->userdata ('GUSERID'),
                'id_prg'        => $_POST['dataSerialise']['data-id-article'],
                'intitule'      => $this->convert_utf8($_POST['dataSerialise']['data-intitule-article']),
                'status'        => 0,
                'module_id'     => NULL,
                'type'          => $_POST['dataSerialise']['data-type-article'],
                'id_classification_favoris'          => NULL,
                'commentaire'   => $this->convert_utf8($_POST['dataSerialise']['comment_therme-article']),
                'date_creation' => time()
            );
            echo $this->stat_prg_model->add($data);
        }
    }

    public function getAllCommentByDataType(){
        $allComment = '';
        if (isset($_POST['type']) && $_POST['status'] == 0) {
            $allCommentResult = $this->stat_prg_model->getFavorisByIdProgramTypeStatus($_POST['id'],$_POST['type'],$_POST['status']);
            if (isset($allCommentResult) && count($allCommentResult) >= 1) {
                foreach ($allCommentResult as $res) {
                    $allComment .= '<p class="page_comment_data"><span class="user_write_comment">'.$this->membres_model->Request('prenom',$res->user_create).' '.$this->membres_model->Request('prenom',$res->user_create).'</span><span class="text_comment_data"> had written : '.$res->commentaire.' in '.date('Y-m-d',$res->date_creation).'</span></p>';
                }
            }
        }
        echo $allComment;
    }

    public function getActivityComment(){
        $allComment = '';
        if (isset($_POST['type']) && $_POST['status'] == 0) {
            $allCommentResult = $this->stat_prg_model->getAllResultByActivity($_POST['id'],$_POST['numero'],$_POST['type'],$_POST['status']);
            if (isset($allCommentResult) && count($allCommentResult) >= 1) {
                foreach ($allCommentResult as $res) {
                    $allComment .= '<p class="page_comment_data"><span class="user_write_comment">'.$this->membres_model->Request('prenom',$res->user_create).' '.$this->membres_model->Request('prenom',$res->user_create).'</span><span class="text_comment_data"> had written : '.$res->commentaire.' in '.date('Y-m-d',$res->date_creation).'</span></p>';
                }
            }
        }
        echo $allComment;
    }

    public function getAllCommentByDataInFavorites(){
        $allComment = '';
        if (isset($_POST['type']) && $_POST['status'] == 0 && isset($_POST['id'])) {
            if ($_POST['type'] == 'activity_sequence') {
                $allCommentResult = $this->stat_prg_model->getAllResultByActivity($_POST['id'],$_POST['numero'],$_POST['type'],$_POST['status']);
            }
            elseif ($_POST['type'] == 'document') {
                $doc               = $this->document_model->read($_POST['id']);
                $allCommentResult  = nl2br($doc['comment']) ;
            }
            else{
                $allCommentResult = $this->stat_prg_model->getFavorisByIdProgramTypeStatus($_POST['id'],$_POST['type'],$_POST['status']);
            }

            if (isset($allCommentResult) && count($allCommentResult) >= 1) {
                if ($_POST['type'] == 'document'){
                    if (isset($allCommentResult)) {        
                        if ( strlen($allCommentResult)!=0 ) {
                            $allCommentResult = str_replace("DEB>","######",$allCommentResult );
                            $allCommentResult = str_replace("<","!!",$allCommentResult );
                            $allCommentResult = str_replace("MID>","######",$allCommentResult );
                            $allCommentResult = str_replace("FIN>","######",$allCommentResult );
                        }
                    }
                    $tab = explode('!!######',$allCommentResult);
                    $auteur;
                    $date_create;
                    for($i=0;$i<count($tab);$i++) {
                        if ( trim($tab[$i]) != '' ) {
                            $data_ex = explode(' a &eacute;crit le ', $this->convert_utf8($tab[$i++]));
                            if (isset($data_ex[0])) {
                               $auteur = $data_ex[0];
                            }
                            if (isset($data_ex[1])) {
                               $date_create = $data_ex[1];
                            }
                            $allComment .= '<p class="page_comment_data"><span class="user_write_comment">'.$auteur.'</span><span class="text_comment_data"> had written : '.str_replace("!!br />", "<br>", $tab[$i]).' in '.$date_create.'</span></p>';
                        }
                    }

                    $allCommentResult1 = $this->stat_prg_model->getFavorisByIdProgramTypeStatus($_POST['id'],$_POST['type'],$_POST['status']);
                    foreach ($allCommentResult1 as $res) {
                        $allComment .= '<p class="page_comment_data"><span class="user_write_comment">'.$this->membres_model->Request('prenom',$res->user_create).' '.$this->membres_model->Request('prenom',$res->user_create).'</span><span class="text_comment_data"> had written : '.$res->commentaire.' in '.date('Y-m-d',$res->date_creation).'</span></p>';
                    }
                }
                else{
                    foreach ($allCommentResult as $res) {
                        $allComment .= '<p class="page_comment_data"><span class="user_write_comment">'.$this->membres_model->Request('prenom',$res->user_create).' '.$this->membres_model->Request('prenom',$res->user_create).'</span><span class="text_comment_data"> had written : '.$res->commentaire.' in '.date('Y-m-d',$res->date_creation).'</span></p>';
                    }
                }
            }
        }
        echo $allComment;
    }

    public function getFavForAllUser(){        
        
        $this->global['pageTitle']          = 'E-learning : '.$this->lang->line('training_period_exercise'); 

        if (isset($_GET['id']) && isset($_GET['data_type']) && $_GET['data_type'] == 'article_nl') {
            $data['articleResult']          = $this->newsletter_model->getArticle($_GET['id']);
            $data['termeResult']            = $this->newsletter_model->getTerme($_GET['id']);
            $this->loadTrackingEl($_GET['id'],0,$this->tracking_type,$_GET['id_st']);  
        }
        else{
            $this->loadTrackingEl(0,0,$this->tracking_type);  
        }

        $idGroupe = '';
        if ($this->isTuteurConnet()) {
            $idGroupe = $this->session->userdata ('STAGIAIREGRP');
            $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
        }
        else{
            $idGroupe = $this->session->userdata ('GROUPE');
        }


        $data['mycollection']                        = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$idGroupe);        
        $data['collectionofotheruser']               = $this->classificationFavoris_Model->getByIdGroupNotInTrainee($this->session->userdata ('GUSERID'),$idGroupe);
        $data['collectionoverviews']                 = $this->classificationFavoris_Model->getClassTuteurByTrainee($idGroupe);   


        if($this->isTuteurConnet()) {
            $this->loadViews("tutor/workbook/index", $this->global, $data , NULL);
        }
        else {                   
            $this->loadViews("trainee/workbook/index", $this->global, $data , NULL);
        }
    }

    public function del(){
        $return = array();
        if (isset($_POST['id_program_stat'])) {
            $this->stat_prg_model->delete($_POST['id_program_stat']);
            $return['idDelete'] = $_POST['id_program_stat'];
        }
        echo json_encode($return);
    }

    public function scancontent(){
        $retour = array();
        if (isset($_POST['type']) && isset($_POST['id'])) {
            $dataType = $_POST['type'];
            $dataId = $_POST['id_prog'];
            $moduleDataId = $_POST['module_id'];
            $pageName = $_POST['page_name'];
            $favoritesId = $_POST['id'];
        }
        echo json_encode($retour);
    }

    public function getJsonContainer(){
        $return = array();
        $pedagogicalTraning = array();
        $personnalInterest = array();
        $newsletter = array();
        $terme = array();
        $document = array();
        $teacherLinkAndDocument = array();
        $communityLibrary = array();
        $tdc = 0;
        $cmm = 0;
        $d = 0;
        $nl = 0;
        $t = 0;
        $idGroupe = $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREGRP') : $this->session->userdata ('GROUPE');
        if (isset($_POST['idFav'])) {

            //PedagogicalTraning
            $pedagogicalTraningResult = $this->sequence_model->getLinksByIdGroupIdDomaine($idGroupe,6);
            for ($p=0; $p < count($pedagogicalTraningResult) ; $p++) {
                $pedagogicalTraning[$p] = array(
                    'link'            => $pedagogicalTraningResult[$p]['link'],
                    'titre'           => $pedagogicalTraningResult[$p]['titre'],
                    'final_url'       => $pedagogicalTraningResult[$p]['final_url'],
                    'thumbnail_file'  => $pedagogicalTraningResult[$p]['thumbnail_file'],
                    'id_sequence'     => $pedagogicalTraningResult[$p]['id_sequence'],
                    'numero'          => $pedagogicalTraningResult[$p]['numero']
                );
            }

            //PersonnalInterest
            $personnalIntersetResult = $this->sequence_model->getLinksByIdGroupIdDomaine($idGroupe,7);
            for ($pi=0; $pi < count($personnalIntersetResult) ; $pi++) {
                $personnalInterest[$pi] = array(
                    'link'            => $personnalIntersetResult[$pi]['link'],
                    'titre'           => $personnalIntersetResult[$pi]['titre'],
                    'final_url'       => $personnalIntersetResult[$pi]['final_url'],
                    'thumbnail_file'  => $personnalIntersetResult[$pi]['thumbnail_file'],
                    'id_sequence'     => $personnalIntersetResult[$pi]['id_sequence'],
                    'numero'          => $personnalIntersetResult[$pi]['numero']
                );
            }

            //ArticleNewsletter
            $newsletterResult = $this->newsletter_model->getAllArticle();
            foreach ($newsletterResult as $article) {
                $newsletter[$nl] = array(
                    'ID'          => $article->ID,
                    'article'     => $article->article
                );
                $nl++;
            }

            //TermeNewsletter
            $termeNewsletterResult = $this->newsletter_model->getAllTerme();
            foreach ($termeNewsletterResult as $tr) {
                $terme[$t] = array(
                    'ID'                => $tr->ID,
                    'nl_article_id'     => $tr->nl_article_id,
                    'terme'             => $tr->terme,
                    'traduction_fr'     => $tr->traduction_fr,
                    'definition'        => $tr->definition
                );
                $t++;
            }

            //LinkAndDocument
            $documentResult = $this->document_model->getAllDocumentByIdGroup($idGroupe);
            foreach ($documentResult as $res) {
                $document[$d] = array(
                    'id'          => $res->id,
                    'id_repertory'=> $res->id_repertory,
                    'titre'       => $res->titre,
                    'fichier'     => $res->fichier,
                    'prop'        => $res->prop,
                    'groupe'      => $res->groupe,
                    'id_tuteur'   => $res->id_tuteur,
                    'type'        => $res->type,
                    'lien'        => $res->lien,
                );
                $d++;
            }

            //teacherLinkAndDoc
            $teacherLinkAndDocumentResults = $this->Teacher_link_and_document_model->getContentByUserCreate($this->session->userdata ('GUSERID'));
            foreach ($teacherLinkAndDocumentResults as $td) {
                if ($td->titre != '') {
                    $teacherLinkAndDocument[$tdc] = array(
                        'id'          => $td->id,
                        'id_repertory'=> $td->id_repertory,
                        'titre'       => $td->titre,
                        'fichier'     => $td->link,
                        'prop'        => $td->user_create,
                        'groupe'      => NULL,
                        'id_tuteur'   => $td->user_create,
                        'type'        => $td->type,
                    );
                    $tdc++;
                }
            }

            //communityLibrary
            $communityLibraryResults = $this->Content_community_library_forma2plus_model->getAll();
            foreach ($communityLibraryResults as $cm) {
                $communityLibrary[$cmm] = array(
                    'id'          => $cm->id,
                    'id_repertory'=> $cm->id_community_library_forma2plus,
                    'titre'       => $cm->titre,
                    'fichier'     => $cm->link,
                    'prop'        => $cm->user_create,
                    'groupe'      => NULL,
                    'id_tuteur'   => $cm->user_create,
                    'type'        => $cm->type,
                );
                $cmm++;
            }

            $return = array(
                'pedagogicalTraningResultJson' => $pedagogicalTraning,
                'personnalInterestResultJson'  => $personnalInterest,
                'newsletterResultJson'         => $newsletter,
                'termesNewsletterResultJson'   => $terme,
                'documentResultJson'           => $document,
                'teacherLinkAndDocumentJson'   => $teacherLinkAndDocument,
                'communityLibraryJson'         => $communityLibrary,
            );
        }
        echo json_encode($return);
    }

    public function addContent(){
        $return = array();
        if (isset($_POST['id_classification_favoris'])) {
            $data = array(
                'id_membres'    => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'), 
                'user_create'   => $this->session->userdata ('GUSERID'),
                'id_classification_favoris'   =>  $_POST['id_classification_favoris'],
                'id_prg'        => $_POST['id_prg'],
                'numero'        => $_POST['numero'],
                'intitule'      => $this->convert_utf8($_POST['title']),
                'status'        => 1,
                'type'          => $_POST['type'],
                'commentaire'   => '',
                'module_id'     => (isset($_POST['type']) && $_POST['type'] == "activity_sequence") ? $this->modules_model->RequestModuleBySequenceOrder('module_id',(int)$_POST['id_prg'],(int)$_POST['numero']) : NULL,
                'date_creation' => time()
            );
            $return['insert'] = $this->stat_prg_model->add($data);
        }
        echo json_encode($return);
    }

    public function addContentPage(){
        $return = array();
        if (isset($_POST['dataPageTraningArea'])) {
            $data = array(
                'id_membres'    => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'), 
                'user_create'   => $this->session->userdata ('GUSERID'),
                'id_classification_favoris'   =>  $_POST['dataPageTraningArea']['idClassificationFavoris'],
                'id_prg'        => NULL,
                'numero'        => NULL,
                'intitule'      => $this->convert_utf8($_POST['dataPageTraningArea']['edit-page-comment']),
                'status'        => 1,
                'type'          => 'page_content',
                'commentaire'   => $this->convert_utf8($_POST['dataPageTraningArea']['page-content']),
                'module_id'     => NULL,
                'date_creation' => time()
            );
            $return['insert'] = $this->stat_prg_model->add($data);

            echo json_encode($return);
        }
    }

     public function updateContentPage(){
        $return = array();        
        if (isset($_POST['dataPageTraningArea'])) {
            $data = array(
                'intitule'             => $_POST['dataPageTraningArea']['comment-page'],
                'commentaire'          => $_POST['dataPageTraningArea']['page-content'],
                'date_creation'        => time()
            );
            $return['data'] = $data;
            $return['id_page_training_area'] = $_POST['dataPageTraningArea']['id_page_training_area'];
            $return['updateId'] = $this->stat_prg_model->update($_POST['dataPageTraningArea']['id_page_training_area'],$data);
        }
        echo json_encode($return);
    }

}

?>